/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.geomancy;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.util.ModFallingBlock;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.SEHelper;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class QuakingSpell
extends Spell {
    @Override
    public SpellStat defaultStats() {
        return super.defaultStats().setRange(12).setRadius(4.0);
    }

    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.QuakingCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.QuakingDuration.get();
    }

    @Override
    public int castDuration(LivingEntity caster, ItemStack staff) {
        int i = this.defaultStats().getRange();
        if (WandUtil.enchantedFocus(caster)) {
            i += WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), caster);
        }
        return i + this.defaultCastDuration();
    }

    @Override
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.RUMBLE.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.QuakingCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.GEOMANCY;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.RANGE.get());
        list.add((Enchantment)ModEnchantments.RADIUS.get());
        return list;
    }

    @Override
    public void useSpell(ServerLevel worldIn, LivingEntity caster, ItemStack staff, int castTime, SpellStat spellStat) {
        block7: {
            int range = spellStat.getRange();
            int radius = (int)spellStat.getRadius();
            float damage = ((Double)SpellConfig.QuakingDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();
            if (WandUtil.enchantedFocus(caster)) {
                range += WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), caster);
                radius += WandUtil.getLevels((Enchantment)ModEnchantments.RADIUS.get(), caster);
                damage += (float)WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
            }
            damage += (float)spellStat.getPotency();
            if (this.rightStaff(staff)) {
                ++radius;
            }
            if (castTime <= this.defaultCastDuration()) break block7;
            if (!this.isShifting(caster)) {
                for (int i = 0; i <= range; ++i) {
                    if (castTime != i + this.defaultCastDuration()) continue;
                    if (this.rightStaff(staff)) {
                        int d = i + 2 - 2;
                        int d2 = i + 2 - 3;
                        float ds = (float)(d + d2) / 2.0f;
                        this.arcTremor(caster, 0.35f, d, 5, 1.05f, -2.0f, 0.0f, 80, damage);
                        this.arcTremor(caster, 0.35f, d2, 5, 1.05f, -2.0f, 0.0f, 80, damage);
                        this.tremorSound(caster, ds, 0.0f);
                        continue;
                    }
                    QuakingSpell.tremor(caster, i, 3.0, 0.0f, damage, 0.1f);
                    QuakingSpell.tremor(caster, i, 3.0, 1.5f, damage, 0.1f);
                    QuakingSpell.tremor(caster, i, 3.0, -1.5f, damage, 0.1f);
                }
            } else {
                for (int i = 0; i <= radius; ++i) {
                    if (castTime != i + this.defaultCastDuration()) continue;
                    QuakingSpell.surroundTremor(caster, i, 3.0, 0.0f, this.rightStaff(staff), damage, 0.1f);
                }
            }
        }
    }

    @Override
    public void stopSpell(ServerLevel worldIn, LivingEntity caster, ItemStack staff, ItemStack focus, int castTime, SpellStat spellStat) {
        if (castTime > this.defaultCastDuration() && caster instanceof Player) {
            Player player = (Player)caster;
            if (!focus.m_41619_()) {
                SEHelper.addCooldown(player, focus.m_41720_(), this.spellCooldown());
                SEHelper.sendSEUpdatePacket(player);
            }
        }
    }

    public static void tremor(LivingEntity livingEntity, int distance, double topY, float side, float damage, float airborne) {
        int hitY = Mth.m_14107_((double)(livingEntity.m_20191_().f_82289_ - 0.5));
        double minY = livingEntity.m_20186_() - 2.0;
        double maxY = livingEntity.m_20186_() + topY;
        float angle = (float)(Math.PI / 180 * (double)livingEntity.f_20885_);
        float f = Mth.m_14089_((float)(livingEntity.f_20885_ * ((float)Math.PI / 180)));
        float f1 = Mth.m_14031_((float)(livingEntity.f_20885_ * ((float)Math.PI / 180)));
        double extraX = (float)distance * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = (float)distance * Mth.m_14089_((float)angle);
        double px = livingEntity.m_20185_() + extraX + (double)(f * side);
        double pz = livingEntity.m_20189_() + extraZ + (double)(f1 * side);
        int hitX = Mth.m_14107_((double)px);
        int hitZ = Mth.m_14107_((double)pz);
        BlockPos blockPos = new BlockPos(hitX, hitY, hitZ);
        BlockPos abovePos = new BlockPos((Vec3i)blockPos).m_7494_();
        BlockState blockState = livingEntity.f_19853_.m_8055_(blockPos);
        BlockState blockAbove = livingEntity.f_19853_.m_8055_(abovePos);
        if (blockState != Blocks.f_50016_.m_49966_() && !blockState.m_155947_() && !blockAbove.m_280555_()) {
            ModFallingBlock fallingBlock = new ModFallingBlock(livingEntity.f_19853_, Vec3.m_82512_((Vec3i)blockPos.m_7494_()), blockState, (float)(0.2 + livingEntity.m_217043_().m_188583_() * 0.15));
            livingEntity.f_19853_.m_7967_((Entity)fallingBlock);
        }
        AABB selection = new AABB(px - 0.5, minY, pz - 0.5, px + 0.5, maxY, pz + 0.5);
        List entities = livingEntity.f_19853_.m_45976_(LivingEntity.class, selection);
        for (LivingEntity target : entities) {
            boolean flag;
            if (MobUtil.areAllies((Entity)target, (Entity)livingEntity) || target == livingEntity || !(flag = target.m_6469_(livingEntity.m_269291_().m_269333_(livingEntity), damage))) continue;
            MobUtil.push((Entity)target, 0.0, (double)(airborne * (float)distance) + livingEntity.m_217043_().m_188500_() * 0.15, 0.0);
        }
        if (distance % 4 == 0) {
            livingEntity.f_19853_.m_5594_(null, blockPos.m_7494_(), (SoundEvent)ModSounds.WALL_ERUPT.get(), SoundSource.PLAYERS, 1.0f, 0.8f + livingEntity.f_19853_.f_46441_.m_188501_() * 0.4f);
            livingEntity.f_19853_.m_5594_(null, blockPos.m_7494_(), (SoundEvent)ModSounds.DIRT_DEBRIS.get(), SoundSource.PLAYERS, 1.0f, 0.8f + livingEntity.f_19853_.f_46441_.m_188501_() * 0.4f);
            livingEntity.f_19853_.m_5594_(null, blockPos.m_7494_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 0.8f + livingEntity.f_19853_.f_46441_.m_188501_() * 0.4f);
        }
    }

    public static void surroundTremor(LivingEntity livingEntity, int distance, double topY, float side, boolean grab, float damage, float airborne) {
        int hitY = Mth.m_14107_((double)(livingEntity.m_20191_().f_82289_ - 0.5));
        double spread = Math.PI * 2;
        int arcLen = Mth.m_14165_((double)((double)distance * spread));
        double minY = livingEntity.m_20186_() - 1.0;
        double maxY = livingEntity.m_20186_() + topY;
        for (int i = 0; i < arcLen; ++i) {
            double theta = ((double)i / ((double)arcLen - 1.0) - 0.5) * spread;
            double vx = Math.cos(theta);
            double vz = Math.sin(theta);
            double px = livingEntity.m_20185_() + vx * (double)distance + (double)side * Math.cos((double)(livingEntity.f_20883_ + 90.0f) * Math.PI / 180.0);
            double pz = livingEntity.m_20189_() + vz * (double)distance + (double)side * Math.sin((double)(livingEntity.f_20883_ + 90.0f) * Math.PI / 180.0);
            float factor = 1.0f - (float)distance / 12.0f;
            int hitX = Mth.m_14107_((double)px);
            int hitZ = Mth.m_14107_((double)pz);
            BlockPos blockPos = new BlockPos(hitX, hitY, hitZ);
            BlockState blockState = livingEntity.f_19853_.m_8055_(blockPos);
            while (blockState.m_60799_() != RenderShape.MODEL) {
                blockPos = blockPos.m_7495_();
                blockState = livingEntity.f_19853_.m_8055_(blockPos);
            }
            BlockState blockAbove = livingEntity.f_19853_.m_8055_(blockPos.m_7494_());
            if (blockState != Blocks.f_50016_.m_49966_() && !blockState.m_155947_() && !blockAbove.m_280555_()) {
                ModFallingBlock fallingBlock = new ModFallingBlock(livingEntity.f_19853_, Vec3.m_82512_((Vec3i)blockPos.m_7494_()), blockState, (float)(0.2 + livingEntity.m_217043_().m_188583_() * 0.15));
                livingEntity.f_19853_.m_7967_((Entity)fallingBlock);
            }
            if (distance % 4 == 0) {
                livingEntity.f_19853_.m_5594_(null, blockPos.m_7494_(), (SoundEvent)ModSounds.WALL_ERUPT.get(), SoundSource.PLAYERS, 1.0f, 0.8f + livingEntity.f_19853_.f_46441_.m_188501_() * 0.4f);
                livingEntity.f_19853_.m_5594_(null, blockPos.m_7494_(), (SoundEvent)ModSounds.DIRT_DEBRIS.get(), SoundSource.PLAYERS, 1.0f, 0.8f + livingEntity.f_19853_.f_46441_.m_188501_() * 0.4f);
                livingEntity.f_19853_.m_5594_(null, blockPos.m_7494_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 0.8f + livingEntity.f_19853_.f_46441_.m_188501_() * 0.4f);
            }
            AABB selection = new AABB(px - 0.5, minY, pz - 0.5, px + 0.5, maxY, pz + 0.5);
            List entities = livingEntity.f_19853_.m_45976_(LivingEntity.class, selection);
            for (LivingEntity target : entities) {
                boolean flag;
                if (MobUtil.areAllies((Entity)target, (Entity)livingEntity) || target == livingEntity || !(flag = target.m_6469_(livingEntity.m_269291_().m_269333_(livingEntity), damage))) continue;
                if (grab) {
                    if (!target.m_21275_(livingEntity.m_269291_().m_269333_(target))) continue;
                    MobUtil.disableShield((Entity)target);
                    continue;
                }
                MobUtil.push((Entity)target, 0.0, (double)(airborne * (float)distance) + livingEntity.m_217043_().m_188500_() * 0.15, 0.0);
            }
        }
    }

    public void arcTremor(LivingEntity caster, float spreadarc, int distance, int height, float mxy, float vec, float math, int shieldbreakticks, float damage) {
        double perpFacing = (double)caster.m_146908_() * (Math.PI / 180);
        double facingAngle = perpFacing + 1.5707963267948966;
        int hitY = Mth.m_14107_((double)(caster.m_20191_().f_82289_ - 0.5));
        double spread = Math.PI * (double)spreadarc;
        int arcLen = Mth.m_14165_((double)((double)distance * spread));
        float f = Mth.m_14089_((float)(caster.m_146908_() * ((float)Math.PI / 180)));
        float f1 = Mth.m_14031_((float)(caster.m_146908_() * ((float)Math.PI / 180)));
        for (int i = 0; i < arcLen; ++i) {
            double theta = ((double)i / ((double)arcLen - 1.0) - 0.5) * spread + facingAngle;
            double vx = Math.cos(theta);
            double vz = Math.sin(theta);
            double px = caster.m_20185_() + vx * (double)distance + (double)vec * Math.cos((double)(caster.m_146908_() + 90.0f) * Math.PI / 180.0) + (double)(f * math);
            double pz = caster.m_20189_() + vz * (double)distance + (double)vec * Math.sin((double)(caster.m_146908_() + 90.0f) * Math.PI / 180.0) + (double)(f1 * math);
            int hitX = Mth.m_14107_((double)px);
            int hitZ = Mth.m_14107_((double)pz);
            BlockPos pos = new BlockPos(hitX, hitY + height, hitZ);
            BlockState block = caster.f_19853_.m_8055_(pos);
            int maxDepth = 30;
            for (int depthCount = 0; depthCount < maxDepth && block.m_60799_() != RenderShape.MODEL; ++depthCount) {
                pos = pos.m_7495_();
                block = caster.f_19853_.m_8055_(pos);
            }
            if (block.m_60799_() != RenderShape.MODEL) {
                block = Blocks.f_50016_.m_49966_();
            }
            if (caster.f_19853_.f_46443_) continue;
            this.spawnBlocks(caster, hitX, hitY + height, hitZ, (int)(caster.m_20186_() - (double)height), block, px, pz, mxy, distance, shieldbreakticks, damage);
        }
    }

    private void spawnBlocks(LivingEntity caster, int hitX, int hitY, int hitZ, int lowestYCheck, BlockState blockState, double px, double pz, float mxy, float distance, int shieldbreakticks, float damage) {
        BlockPos blockpos = new BlockPos(hitX, hitY, hitZ);
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1;
            BlockState blockstate;
            if (!(blockstate = caster.f_19853_.m_8055_(blockpos1 = blockpos.m_7495_())).m_60783_((BlockGetter)caster.f_19853_, blockpos1, Direction.UP)) continue;
            if (caster.f_19853_.m_46859_(blockpos) || (voxelshape = (blockstate1 = caster.f_19853_.m_8055_(blockpos)).m_60812_((BlockGetter)caster.f_19853_, blockpos)).m_83281_()) break;
            d0 = voxelshape.m_83297_(Direction.Axis.Y);
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14143_((float)lowestYCheck) - 1);
        ModFallingBlock fallingBlock = new ModFallingBlock(caster.f_19853_, Vec3.m_82512_((Vec3i)blockpos.m_7494_()), blockState, (float)(0.2 + caster.m_217043_().m_188583_() * 0.04));
        caster.f_19853_.m_7967_((Entity)fallingBlock);
        AABB selection = new AABB(px - 0.5, (double)blockpos.m_123342_() + d0 - 1.0, pz - 0.5, px + 0.5, (double)blockpos.m_123342_() + d0 + (double)mxy, pz + 0.5);
        List hitbox = caster.f_19853_.m_45976_(LivingEntity.class, selection);
        for (LivingEntity entity : hitbox) {
            if (MobUtil.areAllies((Entity)caster, (Entity)entity)) continue;
            boolean flag = entity.m_6469_(caster.m_269291_().m_269333_(entity), damage);
            if (entity.m_21275_(caster.m_269291_().m_269333_(entity)) && shieldbreakticks > 0) {
                MobUtil.disableShield((Entity)entity);
            }
            if (!flag) continue;
            MobUtil.push((Entity)entity, 0.0, (double)(0.1f * distance) + entity.m_217043_().m_188500_() * 0.15, 0.0);
        }
    }

    private void tremorSound(LivingEntity livingEntity, float distance, float math) {
        double theta = (double)livingEntity.m_146908_() * (Math.PI / 180);
        double vecX = Math.cos(theta += 1.5707963267948966);
        double vecZ = Math.sin(theta);
        float f = Mth.m_14089_((float)(livingEntity.m_146908_() * ((float)Math.PI / 180)));
        float f1 = Mth.m_14031_((float)(livingEntity.m_146908_() * ((float)Math.PI / 180)));
        livingEntity.f_19853_.m_6263_(null, livingEntity.m_20185_() + (double)distance * vecX + (double)(f * math), livingEntity.m_20186_(), livingEntity.m_20189_() + (double)distance * vecZ + (double)(f1 * math), (SoundEvent)ModSounds.WALL_ERUPT.get(), SoundSource.PLAYERS, 1.0f, 0.8f + livingEntity.f_19853_.f_46441_.m_188501_() * 0.4f);
        livingEntity.f_19853_.m_6263_(null, livingEntity.m_20185_() + (double)distance * vecX + (double)(f * math), livingEntity.m_20186_(), livingEntity.m_20189_() + (double)distance * vecZ + (double)(f1 * math), (SoundEvent)ModSounds.DIRT_DEBRIS.get(), SoundSource.PLAYERS, 1.0f, 0.8f + livingEntity.f_19853_.f_46441_.m_188501_() * 0.4f);
        livingEntity.f_19853_.m_6263_(null, livingEntity.m_20185_() + (double)distance * vecX + (double)(f * math), livingEntity.m_20186_(), livingEntity.m_20189_() + (double)distance * vecZ + (double)(f1 * math), SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 0.8f + livingEntity.f_19853_.f_46441_.m_188501_() * 0.4f);
    }
}

