/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.geomancy;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.magic.EverChargeSpell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.SEHelper;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockDestructionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class BurrowingSpell
extends EverChargeSpell {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.BurrowingCost.get();
    }

    @Override
    public int defaultCastUp() {
        return (Integer)SpellConfig.BurrowingChargeUp.get();
    }

    @Override
    @Nullable
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.RUMBLE.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.GEOMANCY;
    }

    @Override
    public SoundEvent loopSound(LivingEntity caster) {
        return (SoundEvent)ModSounds.BURROW.get();
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.RANGE.get());
        list.add((Enchantment)ModEnchantments.BURNING.get());
        list.add((Enchantment)ModEnchantments.MAGNET.get());
        list.add(Enchantments.f_44987_);
        list.add(Enchantments.f_44985_);
        return list;
    }

    @Override
    public void startSpell(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        if (caster instanceof Player) {
            Player player = (Player)caster;
            BurrowingSpell.resetMiningProgress((Level)worldIn, player);
        }
        super.startSpell(worldIn, caster, staff, spellStat);
    }

    @Override
    public void stopSpell(ServerLevel worldIn, LivingEntity caster, ItemStack staff, ItemStack focus, int castTime, SpellStat spellStat) {
        if (caster instanceof Player) {
            Player player = (Player)caster;
            BurrowingSpell.resetMiningProgress((Level)worldIn, player);
        }
        super.stopSpell(worldIn, caster, staff, focus, castTime, spellStat);
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        Player player;
        BlockHitResult blockHitResult;
        BlockPos blockPos;
        BlockState blockState;
        int range = spellStat.getRange();
        int potency = spellStat.getPotency();
        int burning = spellStat.getBurning();
        if (WandUtil.enchantedFocus(caster)) {
            range += WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), caster);
            potency += WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
            burning += WandUtil.getLevels((Enchantment)ModEnchantments.BURNING.get(), caster);
        }
        if ((blockState = worldIn.m_8055_(blockPos = (blockHitResult = this.blockResult((Level)worldIn, caster, range)).m_82425_())).m_60795_()) {
            return;
        }
        float hardness = BurrowingSpell.getHardness(blockPos, caster, potency);
        if ((hardness = (float)Math.floor(hardness)) == 0.0f) {
            hardness = 1.0f;
        }
        if (this.rightStaff(staff)) {
            ++potency;
        }
        if (caster instanceof Player && BurrowingSpell.canMineBlock((Level)worldIn, player = (Player)caster, blockPos, blockState)) {
            Tiers tier;
            int miningLevel = 1 + potency;
            Tiers tiers = miningLevel < 3 ? Tiers.IRON : (tier = miningLevel == 3 ? Tiers.DIAMOND : Tiers.NETHERITE);
            if (!TierSortingRegistry.isCorrectTierForDrops((Tier)tier, (BlockState)blockState)) {
                hardness = blockState.m_60800_((BlockGetter)worldIn, blockPos) * 5.0f;
            }
            SoundType soundtype = blockState.getSoundType((LevelReader)worldIn, blockPos, null);
            BlockPos miningPos = SEHelper.getMiningPos(player);
            if (miningPos != null && (miningPos.m_123341_() != blockPos.m_123341_() || miningPos.m_123342_() != blockPos.m_123342_() || miningPos.m_123343_() != blockPos.m_123343_())) {
                SEHelper.setMiningProgress(player, 0);
            }
            SEHelper.increaseMiningProgress(player);
            SEHelper.setMiningPos(player, blockPos);
            BurrowingSpell.destroyBlockProgress(worldIn, player.m_19879_(), blockPos, (int)((float)SEHelper.getMiningProgress(player) / hardness * 10.0f));
            if (SEHelper.getMiningProgress(player) % 4 == 0) {
                worldIn.m_5594_(null, blockPos, soundtype.m_56778_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
            }
            if ((float)SEHelper.getMiningProgress(player) >= hardness) {
                ItemStack tempTool = new ItemStack((ItemLike)Items.f_42385_);
                if (miningLevel == 3) {
                    tempTool = new ItemStack((ItemLike)Items.f_42390_);
                } else if (miningLevel > 3) {
                    tempTool = new ItemStack((ItemLike)Items.f_42395_);
                }
                int silk = WandUtil.getLevels(Enchantments.f_44985_, (LivingEntity)player);
                int fortune = WandUtil.getLevels(Enchantments.f_44987_, (LivingEntity)player);
                if (silk > 0) {
                    tempTool.m_41663_(Enchantments.f_44985_, silk);
                } else if (fortune > 0) {
                    tempTool.m_41663_(Enchantments.f_44987_, fortune);
                }
                BlockEvent.BreakEvent breakEvent = BurrowingSpell.fixForgeEventBreakBlock(blockState, player, (Level)worldIn, blockPos, silk, fortune);
                MinecraftForge.EVENT_BUS.post((Event)breakEvent);
                if (breakEvent.isCanceled()) {
                    return;
                }
                if (TierSortingRegistry.isCorrectTierForDrops((Tier)tier, (BlockState)blockState)) {
                    List drops = Block.m_49874_((BlockState)blockState, (ServerLevel)worldIn, (BlockPos)blockPos, null, (Entity)player, (ItemStack)tempTool);
                    int exp = blockState.getExpDrop((LevelReader)worldIn, worldIn.f_46441_, blockPos, fortune, silk);
                    boolean magnetMode = WandUtil.getLevels((Enchantment)ModEnchantments.MAGNET.get(), caster) > 0;
                    for (ItemStack drop : drops) {
                        ItemStack smeltedItemStack;
                        Optional optional;
                        if (drop == null) continue;
                        if (burning > 0 && (optional = worldIn.m_7465_().m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{drop.m_41777_()}), (Level)worldIn)).isPresent() && !(smeltedItemStack = ((SmeltingRecipe)optional.get()).m_8043_(worldIn.m_9598_()).m_41777_()).m_41619_()) {
                            drop = ItemHandlerHelper.copyStackWithSize((ItemStack)smeltedItemStack, (int)(drop.m_41613_() * smeltedItemStack.m_41613_()));
                        }
                        if (magnetMode) {
                            int wasPickedUp = ForgeEventFactory.onItemPickup((ItemEntity)new ItemEntity((Level)worldIn, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), drop), (Player)player);
                            if (wasPickedUp != 0 || player.m_36356_(drop)) continue;
                            Block.m_49840_((Level)worldIn, (BlockPos)blockPos, (ItemStack)drop);
                            continue;
                        }
                        Block.m_49840_((Level)worldIn, (BlockPos)blockPos, (ItemStack)drop);
                    }
                    if (magnetMode) {
                        if (exp > 0) {
                            player.m_6756_(exp);
                        }
                    } else if (exp > 0) {
                        blockState.m_60734_().m_49805_(worldIn, blockPos, exp);
                    }
                }
                worldIn.m_5594_(null, blockPos, soundtype.m_56775_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
                worldIn.m_46747_(blockPos);
                worldIn.m_46796_(2001, blockPos, Block.m_49956_((BlockState)blockState));
                worldIn.m_46597_(blockPos, Blocks.f_50016_.m_49966_());
                player.m_36246_(Stats.f_12949_.m_12902_((Object)blockState.m_60734_()));
                SEHelper.setMiningProgress(player, 0);
                SEHelper.setMiningPos(player, null);
                BurrowingSpell.destroyBlockProgress(worldIn, player.m_19879_(), blockPos, -1);
            }
        }
    }

    public static void resetMiningProgress(Level level, Player player) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (SEHelper.getMiningProgress(player) > 0) {
                SEHelper.setMiningProgress(player, 0);
            }
            if (SEHelper.getMiningPos(player) != null) {
                BurrowingSpell.destroyBlockProgress(serverLevel, player.m_19879_(), SEHelper.getMiningPos(player), -1);
                SEHelper.setMiningPos(player, null);
            }
        }
    }

    public static void destroyBlockProgress(ServerLevel serverLevel, int p_8612_, BlockPos p_8613_, int p_8614_) {
        for (ServerPlayer serverplayer : serverLevel.m_7654_().m_6846_().m_11314_()) {
            double d2;
            double d1;
            double d0;
            if (serverplayer == null || serverplayer.f_19853_ != serverLevel || !((d0 = (double)p_8613_.m_123341_() - serverplayer.m_20185_()) * d0 + (d1 = (double)p_8613_.m_123342_() - serverplayer.m_20186_()) * d1 + (d2 = (double)p_8613_.m_123343_() - serverplayer.m_20189_()) * d2 < 1024.0)) continue;
            serverplayer.f_8906_.m_9829_((Packet)new ClientboundBlockDestructionPacket(p_8612_, p_8613_, p_8614_));
        }
    }

    public static boolean canMineBlock(Level world, Player player, BlockPos pos, BlockState state) {
        if (!player.m_36326_() || !world.m_7966_(player, pos)) {
            return false;
        }
        return BurrowingSpell.isValid(pos, world) && !MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(world, pos, state, player));
    }

    private static boolean isValid(BlockPos pos, Level world) {
        BlockState state = world.m_8055_(pos);
        if (!state.m_60819_().m_76178_() && !state.m_61138_((Property)BlockStateProperties.f_61362_) || world.m_46859_(pos)) {
            return false;
        }
        if (state.m_60800_((BlockGetter)world, pos) < 0.0f) {
            return false;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity != null) {
            return false;
        }
        return !(state.m_60734_() instanceof DoorBlock);
    }

    private static float getHardness(BlockPos blockPos, LivingEntity player, int efficiency) {
        MobEffectInstance fatigue;
        float hardness = 0.0f;
        float toolSpeed = ((Integer)SpellConfig.BurrowingInitialSpeed.get()).intValue();
        if (efficiency > 0) {
            toolSpeed += (float)(efficiency * efficiency + 1);
        }
        if (MobEffectUtil.m_19584_((LivingEntity)player)) {
            toolSpeed *= 1.0f + (float)(MobEffectUtil.m_19586_((LivingEntity)player) + 1) * 0.2f;
        }
        if ((fatigue = player.m_21124_(MobEffects.f_19599_)) != null) {
            float f1 = switch (fatigue.m_19564_()) {
                case 0 -> 0.3f;
                case 1 -> 0.09f;
                case 2 -> 0.0027f;
                default -> 8.1E-4f;
            };
            toolSpeed *= f1;
        }
        Level world = player.f_19853_;
        BlockState state = world.m_8055_(blockPos);
        if (player instanceof Player) {
            Player player1 = (Player)player;
            toolSpeed = ForgeEventFactory.getBreakSpeed((Player)player1, (BlockState)state, (float)toolSpeed, (BlockPos)blockPos);
        }
        return hardness += state.m_60800_((BlockGetter)world, blockPos) * 30.0f / toolSpeed;
    }

    private static BlockEvent.BreakEvent fixForgeEventBreakBlock(BlockState state, Player player, Level world, BlockPos pos, int silk, int fortune) {
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, player);
        if (state != null) {
            event.setExpToDrop(state.getExpDrop((LevelReader)world, world.f_46441_, pos, fortune, silk));
        }
        return event;
    }
}

