/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.projectiles.SwordProjectile;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.utils.ItemHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;

public class SwordSpell
extends Spell {
    @Override
    public SpellStat defaultStats() {
        return super.defaultStats().setVelocity(1.6f);
    }

    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.SwordCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.SwordDuration.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return SoundEvents.f_11821_;
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.SwordCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.ILL;
    }

    @Override
    public boolean conditionsMet(ServerLevel worldIn, LivingEntity caster) {
        return caster.m_21205_().m_41720_() instanceof SwordItem || caster.m_21206_().m_41720_() instanceof SwordItem;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.VELOCITY.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        float velocity = spellStat.getVelocity();
        if (WandUtil.enchantedFocus(caster)) {
            velocity += (float)WandUtil.getLevels((Enchantment)ModEnchantments.VELOCITY.get(), caster) / 3.0f;
        }
        if (caster.m_21205_().m_41720_() instanceof SwordItem || caster.m_21206_().m_41720_() instanceof SwordItem) {
            ItemStack sword = caster.m_21205_().m_41720_() instanceof SwordItem ? caster.m_21205_() : caster.m_21206_();
            SwordProjectile swordProjectile = new SwordProjectile(caster, (Level)worldIn, sword);
            swordProjectile.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
            swordProjectile.m_37251_((Entity)caster, caster.m_146909_(), caster.m_146908_(), 0.0f, velocity, 1.0f);
            swordProjectile.m_5602_((Entity)caster);
            if (worldIn.m_7967_((Entity)swordProjectile) && MobUtil.validEntity((Entity)caster)) {
                ItemHelper.hurtAndBreak(sword, 10, caster);
            }
            this.playSound(worldIn, caster, 1.0f, 1.0f);
        } else {
            this.playSound(worldIn, (Entity)caster, SoundEvents.f_11937_, 1.0f, 1.0f);
        }
    }
}

