/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells;

import com.Polarice3.Goety.client.particles.FoggyCloudParticleOption;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.projectiles.RainArrow;
import com.Polarice3.Goety.common.magic.EverChargeSpell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ArrowRainSpell
extends EverChargeSpell {
    @Override
    public SpellStat defaultStats() {
        return super.defaultStats().setVelocity(1.0f);
    }

    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.ArrowRainCost.get();
    }

    @Override
    public int defaultCastUp() {
        return (Integer)SpellConfig.ArrowRainChargeUp.get();
    }

    @Override
    public int shotsNumber() {
        return (Integer)SpellConfig.ArrowRainDuration.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.ArrowRainCoolDown.get();
    }

    @Override
    @Nullable
    public SoundEvent CastingSound() {
        return SoundEvents.f_11842_;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.RANGE.get());
        list.add((Enchantment)ModEnchantments.BURNING.get());
        list.add((Enchantment)ModEnchantments.VELOCITY.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        int potency = spellStat.getPotency();
        int burning = spellStat.getBurning();
        int range = spellStat.getRange();
        float velocity = spellStat.getVelocity();
        if (WandUtil.enchantedFocus(caster)) {
            potency += WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
            burning += WandUtil.getLevels((Enchantment)ModEnchantments.BURNING.get(), caster);
            range += WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), caster);
            velocity += (float)WandUtil.getLevels((Enchantment)ModEnchantments.VELOCITY.get(), caster) / 2.0f;
        }
        HitResult rayTrace = this.rayTrace((Level)worldIn, caster, range, 3.0);
        Vec3 location = rayTrace.m_82450_();
        LivingEntity target = this.getTarget(caster, range);
        if (target != null) {
            location = target.m_20182_();
        }
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(location.f_82479_, location.f_82480_ + 1.5, location.f_82481_);
        int maxHeight = 15;
        for (int i = 0; mutableBlockPos.m_123342_() < worldIn.m_151558_() && worldIn.m_46859_((BlockPos)mutableBlockPos) && i < maxHeight; ++i) {
            mutableBlockPos = mutableBlockPos.m_7494_();
        }
        for (int j = 0; j < potency + 1; ++j) {
            RainArrow arrow = new RainArrow((Level)worldIn, caster);
            Vec3 vec3 = mutableBlockPos.m_252807_().m_82520_((double)(worldIn.f_46441_.m_188501_() * 16.0f - 8.0f), (double)(worldIn.f_46441_.m_188501_() * 4.0f - 2.0f), (double)(worldIn.f_46441_.m_188501_() * 16.0f - 8.0f));
            for (int clearTries = 0; clearTries < 6 && !worldIn.m_46859_(BlockPos.m_274446_((Position)vec3)) && worldIn.m_6425_(BlockPos.m_274446_((Position)vec3)).m_76178_(); ++clearTries) {
                vec3 = mutableBlockPos.m_252807_().m_82520_((double)(worldIn.f_46441_.m_188501_() * 16.0f - 8.0f), (double)(worldIn.f_46441_.m_188501_() * 4.0f - 2.0f), (double)(worldIn.f_46441_.m_188501_() * 16.0f - 8.0f));
            }
            if (!worldIn.m_46859_(BlockPos.m_274446_((Position)vec3)) && worldIn.m_6425_(BlockPos.m_274446_((Position)vec3)).m_76178_()) {
                vec3 = mutableBlockPos.m_252807_();
            }
            worldIn.m_8767_((ParticleOptions)new FoggyCloudParticleOption(new ColorUtil(0x4B4B4B), 1.5f, 6), vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_(), 1, 0.0, 0.0, 0.0, 0.0);
            arrow.m_146884_(vec3);
            Vec3 vec31 = location.m_82546_(vec3);
            float randomness = 20.0f + worldIn.f_46441_.m_188501_() * 10.0f;
            if (worldIn.f_46441_.m_188501_() < 0.25f) {
                randomness = worldIn.f_46441_.m_188501_();
            }
            if (burning > 0) {
                arrow.m_20254_(100);
            }
            arrow.m_6686_(vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, velocity + 1.5f * worldIn.f_46441_.m_188501_(), randomness);
            arrow.m_36781_(arrow.m_36789_() + (Double)SpellConfig.ArrowRainExtraDamage.get());
            if (!worldIn.m_7967_((Entity)arrow)) continue;
            this.playSound(worldIn, (Entity)arrow, SoundEvents.f_11687_, 2.0f, 1.0f / (worldIn.m_213780_().m_188501_() * 0.4f + 1.2f) + 0.5f);
        }
    }
}

