/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.items.magic;

import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.api.entities.ally.IServant;
import com.Polarice3.Goety.api.items.magic.IWand;
import com.Polarice3.Goety.api.magic.IBlockSpell;
import com.Polarice3.Goety.api.magic.IBreathingSpell;
import com.Polarice3.Goety.api.magic.IChargingSpell;
import com.Polarice3.Goety.api.magic.ISpell;
import com.Polarice3.Goety.api.magic.ITouchSpell;
import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.blocks.entities.ArcaBlockEntity;
import com.Polarice3.Goety.common.blocks.entities.BrewCauldronBlockEntity;
import com.Polarice3.Goety.common.entities.neutral.AbstractVine;
import com.Polarice3.Goety.common.events.spell.GoetyEventFactory;
import com.Polarice3.Goety.common.items.magic.CallFocus;
import com.Polarice3.Goety.common.items.magic.CommandFocus;
import com.Polarice3.Goety.common.items.magic.OrderFocus;
import com.Polarice3.Goety.common.items.magic.RecallFocus;
import com.Polarice3.Goety.common.items.magic.TroopFocus;
import com.Polarice3.Goety.common.magic.spells.wind.FlyingSpell;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.server.SPlayEntitySoundPacket;
import com.Polarice3.Goety.common.network.server.SPlayPlayerSoundPacket;
import com.Polarice3.Goety.config.MobsConfig;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModKeybindings;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.init.ModTags;
import com.Polarice3.Goety.utils.ItemHelper;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.SEHelper;
import com.Polarice3.Goety.utils.WandUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.gossip.GossipType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class DarkWand
extends Item
implements IWand {
    public SpellType spellType;

    public DarkWand(Item.Properties properties, SpellType spellType) {
        super(properties);
        this.spellType = spellType;
    }

    public DarkWand(SpellType spellType) {
        this(DarkWand.wandProperties(), spellType);
    }

    public DarkWand() {
        this(SpellType.NONE);
    }

    @Override
    public SpellType getSpellType() {
        return this.spellType;
    }

    public static Item.Properties wandProperties() {
        return new Item.Properties().m_41497_(Rarity.RARE).setNoRepair().m_41487_(1);
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entityIn;
            CompoundTag compound = stack.m_41784_();
            if (stack.m_41783_() == null) {
                compound.m_128405_("Soul Use", this.SoulUse(livingEntity, stack));
                compound.m_128405_("Soul Cost", 0);
                compound.m_128405_("Cast Time", this.CastDuration(stack));
                compound.m_128405_("Cool", 0);
                compound.m_128405_("Shots", 0);
                compound.m_128405_("Seconds", 0);
            } else if (!compound.m_128441_("Shots")) {
                compound.m_128405_("Shots", 0);
            }
            if (this.getSpell(stack) != null) {
                this.setSpellConditions(this.getSpell(stack), stack, livingEntity);
            } else {
                this.setSpellConditions(null, stack, livingEntity);
            }
            compound.m_128405_("Soul Use", this.SoulUse(livingEntity, stack));
            compound.m_128405_("Cast Time", this.CastDuration(stack));
            if (IWand.getFocus(stack) != null) {
                IWand.getFocus(stack).m_41666_(worldIn, entityIn, itemSlot, isSelected);
            }
        }
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public void m_7836_(ItemStack pStack, Level pLevel, Player pPlayer) {
        CompoundTag compound = pStack.m_41784_();
        compound.m_128405_("Soul Use", this.SoulUse((LivingEntity)pPlayer, pStack));
        compound.m_128405_("Soul Cost", 0);
        compound.m_128405_("Cast Time", this.CastDuration(pStack));
        compound.m_128405_("Cool", 0);
        compound.m_128405_("Seconds", 0);
        compound.m_128405_("Shots", 0);
        this.setSpellConditions(null, pStack, (LivingEntity)pPlayer);
    }

    @Override
    public int SoulUse(LivingEntity entityLiving, ItemStack stack) {
        if (IWand.getFocus(stack).m_41793_() && ((Boolean)SpellConfig.EnchantMultiCost.get()).booleanValue()) {
            return (int)((float)(this.SoulCost(stack) * 2) * SEHelper.soulDiscount(entityLiving));
        }
        return (int)((float)this.SoulCost(stack) * SEHelper.soulDiscount(entityLiving));
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        IOwned owned1;
        LivingEntity livingEntity;
        IOwned owned;
        LivingEntity target;
        boolean flag = false;
        if (!player.f_19853_.f_46443_ && entity instanceof LivingEntity && (target = (LivingEntity)entity) instanceof IOwned && ((owned = (IOwned)target).getTrueOwner() == player || (livingEntity = owned.getTrueOwner()) instanceof IOwned && (owned1 = (IOwned)livingEntity).getTrueOwner() == player)) {
            List<LivingEntity> list;
            IServant servant;
            IServant servant2;
            if (IWand.getFocus(stack).m_41720_() instanceof CallFocus && !CallFocus.hasSummon(IWand.getFocus(stack))) {
                CompoundTag compoundTag = new CompoundTag();
                if (IWand.getFocus(stack).m_41782_()) {
                    compoundTag = IWand.getFocus(stack).m_41783_();
                }
                CallFocus.setSummon(compoundTag, target);
                IWand.getFocus(stack).m_41751_(compoundTag);
                player.m_5496_(SoundEvents.f_11686_, 1.0f, 0.45f);
                ModNetwork.sendTo(player, new SPlayPlayerSoundPacket(SoundEvents.f_11686_, 1.0f, 0.45f));
                flag = true;
            } else if (IWand.getFocus(stack).m_41720_() instanceof TroopFocus && !TroopFocus.hasSummonType(IWand.getFocus(stack))) {
                CompoundTag compoundTag = new CompoundTag();
                if (IWand.getFocus(stack).m_41782_()) {
                    compoundTag = IWand.getFocus(stack).m_41783_();
                }
                TroopFocus.setSummonType(compoundTag, target.m_6095_());
                IWand.getFocus(stack).m_41751_(compoundTag);
                player.m_5496_(SoundEvents.f_11686_, 1.0f, 0.45f);
                ModNetwork.sendTo(player, new SPlayPlayerSoundPacket(SoundEvents.f_11686_, 1.0f, 0.45f));
                flag = true;
            } else if (IWand.getFocus(stack).m_41720_() instanceof CommandFocus && owned instanceof IServant && (servant2 = (IServant)owned).canBeCommanded() && !CommandFocus.hasServant(IWand.getFocus(stack))) {
                CompoundTag compoundTag = new CompoundTag();
                if (IWand.getFocus(stack).m_41782_()) {
                    compoundTag = IWand.getFocus(stack).m_41783_();
                }
                CommandFocus.setServant(compoundTag, target);
                IWand.getFocus(stack).m_41751_(compoundTag);
                player.m_5496_(SoundEvents.f_11686_, 1.0f, 0.45f);
                ModNetwork.sendTo(player, new SPlayPlayerSoundPacket(SoundEvents.f_11686_, 1.0f, 0.45f));
                flag = true;
            } else if (IWand.getFocus(stack).m_41720_() instanceof OrderFocus && owned instanceof IServant && (servant = (IServant)owned).canBeCommanded() && ((list = OrderFocus.getServants(IWand.getFocus(stack))).isEmpty() || list.size() < 8) && !list.contains(target)) {
                OrderFocus.setServants(IWand.getFocus(stack), player, target);
                player.m_5496_(SoundEvents.f_11686_, 1.0f, 0.45f);
                ModNetwork.sendTo(player, new SPlayPlayerSoundPacket(SoundEvents.f_11686_, 1.0f, 0.45f));
                flag = true;
            }
            if (!flag) {
                if (owned instanceof IServant) {
                    IServant summonedEntity = (IServant)owned;
                    if (player.m_6144_() || player.m_6047_()) {
                        if ((Integer)SpellConfig.OwnerHitKill.get() == 0) {
                            summonedEntity.tryKill(player);
                            flag = true;
                        }
                    } else if (((Boolean)SpellConfig.OwnerHitCommand.get()).booleanValue() && summonedEntity.canUpdateMove()) {
                        summonedEntity.updateMoveMode(player);
                        flag = true;
                    }
                } else if (owned instanceof AbstractVine) {
                    AbstractVine vine = (AbstractVine)owned;
                    if ((player.m_6144_() || player.m_6047_()) && (Integer)SpellConfig.OwnerHitKill.get() == 0) {
                        vine.m_6074_();
                        flag = true;
                    }
                }
            }
        }
        return flag;
    }

    @Nonnull
    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        Object owned1;
        IOwned owned;
        LivingEntity livingEntity3;
        if (IWand.getFocus(stack).m_41720_() instanceof CommandFocus) {
            IServant summoned;
            LivingEntity livingEntity2 = CommandFocus.getServant(IWand.getFocus(stack));
            if (livingEntity2 instanceof IServant && (summoned = (IServant)livingEntity2) != target && summoned.getTrueOwner() == player && target.m_20270_((Entity)player) <= 64.0f) {
                summoned.setCommandPosEntity(target);
                player.m_5496_((SoundEvent)ModSounds.COMMAND.get(), 1.0f, 0.45f);
                if (!player.f_19853_.f_46443_) {
                    ModNetwork.sendTo(player, new SPlayPlayerSoundPacket((SoundEvent)ModSounds.COMMAND.get(), 1.0f, 0.45f));
                }
                return InteractionResult.SUCCESS;
            }
        } else if (IWand.getFocus(stack).m_41720_() instanceof OrderFocus && !OrderFocus.getServants(IWand.getFocus(stack)).isEmpty()) {
            int i = 0;
            for (LivingEntity livingEntity3 : OrderFocus.getServants(IWand.getFocus(stack))) {
                IServant summoned;
                if (!(livingEntity3 instanceof IServant) || (summoned = (IServant)livingEntity3) == target || summoned.getTrueOwner() != player || !(target.m_20270_((Entity)player) <= 64.0f)) continue;
                summoned.setCommandPosEntityOrder(target);
                ++i;
            }
            if (i > 0) {
                player.m_5496_((SoundEvent)ModSounds.COMMAND.get(), 1.0f, 0.45f);
                if (!player.f_19853_.f_46443_) {
                    ModNetwork.sendTo(player, new SPlayPlayerSoundPacket((SoundEvent)ModSounds.COMMAND.get(), 1.0f, 0.45f));
                }
                return InteractionResult.SUCCESS;
            }
        }
        if (target instanceof IOwned && ((owned = (IOwned)target).getTrueOwner() == player || (livingEntity3 = owned.getTrueOwner()) instanceof IOwned && (owned1 = (IOwned)livingEntity3).getTrueOwner() == player)) {
            if (owned instanceof IServant) {
                IServant summonedEntity = (IServant)owned;
                if (player.m_6144_() || player.m_6047_()) {
                    if ((Integer)SpellConfig.OwnerHitKill.get() == 1) {
                        summonedEntity.tryKill(player);
                        return InteractionResult.SUCCESS;
                    }
                } else if (!((Boolean)SpellConfig.OwnerHitCommand.get()).booleanValue() && summonedEntity.canUpdateMove()) {
                    summonedEntity.updateMoveMode(player);
                    return InteractionResult.SUCCESS;
                }
            } else if (owned instanceof AbstractVine) {
                AbstractVine vine = (AbstractVine)owned;
                if ((player.m_6144_() || player.m_6047_()) && (Integer)SpellConfig.OwnerHitKill.get() == 1) {
                    vine.m_6074_();
                    return InteractionResult.SUCCESS;
                }
            }
        }
        if ((owned1 = this.getSpell(stack)) instanceof ITouchSpell) {
            ITouchSpell touchSpells = (ITouchSpell)owned1;
            if (this.canCastTouch(stack, player.f_19853_, (LivingEntity)player)) {
                Level level = player.f_19853_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    touchSpells.touchResult(serverLevel, (LivingEntity)player, target, stack, touchSpells.defaultStats());
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6880_(stack, player, target, hand);
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        Level level = pContext.m_43725_();
        BlockPos blockpos = pContext.m_8083_();
        Player player = pContext.m_43723_();
        InteractionHand hand = pContext.m_43724_();
        ItemStack stack = pContext.m_43722_();
        if (player != null) {
            BlockEntity blockEntity;
            Item item = IWand.getFocus(stack).m_41720_();
            if (item instanceof RecallFocus) {
                RecallFocus recallFocus = (RecallFocus)item;
                CompoundTag compoundTag = IWand.getFocus(stack).m_41784_();
                if (!RecallFocus.hasRecall(IWand.getFocus(stack))) {
                    BlockState blockstate;
                    BlockEntity tileEntity = level.m_7702_(blockpos);
                    if (tileEntity instanceof ArcaBlockEntity) {
                        ArcaBlockEntity arcaTile = (ArcaBlockEntity)tileEntity;
                        if (pContext.m_43723_() == arcaTile.getPlayer() && arcaTile.m_58904_() != null) {
                            recallFocus.addRecallTags((ResourceKey<Level>)arcaTile.m_58904_().m_46472_(), arcaTile.m_58899_(), compoundTag);
                            IWand.getFocus(stack).m_41751_(compoundTag);
                            player.m_5496_(SoundEvents.f_11686_, 1.0f, 0.45f);
                            if (!level.f_46443_) {
                                ModNetwork.sendTo(player, new SPlayPlayerSoundPacket(SoundEvents.f_11686_, 1.0f, 0.45f));
                            }
                            return InteractionResult.m_19078_((boolean)level.f_46443_);
                        }
                    }
                    if ((blockstate = level.m_8055_(blockpos)).m_204336_(ModTags.Blocks.RECALL_BLOCKS)) {
                        recallFocus.addRecallTags((ResourceKey<Level>)level.m_46472_(), blockpos, compoundTag);
                        IWand.getFocus(stack).m_41751_(compoundTag);
                        player.m_5496_(SoundEvents.f_11686_, 1.0f, 0.45f);
                        if (!level.f_46443_) {
                            ModNetwork.sendTo(player, new SPlayPlayerSoundPacket(SoundEvents.f_11686_, 1.0f, 0.45f));
                        }
                        return InteractionResult.m_19078_((boolean)level.f_46443_);
                    }
                }
            } else if (IWand.getFocus(stack).m_41720_() instanceof CommandFocus) {
                LivingEntity tileEntity;
                if (CommandFocus.hasServant(IWand.getFocus(stack)) && (tileEntity = CommandFocus.getServant(IWand.getFocus(stack))) instanceof IServant) {
                    IServant summoned = (IServant)tileEntity;
                    LivingEntity livingEntity = CommandFocus.getServant(IWand.getFocus(stack));
                    if (livingEntity != null && summoned.getTrueOwner() == player && livingEntity.m_20270_((Entity)player) <= 64.0f) {
                        BlockPos above = blockpos.m_7494_();
                        boolean flag = false;
                        if (summoned.canCommandToBlock(level, blockpos)) {
                            summoned.setCommandPos(blockpos);
                            flag = true;
                        } else if (summoned.canCommandToBlock(level, above)) {
                            summoned.setCommandPos(above);
                            flag = true;
                        }
                        if (flag) {
                            player.m_5496_((SoundEvent)ModSounds.COMMAND.get(), 1.0f, 0.45f);
                            if (!level.f_46443_) {
                                ModNetwork.sendTo(player, new SPlayPlayerSoundPacket((SoundEvent)ModSounds.COMMAND.get(), 1.0f, 0.45f));
                            }
                            return InteractionResult.m_19078_((boolean)level.f_46443_);
                        }
                    }
                }
            } else if (IWand.getFocus(stack).m_41720_() instanceof OrderFocus) {
                if (!OrderFocus.getServants(IWand.getFocus(stack)).isEmpty()) {
                    int i = 0;
                    for (LivingEntity livingEntity : OrderFocus.getServants(IWand.getFocus(stack))) {
                        IServant summoned;
                        if (!(livingEntity instanceof IServant) || !(summoned = (IServant)livingEntity).canBeCommanded() || summoned.getTrueOwner() != player || !(livingEntity.m_20270_((Entity)player) <= 64.0f)) continue;
                        BlockPos above = blockpos.m_7494_();
                        if (summoned.canCommandToBlock(level, blockpos)) {
                            summoned.setCommandPos(blockpos);
                            ++i;
                            continue;
                        }
                        if (!summoned.canCommandToBlock(level, above)) continue;
                        summoned.setCommandPos(above);
                        ++i;
                    }
                    if (i > 0) {
                        player.m_5496_((SoundEvent)ModSounds.COMMAND.get(), 1.0f, 0.45f);
                        if (!level.f_46443_) {
                            ModNetwork.sendTo(player, new SPlayPlayerSoundPacket((SoundEvent)ModSounds.COMMAND.get(), 1.0f, 0.45f));
                        }
                        return InteractionResult.m_19078_((boolean)level.f_46443_);
                    }
                }
            } else {
                Object spell2;
                ISpell i = this.getSpell(stack);
                if (i instanceof IBlockSpell) {
                    IBlockSpell blockSpell0 = (IBlockSpell)i;
                    spell2 = GoetyEventFactory.onBlockBasedSpell((LevelAccessor)player.f_19853_, blockpos, player.f_19853_.m_8055_(blockpos), blockSpell0, pContext.m_43719_(), (LivingEntity)player);
                    if (spell2 instanceof IBlockSpell) {
                        ServerLevel serverLevel;
                        IBlockSpell blockSpell = (IBlockSpell)spell2;
                        Level level2 = player.f_19853_;
                        if (level2 instanceof ServerLevel && blockSpell.rightBlock(serverLevel = (ServerLevel)level2, (LivingEntity)player, blockpos, pContext.m_43719_())) {
                            if (this.canCastTouch(stack, level, (LivingEntity)player)) {
                                blockSpell.blockResult(serverLevel, (LivingEntity)player, stack, blockpos, pContext.m_43719_());
                            }
                            return InteractionResult.SUCCESS;
                        }
                    }
                } else if (level.m_8055_(blockpos).m_204336_(BlockTags.f_13028_) && (spell2 = level.m_7702_(blockpos)) instanceof BannerBlockEntity) {
                    CompoundTag compoundtag;
                    BannerBlockEntity bannerBlock = (BannerBlockEntity)spell2;
                    if (!level.f_46443_ && (compoundtag = BlockItem.m_186336_((ItemStack)bannerBlock.m_155043_())) != null && compoundtag.m_128441_("Patterns")) {
                        SEHelper.setBannerBaseColor(player, bannerBlock.m_155044_());
                        SEHelper.setBannerPattern(player, compoundtag.m_128437_("Patterns", 10));
                        player.m_5661_((Component)Component.m_237110_((String)"info.goety.banner.add", (Object[])new Object[]{player.m_5446_()}), true);
                        level.m_6263_(null, (double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_(), (SoundEvent)ModSounds.CAST_SPELL.get(), SoundSource.BLOCKS, 1.0f, 0.5f);
                        return InteractionResult.SUCCESS;
                    }
                } else if (!level.m_8055_(blockpos).m_60795_() && !level.f_46443_) {
                    return level.m_8055_(blockpos).m_60664_(level, player, hand, new BlockHitResult(pContext.m_43720_(), pContext.m_43719_(), pContext.m_8083_(), pContext.m_43721_()));
                }
            }
            if (!level.f_46443_ && (blockEntity = level.m_7702_(blockpos)) instanceof BrewCauldronBlockEntity) {
                BrewCauldronBlockEntity cauldronBlock = (BrewCauldronBlockEntity)blockEntity;
                if (MobUtil.isShifting((Entity)player) && stack.m_41720_() instanceof IWand) {
                    cauldronBlock.fullReset();
                    level.m_5594_(null, blockpos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.m_5594_(null, blockpos, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return super.m_6225_(pContext);
    }

    public void m_5929_(Level worldIn, LivingEntity livingEntityIn, ItemStack stack, int count) {
        ISpell iSpell = GoetyEventFactory.onStartSpell(livingEntityIn, stack, this.getSpell(stack));
        if (worldIn instanceof ServerLevel && this.cannotCast(livingEntityIn, stack, iSpell)) {
            livingEntityIn.m_5810_();
            return;
        }
        int CastTime = stack.m_41779_() - count;
        if (livingEntityIn.m_21211_() == stack && iSpell != null && this.isNotInstant(iSpell, livingEntityIn, stack)) {
            ServerLevel serverLevel;
            SoundEvent soundevent = this.CastingSound(stack, livingEntityIn);
            if (CastTime == 1 && soundevent != null) {
                if (worldIn instanceof ServerLevel) {
                    serverLevel = (ServerLevel)worldIn;
                    iSpell.startSpell(serverLevel, livingEntityIn, stack, iSpell.defaultStats());
                }
                worldIn.m_6263_(null, livingEntityIn.m_20185_(), livingEntityIn.m_20186_(), livingEntityIn.m_20189_(), soundevent, SoundSource.PLAYERS, this.castingVolume(stack), this.castingPitch(stack));
            }
            if (worldIn instanceof ServerLevel) {
                serverLevel = (ServerLevel)worldIn;
                if ((iSpell = GoetyEventFactory.onCastingSpell(livingEntityIn, stack, iSpell, CastTime)) != null) {
                    iSpell.useSpell(serverLevel, livingEntityIn, stack, CastTime, iSpell.defaultStats());
                } else {
                    livingEntityIn.m_5810_();
                }
            }
            if (iSpell != null) {
                IChargingSpell spell;
                if (iSpell instanceof IChargingSpell && (spell = (IChargingSpell)iSpell).castUp(livingEntityIn, stack) > 0) {
                    this.useParticles(worldIn, livingEntityIn, stack, iSpell);
                } else if (!(iSpell instanceof IChargingSpell)) {
                    this.useParticles(worldIn, livingEntityIn, stack, iSpell);
                }
                if (iSpell instanceof IChargingSpell) {
                    Player player;
                    spell = (IChargingSpell)iSpell;
                    if (stack.m_41783_() != null && (CastTime >= spell.castUp(livingEntityIn, stack) || spell.castUp(livingEntityIn, stack) <= 0)) {
                        stack.m_41783_().m_128405_("Cool", stack.m_41783_().m_128451_("Cool") + 1);
                        if (stack.m_41783_().m_128451_("Cool") >= this.Cooldown(stack)) {
                            stack.m_41783_().m_128405_("Cool", 0);
                            if (spell.shotsNumber(livingEntityIn, stack) > 0) {
                                this.increaseShots(stack);
                            }
                            this.MagicResults(stack, worldIn, livingEntityIn, spell);
                        }
                    }
                    if (livingEntityIn instanceof Player && !SEHelper.getSoulsAmount(player = (Player)livingEntityIn, iSpell.soulCost((LivingEntity)player, stack)) && !player.m_7500_()) {
                        player.m_5810_();
                    }
                }
            } else {
                livingEntityIn.m_5810_();
            }
        }
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity livingEntity, int useTimeRemaining) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int CastTime = stack.m_41779_() - useTimeRemaining;
            ISpell spell = GoetyEventFactory.onStopSpell(livingEntity, stack, this.getSpell(stack), CastTime, useTimeRemaining);
            if (spell != null) {
                spell.stopSpell(serverLevel, livingEntity, stack, IWand.getFocus(stack), CastTime, spell.defaultStats());
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    if (spell instanceof IChargingSpell) {
                        IChargingSpell chargeSpell = (IChargingSpell)spell;
                        if (chargeSpell.shotsNumber((LivingEntity)player, stack) > 0) {
                            if (this.ShotsFired(stack) > 0) {
                                float coolPercent = (float)this.ShotsFired(stack) / (float)chargeSpell.shotsNumber((LivingEntity)player, stack);
                                this.setShots(stack, 0);
                                SEHelper.addCooldown(player, IWand.getFocus(stack).m_41720_(), Mth.m_14143_((float)((float)chargeSpell.spellCooldown() * coolPercent)));
                            }
                        } else {
                            SEHelper.addCooldown(player, IWand.getFocus(stack).m_41720_(), Mth.m_14143_((float)chargeSpell.spellCooldown()));
                        }
                    }
                }
            }
        }
    }

    public int m_8105_(ItemStack stack) {
        if (stack.m_41783_() != null) {
            return stack.m_41783_().m_128451_("Cast Time");
        }
        return this.CastDuration(stack);
    }

    @Nonnull
    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.CUSTOM;
    }

    @Nonnull
    public ItemStack m_5922_(ItemStack stack, Level worldIn, LivingEntity entityLiving) {
        super.m_5922_(stack, worldIn, entityLiving);
        ISpell iSpell = GoetyEventFactory.onCastSpell(entityLiving, this.getSpell(stack));
        if (iSpell != null && (!(iSpell instanceof IChargingSpell) || this.isNotInstant(iSpell, entityLiving, stack) || this.notTouch(iSpell)) && !this.cannotCast(entityLiving, stack)) {
            this.MagicResults(stack, worldIn, entityLiving, iSpell);
        }
        if (stack.m_41783_() != null) {
            if (stack.m_41783_().m_128451_("Cool") > 0) {
                stack.m_41783_().m_128405_("Cool", 0);
            }
            if (stack.m_41783_().m_128451_("Shots") > 0) {
                stack.m_41783_().m_128405_("Shots", 0);
            }
        }
        return stack;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        ItemStack focus = IWand.getFocus(itemstack);
        if (focus.m_41720_() instanceof CommandFocus && playerIn.m_6047_()) {
            if (CommandFocus.hasServant(focus) && focus.m_41783_() != null) {
                focus.m_41783_().m_128473_("Servant");
                playerIn.m_5496_(SoundEvents.f_11686_, 1.0f, 0.45f);
                if (!worldIn.f_46443_) {
                    ModNetwork.sendTo(playerIn, new SPlayEntitySoundPacket(playerIn.m_20148_(), SoundEvents.f_11686_, 1.0f, 0.45f));
                }
            }
            return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)worldIn.m_5776_());
        }
        if (focus.m_41720_() instanceof OrderFocus && playerIn.m_6047_()) {
            if (focus.m_41783_() != null) {
                focus.m_41783_().m_128473_(OrderFocus.SERVANT_LIST);
                focus.m_41783_().m_128473_(OrderFocus.SERVANT_CLIENT_LIST);
                playerIn.m_5496_(SoundEvents.f_11686_, 1.0f, 0.45f);
                if (!worldIn.f_46443_) {
                    ModNetwork.sendTo(playerIn, new SPlayEntitySoundPacket(playerIn.m_20148_(), SoundEvents.f_11686_, 1.0f, 0.45f));
                }
            }
            return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)worldIn.m_5776_());
        }
        if (focus.m_41720_() instanceof CallFocus && playerIn.m_6047_()) {
            if (CallFocus.hasSummon(focus) && focus.m_41783_() != null) {
                focus.m_41783_().m_128473_("Summoned");
                playerIn.m_5496_(SoundEvents.f_11686_, 1.0f, 0.45f);
                if (!worldIn.f_46443_) {
                    ModNetwork.sendTo(playerIn, new SPlayEntitySoundPacket(playerIn.m_20148_(), SoundEvents.f_11686_, 1.0f, 0.45f));
                }
            }
            return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)worldIn.m_5776_());
        }
        if (this.getSpell(itemstack) != null) {
            if (this.cannotCast((LivingEntity)playerIn, itemstack)) {
                return InteractionResultHolder.m_19098_((Object)itemstack);
            }
            if (this.isNotInstant(this.getSpell(itemstack), (LivingEntity)playerIn, itemstack)) {
                if ((SEHelper.getSoulsAmount(playerIn, this.getSpell(itemstack).soulCost((LivingEntity)playerIn, itemstack)) || playerIn.m_150110_().f_35937_) && !worldIn.f_46443_) {
                    playerIn.m_6672_(handIn);
                }
            } else if (this.notTouch(this.getSpell(itemstack))) {
                playerIn.m_6674_(handIn);
                ISpell iSpell = GoetyEventFactory.onCastSpell((LivingEntity)playerIn, this.getSpell(itemstack));
                this.MagicResults(itemstack, worldIn, (LivingEntity)playerIn, iSpell);
            }
        }
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public void setSpellConditions(@Nullable ISpell spell, ItemStack stack, LivingEntity livingEntity) {
        if (stack.m_41783_() != null) {
            if (spell != null) {
                stack.m_41783_().m_128405_("Soul Cost", spell.soulCost(livingEntity, stack));
                stack.m_41783_().m_128405_("Duration", spell.castDuration(livingEntity, stack));
                if (spell instanceof IChargingSpell) {
                    IChargingSpell chargingSpell = (IChargingSpell)spell;
                    stack.m_41783_().m_128405_("Cooldown", chargingSpell.Cooldown(livingEntity, stack, stack.m_41783_().m_128441_("Shots") ? stack.m_41783_().m_128451_("Shots") : 0));
                } else {
                    stack.m_41783_().m_128405_("Cooldown", 0);
                }
            } else {
                stack.m_41783_().m_128405_("Soul Cost", 0);
                stack.m_41783_().m_128405_("Duration", 0);
                stack.m_41783_().m_128405_("Cooldown", 0);
            }
        }
    }

    public int SoulCost(ItemStack itemStack) {
        if (itemStack.m_41783_() == null) {
            return 0;
        }
        return itemStack.m_41783_().m_128451_("Soul Cost");
    }

    public int CastDuration(ItemStack itemStack) {
        if (itemStack.m_41783_() != null) {
            return itemStack.m_41783_().m_128451_("Duration");
        }
        return 0;
    }

    public int Cooldown(ItemStack itemStack) {
        if (itemStack.m_41783_() != null) {
            return itemStack.m_41783_().m_128451_("Cooldown");
        }
        return 0;
    }

    @Override
    public int ShotsFired(ItemStack itemStack) {
        if (itemStack.m_41783_() != null) {
            return itemStack.m_41783_().m_128451_("Shots");
        }
        return 0;
    }

    public void increaseShots(ItemStack itemStack) {
        if (itemStack.m_41783_() != null) {
            itemStack.m_41783_().m_128405_("Shots", this.ShotsFired(itemStack) + 1);
        }
    }

    public void setShots(ItemStack itemStack, int amount) {
        if (itemStack.m_41783_() != null) {
            itemStack.m_41783_().m_128405_("Shots", amount);
        }
    }

    @Nullable
    public SoundEvent CastingSound(ItemStack stack, LivingEntity caster) {
        if (this.getSpell(stack) != null) {
            return this.getSpell(stack).CastingSound(caster);
        }
        return null;
    }

    public float castingVolume(ItemStack stack) {
        if (this.getSpell(stack) != null) {
            return this.getSpell(stack).castingVolume();
        }
        return 0.5f;
    }

    public float castingPitch(ItemStack stack) {
        if (this.getSpell(stack) != null) {
            return this.getSpell(stack).castingPitch();
        }
        return 1.0f;
    }

    public boolean canCastTouch(ItemStack stack, Level worldIn, LivingEntity caster) {
        ISpell spell;
        Player playerEntity = (Player)caster;
        if (!worldIn.f_46443_ && (spell = GoetyEventFactory.onTouchBasedSpell(caster, stack, this.getSpell(stack))) != null && !this.cannotCast(caster, stack, spell)) {
            if (playerEntity.m_7500_()) {
                SEHelper.addCooldown(playerEntity, IWand.getFocus(stack).m_41720_(), spell.spellCooldown());
                return stack.m_41783_() != null;
            }
            if (SEHelper.getSoulsAmount(playerEntity, this.SoulUse(caster, stack)) && stack.m_41783_() != null) {
                SEHelper.decreaseSouls(playerEntity, this.SoulUse(caster, stack));
                SEHelper.addCooldown(playerEntity, IWand.getFocus(stack).m_41720_(), spell.spellCooldown());
                SEHelper.sendSEUpdatePacket(playerEntity);
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public void MagicResults(ItemStack stack, Level worldIn, LivingEntity caster) {
        this.MagicResults(stack, worldIn, caster, this.getSpell(stack));
    }

    public void MagicResults(ItemStack stack, Level worldIn, LivingEntity caster, ISpell spell) {
        if (spell != null && caster instanceof Player) {
            Player playerEntity = (Player)caster;
            if (!worldIn.f_46443_) {
                ServerLevel serverWorld = (ServerLevel)worldIn;
                if (playerEntity.m_7500_()) {
                    if (stack.m_41783_() != null) {
                        spell.SpellResult(serverWorld, caster, stack, spell.defaultStats());
                        boolean flag = false;
                        if (spell instanceof IChargingSpell) {
                            IChargingSpell chargingSpell = (IChargingSpell)spell;
                            if (chargingSpell.shotsNumber((LivingEntity)playerEntity, stack) > 0 && this.ShotsFired(stack) >= chargingSpell.shotsNumber((LivingEntity)playerEntity, stack)) {
                                flag = true;
                            }
                        } else {
                            flag = true;
                        }
                        if (flag) {
                            this.setShots(stack, 0);
                            SEHelper.addCooldown(playerEntity, IWand.getFocus(stack).m_41720_(), spell.spellCooldown());
                        }
                    }
                } else if (SEHelper.getSoulsAmount(playerEntity, this.SoulUse(caster, stack))) {
                    Object spell1;
                    boolean spent = true;
                    if (spell instanceof IChargingSpell && (spell1 = (IChargingSpell)spell).everCharge() && stack.m_41783_() != null) {
                        stack.m_41783_().m_128405_("Seconds", stack.m_41783_().m_128451_("Seconds") + 1);
                        if (stack.m_41783_().m_128451_("Seconds") != 20) {
                            spent = false;
                        } else {
                            stack.m_41783_().m_128405_("Seconds", 0);
                        }
                    }
                    if (spent) {
                        SEHelper.decreaseSouls(playerEntity, this.SoulUse(caster, stack));
                        SEHelper.sendSEUpdatePacket(playerEntity);
                        if ((Integer)MobsConfig.VillagerHateSpells.get() > 0) {
                            for (Villager villager : caster.f_19853_.m_45976_(Villager.class, caster.m_20191_().m_82400_(16.0))) {
                                if (!villager.m_142582_((Entity)caster)) continue;
                                villager.m_35517_().m_26191_(caster.m_20148_(), GossipType.MINOR_NEGATIVE, ((Integer)MobsConfig.VillagerHateSpells.get()).intValue());
                            }
                        }
                    }
                    if (stack.m_41783_() != null) {
                        spell.SpellResult(serverWorld, caster, stack, spell.defaultStats());
                        boolean flag = false;
                        if (spell instanceof IChargingSpell) {
                            IChargingSpell chargingSpell = (IChargingSpell)spell;
                            if (chargingSpell.shotsNumber((LivingEntity)playerEntity, stack) > 0 && this.ShotsFired(stack) >= chargingSpell.shotsNumber((LivingEntity)playerEntity, stack)) {
                                flag = true;
                            }
                        } else {
                            flag = true;
                        }
                        if (flag) {
                            this.setShots(stack, 0);
                            SEHelper.addCooldown(playerEntity, IWand.getFocus(stack).m_41720_(), spell.spellCooldown());
                        }
                    }
                } else {
                    worldIn.m_6263_(null, caster.m_20185_(), caster.m_20186_(), caster.m_20189_(), SoundEvents.f_11937_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                }
            }
            if (worldIn.f_46443_) {
                if (playerEntity.m_7500_()) {
                    if (spell instanceof IBreathingSpell) {
                        breathingSpells = (IBreathingSpell)spell;
                        breathingSpells.showWandBreath(caster);
                    }
                } else if (SEHelper.getSoulsAmount(playerEntity, this.SoulUse(caster, stack))) {
                    if (spell instanceof IBreathingSpell) {
                        breathingSpells = (IBreathingSpell)spell;
                        breathingSpells.showWandBreath(caster);
                    }
                } else {
                    this.failParticles(worldIn, caster);
                }
            }
        } else {
            this.failParticles(worldIn, caster);
            worldIn.m_6263_(null, caster.m_20185_(), caster.m_20186_(), caster.m_20189_(), SoundEvents.f_11937_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        Player player = Goety.PROXY.getPlayer();
        if (stack.m_41783_() != null) {
            int SoulUse = stack.m_41783_().m_128451_("Soul Use");
            tooltip.add((Component)Component.m_237110_((String)"info.goety.wand.cost", (Object[])new Object[]{SoulUse}));
            if (this.getSpell(stack) != null) {
                if (this.isNotInstant(this.getSpell(stack), (LivingEntity)player, stack) && !(this.getSpell(stack) instanceof IChargingSpell)) {
                    int CastTime = stack.m_41783_().m_128451_("Cast Time");
                    tooltip.add((Component)Component.m_237110_((String)"info.goety.wand.castTime", (Object[])new Object[]{Float.valueOf((float)CastTime / 20.0f)}));
                }
                if (this.getSpell(stack).spellCooldown() > 0) {
                    tooltip.add((Component)Component.m_237110_((String)"info.goety.wand.coolDown", (Object[])new Object[]{Float.valueOf((float)this.getSpell(stack).spellCooldown() / 20.0f)}));
                }
            }
        } else {
            tooltip.add((Component)Component.m_237110_((String)"info.goety.wand.cost", (Object[])new Object[]{this.SoulCost(stack)}));
        }
        if (!IWand.getFocus(stack).m_41619_()) {
            tooltip.add((Component)Component.m_237110_((String)"info.goety.wand.focus", (Object[])new Object[]{IWand.getFocus(stack).m_41720_().m_41466_()}));
            if (IWand.getFocus(stack).m_41720_() instanceof RecallFocus) {
                ItemStack recallFocus = IWand.getFocus(stack);
                RecallFocus.addRecallText(recallFocus, tooltip);
            }
            ItemHelper.addOnShift(tooltip, () -> this.addInformationAfterShift(IWand.getFocus(stack).m_41720_(), tooltip));
        } else {
            tooltip.add((Component)Component.m_237110_((String)"info.goety.wand.focus", (Object[])new Object[]{Component.m_237115_((String)"info.goety.wand.empty")}));
            if (ModKeybindings.wandSlot() != null) {
                tooltip.add((Component)Component.m_237110_((String)"info.goety.wand.open", (Object[])new Object[]{ModKeybindings.wandSlot().m_90863_()}).m_130940_(ChatFormatting.BLUE));
            }
        }
        if (ModKeybindings.wandCircle() != null) {
            tooltip.add((Component)Component.m_237110_((String)"info.goety.wand.switch", (Object[])new Object[]{ModKeybindings.wandCircle().m_90863_()}).m_130940_(ChatFormatting.BLUE));
        }
    }

    public void addInformationAfterShift(Item item, List<Component> tooltip) {
        tooltip.add((Component)Component.m_237115_((String)(item.m_5524_() + ".info")).m_130940_(ChatFormatting.GRAY));
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new DarkWandClient());
    }

    public static class DarkWandClient
    implements IClientItemExtensions {
        private static final HumanoidModel.ArmPose SPELL = HumanoidModel.ArmPose.create((String)"GOETY_SPELL", (boolean)false, (model, entity, arm) -> {
            float f5 = entity.f_267362_.m_267590_(Minecraft.m_91087_().getPartialTick());
            if (arm == HumanoidArm.RIGHT) {
                model.f_102811_.f_104203_ -= MathHelper.modelDegrees(105.0f);
                model.f_102811_.f_104205_ = Mth.m_14089_((float)(f5 * 0.6662f)) * 0.25f;
                model.f_102812_.f_104203_ += MathHelper.modelDegrees(25.0f);
            } else {
                model.f_102812_.f_104203_ -= MathHelper.modelDegrees(105.0f);
                model.f_102812_.f_104205_ = -Mth.m_14089_((float)(f5 * 0.6662f)) * 0.25f;
                model.f_102811_.f_104203_ += MathHelper.modelDegrees(25.0f);
            }
        });
        private static final HumanoidModel.ArmPose FLIGHT_POSE = HumanoidModel.ArmPose.create((String)"GOETY_FLYING", (boolean)false, (model, entity, arm) -> {
            float f5 = 1.0f;
            if (arm == HumanoidArm.RIGHT) {
                model.f_102811_.f_104203_ = -MathHelper.modelDegrees(105.0f);
                model.f_102811_.f_104205_ = Mth.m_14089_((float)(f5 * 0.6662f)) * 0.25f;
                model.f_102812_.f_104203_ = MathHelper.modelDegrees(25.0f);
            } else {
                model.f_102812_.f_104203_ = -MathHelper.modelDegrees(105.0f);
                model.f_102812_.f_104205_ = -Mth.m_14089_((float)(f5 * 0.6662f)) * 0.25f;
                model.f_102811_.f_104203_ = MathHelper.modelDegrees(25.0f);
            }
            model.f_102813_.f_104203_ = MathHelper.modelDegrees(17.5f);
            model.f_102814_.f_104203_ = MathHelper.modelDegrees(17.5f);
            model.f_102813_.f_104203_ += 1.0f * Mth.m_14031_((float)(Minecraft.m_91087_().getPartialTick() * 0.067f)) * 0.05f;
            model.f_102814_.f_104203_ += -1.0f * Mth.m_14031_((float)(Minecraft.m_91087_().getPartialTick() * 0.067f)) * 0.05f;
        });
        private static final HumanoidModel.ArmPose HOLD_STAFF = HumanoidModel.ArmPose.create((String)"HOLD_STAFF", (boolean)false, (model, entity, arm) -> {
            float f5 = entity.f_267362_.m_267590_(Minecraft.m_91087_().getPartialTick());
            if (arm == HumanoidArm.RIGHT) {
                model.f_102811_.f_104203_ -= MathHelper.modelDegrees(90.0f);
                model.f_102811_.f_104205_ = Mth.m_14089_((float)(f5 * 0.6662f)) * 0.1f;
            } else {
                model.f_102812_.f_104203_ -= MathHelper.modelDegrees(90.0f);
                model.f_102812_.f_104205_ = -Mth.m_14089_((float)(f5 * 0.6662f)) * 0.1f;
            }
        });

        public HumanoidModel.ArmPose getArmPose(LivingEntity entityLiving, InteractionHand hand, ItemStack itemStack) {
            ISpell spell;
            if (!itemStack.m_41619_() && itemStack.m_41720_() instanceof IWand && entityLiving.m_7655_() == hand && entityLiving.m_21212_() > 0 && (spell = WandUtil.getSpell(entityLiving)) != null) {
                if (spell instanceof FlyingSpell) {
                    return FLIGHT_POSE;
                }
                return SPELL;
            }
            return HumanoidModel.ArmPose.EMPTY;
        }

        public boolean applyForgeHandTransform(PoseStack poseStack, LocalPlayer player, HumanoidArm arm, ItemStack itemInHand, float partialTick, float equipProcess, float swingProcess) {
            int i;
            int n = i = arm == HumanoidArm.RIGHT ? 1 : -1;
            if (player.m_6117_()) {
                this.applyItemArmTransform(poseStack, arm, equipProcess);
                poseStack.m_85837_((double)((float)i * -0.2785682f), 0.18344387412071228, 0.15731531381607056);
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-13.935f));
                poseStack.m_252781_(Axis.f_252436_.m_252977_((float)i * 35.3f));
                poseStack.m_252781_(Axis.f_252403_.m_252977_((float)i * -9.785f));
                float f8 = (float)itemInHand.m_41779_() - ((float)player.m_21212_() - partialTick + 1.0f);
                float f12 = f8 / 20.0f;
                f12 = (f12 * f12 + f12 * 2.0f) / 3.0f;
                if (f12 > 1.0f) {
                    f12 = 1.0f;
                }
                if (f12 > 0.1f) {
                    float f15 = Mth.m_14031_((float)((f8 - 0.1f) * 1.3f));
                    float f18 = f12 - 0.1f;
                    float f20 = f15 * f18;
                    poseStack.m_85837_((double)(f20 * 0.0f), (double)(f20 * 0.004f), (double)(f20 * 0.0f));
                }
                poseStack.m_85837_((double)(f12 * 0.0f), (double)(f12 * 0.0f), (double)(f12 * 0.04f));
                poseStack.m_85841_(1.0f, 1.0f, 1.0f + f12 * 0.2f);
                poseStack.m_252781_(Axis.f_252392_.m_252977_((float)i * 45.0f));
            } else {
                float f5 = -0.4f * Mth.m_14031_((float)(Mth.m_14116_((float)swingProcess) * (float)Math.PI));
                float f6 = 0.2f * Mth.m_14031_((float)(Mth.m_14116_((float)swingProcess) * ((float)Math.PI * 2)));
                float f10 = -0.2f * Mth.m_14031_((float)(swingProcess * (float)Math.PI));
                poseStack.m_85837_((double)((float)i * f5), (double)f6, (double)f10);
                this.applyItemArmTransform(poseStack, arm, equipProcess);
                this.applyItemArmAttackTransform(poseStack, arm, swingProcess);
            }
            return true;
        }

        private void applyItemArmTransform(PoseStack poseStack, HumanoidArm arm, float equipProcess) {
            int i = arm == HumanoidArm.RIGHT ? 1 : -1;
            poseStack.m_85837_((double)((float)i * 0.56f), (double)(-0.52f + equipProcess * -0.6f), (double)-0.72f);
        }

        private void applyItemArmAttackTransform(PoseStack poseStack, HumanoidArm humanoidArm, float swingProcess) {
            int i = humanoidArm == HumanoidArm.RIGHT ? 1 : -1;
            float f = Mth.m_14031_((float)(swingProcess * swingProcess * (float)Math.PI));
            poseStack.m_252781_(Axis.f_252436_.m_252977_((float)i * (45.0f + f * -20.0f)));
            float f1 = Mth.m_14031_((float)(Mth.m_14116_((float)swingProcess) * (float)Math.PI));
            poseStack.m_252781_(Axis.f_252403_.m_252977_((float)i * f1 * -20.0f));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(f1 * -80.0f));
            poseStack.m_252781_(Axis.f_252436_.m_252977_((float)i * -45.0f));
        }
    }
}

