/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.items.curios;

import com.Polarice3.Goety.common.items.curios.SingleStackItem;
import com.Polarice3.Goety.config.ItemConfig;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.ItemHelper;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class PendantOfHungerItem
extends SingleStackItem {
    private static final String ROTTEN_FLESH = "Rotten Flesh Count";

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof Player) {
            Player player = (Player)entityIn;
            if (!stack.m_41782_()) {
                stack.m_41751_(new CompoundTag());
                stack.m_41784_().m_128405_(ROTTEN_FLESH, 0);
            } else if (CuriosFinder.hasCurio((LivingEntity)player, itemStack -> itemStack == stack)) {
                if (this.getRottenFleshAmount(stack) < (Integer)ItemConfig.PendantOfHungerLimit.get() && !ItemHelper.findItem(player, Items.f_42583_).m_41619_()) {
                    this.increaseRottenFlesh(stack);
                    ItemHelper.findItem(player, Items.f_42583_).m_41774_(1);
                }
                if (this.getRottenFleshAmount(stack) > 0 && MobUtil.playerValidity(player, true)) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 600, 0, false, false));
                    if (player.m_36324_().m_38721_()) {
                        player.m_5584_(player.f_19853_, new ItemStack((ItemLike)Items.f_42583_));
                        this.decreaseRottenFlesh(stack);
                    }
                }
            }
        }
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public void m_7836_(ItemStack pStack, Level pLevel, Player pPlayer) {
        CompoundTag compound = pStack.m_41784_();
        compound.m_128405_(ROTTEN_FLESH, 0);
    }

    public void increaseRottenFlesh(ItemStack stack) {
        if (stack.m_41783_() != null) {
            stack.m_41784_().m_128405_(ROTTEN_FLESH, this.getRottenFleshAmount(stack) + 1);
        }
    }

    public void decreaseRottenFlesh(ItemStack stack) {
        if (stack.m_41783_() != null) {
            stack.m_41784_().m_128405_(ROTTEN_FLESH, this.getRottenFleshAmount(stack) - 1);
        }
    }

    public int getRottenFleshAmount(ItemStack stack) {
        if (stack.m_41783_() != null) {
            return stack.m_41784_().m_128451_(ROTTEN_FLESH);
        }
        return 0;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.m_41720_() != newStack.m_41720_();
    }

    public int m_142159_(ItemStack stack) {
        float f = Math.max(0.0f, (float)(1.0 - this.amountColor(stack)) / 2.0f);
        return Mth.m_14169_((float)1.0f, (float)f, (float)f);
    }

    public double amountColor(ItemStack stack) {
        if (stack.m_41783_() != null) {
            int i = stack.m_41783_().m_128451_(ROTTEN_FLESH);
            return 1.0 - (double)i / (double)((Integer)ItemConfig.PendantOfHungerLimit.get()).intValue();
        }
        return 1.0;
    }

    public boolean m_142522_(ItemStack stack) {
        return stack.m_41783_() != null;
    }

    public int m_142158_(ItemStack stack) {
        if (stack.m_41783_() != null) {
            int power = stack.m_41783_().m_128451_(ROTTEN_FLESH);
            return Math.round((float)power * 13.0f / (float)((Integer)ItemConfig.PendantOfHungerLimit.get()).intValue());
        }
        return 0;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (stack.m_41783_() != null) {
            int rottenFlesh = stack.m_41783_().m_128451_(ROTTEN_FLESH);
            tooltip.add((Component)Component.m_237110_((String)"info.goety.hunger_pendent.amount", (Object[])new Object[]{rottenFlesh}));
        } else {
            tooltip.add((Component)Component.m_237110_((String)"info.goety.hunger_pendent.amount", (Object[])new Object[]{0}));
        }
    }
}

