/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.items;

import com.Polarice3.Goety.common.blocks.entities.ArcaBlockEntity;
import com.Polarice3.Goety.utils.SEHelper;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.level.Level;

public class ArcaCompassItem
extends Item
implements Vanishable {
    public static final String TAG_PLAYER = "TrackedPlayer";
    public static final String TAG_PLAYER_NAME = "TrackedPlayerName";
    public static final String TAG_ARCA_POS = "ArcaPos";
    public static final String TAG_ARCA_DIMENSION = "ArcaDimension";
    public static final String TAG_ARCA_TRACKED = "ArcaTracked";

    public ArcaCompassItem() {
        super(new Item.Properties().m_41486_());
    }

    public static boolean hasPlayer(ItemStack p_40737_) {
        CompoundTag compoundtag = p_40737_.m_41783_();
        return compoundtag != null && compoundtag.m_128441_(TAG_PLAYER);
    }

    public static boolean hasArca(ItemStack p_40737_) {
        CompoundTag compoundtag = p_40737_.m_41783_();
        return compoundtag != null && (compoundtag.m_128441_(TAG_ARCA_DIMENSION) || compoundtag.m_128441_(TAG_ARCA_POS));
    }

    private static Optional<ResourceKey<Level>> getArcaDimension(CompoundTag p_40728_) {
        return Level.f_46427_.parse((DynamicOps)NbtOps.f_128958_, (Object)p_40728_.m_128423_(TAG_ARCA_DIMENSION)).result();
    }

    @Nullable
    public static GlobalPos getArcaPosition(CompoundTag p_220022_) {
        Optional<ResourceKey<Level>> optional;
        boolean flag = p_220022_.m_128441_(TAG_ARCA_POS);
        boolean flag1 = p_220022_.m_128441_(TAG_ARCA_DIMENSION);
        if (flag && flag1 && (optional = ArcaCompassItem.getArcaDimension(p_220022_)).isPresent()) {
            BlockPos blockpos = NbtUtils.m_129239_((CompoundTag)p_220022_.m_128469_(TAG_ARCA_POS));
            return GlobalPos.m_122643_(optional.get(), (BlockPos)blockpos);
        }
        return null;
    }

    public boolean m_5812_(ItemStack p_40739_) {
        return ArcaCompassItem.hasPlayer(p_40739_) || super.m_5812_(p_40739_);
    }

    public void m_6883_(ItemStack p_40720_, Level p_40721_, Entity p_40722_, int p_40723_, boolean p_40724_) {
        if (!p_40721_.f_46443_) {
            CompoundTag compoundtag = p_40720_.m_41784_();
            if (!p_40722_.m_6084_()) {
                if (compoundtag.m_128441_(TAG_PLAYER)) {
                    compoundtag.m_128473_(TAG_PLAYER);
                }
                if (compoundtag.m_128441_(TAG_PLAYER_NAME)) {
                    compoundtag.m_128473_(TAG_PLAYER_NAME);
                }
                if (compoundtag.m_128441_(TAG_ARCA_POS)) {
                    compoundtag.m_128473_(TAG_ARCA_POS);
                }
                if (compoundtag.m_128441_(TAG_ARCA_DIMENSION)) {
                    compoundtag.m_128473_(TAG_ARCA_DIMENSION);
                }
                if (compoundtag.m_128441_(TAG_ARCA_TRACKED)) {
                    compoundtag.m_128473_(TAG_ARCA_TRACKED);
                }
            }
            if (ArcaCompassItem.hasPlayer(p_40720_)) {
                if (compoundtag.m_128441_(TAG_PLAYER)) {
                    Player player = p_40721_.m_46003_(compoundtag.m_128342_(TAG_PLAYER));
                    if (player == null) {
                        return;
                    }
                    if (SEHelper.getArcaBlock(player) != null && !compoundtag.m_128441_(TAG_ARCA_POS)) {
                        compoundtag.m_128365_(TAG_ARCA_POS, (Tag)NbtUtils.m_129224_((BlockPos)SEHelper.getArcaBlock(player)));
                        if (SEHelper.getArcaDimension(player) != null) {
                            Level.f_46427_.encodeStart((DynamicOps)NbtOps.f_128958_, SEHelper.getArcaDimension(player)).result().ifPresent(p_40731_ -> compoundtag.m_128365_(TAG_ARCA_DIMENSION, p_40731_));
                        }
                    }
                }
                if (ArcaCompassItem.hasArca(p_40720_)) {
                    BlockPos blockpos;
                    if (compoundtag.m_128441_(TAG_ARCA_TRACKED) && !compoundtag.m_128471_(TAG_ARCA_TRACKED)) {
                        return;
                    }
                    Optional<ResourceKey<Level>> optional = ArcaCompassItem.getArcaDimension(compoundtag);
                    if (optional.isPresent() && optional.get() == p_40721_.m_46472_() && compoundtag.m_128441_(TAG_ARCA_POS) && (!p_40721_.m_46739_(blockpos = NbtUtils.m_129239_((CompoundTag)compoundtag.m_128469_(TAG_ARCA_POS))) || !(p_40721_.m_7702_(blockpos) instanceof ArcaBlockEntity))) {
                        compoundtag.m_128473_(TAG_ARCA_POS);
                    }
                }
            } else if (compoundtag.m_128441_(TAG_PLAYER_NAME)) {
                compoundtag.m_128473_(TAG_PLAYER_NAME);
            }
        }
    }

    public static void addPlayer(Player player, CompoundTag p_40735_) {
        p_40735_.m_128362_(TAG_PLAYER, player.m_20148_());
        p_40735_.m_128359_(TAG_PLAYER_NAME, player.m_5446_().getString());
        p_40735_.m_128379_(TAG_ARCA_TRACKED, true);
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.m_41783_() != null) {
            GlobalPos globalPos;
            if (stack.m_41783_().m_128441_(TAG_PLAYER_NAME)) {
                tooltip.add((Component)Component.m_237110_((String)"tooltip.goety.arca_compass_track", (Object[])new Object[]{stack.m_41783_().m_128461_(TAG_PLAYER_NAME)}).m_130940_(ChatFormatting.AQUA));
            }
            if ((globalPos = ArcaCompassItem.getArcaPosition(stack.m_41783_())) != null) {
                BlockPos blockPos = globalPos.m_122646_();
                tooltip.add((Component)Component.m_237115_((String)"tooltip.goety.arca").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237110_((String)"tooltip.goety.arcaCoords", (Object[])new Object[]{blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_()})));
                if (ArcaCompassItem.getArcaDimension(stack.m_41783_()).isPresent()) {
                    ResourceKey<Level> dimension = ArcaCompassItem.getArcaDimension(stack.m_41783_()).get();
                    tooltip.add((Component)Component.m_237110_((String)"tooltip.goety.arcaDimension", (Object[])new Object[]{dimension.m_135782_().toString()}));
                }
            }
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.goety.arca_compass").m_130940_(ChatFormatting.GOLD));
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }
}

