/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.events;

import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.utils.EventTask;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="goety", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TimedEvents {
    private static final Queue<Pair<String, EventTask>> TASKS = new ArrayDeque<Pair<String, EventTask>>();

    @SubscribeEvent
    public static void ServerTickEvents(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Iterator it = TASKS.iterator();
            while (it.hasNext()) {
                Pair current = (Pair)it.next();
                try {
                    if (((EventTask)current.getRight()).getAsBoolean()) {
                        ((EventTask)current.getRight()).endTask();
                        it.remove();
                        continue;
                    }
                    ((EventTask)current.getRight()).tickTask();
                }
                catch (Exception ex) {
                    Goety.LOGGER.error("An exception occurred while running a ticking task with ID {}.  It will be terminated.", current.getLeft());
                    it.remove();
                }
            }
        }
    }

    @SubscribeEvent
    public static void stopped(ServerStoppedEvent event) {
        for (Pair pair : TASKS) {
            if (pair.getRight() == null) continue;
            ((EventTask)pair.getRight()).endTask();
        }
        TASKS.clear();
    }

    @SubscribeEvent
    public static void started(ServerStartedEvent event) {
        TASKS.clear();
    }

    public static void submitTask(String id, EventTask task) {
        TASKS.add((Pair<String, EventTask>)Pair.of((Object)id, (Object)task));
        task.startTask();
    }
}

