/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.events;

import com.Polarice3.Goety.api.items.magic.IWand;
import com.Polarice3.Goety.client.particles.ShockwaveParticleOption;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.items.equipment.DarkScytheItem;
import com.Polarice3.Goety.common.items.equipment.DeathScytheItem;
import com.Polarice3.Goety.common.items.equipment.HuntersBowItem;
import com.Polarice3.Goety.common.items.equipment.RampagingAxeItem;
import com.Polarice3.Goety.common.items.revive.ReviveServantItem;
import com.Polarice3.Goety.config.ItemConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.EffectsUtil;
import com.Polarice3.Goety.utils.ExplosionUtil;
import com.Polarice3.Goety.utils.ItemHelper;
import com.Polarice3.Goety.utils.LootingExplosion;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.SEHelper;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="goety", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ItemEvents {
    @SubscribeEvent
    public static void HurtEvent(LivingHurtEvent event) {
        LivingEntity victim = event.getEntity();
        Entity directEntity = event.getSource().m_7640_();
        if (event.getAmount() > 0.0f && directEntity instanceof LivingEntity) {
            LivingEntity livingAttacker = (LivingEntity)directEntity;
            if (ModDamageSource.physicalAttacks(event.getSource())) {
                ItemHelper.setItemEffect(livingAttacker.m_21205_(), victim);
                Item item = livingAttacker.m_21205_().m_41720_();
                if (item instanceof TieredItem) {
                    TieredItem weapon = (TieredItem)item;
                    if (weapon == ModItems.FANGED_DAGGER.get()) {
                        MobEffect effect = MobEffects.f_19614_;
                        if (CuriosFinder.hasWildRobe(livingAttacker)) {
                            effect = (MobEffect)GoetyEffects.ACID_VENOM.get();
                        }
                        if (livingAttacker.m_21023_((MobEffect)GoetyEffects.VENOMOUS_HANDS.get())) {
                            EffectsUtil.increaseDuration(victim, effect, 600);
                        } else {
                            victim.m_7292_(new MobEffectInstance(effect, 200));
                        }
                    }
                    if (weapon == ModItems.HUNGRY_DAGGER.get()) {
                        int soulEat = EnchantmentHelper.m_44836_((Enchantment)((Enchantment)ModEnchantments.SOUL_EATER.get()), (LivingEntity)livingAttacker) + 1;
                        livingAttacker.m_5634_(event.getAmount() * (0.05f * (float)soulEat));
                    }
                    if (weapon instanceof DarkScytheItem) {
                        victim.m_216990_((SoundEvent)ModSounds.SCYTHE_HIT_MEATY.get());
                    }
                    if (weapon instanceof DeathScytheItem) {
                        if (!victim.m_21023_((MobEffect)GoetyEffects.SAPPED.get())) {
                            victim.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.SAPPED.get(), 100));
                            victim.m_5496_(SoundEvents.f_12347_, 2.0f, 1.0f);
                        } else if (victim.f_19853_.f_46441_.m_188501_() <= 0.2f) {
                            EffectsUtil.amplifyEffect(victim, (MobEffect)GoetyEffects.SAPPED.get(), 100);
                            victim.m_5496_(SoundEvents.f_12347_, 2.0f, 1.0f);
                        } else {
                            EffectsUtil.resetDuration(victim, (MobEffect)GoetyEffects.SAPPED.get(), 100);
                        }
                    }
                }
            }
        }
        if (victim instanceof Player) {
            Player player = (Player)victim;
            if (CuriosFinder.hasCurio(victim, (Item)ModItems.SPITEFUL_BELT.get())) {
                LivingEntity livingentity;
                Entity entity;
                int a = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44972_, (ItemStack)CuriosFinder.findCurio(victim, (Item)ModItems.SPITEFUL_BELT.get()));
                if (SEHelper.getSoulsAmount(player, (Integer)ItemConfig.SpitefulBeltUseAmount.get() * (a + 1)) && !event.getSource().m_269533_(DamageTypeTags.f_268640_) && !event.getSource().m_276093_(DamageTypes.f_268440_) && (entity = event.getSource().m_7639_()) instanceof LivingEntity && (livingentity = (LivingEntity)entity) != victim) {
                    livingentity.m_6469_(livingentity.m_269291_().m_269374_((Entity)victim), 2.0f + (float)a);
                    SEHelper.decreaseSouls(player, (Integer)ItemConfig.SpitefulBeltUseAmount.get() * (a + 1));
                }
            }
        }
    }

    @SubscribeEvent
    public static void AxeDeath(LivingDeathEvent event) {
        LivingEntity killed = event.getEntity();
        Entity killer = event.getSource().m_7639_();
        Level world = killed.m_20193_();
        if (killer instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)killer;
            if (ModDamageSource.physicalAttacks(event.getSource()) && livingEntity.m_21205_().m_41720_() instanceof RampagingAxeItem) {
                MobEffectInstance effectinstance1 = livingEntity.m_21124_((MobEffect)GoetyEffects.RAMPAGE.get());
                if (!livingEntity.m_21023_((MobEffect)GoetyEffects.RAMPAGE.get())) {
                    livingEntity.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.RAMPAGE.get(), MathHelper.secondsToTicks((Integer)ItemConfig.RampagingAxeDuration.get())));
                } else if (effectinstance1 != null) {
                    int random;
                    int n = random = killed.m_21233_() >= 20.0f ? 0 : world.f_46441_.m_188503_(4);
                    if (effectinstance1.m_19564_() < 4) {
                        if (random == 0) {
                            EffectsUtil.amplifyEffect(livingEntity, (MobEffect)GoetyEffects.RAMPAGE.get(), MathHelper.secondsToTicks((Integer)ItemConfig.RampagingAxeDuration.get()));
                        }
                    } else {
                        livingEntity.m_21195_((MobEffect)GoetyEffects.RAMPAGE.get());
                        if (world instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)world;
                            serverLevel.m_8767_((ParticleOptions)new ShockwaveParticleOption(), livingEntity.m_20185_(), livingEntity.m_20186_() + 0.5, livingEntity.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
                            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123812_, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), 0, 1.0, 0.0, 0.0, 0.5);
                        }
                        LootingExplosion.Mode lootMode = CuriosFinder.hasWanting((Entity)livingEntity) ? LootingExplosion.Mode.LOOT : LootingExplosion.Mode.REGULAR;
                        ExplosionUtil.lootExplode(world, (Entity)livingEntity, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), 3.0f, false, Explosion.BlockInteraction.KEEP, lootMode);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void HunterLoot(LootingLevelEvent event) {
        LivingEntity livingEntity;
        Entity entity;
        if (event.getDamageSource() != null && event.getEntity() != null && !event.getEntity().f_19853_.f_46443_ && event.getDamageSource().m_7639_() != null && (entity = event.getDamageSource().m_7639_()) instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_21205_().m_41720_() instanceof HuntersBowItem && event.getDamageSource().m_7640_() instanceof AbstractArrow && event.getEntity() instanceof Animal) {
            event.setLootingLevel(event.getLootingLevel() + 4);
        }
    }

    @SubscribeEvent
    public static void EmptyClickEvents(PlayerInteractEvent.LeftClickEmpty event) {
        DeathScytheItem.emptyClick(event.getItemStack());
    }

    @SubscribeEvent
    public static void PlayerAttackEvents(AttackEntityEvent event) {
        DeathScytheItem.entityClick(event.getEntity(), event.getEntity().f_19853_);
    }

    @SubscribeEvent
    public static void InteractEntityEvents(PlayerInteractEvent.EntityInteract event) {
        Entity entity;
        if (event.getItemStack().m_41720_() instanceof ReviveServantItem && SEHelper.getFocusCoolDown(event.getEntity()).isOnCooldown(event.getItemStack().m_41720_())) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.FAIL);
        }
        if (event.getItemStack().m_41720_() instanceof IWand && (entity = event.getTarget()) instanceof Villager) {
            Villager villager = (Villager)entity;
            InteractionResult result = event.getItemStack().m_41647_(event.getEntity(), (LivingEntity)villager, event.getHand());
            if (result.m_19077_()) {
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
        }
    }

    @SubscribeEvent
    public static void GeneralInteractEvents(PlayerInteractEvent.RightClickItem event) {
        InteractionResultHolder<ItemStack> result;
        if (event.getItemStack().m_150930_(Items.f_42590_) && (result = ItemHelper.getVoidBottle(event.getEntity(), event.getLevel(), event.getHand())).m_19089_().m_19077_()) {
            event.setCanceled(true);
            event.setCancellationResult(result.m_19089_());
        }
    }
}

