/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.util;

import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;

public class FireBlastTrap
extends Entity {
    private static final EntityDataAccessor<Boolean> IMMEDIATE = SynchedEntityData.m_135353_(FireBlastTrap.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public LivingEntity owner;
    private UUID ownerUniqueId;
    private float extraDamage;
    private float areaOfEffect = 0.0f;
    private int burning = 0;

    public FireBlastTrap(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
        this.f_19794_ = true;
    }

    public FireBlastTrap(Level worldIn, double x, double y, double z) {
        this((EntityType)ModEntityType.FIRE_BLAST_TRAP.get(), worldIn);
        this.m_6034_(x, y, z);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(IMMEDIATE, (Object)false);
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128403_("Owner")) {
            this.ownerUniqueId = compound.m_128342_("Owner");
        }
        this.extraDamage = compound.m_128457_("ExtraDamage");
        this.areaOfEffect = compound.m_128457_("AreaOfEffect");
        this.burning = compound.m_128451_("Burning");
    }

    protected void m_7380_(CompoundTag compound) {
        if (this.ownerUniqueId != null) {
            compound.m_128362_("Owner", this.ownerUniqueId);
        }
        compound.m_128350_("ExtraDamage", this.extraDamage);
        compound.m_128350_("AreaOfEffect", this.areaOfEffect);
        compound.m_128405_("Burning", this.burning);
    }

    public void setOwner(@Nullable LivingEntity ownerIn) {
        this.owner = ownerIn;
        this.ownerUniqueId = ownerIn == null ? null : ownerIn.m_20148_();
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUniqueId != null && this.f_19853_ instanceof ServerLevel && (entity = ((ServerLevel)this.f_19853_).m_8791_(this.ownerUniqueId)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    public void setBurning(int burning) {
        this.burning = burning;
    }

    public int getBurning() {
        return this.burning;
    }

    public void setExtraDamage(float damage) {
        this.extraDamage = damage;
    }

    public float getExtraDamage() {
        return this.extraDamage;
    }

    public void setAreaOfEffect(float damage) {
        this.areaOfEffect = damage;
    }

    public float getAreaOfEffect() {
        return this.areaOfEffect;
    }

    public void setImmediate(boolean immediate) {
        this.f_19804_.m_135381_(IMMEDIATE, (Object)immediate);
    }

    public boolean getImmediate() {
        return (Boolean)this.f_19804_.m_135370_(IMMEDIATE);
    }

    public void m_8119_() {
        super.m_8119_();
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            float area = this.getAreaOfEffect() / 2.0f;
            float f = 1.5f + area;
            float f5 = (float)Math.PI * f * f;
            int k1 = 0;
            while ((float)k1 < f5) {
                float f6 = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
                float f7 = Mth.m_14116_((float)this.f_19796_.m_188501_()) * f;
                float f8 = Mth.m_14089_((float)f6) * f7;
                float f9 = Mth.m_14031_((float)f6) * f7;
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.BURNING.get()), this.m_20185_() + (double)f8, this.m_20186_(), this.m_20189_() + (double)f9, 1, 0.0, 0.0, 0.0, 0.0);
                ++k1;
            }
            ColorUtil color = new ColorUtil(ChatFormatting.GOLD);
            ServerParticleUtil.windParticle(serverLevel, color, f - 1.0f + serverLevel.f_46441_.m_188501_() * 0.5f, 0.0f, this.m_19879_(), this.m_20182_());
            ServerParticleUtil.windParticle(serverLevel, color, f + serverLevel.f_46441_.m_188501_() * 0.5f, 0.0f, this.m_19879_(), this.m_20182_());
            if (this.f_19797_ == 20 || this.getImmediate()) {
                for (int j1 = 0; j1 < 16; ++j1) {
                    int k12 = 0;
                    while ((float)k12 < f5) {
                        float f6 = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
                        float f7 = Mth.m_14116_((float)this.f_19796_.m_188501_()) * f;
                        float f8 = Mth.m_14089_((float)f6) * f7;
                        float f9 = Mth.m_14031_((float)f6) * f7;
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_() + (double)f8, this.m_20186_(), this.m_20189_() + (double)f9, 0, 0.0, 0.5, 0.0, 0.5);
                        ++k12;
                    }
                }
                ArrayList<Entity> targets = new ArrayList<Entity>();
                float area0 = 1.0f + area;
                AABB aabb = this.m_20191_();
                AABB aabb1 = new AABB(aabb.f_82288_ - (double)area0, aabb.f_82289_ - 1.0, aabb.f_82290_ - (double)area0, aabb.f_82291_ + (double)area0, aabb.f_82292_ + 1.0, aabb.f_82293_ + (double)area0);
                for (Entity entity : this.f_19853_.m_45976_(Entity.class, aabb1)) {
                    if (this.owner != null) {
                        if (entity == this.owner || MobUtil.areAllies(entity, (Entity)this.owner)) continue;
                        LivingEntity livingEntity = this.owner;
                        if (livingEntity instanceof Mob) {
                            Mob mob = (Mob)livingEntity;
                            if (this.owner instanceof Enemy && entity instanceof Enemy) {
                                if (mob.m_5448_() != entity) continue;
                                targets.add(entity);
                                continue;
                            }
                        }
                        targets.add(entity);
                        continue;
                    }
                    targets.add(entity);
                }
                if (!targets.isEmpty()) {
                    for (Entity entity : targets) {
                        if (this.owner != null && CuriosFinder.hasUnholySet(this.owner)) {
                            if (entity instanceof LivingEntity) {
                                LivingEntity livingEntity = (LivingEntity)entity;
                                livingEntity.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.BURN_HEX.get(), 1200));
                            }
                            entity.m_6469_(ModDamageSource.hellfire(this, (Entity)this.owner), ((Double)AttributesConfig.ApostleMagicDamage.get()).floatValue() + this.getExtraDamage());
                        } else if (this.owner != null) {
                            Mob mob;
                            float damage = 5.0f;
                            LivingEntity livingEntity = this.owner;
                            if (livingEntity instanceof Mob && (mob = (Mob)livingEntity).m_21051_(Attributes.f_22281_) != null) {
                                damage = (float)mob.m_21133_(Attributes.f_22281_);
                            }
                            entity.m_6469_(ModDamageSource.magicFireBreath(this, (Entity)this.owner), damage + this.getExtraDamage());
                        } else {
                            entity.m_6469_(this.m_269291_().m_269425_(), 5.0f + this.getExtraDamage());
                        }
                        if (!(entity instanceof LivingEntity)) continue;
                        LivingEntity livingEntity = (LivingEntity)entity;
                        MobUtil.push((Entity)livingEntity, 0.0, 1.0, 0.0, 0.5);
                        if (this.burning <= 0) continue;
                        livingEntity.m_20254_(this.burning * 4);
                    }
                }
            }
        }
        if (this.f_19797_ > 20 || this.getImmediate() && this.f_19797_ > 5) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.25, 0.0));
            this.m_6478_(MoverType.SELF, this.m_20184_());
        }
        if (this.f_19797_ == 20 || this.getImmediate() && this.f_19797_ == 5) {
            this.m_5496_(SoundEvents.f_11913_, 1.0f, 0.5f);
        }
        if (this.owner != null && (this.owner.m_21224_() || this.owner.m_213877_())) {
            this.m_146870_();
        }
        if (this.f_19797_ % 30 == 0) {
            this.m_146870_();
        }
    }

    public PushReaction m_7752_() {
        return PushReaction.IGNORE;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }
}

