/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.util;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.EntityFinder;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import com.Polarice3.Goety.utils.SoundUtil;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;

public class DelayedSummon
extends Entity {
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UNIQUE_ID = SynchedEntityData.m_135353_(DelayedSummon.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    public Entity entity;
    public boolean preMade;
    public boolean noPos;
    public boolean necromancy;
    public int lifeSpan = 20;

    public DelayedSummon(EntityType<?> pType, Level pLevel) {
        super(pType, pLevel);
    }

    public DelayedSummon(Level pLevel, Vec3 pPos, Entity pEntity, boolean preMade, boolean noPos, @Nullable LivingEntity pOwner) {
        this((EntityType)ModEntityType.DELAYED_SUMMON.get(), pLevel);
        this.m_6034_(pPos.f_82479_, pPos.f_82480_, pPos.f_82481_);
        this.entity = pEntity;
        this.preMade = preMade;
        this.noPos = noPos;
        this.setTrueOwner(pOwner);
    }

    public DelayedSummon(Level pLevel, BlockPos pPos, Entity pEntity, boolean preMade, boolean noPos, @Nullable LivingEntity pOwner) {
        this((EntityType)ModEntityType.DELAYED_SUMMON.get(), pLevel);
        this.m_6034_(pPos.m_123341_(), pPos.m_123342_(), pPos.m_123343_());
        this.entity = pEntity;
        this.preMade = preMade;
        this.noPos = noPos;
        this.setTrueOwner(pOwner);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(OWNER_UNIQUE_ID, Optional.empty());
    }

    protected void m_7378_(CompoundTag pCompound) {
        Entity entity = EntityType.m_20645_((CompoundTag)pCompound, (Level)this.f_19853_, p_58740_ -> p_58740_);
        if (entity != null) {
            this.entity = entity;
        }
        if (pCompound.m_128403_("Owner")) {
            this.setOwnerId(pCompound.m_128342_("Owner"));
        }
        this.preMade = pCompound.m_128471_("preMade");
        this.noPos = pCompound.m_128471_("noPos");
        this.necromancy = pCompound.m_128471_("Necromancy");
        this.lifeSpan = pCompound.m_128451_("lifeSpan");
    }

    protected void m_7380_(CompoundTag pCompound) {
        if (this.entity != null) {
            this.entity.m_20223_(pCompound);
        }
        if (this.getOwnerId() != null) {
            pCompound.m_128362_("Owner", this.getOwnerId());
        }
        pCompound.m_128379_("preMade", this.preMade);
        pCompound.m_128379_("noPos", this.noPos);
        pCompound.m_128379_("Necromancy", this.necromancy);
        pCompound.m_128405_("lifeSpan", this.lifeSpan);
    }

    @Nullable
    public LivingEntity getTrueOwner() {
        try {
            UUID uuid = this.getOwnerId();
            return uuid == null ? null : EntityFinder.getLivingEntityByUuiD(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    @Nullable
    public UUID getOwnerId() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setOwnerId(@Nullable UUID p_184754_1_) {
        this.f_19804_.m_135381_(OWNER_UNIQUE_ID, Optional.ofNullable(p_184754_1_));
    }

    public void setTrueOwner(@Nullable LivingEntity livingEntity) {
        if (livingEntity != null) {
            this.setOwnerId(livingEntity.m_20148_());
        }
    }

    public void setLifeSpan(int lifeSpan) {
        this.lifeSpan = lifeSpan;
    }

    public int getLifeSpan() {
        if (this.lifeSpan == 0) {
            return 20;
        }
        return this.lifeSpan;
    }

    public void setNecromancy(boolean necromancy) {
        this.necromancy = necromancy;
    }

    public PushReaction m_7752_() {
        return PushReaction.IGNORE;
    }

    public void m_8119_() {
        Level level;
        super.m_8119_();
        if (!this.m_20068_()) {
            MobUtil.moveDownToGround(this);
        }
        if ((level = this.f_19853_) instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            if (this.f_19797_ >= this.getLifeSpan() && this.entity != null) {
                if (this.noPos) {
                    this.entity.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                }
                if (this.preMade) {
                    Entity entity = this.entity;
                    if (entity instanceof TamableAnimal) {
                        TamableAnimal animal = (TamableAnimal)entity;
                        if (this.getOwnerId() != null) {
                            animal.m_21816_(this.getOwnerId());
                        }
                    }
                    if ((entity = this.entity) instanceof IOwned) {
                        IOwned owned = (IOwned)entity;
                        if (this.getTrueOwner() != null) {
                            owned.setTrueOwner(this.getTrueOwner());
                        }
                    }
                    if ((entity = this.entity) instanceof Mob) {
                        Mob mob1;
                        LivingEntity livingEntity;
                        Mob mob = (Mob)entity;
                        ForgeEventFactory.onFinalizeSpawn((Mob)mob, (ServerLevelAccessor)serverWorld, (DifficultyInstance)this.f_19853_.m_6436_(this.m_20183_()), (MobSpawnType)MobSpawnType.MOB_SUMMONED, null, null);
                        if (this.getTrueOwner() != null && (livingEntity = this.getTrueOwner()) instanceof Mob && (mob1 = (Mob)livingEntity).m_5448_() != null) {
                            mob.m_6710_(mob1.m_5448_());
                        }
                    }
                }
                if (serverWorld.m_7967_(this.entity)) {
                    if (this.necromancy) {
                        SoundUtil.playNecromancerSummon(this.entity);
                        ColorUtil colorUtil = new ColorUtil(2804175);
                        ServerParticleUtil.windShockwaveParticle(serverWorld, colorUtil, 0.1f, 0.1f, 0.05f, -1, this.entity.m_20182_());
                    }
                    this.m_146870_();
                }
            }
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

