/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.util;

import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.effects.brew.BrewEffectInstance;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.BrewUtils;
import com.Polarice3.Goety.utils.ConstantPaths;
import com.Polarice3.Goety.utils.MathHelper;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BrewGas
extends Entity {
    private static final EntityDataAccessor<Integer> DATA_COLOR = SynchedEntityData.m_135353_(BrewGas.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public List<MobEffectInstance> effects = Lists.newArrayList();
    public List<BrewEffectInstance> brewEffects = Lists.newArrayList();
    private boolean fixedColor;
    public int duration = 600;
    public int area = 10;
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUUID;

    public BrewGas(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
        this.f_19794_ = true;
    }

    public BrewGas(Level p_19707_, double p_19708_, double p_19709_, double p_19710_) {
        this((EntityType)ModEntityType.BREW_EFFECT_GAS.get(), p_19707_);
        this.m_6034_(p_19708_, p_19709_, p_19710_);
    }

    public void setGas(List<MobEffectInstance> mobEffectInstances, List<BrewEffectInstance> brewEffectInstances, int duration, int area, @Nullable LivingEntity owner) {
        if (!mobEffectInstances.isEmpty()) {
            for (MobEffectInstance mobEffectInstance : mobEffectInstances) {
                this.addEffect(mobEffectInstance);
            }
        }
        if (!brewEffectInstances.isEmpty()) {
            for (BrewEffectInstance brewEffectInstance : brewEffectInstances) {
                this.addBrewEffect(brewEffectInstance);
            }
        }
        this.duration = duration;
        this.area = area;
        this.owner = owner;
        this.ownerUUID = owner != null ? owner.m_20148_() : null;
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(DATA_COLOR, (Object)0xFFFFFF);
    }

    protected void m_7378_(CompoundTag p_20052_) {
        Object instance;
        CompoundTag compoundtag;
        int i;
        ListTag listtag;
        if (p_20052_.m_128425_("Effects", 9)) {
            listtag = p_20052_.m_128437_("Effects", 10);
            for (i = 0; i < listtag.size(); ++i) {
                compoundtag = listtag.m_128728_(i);
                instance = MobEffectInstance.m_19560_((CompoundTag)compoundtag);
                if (instance == null) continue;
                this.addEffect((MobEffectInstance)instance);
            }
        }
        if (p_20052_.m_128425_("BrewEffects", 9)) {
            listtag = p_20052_.m_128437_("BrewEffects", 10);
            for (i = 0; i < listtag.size(); ++i) {
                compoundtag = listtag.m_128728_(i);
                instance = BrewEffectInstance.load(compoundtag);
                if (instance == null) continue;
                this.addBrewEffect((BrewEffectInstance)instance);
            }
        }
        if (p_20052_.m_128403_("Owner")) {
            this.ownerUUID = p_20052_.m_128342_("Owner");
        }
        if (p_20052_.m_128425_("Color", 99)) {
            this.setFixedColor(p_20052_.m_128451_("Color"));
        }
        if (p_20052_.m_128441_("Duration")) {
            this.duration = p_20052_.m_128451_("Duration");
        }
        if (p_20052_.m_128441_("Area")) {
            this.area = p_20052_.m_128451_("Area");
        }
        if (p_20052_.m_128441_("Age")) {
            this.f_19797_ = p_20052_.m_128451_("Age");
        }
    }

    protected void m_7380_(CompoundTag p_20139_) {
        ListTag listtag;
        if (!this.effects.isEmpty()) {
            listtag = new ListTag();
            for (MobEffectInstance mobeffectinstance : this.effects) {
                listtag.add((Object)mobeffectinstance.m_19555_(new CompoundTag()));
            }
            p_20139_.m_128365_("Effects", (Tag)listtag);
        }
        if (!this.brewEffects.isEmpty()) {
            listtag = new ListTag();
            for (BrewEffectInstance brewEffectInstance : this.brewEffects) {
                listtag.add((Object)brewEffectInstance.save(new CompoundTag()));
            }
            p_20139_.m_128365_("BrewEffects", (Tag)listtag);
        }
        if (this.ownerUUID != null) {
            p_20139_.m_128362_("Owner", this.ownerUUID);
        }
        if (this.fixedColor) {
            p_20139_.m_128405_("Color", this.getColor());
        }
        if (this.duration > 0) {
            p_20139_.m_128405_("Duration", this.duration);
        }
        p_20139_.m_128405_("Area", this.area);
        p_20139_.m_128405_("Age", this.f_19797_);
    }

    public void m_6034_(double p_33449_, double p_33450_, double p_33451_) {
        super.m_6034_((double)Mth.m_14107_((double)p_33449_) + 0.5, (double)Mth.m_14107_((double)(p_33450_ + 0.5)), (double)Mth.m_14107_((double)p_33451_) + 0.5);
    }

    public boolean isInSolid() {
        if (!this.f_19853_.m_8055_(this.m_20183_()).m_60795_() && !BlockFinder.canBeReplaced(this.f_19853_, this.m_20183_())) {
            return true;
        }
        if (!this.f_19853_.m_6425_(this.m_20183_()).m_76178_() || this.f_19853_.m_8055_(this.m_20183_()).m_204336_(BlockTags.f_13076_)) {
            return true;
        }
        float f = this.m_6972_((Pose)Pose.STANDING).f_20377_ * 0.8f;
        AABB aabb = AABB.m_165882_((Vec3)this.m_146892_(), (double)f, (double)1.0E-6, (double)f);
        return BlockPos.m_121921_((AABB)aabb).anyMatch(p_201942_ -> {
            BlockState blockstate = this.f_19853_.m_8055_(p_201942_);
            return !blockstate.m_60795_() && blockstate.m_60828_((BlockGetter)this.f_19853_, p_201942_) && Shapes.m_83157_((VoxelShape)blockstate.m_60812_((BlockGetter)this.f_19853_, p_201942_).m_83216_((double)p_201942_.m_123341_(), (double)p_201942_.m_123342_(), (double)p_201942_.m_123343_()), (VoxelShape)Shapes.m_83064_((AABB)aabb), (BooleanOp)BooleanOp.f_82689_);
        });
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            List list1;
            Level level = this.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.CULT_SPELL.get()), this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 0, MathHelper.rgbParticle(this.getColor())[0], MathHelper.rgbParticle(this.getColor())[1], MathHelper.rgbParticle(this.getColor())[2], 0.5);
            }
            if (this.isInSolid()) {
                this.m_146870_();
            }
            int i = this.duration - this.f_19797_;
            if (this.area > 0) {
                if (this.f_19796_.m_188503_(40) == 0 || this.f_19797_ == 5) {
                    boolean expanded = false;
                    for (Direction direction : Direction.values()) {
                        BlockPos blockPos;
                        BlockState blockState;
                        double probability = 0.4;
                        if (direction.m_122434_().m_122479_()) {
                            probability = 0.8;
                        }
                        if (!(this.f_19853_.f_46441_.m_188500_() < probability) || !(blockState = this.f_19853_.m_8055_(blockPos = this.m_20183_().m_121945_(direction))).m_60795_() && !blockState.m_60722_((Fluid)Fluids.f_76192_)) continue;
                        if (this.f_19853_.m_45976_(BrewGas.class, new AABB(blockPos)).isEmpty()) {
                            BrewGas brewGas = new BrewGas((EntityType)ModEntityType.BREW_EFFECT_GAS.get(), this.f_19853_);
                            brewGas.m_6034_(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
                            brewGas.setGas(this.effects, this.brewEffects, this.duration, this.area - 1, this.owner != null ? this.owner : null);
                            if (!this.f_19853_.m_7967_((Entity)brewGas)) continue;
                            expanded = true;
                            continue;
                        }
                        expanded = true;
                    }
                    if (expanded) {
                        --this.area;
                    }
                }
            } else if (this.f_19797_ >= this.duration || this.f_19853_.f_46441_.m_188503_(i) == 0) {
                this.m_146870_();
            }
            if (!(this.effects.isEmpty() && this.brewEffects.isEmpty() || (list1 = this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_())).isEmpty())) {
                for (LivingEntity livingentity : list1) {
                    if (!livingentity.m_5801_() || livingentity.m_19880_().contains(ConstantPaths.gassed())) continue;
                    for (MobEffectInstance mobEffectInstance : this.effects) {
                        if (mobEffectInstance.m_19544_().m_8093_()) {
                            mobEffectInstance.m_19544_().m_19461_((Entity)this, (Entity)this.getOwner(), livingentity, mobEffectInstance.m_19564_(), 0.5);
                            continue;
                        }
                        livingentity.m_147207_(new MobEffectInstance(mobEffectInstance), (Entity)this);
                    }
                    for (BrewEffectInstance brewEffectInstance : this.brewEffects) {
                        if (!brewEffectInstance.getEffect().canLinger()) continue;
                        brewEffectInstance.getEffect().applyInstantenousEffect(this, (Entity)this.getOwner(), livingentity, brewEffectInstance.getAmplifier(), 0.5);
                    }
                    livingentity.m_20049_(ConstantPaths.gassed());
                }
            }
        }
    }

    private void updateColor() {
        this.m_20088_().m_135381_(DATA_COLOR, (Object)BrewUtils.getColor(this.effects, this.brewEffects));
    }

    public void addEffect(MobEffectInstance p_19717_) {
        this.effects.add(p_19717_);
        if (!this.fixedColor) {
            this.updateColor();
        }
    }

    public void addBrewEffect(BrewEffectInstance p_19717_) {
        this.brewEffects.add(p_19717_);
        if (!this.fixedColor) {
            this.updateColor();
        }
    }

    public int getColor() {
        return (Integer)this.m_20088_().m_135370_(DATA_COLOR);
    }

    public void setFixedColor(int p_19715_) {
        this.fixedColor = true;
        this.m_20088_().m_135381_(DATA_COLOR, (Object)p_19715_);
    }

    public void setOwner(@Nullable LivingEntity p_19719_) {
        this.owner = p_19719_;
        this.ownerUUID = p_19719_ == null ? null : p_19719_.m_20148_();
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.f_19853_ instanceof ServerLevel && (entity = ((ServerLevel)this.f_19853_).m_8791_(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    public PushReaction m_7752_() {
        return PushReaction.IGNORE;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }
}

