/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class IceSpike
extends AbstractArrow {
    public static final EntityDataAccessor<Boolean> DATA_RAIN = SynchedEntityData.m_135353_(IceSpike.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Float> DATA_EXTRA_DAMAGE = SynchedEntityData.m_135353_(IceSpike.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);

    public IceSpike(EntityType<? extends AbstractArrow> p_36721_, Level p_36722_) {
        super(p_36721_, p_36722_);
        this.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
    }

    public IceSpike(double p_36712_, double p_36713_, double p_36714_, Level p_36715_) {
        super((EntityType)ModEntityType.ICE_SPIKE.get(), p_36712_, p_36713_, p_36714_, p_36715_);
        this.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
    }

    public IceSpike(LivingEntity p_36718_, Level p_36719_) {
        super((EntityType)ModEntityType.ICE_SPIKE.get(), p_36718_, p_36719_);
        this.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_RAIN, (Object)false);
        this.f_19804_.m_135372_(DATA_EXTRA_DAMAGE, (Object)Float.valueOf(0.0f));
    }

    public void m_7380_(CompoundTag p_36881_) {
        super.m_7380_(p_36881_);
        p_36881_.m_128379_("Rain", this.isRain());
        p_36881_.m_128350_("ExtraDamage", this.getExtraDamage());
    }

    public void m_7378_(CompoundTag p_36875_) {
        super.m_7378_(p_36875_);
        if (p_36875_.m_128441_("Rain")) {
            this.setRain(p_36875_.m_128471_("Rain"));
        }
        if (p_36875_.m_128441_("ExtraDamage")) {
            this.setExtraDamage(p_36875_.m_128457_("ExtraDamage"));
        }
    }

    public boolean isRain() {
        return (Boolean)this.f_19804_.m_135370_(DATA_RAIN);
    }

    public void setRain(boolean rain) {
        this.f_19804_.m_135381_(DATA_RAIN, (Object)rain);
    }

    public float getExtraDamage() {
        return ((Float)this.f_19804_.m_135370_(DATA_EXTRA_DAMAGE)).floatValue();
    }

    public void setExtraDamage(float pDamage) {
        this.f_19804_.m_135381_(DATA_EXTRA_DAMAGE, (Object)Float.valueOf(pDamage));
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_20077_() || this.m_6060_()) {
            this.m_146870_();
        }
        if (!this.f_36703_) {
            Vec3 vector3d = this.m_20184_();
            double d3 = vector3d.f_82479_;
            double d4 = vector3d.f_82480_;
            double d0 = vector3d.f_82481_;
            double d5 = this.m_20185_() + d3;
            double d1 = this.m_20186_() + d4;
            double d2 = this.m_20189_() + d0;
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_175821_, d5 - d3 * 0.25, d1 - d4 * 0.25, d2 - d0 * 0.25, d3, d4, d0);
        } else if (this.isRain() && this.f_19797_ % 5 == 0) {
            this.m_146870_();
        }
    }

    protected void m_5790_(EntityHitResult p_37626_) {
        if (!this.f_19853_.f_46443_) {
            boolean flag;
            float baseDamage = ((Double)SpellConfig.IceSpikeDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();
            Entity entity = p_37626_.m_82443_();
            Entity entity1 = this.m_19749_();
            baseDamage += this.getExtraDamage();
            if (entity1 instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity1;
                flag = entity.m_6469_(ModDamageSource.iceSpike((Entity)this, (Entity)livingentity), baseDamage);
                if (flag && entity.m_6084_()) {
                    this.m_19970_(livingentity, entity);
                }
            } else {
                flag = entity.m_6469_(ModDamageSource.iceSpike((Entity)this, (Entity)this), baseDamage);
            }
            if (flag && entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.FREEZING.get(), MathHelper.secondsToTicks(3 + livingEntity.m_217043_().m_188503_(2))));
                this.m_5496_((SoundEvent)ModSounds.ICE_SPIKE_HIT.get(), 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
                Level level = livingEntity.f_19853_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    ServerParticleUtil.addParticlesAroundSelf(serverLevel, (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50354_.m_49966_()), (Entity)livingEntity);
                }
                this.m_146870_();
            }
        }
    }

    protected void m_8060_(BlockHitResult p_36755_) {
        super.m_8060_(p_36755_);
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.isRain()) {
                ServerParticleUtil.addParticlesAroundSelf(serverLevel, (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50354_.m_49966_()), (Entity)this);
                this.m_146870_();
            }
        }
    }

    public void m_142687_(Entity.RemovalReason p_146834_) {
        Level level;
        if (p_146834_ == Entity.RemovalReason.DISCARDED && this.isRain() && (level = this.f_19853_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175821_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0, 0.0, 0.5, 0.0, 1.0);
        }
        super.m_142687_(p_146834_);
    }

    protected boolean m_5603_(Entity pEntity) {
        if (this.m_19749_() != null) {
            Mob mob;
            Entity entity = this.m_19749_();
            if (entity instanceof Mob && (mob = (Mob)entity).m_5448_() == pEntity) {
                return super.m_5603_(pEntity);
            }
            if (MobUtil.areAllies(this.m_19749_(), pEntity)) {
                return false;
            }
            if (this.m_19749_() instanceof Enemy && pEntity instanceof Enemy) {
                return false;
            }
            if (pEntity instanceof IOwned) {
                IOwned owned0 = (IOwned)pEntity;
                Entity entity2 = this.m_19749_();
                if (entity2 instanceof IOwned) {
                    IOwned owned1 = (IOwned)entity2;
                    return !MobUtil.ownerStack(owned0, owned1);
                }
            }
        }
        return super.m_5603_(pEntity);
    }

    protected float m_6882_() {
        return 0.99f;
    }

    protected boolean m_142470_(Player p_150196_) {
        return false;
    }

    protected SoundEvent m_7239_() {
        return SoundEvents.f_11983_;
    }

    public boolean m_6000_(double x, double y, double z) {
        return true;
    }

    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

