/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.projectiles.AbstractSpellCloud;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class HailCloud
extends AbstractSpellCloud {
    public HailCloud(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
        this.setRainParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123814_, Blocks.f_50127_.m_49966_()));
    }

    public HailCloud(Level pLevel, LivingEntity pOwner, LivingEntity pTarget) {
        this((EntityType)ModEntityType.HAIL_CLOUD.get(), pLevel);
        if (pOwner != null) {
            this.setOwner(pOwner);
        }
        if (pTarget != null) {
            BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos(pTarget.m_20185_(), pTarget.m_20186_(), pTarget.m_20189_());
            while ((double)blockpos$mutable.m_123342_() < pTarget.m_20186_() + 4.0 && !this.f_19853_.m_8055_((BlockPos)blockpos$mutable).m_280555_()) {
                blockpos$mutable.m_122173_(Direction.UP);
            }
            this.m_6034_(pTarget.m_20185_(), blockpos$mutable.m_123342_(), pTarget.m_20189_());
            this.setTarget(pTarget);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_ && this.isStaff()) {
            if (this.getTarget() == null) {
                for (Entity entity : this.f_19853_.m_45976_(Entity.class, this.m_20191_().m_82400_(16.0))) {
                    LivingEntity livingEntity = MobUtil.getLivingTarget(entity);
                    if (livingEntity == null || !MobUtil.ownedPredicate(this).test(livingEntity)) continue;
                    this.setTarget(livingEntity);
                }
            }
            float speed = 0.175f;
            if (this.getTarget() != null && this.getTarget().m_6084_()) {
                this.m_20256_(Vec3.f_82478_);
                double d0 = this.getTarget().m_20185_() - this.m_20185_();
                double d1 = this.getTarget().m_20186_() + 4.0 - this.m_20186_();
                double d2 = this.getTarget().m_20189_() - this.m_20189_();
                double d = Math.sqrt(d0 * d0 + d2 * d2);
                double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                if (d > 0.5) {
                    this.m_20256_(this.m_20184_().m_82520_(d0 / d3, d1 / d3, d2 / d3).m_82490_((double)speed));
                }
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
        }
    }

    @Override
    public void hurtEntities(LivingEntity livingEntity) {
        if (livingEntity != null) {
            float baseDamage = ((Double)SpellConfig.HailDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();
            if (livingEntity.m_6469_(ModDamageSource.frostBreath(this, (Entity)this.m_269323_()), baseDamage += this.getExtraDamage())) {
                livingEntity.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.FREEZING.get(), MathHelper.secondsToTicks(5)));
            }
        }
    }
}

