/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.common.entities.projectiles.SpellEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractWave
extends SpellEntity {
    private static final EntityDataAccessor<Boolean> SLAMMING = SynchedEntityData.m_135353_(AbstractWave.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> LIFESPAN = SynchedEntityData.m_135353_(AbstractWave.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> WAITING_TICKS = SynchedEntityData.m_135353_(AbstractWave.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> Y_ROT = SynchedEntityData.m_135353_(AbstractWave.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> WAVE_SCALE = SynchedEntityData.m_135353_(AbstractWave.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private float slamProgress;
    private float prevSlamProgress;
    private int lSteps;
    private double lx;
    private double ly;
    private double lz;
    private double lyr;
    private double lxr;
    private double lxd;
    private double lyd;
    private double lzd;
    public int activeWaveTicks;
    public boolean isShrink = false;
    public int shrinking = 40;

    public AbstractWave(EntityType p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(SLAMMING, (Object)false);
        this.m_20088_().m_135372_(LIFESPAN, (Object)10);
        this.m_20088_().m_135372_(WAITING_TICKS, (Object)0);
        this.m_20088_().m_135372_(Y_ROT, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(WAVE_SCALE, (Object)Float.valueOf(1.0f));
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (compoundTag.m_128441_("Lifespan")) {
            this.setLifespan(compoundTag.m_128451_("Lifespan"));
        }
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("Lifespan", this.getLifespan());
    }

    public float getStepHeight() {
        return 2.0f;
    }

    public float m_146908_() {
        return ((Float)this.f_19804_.m_135370_(Y_ROT)).floatValue();
    }

    public void m_146922_(float f) {
        this.f_19804_.m_135381_(Y_ROT, (Object)Float.valueOf(f));
    }

    public int getLifespan() {
        return (Integer)this.f_19804_.m_135370_(LIFESPAN);
    }

    public void setLifespan(int time) {
        this.f_19804_.m_135381_(LIFESPAN, (Object)time);
    }

    public int getWaitingTicks() {
        return (Integer)this.f_19804_.m_135370_(WAITING_TICKS);
    }

    public void setWaitingTicks(int time) {
        this.f_19804_.m_135381_(WAITING_TICKS, (Object)time);
    }

    public boolean isSlamming() {
        return (Boolean)this.f_19804_.m_135370_(SLAMMING);
    }

    public void setSlamming(boolean bool) {
        this.f_19804_.m_135381_(SLAMMING, (Object)bool);
    }

    public float getWaveScale() {
        return ((Float)this.f_19804_.m_135370_(WAVE_SCALE)).floatValue();
    }

    public void setWaveScale(float waveScale) {
        this.f_19804_.m_135381_(WAVE_SCALE, (Object)Float.valueOf(waveScale));
    }

    public float getSlamAmount(float partialTicks) {
        return (this.prevSlamProgress + (this.slamProgress - this.prevSlamProgress) * partialTicks) * 0.1f;
    }

    public void spawnParticleAt(float yOffset, float zOffset, float xOffset, ParticleOptions particleType) {
        Vec3 vec3 = new Vec3((double)xOffset, (double)yOffset, (double)zOffset).m_82524_((float)Math.toRadians(-this.m_146908_()));
        this.f_19853_.m_7106_(particleType, this.m_20185_() + vec3.f_82479_, this.m_20186_() + vec3.f_82480_, this.m_20189_() + vec3.f_82481_, this.m_20184_().f_82479_, (double)0.1f, this.m_20184_().f_82481_);
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.prevSlamProgress = this.slamProgress;
        if (this.isWaitingTick()) {
            return;
        }
        if (this.isSlamming() && this.slamProgress < 10.0f) {
            this.slamProgress += 1.0f;
        }
        if (this.isSlamming() && this.slamProgress >= 10.0f) {
            this.isShrink = true;
        }
        if (this.isShrink) {
            this.shrinkingTick();
        }
        if (!this.m_20068_() && !this.m_20072_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, (double)-0.04f, 0.0));
        }
        float f = Math.min((float)this.activeWaveTicks / 10.0f, 1.0f);
        Vec3 directionVec = new Vec3(0.0, 0.0, (double)(f * f * 0.2f)).m_82524_((float)Math.toRadians(-this.m_146908_()));
        if (this.f_19853_.f_46443_) {
            if (this.lSteps > 0) {
                double d5 = this.m_20185_() + (this.lx - this.m_20185_()) / (double)this.lSteps;
                double d6 = this.m_20186_() + (this.ly - this.m_20186_()) / (double)this.lSteps;
                double d7 = this.m_20189_() + (this.lz - this.m_20189_()) / (double)this.lSteps;
                this.m_146922_(Mth.m_14177_((float)((float)this.lyr)));
                this.m_146926_(this.m_146909_() + (float)(this.lxr - (double)this.m_146909_()) / (float)this.lSteps);
                --this.lSteps;
                this.m_6034_(d5, d6, d7);
            } else {
                this.m_20090_();
            }
        } else {
            this.m_20090_();
            this.m_19915_(this.m_146908_(), this.m_146909_());
        }
        if (!this.f_19853_.f_46443_) {
            this.attackEntities(this.getSlamAmount(1.0f) * 2.0f + 1.0f + this.getWaveScale());
        }
        Vec3 vec3 = this.m_20184_().m_82490_((double)0.9f).m_82549_(directionVec);
        this.m_6478_(MoverType.SELF, vec3);
        this.m_20256_(vec3.m_82542_((double)0.99f, (double)0.98f, (double)0.99f));
        if (this.activeWaveTicks > this.getLifespan() || this.activeWaveTicks > 10 && this.m_20184_().m_165924_() < (double)0.04f) {
            this.setSlamming(true);
        }
        ++this.activeWaveTicks;
    }

    public boolean isWaitingTick() {
        if (this.getWaitingTicks() > 0) {
            if (!this.f_19853_.f_46443_) {
                this.setWaitingTicks(this.getWaitingTicks() - 1);
            }
            this.m_6842_(true);
            return true;
        }
        if (this.m_20145_()) {
            this.m_6842_(false);
        }
        return false;
    }

    public void shrinkingTick() {
        if (this.getWaveScale() <= 0.0f) {
            this.m_146870_();
        } else {
            this.setWaveScale(this.getWaveScale() - 0.1f);
        }
    }

    public void attackEntities(float scale) {
    }

    public void m_7350_(EntityDataAccessor<?> dataAccessor) {
        if (WAVE_SCALE.equals(dataAccessor)) {
            this.m_6210_();
        }
        super.m_7350_(dataAccessor);
    }

    public EntityDimensions m_6972_(Pose pose) {
        float newDim = Math.max((this.getWaveScale() - 1.0f) * 2.0f, 0.0f);
        return super.m_6972_(pose).m_20390_(this.getWaveScale() + newDim, this.getWaveScale() + newDim);
    }

    public void m_6453_(double x, double y, double z, float yr, float xr, int steps, boolean b) {
        this.lx = x;
        this.ly = y;
        this.lz = z;
        this.lyr = yr;
        this.lxr = xr;
        this.lSteps = steps;
        this.m_20334_(this.lxd, this.lyd, this.lzd);
    }

    public void m_6001_(double lerpX, double lerpY, double lerpZ) {
        this.lxd = lerpX;
        this.lyd = lerpY;
        this.lzd = lerpZ;
        this.m_20334_(this.lxd, this.lyd, this.lzd);
    }
}

