/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.projectiles.SpellEntity;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.arguments.ParticleArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public abstract class AbstractSpellCloud
extends SpellEntity {
    private static final EntityDataAccessor<Float> DATA_RADIUS = SynchedEntityData.m_135353_(AbstractSpellCloud.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<ParticleOptions> DATA_PARTICLE = SynchedEntityData.m_135353_(AbstractSpellCloud.class, (EntityDataSerializer)EntityDataSerializers.f_135036_);
    public boolean activated;
    public int activateTime = 20;
    public int lifeSpan = 100;

    public AbstractSpellCloud(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    public AbstractSpellCloud(EntityType<?> p_19870_, Level pLevel, LivingEntity pOwner, LivingEntity pTarget) {
        this(p_19870_, pLevel);
        if (pOwner != null) {
            this.setOwner(pOwner);
        }
        if (pTarget != null) {
            BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos(pTarget.m_20185_(), pTarget.m_20186_(), pTarget.m_20189_());
            while ((double)blockpos$mutable.m_123342_() < pTarget.m_20186_() + 4.0 && !this.f_19853_.m_8055_((BlockPos)blockpos$mutable).m_280555_()) {
                blockpos$mutable.m_122173_(Direction.UP);
            }
            this.m_6034_(pTarget.m_20185_(), blockpos$mutable.m_123342_(), pTarget.m_20189_());
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_PARTICLE, (Object)ParticleTypes.f_123761_);
        this.m_20088_().m_135372_(DATA_RADIUS, (Object)Float.valueOf(2.0f));
    }

    public void m_7350_(EntityDataAccessor<?> p_19729_) {
        if (DATA_RADIUS.equals(p_19729_)) {
            this.m_6210_();
        }
        super.m_7350_(p_19729_);
    }

    @Override
    public void m_7378_(CompoundTag p_20052_) {
        super.m_7378_(p_20052_);
        if (p_20052_.m_128425_("Particle", 8)) {
            try {
                this.setRainParticle(ParticleArgument.m_247456_((StringReader)new StringReader(p_20052_.m_128461_("Particle")), (HolderLookup)BuiltInRegistries.f_257034_.m_255303_()));
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
        if (p_20052_.m_128441_("Activated")) {
            this.activated = p_20052_.m_128471_("Activated");
        }
        if (p_20052_.m_128441_("ActivateTime")) {
            this.activateTime = p_20052_.m_128451_("ActivateTime");
        }
        if (p_20052_.m_128441_("LifeSpan")) {
            this.lifeSpan = p_20052_.m_128451_("LifeSpan");
        }
    }

    @Override
    public void m_7380_(CompoundTag p_20139_) {
        super.m_7380_(p_20139_);
        p_20139_.m_128359_("Particle", this.getRainParticle().m_5942_());
        p_20139_.m_128379_("Activated", this.activated);
        p_20139_.m_128405_("ActivateTime", this.activateTime);
        p_20139_.m_128405_("LifeSpan", this.lifeSpan);
    }

    public void setActivateTime(int activateTime) {
        this.activateTime = activateTime;
    }

    public void setLifeSpan(int lifeSpan) {
        this.lifeSpan = lifeSpan;
    }

    public ParticleOptions getRainParticle() {
        return (ParticleOptions)this.m_20088_().m_135370_(DATA_PARTICLE);
    }

    public void setRainParticle(ParticleOptions p_19725_) {
        this.m_20088_().m_135381_(DATA_PARTICLE, (Object)p_19725_);
    }

    public int getColor() {
        return 0xFFFFFF;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            this.cloudParticles(this.getColor());
            if (this.activated) {
                if (this.lifeSpan > 0) {
                    --this.lifeSpan;
                    this.rainParticles(this.getRainParticle());
                    AABB below = this.m_20191_().m_82386_(0.0, -16.0, 0.0).m_82377_(0.0, 16.0, 0.0);
                    for (Entity entity : this.f_19853_.m_45976_(Entity.class, below)) {
                        LivingEntity livingEntity = MobUtil.getLivingTarget(entity);
                        if (livingEntity == null) continue;
                        boolean flag = false;
                        if (this.m_269323_() != null) {
                            if (livingEntity != this.m_269323_() && !MobUtil.areAllies((Entity)this.m_269323_(), (Entity)livingEntity)) {
                                flag = true;
                            }
                        } else {
                            flag = true;
                        }
                        if (!flag) continue;
                        int distance = (int)(this.m_20186_() - livingEntity.m_20186_());
                        if (!BlockFinder.emptySpaceBetween(this.f_19853_, livingEntity.m_20183_(), distance, true)) continue;
                        this.hurtEntities(livingEntity);
                    }
                } else {
                    this.m_146870_();
                }
            } else if (this.f_19797_ % this.activateTime == 0) {
                this.activated = true;
            }
        }
    }

    public void setRadius(float radius) {
        if (!this.f_19853_.f_46443_) {
            this.m_20088_().m_135381_(DATA_RADIUS, (Object)Float.valueOf(Mth.m_14036_((float)radius, (float)0.0f, (float)32.0f)));
        }
    }

    public float getRadius() {
        return ((Float)this.m_20088_().m_135370_(DATA_RADIUS)).floatValue();
    }

    public void m_6210_() {
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d0, d1, d2);
    }

    public void cloudParticles(int color) {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            float f = this.getRadius();
            float f5 = (float)Math.PI * f * f;
            int k1 = 0;
            while ((float)k1 < f5) {
                float f6 = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
                float f7 = Mth.m_14116_((float)this.f_19796_.m_188501_()) * f;
                float f8 = Mth.m_14089_((float)f6) * f7;
                float f9 = Mth.m_14031_((float)f6) * f7;
                if (color == 0xFFFFFF) {
                    serverWorld.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.SPELL_CLOUD.get()), this.m_20185_() + (double)f8, this.m_20186_(), this.m_20189_() + (double)f9, 0, 1.0, 1.0, 1.0, 0.5);
                } else {
                    serverWorld.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.SPELL_CLOUD.get()), this.m_20185_() + (double)f8, this.m_20186_(), this.m_20189_() + (double)f9, 0, MathHelper.rgbParticle(color)[0], MathHelper.rgbParticle(color)[1], MathHelper.rgbParticle(color)[2], 0.5);
                }
                ++k1;
            }
        }
    }

    public void rainParticles(ParticleOptions particleRain) {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            float f = this.getRadius();
            float f5 = (float)Math.PI * f * f;
            int k1 = 0;
            while ((float)k1 < f5) {
                float f6 = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
                float f7 = Mth.m_14116_((float)this.f_19796_.m_188501_()) * f;
                float f8 = Mth.m_14089_((float)f6) * f7;
                float f9 = Mth.m_14031_((float)f6) * f7;
                serverWorld.m_8767_(particleRain, this.m_20185_() + (double)f8, this.m_20186_(), this.m_20189_() + (double)f9, 1, 0.0, 0.0, 0.0, 0.0);
                ++k1;
            }
        }
    }

    public void hurtEntities(LivingEntity livingEntity) {
    }

    public EntityDimensions m_6972_(Pose p_19721_) {
        return EntityDimensions.m_20395_((float)(this.getRadius() * 2.0f), (float)0.5f);
    }
}

