/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.neutral;

import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class BeastHead
extends Owned {
    private Vec3 chargePos;
    public int life;
    public float keepYRot;
    public float keepXRot;
    public float alpha = 0.0f;
    private boolean sentSpawnEvent;
    private boolean sentAttackEvent;
    private final List<Entity> hitEntities = new ArrayList<Entity>();
    public AnimationState spawnAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();

    public BeastHead(EntityType<? extends Owned> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
        this.f_19794_ = true;
        this.m_20242_(true);
    }

    public BeastHead(EntityType<? extends Owned> p_19870_, Level p_19871_, LivingEntity target) {
        this(p_19870_, p_19871_);
        MobUtil.instaLook((Mob)this, (Entity)target);
        this.m_6710_(target);
        this.f_19859_ = this.m_146908_();
        this.f_20886_ = this.m_146908_();
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.life = pCompound.m_128451_("life");
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("life", this.life);
    }

    public void m_7601_(BlockState p_20006_, Vec3 p_20007_) {
        super.m_7601_(p_20006_, Vec3.f_82478_);
    }

    @Override
    protected void m_7324_(Entity p_20971_) {
    }

    @Override
    public boolean m_7337_(Entity p_20303_) {
        return false;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        return pSource.m_269533_(DamageTypeTags.f_268738_);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.m_146922_(this.m_6080_());
        this.f_20883_ = this.m_146908_();
        this.f_19794_ = true;
        this.m_20242_(true);
        ++this.life;
        if (!this.f_19853_.f_46443_) {
            if (!this.sentSpawnEvent) {
                this.f_19853_.m_7605_((Entity)this, (byte)4);
                this.sentSpawnEvent = true;
            }
            if (this.life < 30) {
                Vec3 vector3d;
                if (this.m_5448_() != null) {
                    vector3d = this.m_5448_().m_20299_(1.0f);
                    MobUtil.instaLook((Mob)this, (Entity)this.m_5448_());
                } else {
                    vector3d = this.m_20252_(1.0f);
                    MobUtil.instaLook((Mob)this, vector3d);
                }
                double dx = this.m_20185_() - vector3d.m_7096_();
                double dy = this.m_20186_() - vector3d.m_7098_();
                double dz = this.m_20189_() - vector3d.m_7094_();
                double d0 = Math.sqrt(dx * dx + dy * dy + dz * dz);
                double velocity = 2.0;
                double xPower = -(dx / d0 * velocity * 0.2);
                double yPower = -(dy / d0 * velocity * 0.2);
                double zPower = -(dz / d0 * velocity * 0.2);
                this.chargePos = new Vec3(xPower, yPower, zPower);
                this.keepYRot = this.m_146908_();
                this.keepXRot = this.m_146909_();
            } else {
                this.m_146922_(this.keepYRot);
                this.m_146926_(this.keepXRot);
                if (!this.sentAttackEvent) {
                    this.f_19853_.m_7605_((Entity)this, (byte)5);
                    this.sentAttackEvent = true;
                }
                if (this.chargePos != null) {
                    this.m_20256_(this.chargePos);
                }
                if (this.life <= 40) {
                    for (LivingEntity livingEntity : this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_().m_82400_(1.0))) {
                        if (this.hitEntities.contains(livingEntity) || MobUtil.areAllies((Entity)(this.m_269323_() != null ? this.m_269323_() : this), (Entity)livingEntity) || !EntitySelector.f_20406_.test(livingEntity)) continue;
                        DamageSource damageSource = this.m_269291_().m_269333_((LivingEntity)this);
                        if (this.m_269323_() != null) {
                            damageSource = ModDamageSource.summonAttack((LivingEntity)this, this.m_269323_());
                        }
                        if (!livingEntity.m_6469_(damageSource, ((Double)AttributesConfig.BlackBeastDamage.get()).floatValue())) continue;
                        this.hitEntities.add((Entity)livingEntity);
                    }
                } else {
                    this.m_20256_(this.m_20184_().m_82490_(0.25));
                }
            }
            if (this.life >= 70) {
                this.m_146870_();
            }
        } else {
            if (this.life > 10 && this.life < 50 && this.alpha < 1.0f) {
                this.alpha = Mth.m_14036_((float)(this.alpha + 0.1f), (float)0.0f, (float)1.0f);
            }
            if (this.life >= 50) {
                this.alpha = Mth.m_14036_((float)(this.alpha - 0.05f), (float)0.0f, (float)1.0f);
            }
        }
    }

    public boolean m_6097_() {
        return false;
    }

    public boolean m_5789_() {
        return false;
    }

    public boolean m_142065_() {
        return false;
    }

    @Override
    public boolean m_7301_(MobEffectInstance pPotioneffect) {
        return false;
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public boolean m_6051_() {
        return false;
    }

    public void m_7822_(byte p_36935_) {
        if (p_36935_ == 4) {
            this.spawnAnimationState.m_216982_(this.f_19797_);
        } else if (p_36935_ == 5) {
            this.spawnAnimationState.m_216973_();
            this.attackAnimationState.m_216977_(this.f_19797_);
        } else {
            super.m_7822_(p_36935_);
        }
    }
}

