/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.neutral;

import com.Polarice3.Goety.api.entities.IAutoRideable;
import com.Polarice3.Goety.api.entities.ally.IServant;
import com.Polarice3.Goety.api.items.magic.IWand;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ai.ModMeleeAttackGoal;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.ally.spider.SpiderServant;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.entities.neutral.SpiderEgg;
import com.Polarice3.Goety.common.entities.projectiles.WebShot;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.client.CSetDeltaMovement;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.config.MobsConfig;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.RiderShieldingMount;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;

public class AbstractBroodMother
extends Summoned
implements IAutoRideable,
PlayerRideableJumping,
RiderShieldingMount,
RangedAttackMob {
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(AbstractBroodMother.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final UUID DETECTION_MODIFIER_UUID = UUID.fromString("858f6b2f-73e3-45a0-8bef-bb31e0d55be4");
    public static final AttributeModifier DETECTION_MODIFIER = new AttributeModifier(DETECTION_MODIFIER_UUID, "Light Is Blinding", -1.0, AttributeModifier.Operation.ADDITION);
    private static final EntityDataAccessor<Integer> ATTACK_TYPE = SynchedEntityData.m_135353_(AbstractBroodMother.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(AbstractBroodMother.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> AUTO_MODE = SynchedEntityData.m_135353_(AbstractBroodMother.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final UUID SPEED_STOP_UUID = UUID.fromString("e336b82c-bd58-4374-9875-0b50a602fef2");
    private static final AttributeModifier SPEED_STOP = new AttributeModifier(SPEED_STOP_UUID, "Stop moving", -1.0, AttributeModifier.Operation.ADDITION);
    public static String ATTACK = "attack";
    public static String SHOOT = "shoot";
    public static String LAY_EGGS = "lay_eggs";
    public static String CHARGE = "charge";
    public static String BACK_OFF = "back_off";
    public static String JUMP = "jump";
    public static String DEATH = "death";
    public static int WEB_ATTACK = 1;
    public static int LAY_EGG_ATTACK = 2;
    public static int CHARGE_ATTACK = 3;
    public static int BACK_OFF_ATTACK = 4;
    public int deathTime = 0;
    protected int meleeTicks;
    protected int attackTicks;
    protected int jumpTicks;
    protected int multiLay;
    protected int summonCooldown;
    protected int webCooldown;
    protected int chargeCooldown;
    protected int backOffCooldown;
    public int circleTick;
    public boolean circleDirection;
    public boolean isCircling;
    public boolean clientAttacking;
    protected boolean isJumping;
    protected float playerJumpPendingScale;
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState shootAnimationState = new AnimationState();
    public AnimationState layEggsAnimationState = new AnimationState();
    public AnimationState chargeAnimationState = new AnimationState();
    public AnimationState backOffAnimationState = new AnimationState();
    public AnimationState jumpAnimationState = new AnimationState();
    public AnimationState deathAnimationState = new AnimationState();

    public AbstractBroodMother(EntityType<? extends Summoned> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new WebGoal());
        this.f_21345_.m_25352_(0, (Goal)new ChargeGoal());
        this.f_21345_.m_25352_(1, (Goal)new BackOffGoal());
        this.f_21345_.m_25352_(1, (Goal)new SummonSpiders());
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 140.0f));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 140.0f));
        this.f_21345_.m_25352_(5, new Summoned.WanderGoal<AbstractBroodMother>(this, 0.8));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.attackGoal();
    }

    public void attackGoal() {
        this.f_21345_.m_25352_(4, (Goal)new ModMeleeAttackGoal(this, 1.0, true){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean m_8036_() {
                if (!super.m_8036_()) return false;
                PathfinderMob pathfinderMob = this.mob;
                if (!(pathfinderMob instanceof AbstractBroodMother)) return false;
                AbstractBroodMother broodMother = (AbstractBroodMother)pathfinderMob;
                if (broodMother.isCircling) return false;
                return true;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean m_8045_() {
                if (!super.m_8045_()) return false;
                PathfinderMob pathfinderMob = this.mob;
                if (!(pathfinderMob instanceof AbstractBroodMother)) return false;
                AbstractBroodMother broodMother = (AbstractBroodMother)pathfinderMob;
                if (broodMother.isCircling) return false;
                return true;
            }

            @Override
            protected void checkAndPerformAttack(LivingEntity livingEntity, double distToEnemySqr) {
                double d0 = this.getAttackReachSqr(livingEntity);
                this.mob.m_21563_().m_24960_((Entity)livingEntity, 100.0f, 100.0f);
                if (distToEnemySqr <= d0 && this.isTimeToAttack()) {
                    int i = 0;
                    float angle = 2.0f;
                    double radius = 2.0;
                    double extraX = this.mob.m_20185_() + 0.8 * Math.sin((double)(-this.mob.m_146908_()) * Math.PI / 180.0) + (double)angle * Math.sin((double)(-this.mob.f_20885_) * Math.PI / 180.0) * Math.cos((double)(-this.mob.m_146909_()) * Math.PI / 180.0);
                    double extraZ = this.mob.m_20189_() + 0.8 * Math.cos((double)(-this.mob.m_146908_()) * Math.PI / 180.0) + (double)angle * Math.cos((double)(-this.mob.f_20885_) * Math.PI / 180.0) * Math.cos((double)(-this.mob.m_146909_()) * Math.PI / 180.0);
                    List list = this.mob.f_19853_.m_45976_(LivingEntity.class, new AABB(extraX - radius, this.mob.m_20186_(), extraZ - radius, extraX + radius, this.mob.m_20186_() + radius, extraZ + radius));
                    for (LivingEntity target : list) {
                        if (!EntitySelector.f_20406_.test(target) || MobUtil.areAllies((Entity)this.mob, (Entity)target) || !this.mob.m_7327_((Entity)target) && !target.m_21254_()) continue;
                        ++i;
                    }
                    if (i > 0) {
                        this.mob.m_6674_(InteractionHand.MAIN_HAND);
                        this.mob.m_5496_((SoundEvent)ModSounds.SWING.get(), 2.0f, 0.5f);
                    }
                    this.resetAttackCooldown();
                }
            }

            @Override
            protected double getAttackReachSqr(LivingEntity target) {
                return (double)this.mob.m_20205_() * 1.25 * (double)this.mob.m_20205_() * 1.25 + (double)target.m_20205_();
            }
        });
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.BroodMotherHealth.get()).doubleValue()).m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.BroodMotherArmor.get()).doubleValue()).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.BroodMotherDamage.get()).doubleValue()).m_22268_(Attributes.f_22277_, 32.0).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 2.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.BroodMotherHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.BroodMotherArmor.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.BroodMotherDamage.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(ATTACK_TYPE, (Object)0);
        this.f_19804_.m_135372_(ANIM_STATE, (Object)0);
        this.f_19804_.m_135372_(AUTO_MODE, (Object)false);
    }

    public void m_7350_(EntityDataAccessor<?> p_219422_) {
        if (ANIM_STATE.equals(p_219422_) && this.f_19853_.f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    break;
                }
                case 1: {
                    this.stopAllAnimation();
                    this.attackAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.stopAllAnimation();
                    this.shootAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 3: {
                    this.stopAllAnimation();
                    this.layEggsAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 4: {
                    this.stopAllAnimation();
                    this.chargeAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 5: {
                    this.stopAllAnimation();
                    this.backOffAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 6: {
                    this.stopAllAnimation();
                    this.jumpAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 7: {
                    this.stopAllAnimation();
                    this.deathAnimationState.m_216977_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_219422_);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("SummonCool", this.getSummonCooldown());
        pCompound.m_128405_("WebCool", this.getWebCooldown());
        pCompound.m_128405_("ChargeCool", this.getChargeCooldown());
        pCompound.m_128405_("BackOffCool", this.getBackOffCooldown());
        pCompound.m_128405_("MultiLay", this.getMultiLay());
        pCompound.m_128379_("AutoMode", this.isAutonomous());
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("SummonCool")) {
            this.setSummonCooldown(pCompound.m_128451_("SummonCool"));
        }
        if (pCompound.m_128441_("WebCool")) {
            this.setWebCooldown(pCompound.m_128451_("WebCool"));
        }
        if (pCompound.m_128441_("ChargeCool")) {
            this.setChargeCooldown(pCompound.m_128451_("ChargeCool"));
        }
        if (pCompound.m_128441_("BackOffCool")) {
            this.setBackOffCooldown(pCompound.m_128451_("BackOffCool"));
        }
        if (pCompound.m_128441_("MultiLay")) {
            this.setMultiLay(pCompound.m_128451_("MultiLay"));
        }
        if (pCompound.m_128441_("AutoMode")) {
            this.setAutonomous(pCompound.m_128471_("AutoMode"));
        }
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    @Override
    public Predicate<Entity> summonPredicate() {
        return entity -> entity instanceof AbstractBroodMother;
    }

    @Override
    public int getSummonLimit(LivingEntity owner) {
        return (Integer)SpellConfig.BroodMotherLimit.get();
    }

    @Override
    public int xpReward() {
        return 20;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12432_;
    }

    protected SoundEvent m_7975_(DamageSource p_33814_) {
        return SoundEvents.f_12434_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12433_;
    }

    protected void m_7355_(BlockPos p_33804_, BlockState p_33805_) {
        this.m_5496_(SoundEvents.f_12435_, 0.15f, 1.0f);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, ATTACK)) {
            return 1;
        }
        if (Objects.equals(animation, SHOOT)) {
            return 2;
        }
        if (Objects.equals(animation, LAY_EGGS)) {
            return 3;
        }
        if (Objects.equals(animation, CHARGE)) {
            return 4;
        }
        if (Objects.equals(animation, BACK_OFF)) {
            return 5;
        }
        if (Objects.equals(animation, JUMP)) {
            return 6;
        }
        if (Objects.equals(animation, DEATH)) {
            return 7;
        }
        return 0;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public void stopAllAnimation() {
        for (AnimationState state : this.getAnimations()) {
            state.m_216973_();
        }
    }

    public int getCurrentAnimation() {
        return (Integer)this.f_19804_.m_135370_(ANIM_STATE);
    }

    public List<AnimationState> getAnimations() {
        ArrayList<AnimationState> animationStates = new ArrayList<AnimationState>();
        animationStates.add(this.attackAnimationState);
        animationStates.add(this.shootAnimationState);
        animationStates.add(this.layEggsAnimationState);
        animationStates.add(this.chargeAnimationState);
        animationStates.add(this.backOffAnimationState);
        animationStates.add(this.jumpAnimationState);
        animationStates.add(this.deathAnimationState);
        return animationStates;
    }

    @Override
    public void setAutonomous(boolean autonomous) {
        this.f_19804_.m_135381_(AUTO_MODE, (Object)autonomous);
        if (autonomous) {
            this.m_216990_(SoundEvents.f_11686_);
            if (!this.isWandering()) {
                this.setWandering(true);
                this.setStaying(false);
            }
        }
    }

    @Override
    public boolean isAutonomous() {
        return (Boolean)this.f_19804_.m_135370_(AUTO_MODE);
    }

    @Nullable
    public LivingEntity m_6688_() {
        if (!this.m_21525_()) {
            Entity entity = this.m_146895_();
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                if (((Boolean)MobsConfig.ServantRideAutonomous.get()).booleanValue()) {
                    return null;
                }
                return mob;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (this.notClientAttacking() && !this.isAutonomous()) {
                    return livingEntity;
                }
            }
        }
        return null;
    }

    public boolean m_6109_() {
        return this.m_21515_();
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    @Override
    public boolean m_7301_(MobEffectInstance instance) {
        if (instance.m_19544_() == GoetyEffects.ACID_VENOM.get() || instance.m_19544_() == MobEffects.f_19614_) {
            MobEffectEvent.Applicable event = new MobEffectEvent.Applicable((LivingEntity)this, instance);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.getResult() == Event.Result.ALLOW;
        }
        return super.m_7301_(instance);
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_20160_() && source.m_7639_() != null && this.m_146895_() != null && source.m_7639_() == this.m_146895_() && MobUtil.areAllies((Entity)this, this.m_146895_())) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    protected void m_6153_() {
        ++this.deathTime;
        if (this.deathTime >= 30) {
            this.m_21373_();
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        if (!this.m_20197_().isEmpty()) {
            this.m_20197_().forEach(Entity::m_8127_);
        }
        this.f_20916_ = 1;
    }

    @Override
    public void m_6667_(DamageSource p_21014_) {
        this.setAnimationState(DEATH);
        super.m_6667_(p_21014_);
    }

    @Override
    public boolean isStaying() {
        IServant servant;
        LivingEntity livingEntity;
        return super.isStaying() || (livingEntity = this.m_6688_()) instanceof IServant && (servant = (IServant)livingEntity).isStaying();
    }

    public int getAttackType() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_TYPE);
    }

    public void setAttackType(int attackType) {
        this.f_19804_.m_135381_(ATTACK_TYPE, (Object)attackType);
    }

    public int getAttackTicks() {
        return this.attackTicks;
    }

    public void setAttackTicks(int attackTicks) {
        this.attackTicks = attackTicks;
    }

    public void setSummonCooldown(int summonCooldown) {
        this.summonCooldown = summonCooldown;
    }

    public int getSummonCooldown() {
        return this.summonCooldown;
    }

    public void setWebCooldown(int webCooldown) {
        this.webCooldown = webCooldown;
    }

    public int getWebCooldown() {
        return this.webCooldown;
    }

    public void setChargeCooldown(int chargeCooldown) {
        this.chargeCooldown = chargeCooldown;
    }

    public int getChargeCooldown() {
        return this.chargeCooldown;
    }

    public void setBackOffCooldown(int backOffCooldown) {
        this.backOffCooldown = backOffCooldown;
    }

    public int getBackOffCooldown() {
        return this.backOffCooldown;
    }

    public void setMultiLay(int multiLay) {
        this.multiLay = multiLay;
    }

    public int getMultiLay() {
        return this.multiLay;
    }

    public boolean isMeleeAttacking() {
        return this.meleeTicks > 0;
    }

    public float m_6100_() {
        return 0.5f;
    }

    @Override
    public void m_8119_() {
        AttributeInstance modifiableattributeinstance;
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            this.setClimbing(this.f_19862_);
            modifiableattributeinstance = this.m_21051_(Attributes.f_22277_);
            if (MobUtil.isInBrightLight((LivingEntity)this)) {
                if (modifiableattributeinstance != null && this.m_21051_(Attributes.f_22277_) != null) {
                    modifiableattributeinstance.m_22130_(DETECTION_MODIFIER);
                    modifiableattributeinstance.m_22118_(DETECTION_MODIFIER);
                }
            } else if (modifiableattributeinstance != null && modifiableattributeinstance.m_22109_(DETECTION_MODIFIER)) {
                modifiableattributeinstance.m_22130_(DETECTION_MODIFIER);
            }
        }
        if (this.summonCooldown > 0) {
            --this.summonCooldown;
        }
        if (this.webCooldown > 0) {
            --this.webCooldown;
        }
        if (this.chargeCooldown > 0) {
            --this.chargeCooldown;
        }
        if (this.backOffCooldown > 0) {
            --this.backOffCooldown;
        }
        if (this.meleeTicks > 0) {
            --this.meleeTicks;
        } else if (this.getCurrentAnimation() == this.getAnimationState(ATTACK)) {
            this.setAnimationState(0);
        }
        if (this.jumpTicks > 0) {
            --this.jumpTicks;
        } else if (this.getCurrentAnimation() == this.getAnimationState(JUMP)) {
            this.setAnimationState(0);
        }
        if (this.getAttackType() > 0) {
            ++this.attackTicks;
            if (!this.f_19853_.f_46443_) {
                this.f_19853_.m_7605_((Entity)this, (byte)4);
            }
        } else if (!this.f_19853_.f_46443_) {
            this.f_19853_.m_7605_((Entity)this, (byte)5);
        }
        if ((modifiableattributeinstance = this.m_21051_(Attributes.f_22279_)) != null) {
            if (this.getAttackType() > 0 || this.isMeleeAttacking()) {
                modifiableattributeinstance.m_22130_(SPEED_STOP);
                modifiableattributeinstance.m_22118_(SPEED_STOP);
            } else if (modifiableattributeinstance.m_22109_(SPEED_STOP)) {
                modifiableattributeinstance.m_22130_(SPEED_STOP);
            }
        }
        if (this.getAttackType() != 0) {
            this.m_21573_().m_26573_();
            this.m_21566_().m_24988_(0.0f, 0.0f);
        }
        if (this.f_19796_.m_188503_(200) == 0) {
            this.circleDirection = !this.circleDirection;
        }
        this.circleTick += this.circleDirection ? 1 : -1;
        if (this.m_5448_() != null) {
            Predicate<Entity> predicate = entity -> {
                Spider spider;
                SpiderServant spiderServant;
                return entity.m_6084_() && (entity instanceof SpiderServant && (spiderServant = (SpiderServant)entity).getTrueOwner() == this || entity instanceof Spider && (spider = (Spider)entity).m_5448_() != null && spider.m_5448_() == this.m_5448_() && this.isHostile());
            };
            int i = this.f_19853_.m_6443_(LivingEntity.class, this.m_5448_().m_20191_().m_82400_(8.0), predicate).size();
            if (this.getAttackType() == 0 && i > 0 && (double)this.m_5448_().m_20270_((Entity)this) >= 4.0) {
                this.isCircling = true;
                this.circleTarget((Entity)this.m_5448_(), this.circleTick);
                MobUtil.instaLook((Mob)this, (Entity)this.m_5448_());
            } else {
                this.isCircling = false;
            }
        } else {
            this.isCircling = false;
        }
        this.attackAI();
    }

    public void attackAI() {
        if (this.m_6084_() && !this.f_19853_.f_46443_) {
            double z;
            double y;
            double x;
            double power;
            Level level;
            if (this.getAttackType() == WEB_ATTACK && this.getAttackTicks() == 7 && this.m_5448_() != null) {
                for (int i = 0; i < 8; ++i) {
                    this.m_6504_(this.m_5448_(), 1.0f);
                }
                this.m_5496_((SoundEvent)ModSounds.SPIDER_SPIT.get(), 1.0f, 0.4f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
            }
            if (this.getAttackType() == LAY_EGG_ATTACK && this.getAttackTicks() == 10 && (level = this.f_19853_) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                SpiderEgg spiderEgg = new SpiderEgg((EntityType<? extends Owned>)((EntityType)ModEntityType.SPIDER_EGG.get()), (Level)serverLevel);
                BlockPos blockPos = BlockFinder.SummonRadius(this.m_20183_(), (Entity)spiderEgg, (Level)serverLevel, 1);
                spiderEgg.setTrueOwner((LivingEntity)this);
                spiderEgg.m_20035_(blockPos, this.m_146908_(), this.m_146909_());
                spiderEgg.m_21530_();
                spiderEgg.setLimitedLife(MathHelper.secondsToTicks(3 + serverLevel.m_213780_().m_188503_(3)));
                spiderEgg.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(blockPos), MobSpawnType.MOB_SUMMONED, null, null);
                if (serverLevel.m_7967_((Entity)spiderEgg)) {
                    spiderEgg.m_216990_((SoundEvent)ModSounds.SPIDER_NEST_START.get());
                }
            }
            if (this.getAttackType() == CHARGE_ATTACK) {
                Vec3 vector3d = this.m_20252_(1.0f);
                double distance0 = Math.sqrt(vector3d.f_82479_ * vector3d.f_82479_ + vector3d.f_82480_ * vector3d.f_82480_ + vector3d.f_82481_ * vector3d.f_82481_);
                power = 10.0;
                x = vector3d.f_82479_ / distance0 * power * 0.2;
                y = vector3d.f_82480_ / distance0 * power * 0.06;
                z = vector3d.f_82481_ / distance0 * power * 0.2;
                if (this.getAttackTicks() == 8) {
                    this.m_5496_(SoundEvents.f_12316_, 2.0f, 0.75f);
                    this.m_20334_(x, y > 0.0 ? y + 0.2 : 0.2, z);
                }
                if (this.getAttackTicks() >= 10) {
                    this.areaAttack();
                }
            }
            if (this.getAttackType() == BACK_OFF_ATTACK) {
                Vec3 vector3d = this.m_20252_(1.0f);
                double distance0 = Math.sqrt(vector3d.f_82479_ * vector3d.f_82479_ + vector3d.f_82480_ * vector3d.f_82480_ + vector3d.f_82481_ * vector3d.f_82481_);
                power = 10.0;
                x = -(vector3d.f_82479_ / distance0 * power * 0.2);
                y = -(vector3d.f_82480_ / distance0 * power * 0.06);
                z = -(vector3d.f_82481_ / distance0 * power * 0.2);
                if (this.m_5448_() != null) {
                    double deltaX = this.m_20185_() - this.m_5448_().m_20185_();
                    double deltaY = this.m_20186_() - (this.m_5448_().m_20186_() + 1.5);
                    double deltaZ = this.m_20189_() - this.m_5448_().m_20189_();
                    double distance = Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
                    x = deltaX / distance * power * 0.2;
                    y = -(deltaY / distance * power * 0.06);
                    z = deltaZ / distance * power * 0.2;
                }
                if (this.getAttackTicks() == 8) {
                    this.m_5496_(SoundEvents.f_12316_, 2.0f, 0.75f);
                    this.m_20334_(x, y > 0.0 ? y + 0.2 : 0.2, z);
                }
                if (this.getAttackTicks() >= 10) {
                    this.areaAttack();
                }
            }
        }
    }

    public void areaAttack() {
        for (LivingEntity livingEntity : this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_().m_82400_(16.0), living -> !MobUtil.areAllies((Entity)living, (Entity)this) && living.m_6084_())) {
            double xPower = this.m_20185_() - livingEntity.m_20185_();
            double yPower = this.m_20186_() - livingEntity.m_20186_();
            double zPower = this.m_20189_() - livingEntity.m_20189_();
            double distance = Math.sqrt(xPower * xPower + yPower * yPower + zPower * zPower);
            if (!(this.m_20280_((Entity)livingEntity) < 9.0) || !livingEntity.m_6469_(this.getServantAttack(), (float)this.m_21133_(Attributes.f_22281_))) continue;
            this.m_5496_(SoundEvents.f_12314_, 1.0f, 1.0f);
            livingEntity.f_19864_ = true;
            if (livingEntity.m_21023_((MobEffect)GoetyEffects.TANGLED.get())) continue;
            MobUtil.push((Entity)livingEntity, -xPower / distance * 2.0, -yPower / distance * 2.0 + 0.5, -zPower / distance * 2.0);
        }
    }

    private void circleTarget(Entity target, int circleFrame) {
        double t = (double)circleFrame * 0.5 * 0.8 / 10.0;
        Vec3 movePos = target.m_20182_().m_82520_(10.0 * Math.cos(t), 0.0, 10.0 * Math.sin(t));
        this.m_21573_().m_26519_(movePos.m_7096_(), movePos.m_7098_(), movePos.m_7094_(), 1.0);
    }

    @Override
    public void tryKill(Player player) {
        if (this.killChance <= 0) {
            this.warnKill(player);
        } else {
            this.m_6469_(this.m_269291_().m_269064_(), Float.MAX_VALUE);
        }
    }

    public boolean m_6147_() {
        return this.isClimbing();
    }

    public boolean isClimbing() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setClimbing(boolean p_33820_) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        b0 = p_33820_ ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)b0);
    }

    public void m_7601_(BlockState p_33796_, Vec3 p_33797_) {
        if (!p_33796_.m_60713_(Blocks.f_50033_) && !p_33796_.m_60713_(Blocks.f_50016_)) {
            super.m_7601_(p_33796_, p_33797_);
        }
    }

    public void m_6674_(InteractionHand p_21007_) {
        this.meleeTicks = 10;
        this.setAnimationState(ATTACK);
        super.m_6674_(p_21007_);
    }

    @Override
    public boolean m_7327_(Entity target) {
        if (super.m_7327_(target)) {
            if (target instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)target;
                int i = 15;
                if (this.f_19853_.m_46791_() == Difficulty.HARD) {
                    i = 30;
                }
                livingEntity.m_147207_(new MobEffectInstance((MobEffect)GoetyEffects.ACID_VENOM.get(), i * 20, 0), (Entity)this);
            }
            this.m_5496_((SoundEvent)ModSounds.SPIDER_BITE.get(), this.m_6121_(), this.m_6100_() + 0.25f);
            return true;
        }
        return false;
    }

    public double m_262813_() {
        return 0.5;
    }

    protected void doPlayerRide(Player player) {
        if (!this.f_19853_.f_46443_) {
            player.m_146922_(this.m_146908_());
            player.m_146926_(this.m_146909_());
            player.m_20329_((Entity)this);
        }
    }

    protected float m_245547_(Player p_278241_) {
        float f = p_278241_.m_20142_() ? 0.1f : 0.0f;
        return (float)this.m_21133_(Attributes.f_22279_) + f;
    }

    protected Vec3 m_274312_(Player p_278278_, Vec3 p_275506_) {
        if (this.m_20096_() && this.playerJumpPendingScale == 0.0f) {
            return Vec3.f_82478_;
        }
        float f = p_278278_.f_20900_ * 0.5f;
        float f1 = p_278278_.f_20902_;
        if (f1 <= 0.0f) {
            f1 *= 0.25f;
        }
        return new Vec3((double)f, 0.0, (double)f1);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void m_7023_(@NotNull Vec3 pTravelVector) {
        if (!this.m_6084_()) return;
        LivingEntity rider = this.m_6688_();
        if (this.m_20160_() && this.notClientAttacking() && rider instanceof Player) {
            Player player = (Player)rider;
            if (!this.isAutonomous()) {
                this.m_146922_(rider.m_146908_());
                this.f_19859_ = this.m_146908_();
                this.m_146926_(rider.m_146909_() * 0.5f);
                this.m_19915_(this.m_146908_(), this.m_146909_());
                this.f_20885_ = this.f_20883_ = this.m_146908_();
                float speed = this.m_245547_(player);
                float f = rider.f_20900_ * speed;
                float f1 = rider.f_20902_ * speed;
                if (f1 <= 0.0f) {
                    f1 *= 0.25f;
                }
                if (this.m_6336_() != MobType.f_21641_ && (this.m_20069_() && this.getFluidTypeHeight((FluidType)ForgeMod.WATER_TYPE.get()) > this.m_20204_() || this.m_20077_() || this.isInFluidType((fluidType, height) -> this.canSwimInFluidType((FluidType)fluidType) && height > this.m_20204_()))) {
                    Vec3 vector3d = this.m_20184_();
                    this.m_20334_(vector3d.f_82479_, 0.04f, vector3d.f_82481_);
                    this.f_19812_ = true;
                    if (f1 > 0.0f) {
                        float f2 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                        float f3 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                        this.m_20256_(this.m_20184_().m_82520_((double)(-0.4f * f2 * 0.04f), 0.0, (double)(0.4f * f3 * 0.04f)));
                    }
                }
                this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
                super.m_7023_(new Vec3((double)f, pTravelVector.f_82480_, (double)f1));
                this.f_20903_ = 0;
                this.m_267651_(false);
                return;
            }
        }
        super.m_7023_(pTravelVector);
    }

    public boolean m_20329_(Entity p_20330_) {
        return false;
    }

    @Override
    public boolean m_21532_() {
        return true;
    }

    public double m_6048_() {
        return 1.9;
    }

    @Override
    public boolean canUpdateMove() {
        return !(this.m_6688_() instanceof Mob);
    }

    public boolean isJumping() {
        return this.isJumping;
    }

    public void setIsJumping(boolean jumping) {
        this.isJumping = jumping;
    }

    public boolean m_7132_() {
        return this.notClientAttacking();
    }

    protected void m_274498_(Player p_278233_, Vec3 p_275693_) {
        super.m_274498_(p_278233_, p_275693_);
        if (p_278233_.m_7578_() && this.m_20096_()) {
            this.setIsJumping(false);
            if (this.playerJumpPendingScale > 0.0f && !this.isJumping()) {
                if (!this.m_20067_()) {
                    this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12316_, this.m_5720_(), 2.0f, 0.75f, false);
                }
                this.executeRidersJump(this.playerJumpPendingScale, p_275693_);
            }
            this.playerJumpPendingScale = 0.0f;
        }
    }

    protected void executeRidersJump(float p_248808_, Vec3 p_275435_) {
        double d0 = 1.0 * (double)p_248808_ * (double)this.m_20098_();
        double d1 = d0 + (double)this.m_285755_();
        Vec3 vec3 = this.m_20184_();
        this.m_20334_(vec3.f_82479_, d1, vec3.f_82481_);
        ModNetwork.sendToServer(new CSetDeltaMovement(this.m_19879_(), vec3.f_82479_, d1, vec3.f_82481_));
        this.setIsJumping(true);
        this.f_19812_ = true;
        ForgeHooks.onLivingJump((LivingEntity)this);
        this.setAnimationState(JUMP);
        this.jumpTicks = 10;
        if (p_275435_.f_82481_ > 0.0) {
            float f = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            float f1 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            Vec3 vec31 = this.m_20184_().m_82520_((double)(-0.4f * f * p_248808_), 0.0, (double)(0.4f * f1 * p_248808_));
            this.m_20256_(vec31);
            ModNetwork.sendToServer(new CSetDeltaMovement(this.m_19879_(), vec31.f_82479_, vec31.f_82480_, vec31.f_82481_));
        }
    }

    public void m_7888_(int p_21696_) {
        if (p_21696_ < 0) {
            p_21696_ = 0;
        }
        this.playerJumpPendingScale = p_21696_ >= 90 ? 1.0f : 0.4f + 0.4f * (float)p_21696_ / 90.0f;
    }

    public void m_7199_(int p_21695_) {
    }

    public void m_8012_() {
    }

    public boolean notClientAttacking() {
        return !this.clientAttacking;
    }

    public void m_7822_(byte pId) {
        if (pId == 4) {
            this.clientAttacking = true;
        } else if (pId == 5) {
            this.clientAttacking = false;
        } else {
            super.m_7822_(pId);
        }
    }

    public void m_6504_(LivingEntity p_33317_, float p_33318_) {
        WebShot webShot = new WebShot((LivingEntity)this, this.f_19853_);
        webShot.m_146884_(webShot.m_20182_().m_82520_(0.0, 1.0, 0.0));
        Vec3 vec3 = p_33317_.m_20184_();
        double d0 = p_33317_.m_20185_() + vec3.f_82479_ - this.m_20185_();
        double d1 = p_33317_.m_20188_() - (double)1.1f - this.m_20186_();
        double d2 = p_33317_.m_20189_() + vec3.f_82481_ - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        webShot.m_146926_(webShot.m_146909_() - -20.0f);
        webShot.m_6686_(d0, d1 + d3 * 0.2, d2, 0.75f, 30.0f);
        this.f_19853_.m_7967_((Entity)webShot);
    }

    public boolean isFood(ItemStack p_30440_) {
        Item item = p_30440_.m_41720_();
        return item.m_41472_() && p_30440_.getFoodProperties((LivingEntity)this).m_38746_();
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (pPlayer == this.getTrueOwner()) {
            if (this.isFood(itemstack) && this.m_21223_() < this.m_21233_()) {
                FoodProperties foodProperties = itemstack.getFoodProperties((LivingEntity)this);
                if (foodProperties != null) {
                    this.m_5634_(foodProperties.m_38744_());
                    if (!pPlayer.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    this.m_146852_(GameEvent.f_157806_, (Entity)this);
                    this.m_5584_(this.f_19853_, itemstack);
                    Level level = this.f_19853_;
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        for (int i = 0; i < 7; ++i) {
                            double d0 = this.f_19796_.m_188583_() * 0.02;
                            double d1 = this.f_19796_.m_188583_() * 0.02;
                            double d2 = this.f_19796_.m_188583_() * 0.02;
                            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.HEAL_EFFECT.get()), this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                        }
                    }
                    pPlayer.m_6674_(pHand);
                    return InteractionResult.SUCCESS;
                }
            } else if (!pPlayer.m_6047_()) {
                if (this.m_146895_() != null && this.m_146895_() != pPlayer) {
                    this.m_146895_().m_8127_();
                    return InteractionResult.SUCCESS;
                }
                if (!(pPlayer.m_21120_(pHand).m_41720_() instanceof IWand)) {
                    this.doPlayerRide(pPlayer);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public class WebGoal
    extends BroodMotherGoal {
        public boolean m_8036_() {
            return AbstractBroodMother.this.f_19796_.m_188503_(16) == 0 && AbstractBroodMother.this.m_5448_() != null && AbstractBroodMother.this.m_5448_().m_20270_((Entity)AbstractBroodMother.this) <= 16.0f && AbstractBroodMother.this.m_142582_((Entity)AbstractBroodMother.this.m_5448_()) && AbstractBroodMother.this.getWebCooldown() < 1;
        }

        public boolean m_8045_() {
            if (AbstractBroodMother.this.getAttackTicks() <= 20) {
                return AbstractBroodMother.this.getAttackType() == WEB_ATTACK;
            }
            return false;
        }

        public void m_8056_() {
            AbstractBroodMother.this.setAnimationState(SHOOT);
            AbstractBroodMother.this.m_5496_((SoundEvent)ModSounds.SPIDER_CALL.get(), AbstractBroodMother.this.m_6121_(), AbstractBroodMother.this.m_6100_());
            AbstractBroodMother.this.setAttackType(WEB_ATTACK);
        }

        public void m_8037_() {
            AbstractBroodMother.this.m_21573_().m_26573_();
            AbstractBroodMother.this.m_21566_().m_24988_(0.0f, 0.0f);
            if (AbstractBroodMother.this.m_5448_() != null) {
                AbstractBroodMother.this.m_21563_().m_24960_((Entity)AbstractBroodMother.this.m_5448_(), 100.0f, 100.0f);
            }
        }

        public void m_8041_() {
            AbstractBroodMother.this.setAnimationState(0);
            AbstractBroodMother.this.setAttackTicks(0);
            AbstractBroodMother.this.setAttackType(0);
            AbstractBroodMother.this.setWebCooldown(200);
        }
    }

    public class ChargeGoal
    extends BroodMotherGoal {
        public boolean m_8036_() {
            return AbstractBroodMother.this.m_5448_() != null && AbstractBroodMother.this.getChargeCooldown() <= 0 && !AbstractBroodMother.this.isStaying() && AbstractBroodMother.this.m_142582_((Entity)AbstractBroodMother.this.m_5448_()) && AbstractBroodMother.this.m_5448_().m_21023_((MobEffect)GoetyEffects.TANGLED.get());
        }

        public boolean m_8045_() {
            if (AbstractBroodMother.this.getAttackTicks() <= 25 || !AbstractBroodMother.this.m_20096_() && AbstractBroodMother.this.getAttackTicks() <= 30) {
                return AbstractBroodMother.this.getAttackType() == CHARGE_ATTACK;
            }
            return false;
        }

        public void m_8056_() {
            AbstractBroodMother.this.setAnimationState(CHARGE);
            AbstractBroodMother.this.setAttackType(CHARGE_ATTACK);
        }

        public void m_8037_() {
            AbstractBroodMother.this.m_21573_().m_26573_();
            AbstractBroodMother.this.m_21566_().m_24988_(0.0f, 0.0f);
        }

        public void m_8041_() {
            AbstractBroodMother.this.setAnimationState(0);
            AbstractBroodMother.this.setAttackTicks(0);
            AbstractBroodMother.this.setAttackType(0);
            AbstractBroodMother.this.setChargeCooldown(100);
        }
    }

    public class BackOffGoal
    extends BroodMotherGoal {
        public boolean m_8036_() {
            return AbstractBroodMother.this.m_5448_() != null && AbstractBroodMother.this.m_217043_().m_188503_(16) == 0 && AbstractBroodMother.this.getBackOffCooldown() <= 0 && !AbstractBroodMother.this.isStaying() && AbstractBroodMother.this.m_5448_().m_20270_((Entity)AbstractBroodMother.this) <= 10.0f;
        }

        public boolean m_8045_() {
            if (AbstractBroodMother.this.getAttackTicks() <= 25 || !AbstractBroodMother.this.m_20096_() && AbstractBroodMother.this.getAttackTicks() <= 30) {
                return AbstractBroodMother.this.getAttackType() == BACK_OFF_ATTACK;
            }
            return false;
        }

        public void m_8056_() {
            AbstractBroodMother.this.setAnimationState(BACK_OFF);
            AbstractBroodMother.this.setAttackType(BACK_OFF_ATTACK);
        }

        public void m_8037_() {
            AbstractBroodMother.this.m_21573_().m_26573_();
            AbstractBroodMother.this.m_21566_().m_24988_(0.0f, 0.0f);
        }

        public void m_8041_() {
            AbstractBroodMother.this.setAnimationState(0);
            AbstractBroodMother.this.setAttackTicks(0);
            AbstractBroodMother.this.setAttackType(0);
            AbstractBroodMother.this.setBackOffCooldown(100);
        }
    }

    public class SummonSpiders
    extends BroodMotherGoal {
        public boolean m_8036_() {
            Predicate<Entity> predicate = entity -> {
                SpiderServant spiderServant;
                return entity.m_6084_() && entity instanceof SpiderServant && (spiderServant = (SpiderServant)entity).getTrueOwner() instanceof AbstractBroodMother;
            };
            int i = AbstractBroodMother.this.f_19853_.m_6443_(LivingEntity.class, AbstractBroodMother.this.m_20191_().m_82377_(32.0, 16.0, 32.0), predicate).size();
            return i < 4 && AbstractBroodMother.this.getSummonCooldown() <= 0 && AbstractBroodMother.this.m_5448_() != null && ((double)AbstractBroodMother.this.m_5448_().m_20270_((Entity)AbstractBroodMother.this) > 10.0 || AbstractBroodMother.this.getMultiLay() > 0);
        }

        public boolean m_8045_() {
            if (AbstractBroodMother.this.getAttackTicks() <= 20) {
                return AbstractBroodMother.this.getAttackType() == LAY_EGG_ATTACK;
            }
            return false;
        }

        public void m_8056_() {
            AbstractBroodMother.this.setAnimationState(LAY_EGGS);
            AbstractBroodMother.this.setAttackType(LAY_EGG_ATTACK);
            if (AbstractBroodMother.this.getMultiLay() <= 0 && MobUtil.healthIsHalved((LivingEntity)AbstractBroodMother.this) && AbstractBroodMother.this.m_217043_().m_188499_()) {
                AbstractBroodMother.this.setMultiLay(3);
            }
        }

        public void m_8037_() {
            AbstractBroodMother.this.m_21573_().m_26573_();
            AbstractBroodMother.this.m_21566_().m_24988_(0.0f, 0.0f);
            if (AbstractBroodMother.this.m_5448_() != null) {
                AbstractBroodMother.this.m_21563_().m_24960_((Entity)AbstractBroodMother.this.m_5448_(), 100.0f, 100.0f);
            }
        }

        public void m_8041_() {
            AbstractBroodMother.this.setAnimationState(0);
            AbstractBroodMother.this.setAttackTicks(0);
            AbstractBroodMother.this.setAttackType(0);
            if (AbstractBroodMother.this.getMultiLay() > 1) {
                AbstractBroodMother.this.setSummonCooldown(MathHelper.secondsToTicks(1));
                AbstractBroodMother.this.setMultiLay(AbstractBroodMother.this.getMultiLay() - 1);
            } else {
                AbstractBroodMother.this.setSummonCooldown(MathHelper.secondsToTicks(7));
                AbstractBroodMother.this.setMultiLay(0);
            }
        }
    }

    public static abstract class BroodMotherGoal
    extends Goal {
        public BroodMotherGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_183429_() {
            return true;
        }
    }
}

