/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.hostile.cultists;

import com.Polarice3.Goety.api.entities.ICustomAttributes;
import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.common.entities.ai.StrollAroundLeaderGoal;
import com.Polarice3.Goety.utils.EntityFinder;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;

public class Cultist
extends Raider
implements ICustomAttributes {
    protected static final EntityDataAccessor<Optional<UUID>> LEADER_UUID = SynchedEntityData.m_135353_(Cultist.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);

    protected Cultist(EntityType<? extends Cultist> type, Level worldIn) {
        super(type, worldIn);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 16.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
        this.m_21573_().m_7008_(true);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.extraGoal();
        this.f_21345_.m_25352_(8, (Goal)new StrollAroundLeaderGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Cultist.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Witch.class}).m_26044_(new Class[0]));
    }

    public void extraGoal() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
    }

    @Override
    public void setConfigurableAttributes() {
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LEADER_UUID, Optional.empty());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("LeaderUUID")) {
            this.setLeaderID(compound.m_128342_("LeaderUUID"));
        }
        this.setConfigurableAttributes();
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.getLeaderID() != null) {
            compound.m_128362_("LeaderUUID", this.getLeaderID());
        }
    }

    public UUID getLeaderID() {
        return ((Optional)this.f_19804_.m_135370_(LEADER_UUID)).orElse(null);
    }

    public void setLeaderID(UUID uuid) {
        this.f_19804_.m_135381_(LEADER_UUID, Optional.ofNullable(uuid));
    }

    @Nullable
    public Entity getLeader() {
        UUID uuid = this.getLeaderID();
        return uuid == null ? null : EntityFinder.getLivingEntityByUuiD(uuid);
    }

    public void setLeader(@Nullable Entity entity) {
        if (entity != null) {
            this.setLeaderID(entity.m_20148_());
        }
    }

    public boolean isBarterable() {
        return true;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        this.alertWitches();
        return super.m_6469_(pSource, pAmount);
    }

    protected void alertWitches() {
        double d0 = this.m_21133_(Attributes.f_22277_);
        AABB axisalignedbb = AABB.m_82333_((Vec3)this.m_20182_()).m_82377_(d0, 10.0, d0);
        List list = this.f_19853_.m_45976_(Mob.class, axisalignedbb);
        for (Mob mob : list) {
            if (mob.m_5448_() != null || this.m_21188_() == null || this.m_21188_() instanceof Raider || MobUtil.areAllies((Entity)this.m_21188_(), (Entity)this) || !(mob instanceof Witch) && !(mob instanceof Cultist) || mob.m_6095_().m_204039_(Tags.EntityTypes.BOSSES) || !EntitySelector.f_20406_.test(this.m_21188_())) continue;
            mob.m_6710_(this.m_21188_());
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_ && this.getLeader() != null) {
            if (!this.getLeader().m_6084_()) {
                this.setLeader(null);
            } else {
                LivingEntity livingEntity;
                Entity entity;
                Vec3 vec3 = this.getLeader().m_20182_();
                if (this.m_5448_() != null && this.m_5448_().m_20238_(vec3) > (double)Mth.m_144944_((int)32)) {
                    this.m_6710_(null);
                    this.m_21573_().m_5624_(this.getLeader(), 1.0);
                }
                if ((entity = this.getLeader()) instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_21188_() != null && !MobUtil.areAllies((Entity)livingEntity.m_21188_(), (Entity)this) && EntitySelector.f_20406_.test(livingEntity.m_21188_())) {
                    this.m_6710_(livingEntity.m_21188_());
                }
            }
        }
    }

    public CultistArmPose getArmPose() {
        return CultistArmPose.CROSSED;
    }

    public void m_7895_(int wave, boolean p_213660_2_) {
    }

    public SoundEvent m_7930_() {
        return SoundEvents.f_11863_;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 1.62f;
    }

    public boolean m_7490_() {
        return false;
    }

    public boolean m_7307_(Entity entityIn) {
        if (super.m_7307_(entityIn)) {
            return true;
        }
        if (entityIn instanceof Witch) {
            return this.m_5647_() == null && entityIn.m_5647_() == null;
        }
        if (entityIn instanceof Cultist) {
            return this.m_5647_() == null && entityIn.m_5647_() == null;
        }
        if (entityIn instanceof AbstractPiglin) {
            return this.m_5647_() == null && entityIn.m_5647_() == null;
        }
        return entityIn instanceof IOwned && ((IOwned)entityIn).getTrueOwner() instanceof Cultist;
    }

    public static enum CultistArmPose {
        CROSSED,
        ATTACKING,
        SPELLCASTING,
        PRAYING,
        SPELL_AND_WEAPON,
        BOW_AND_ARROW,
        TORCH_AND_WEAPON,
        CROSSBOW_HOLD,
        CROSSBOW_CHARGE,
        BOMB_AND_WEAPON,
        THROW_SPEAR,
        ITEM,
        DYING,
        NEUTRAL;

    }
}

