/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.hostile;

import com.Polarice3.Goety.api.entities.ICustomAttributes;
import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.blocks.entities.PithosBlockEntity;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.hostile.BoneLord;
import com.Polarice3.Goety.common.entities.projectiles.HauntedSkullProjectile;
import com.Polarice3.Goety.common.magic.spells.ShockwaveSpell;
import com.Polarice3.Goety.common.magic.spells.storm.ElectroOrbSpell;
import com.Polarice3.Goety.common.network.ModServerBossInfo;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.config.MainConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.EntityFinder;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import com.Polarice3.Goety.utils.SoundUtil;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.AngerLevel;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SkullLord
extends Monster
implements ICustomAttributes {
    protected static final EntityDataAccessor<Byte> FLAGS = SynchedEntityData.m_135353_(SkullLord.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Optional<UUID>> BONE_LORD = SynchedEntityData.m_135353_(SkullLord.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    protected static final EntityDataAccessor<Integer> BONE_LORD_CLIENT_ID = SynchedEntityData.m_135353_(SkullLord.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final ModServerBossInfo bossInfo = new ModServerBossInfo((Mob)this, BossEvent.BossBarColor.PURPLE, false, false);
    @Nullable
    private BlockPos boundOrigin;
    private int spawnDelay = 100;
    private int spawnNumber = 0;
    private int chargeTime = 0;
    private int shockWaveCool = 0;
    private int oldSwell;
    private int swell;
    public float explosionRadius = 2.0f;
    public int boneLordRegen;
    private int hitTimes;
    private int stuckTime = 0;

    public SkullLord(EntityType<? extends SkullLord> p_i50190_1_, Level p_i50190_2_) {
        super(p_i50190_1_, p_i50190_2_);
        this.f_21344_ = this.m_6037_(p_i50190_2_);
        this.f_21342_ = new MoveHelperController(this);
        this.hitTimes = 0;
        this.f_21364_ = 70;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(4, (Goal)new SoulSkullGoal());
        this.f_21345_.m_25352_(4, (Goal)new ChargeAttackGoal());
        this.f_21345_.m_25352_(4, (Goal)new ElectroOrbAttackGoal());
        this.f_21345_.m_25352_(4, (Goal)new ShockwaveAttackGoal());
        this.f_21345_.m_25352_(8, (Goal)new MoveRandomGoal());
        this.f_21345_.m_25352_(7, (Goal)new LookAroundGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.SkullLordDamage.get()).doubleValue()).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.SkullLordHealth.get()).doubleValue());
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.SkullLordHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.SkullLordDamage.get());
    }

    public void m_6478_(MoverType typeIn, Vec3 pos) {
        super.m_6478_(typeIn, pos);
        this.m_20101_();
    }

    protected PathNavigation m_6037_(Level worldIn) {
        FlyingPathNavigation flyingpathnavigator = new FlyingPathNavigation((Mob)this, worldIn);
        flyingpathnavigator.m_26440_(false);
        flyingpathnavigator.m_26443_(false);
        return flyingpathnavigator;
    }

    public BlockEntity getPithos() {
        if (this.getBoundOrigin() != null) {
            return this.f_19853_.m_7702_(this.getBoundOrigin());
        }
        return null;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.m_20147_()) {
            return false;
        }
        ++this.hitTimes;
        if (this.hitTimes > 3 || pAmount >= 20.0f) {
            pAmount /= 2.0f;
        }
        return super.m_6469_(pSource, pAmount);
    }

    public void m_6043_() {
        this.setIsDespawn(true);
        super.m_6043_();
    }

    public boolean m_5825_() {
        return this.m_20147_();
    }

    protected boolean m_6129_() {
        return false;
    }

    public void m_8119_() {
        BlockPos blockPos;
        super.m_8119_();
        if (this.f_19797_ % 5 == 0) {
            this.bossInfo.update();
        }
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
        this.m_20242_(true);
        int delay = switch (this.f_19853_.m_46791_()) {
            case Difficulty.NORMAL -> 300;
            case Difficulty.HARD -> 150;
            default -> 400;
        };
        Vec3 vector3d = this.m_20184_();
        double d0 = this.m_20185_() + vector3d.f_82479_;
        double d1 = this.m_20186_() + vector3d.f_82480_;
        double d2 = this.m_20189_() + vector3d.f_82481_;
        SimpleParticleType particleData = ParticleTypes.f_123762_;
        if (this.isSpawning()) {
            particleData = ParticleTypes.f_123744_;
        } else if (this.m_20147_()) {
            particleData = ParticleTypes.f_123759_;
        } else if (this.isShockWave()) {
            particleData = ParticleTypes.f_123745_;
        } else if (this.isElectroOrb()) {
            particleData = (ParticleOptions)ModParticleTypes.ELECTRIC.get();
        }
        this.f_19853_.m_7106_((ParticleOptions)particleData, d0 + this.f_19796_.m_188583_() * (double)0.3f, d1 + this.f_19796_.m_188583_() * (double)0.3f, d2 + this.f_19796_.m_188583_() * (double)0.3f, 0.0, 0.0, 0.0);
        if (this.m_20147_()) {
            int healFreq;
            switch (this.f_19853_.m_46791_()) {
                case NORMAL: {
                    int n = 40;
                    break;
                }
                case HARD: {
                    int n = 20;
                    break;
                }
                default: {
                    int n = healFreq = 60;
                }
            }
            if (this.f_19797_ % healFreq == 0) {
                this.m_5634_(1.0f);
            }
        }
        if (this.m_6060_() && (this.f_19797_ % 100 == 0 || this.m_20147_())) {
            this.m_20095_();
        }
        if (this.getPithos() != null && this.m_20275_((blockPos = this.getPithos().m_58899_()).m_123341_(), blockPos.m_123342_(), blockPos.m_123343_()) > 1024.0) {
            this.m_20035_(blockPos, 0.0f, 0.0f);
            if (this.getBoneLord() != null) {
                this.getBoneLord().m_20035_(blockPos, 0.0f, 0.0f);
            }
        }
        if (this.m_5448_() != null) {
            if (this.m_5448_().m_21224_() || this.m_5448_().m_213877_()) {
                this.m_6710_(null);
            }
        } else {
            Player player2;
            for (Player player2 : this.f_19853_.m_6443_(Player.class, this.m_20191_().m_82400_(4.0), EntitySelector.f_20406_)) {
                this.m_6710_((LivingEntity)player2);
            }
            if (this.getPithos() != null && (player2 = this.getPithos()) instanceof PithosBlockEntity) {
                PithosBlockEntity pithosTile = (PithosBlockEntity)player2;
                if (this.f_19797_ % 100 == 0 && this.f_19853_.m_46749_(pithosTile.m_58899_())) {
                    this.setIsDespawn(true);
                    pithosTile.lock();
                    if (this.getBoneLord() != null) {
                        this.getBoneLord().m_146870_();
                    }
                    this.m_146870_();
                }
            }
        }
        if (this.isShockWave()) {
            this.oldSwell = this.swell++;
        } else {
            this.oldSwell = 0;
            this.swell = 0;
        }
        if (!this.f_19853_.f_46443_) {
            int k;
            int j;
            ServerLevel serverWorld = (ServerLevel)this.f_19853_;
            int i = this.m_20183_().m_123341_();
            List list = this.f_19853_.m_6443_(LivingEntity.class, new AABB((double)i, (double)(j = this.m_20183_().m_123342_()), (double)(k = this.m_20183_().m_123343_()), (double)i, (double)(j - 4), (double)k).m_82377_(8.0, 8.0, 8.0), t -> {
                IOwned owned;
                return t instanceof IOwned && (owned = (IOwned)t).getTrueOwner() == this;
            });
            if (list.size() < 8 && this.m_5448_() != null && (this.isNotAbility() || this.isSpawning())) {
                int warn;
                int n = warn = this.isHalfHealth() ? 20 : 40;
                if (this.spawnDelay > 0) {
                    --this.spawnDelay;
                    if (this.spawnDelay == warn) {
                        this.m_216990_((SoundEvent)ModSounds.PREPARE_SUMMON.get());
                    }
                    if (this.spawnDelay <= warn) {
                        this.m_20256_(Vec3.f_82478_);
                        this.setSpawning(true);
                    } else {
                        this.setSpawning(false);
                    }
                } else {
                    this.spawnDelay = this.f_19853_.f_46441_.m_188503_(delay) + delay;
                    this.setSpawning(false);
                    this.spawnMobs();
                }
            }
            if (this.getBoneLord() == null || this.getBoneLord() != null && this.getBoneLord().m_21224_()) {
                BoneLord boneLord;
                --this.boneLordRegen;
                this.setIsInvulnerable(false);
                this.f_19853_.m_7605_((Entity)this, (byte)5);
                for (BoneLord boneLord2 : this.f_19853_.m_45976_(BoneLord.class, this.m_20191_().m_82400_(32.0))) {
                    if (boneLord2.getSkullLord() != this) continue;
                    this.setBoneLord(boneLord2);
                }
                if (this.boneLordRegen <= 0 && this.isNotAbility() && (boneLord = (BoneLord)((EntityType)ModEntityType.BONE_LORD.get()).m_20615_(this.f_19853_)) != null) {
                    boneLord.m_6518_((ServerLevelAccessor)serverWorld, this.f_19853_.m_6436_(this.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                    boneLord.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                    boneLord.setSkullLord(this);
                    this.setBoneLord(boneLord);
                    this.f_19853_.m_7967_((Entity)boneLord);
                }
            } else if (this.getBoneLord() != null) {
                this.drawAttachParticleBeam((LivingEntity)this, (LivingEntity)this.getBoneLord());
                if (this.m_20280_((Entity)this.getBoneLord()) > (double)Mth.m_144944_((int)16)) {
                    this.m_20219_(this.getBoneLord().m_20182_());
                }
                this.setIsInvulnerable(true);
                this.f_19853_.m_7605_((Entity)this, (byte)4);
                this.hitTimes = 0;
                this.boneLordRegen = delay * 2;
                this.stopAttackersFromAttacking();
            }
            if (this.isCharging()) {
                ++this.chargeTime;
                for (LivingEntity livingEntity : this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_().m_82400_(2.0))) {
                    if (livingEntity instanceof BoneLord || livingEntity == this || livingEntity == this.m_5448_() || !this.m_20191_().m_82381_(livingEntity.m_20191_())) continue;
                    this.f_19853_.m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.explosionRadius, Level.ExplosionInteraction.NONE);
                    if (!(this.f_19796_.m_188501_() < 0.25f)) continue;
                    this.setIsCharging(false);
                }
                if (this.f_19862_ || this.f_19863_) {
                    this.f_19853_.m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.explosionRadius, Level.ExplosionInteraction.NONE);
                    this.setIsCharging(false);
                }
                if (this.chargeTime >= 100) {
                    this.setIsCharging(false);
                }
            } else {
                this.chargeTime = 0;
            }
            if (this.shockWaveCool > 0) {
                --this.shockWaveCool;
            }
        }
    }

    public void stopAttackersFromAttacking() {
        List list = this.f_19853_.m_45976_(Mob.class, this.m_20191_().m_82400_(100.0));
        if (this.getBoneLord() != null) {
            for (Mob attacker : list) {
                if (attacker.m_21188_() == this) {
                    attacker.m_6703_((LivingEntity)this.getBoneLord());
                }
                if (attacker.m_5448_() == this) {
                    attacker.m_6710_((LivingEntity)this.getBoneLord());
                }
                if (attacker instanceof Warden) {
                    Warden warden = (Warden)attacker;
                    if (warden.m_5448_() != this) continue;
                    warden.m_219387_((Entity)this.getBoneLord(), AngerLevel.ANGRY.m_219226_() + 100, false);
                    warden.m_219459_((LivingEntity)this.getBoneLord());
                    continue;
                }
                if (!attacker.m_6274_().m_21874_(MemoryModuleType.f_26372_) || !attacker.m_6274_().m_21952_(MemoryModuleType.f_26372_).isPresent() || attacker.m_6274_().m_21952_(MemoryModuleType.f_26372_).get() != this) continue;
                attacker.m_6274_().m_21882_(MemoryModuleType.f_26334_, (Object)this.getBoneLord().m_20148_(), 600L);
                attacker.m_6274_().m_21882_(MemoryModuleType.f_26372_, (Object)this.getBoneLord(), 600L);
            }
        }
    }

    public float getSwelling(float p_32321_) {
        return Mth.m_14179_((float)p_32321_, (float)this.oldSwell, (float)this.swell) / 28.0f;
    }

    private void drawAttachParticleBeam(LivingEntity pSource, LivingEntity pTarget) {
        double d0 = pTarget.m_20185_() - pSource.m_20185_();
        double d1 = pTarget.m_20188_() - pSource.m_20186_();
        double d2 = pTarget.m_20189_() - pSource.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
        d0 /= d3;
        d1 /= d3;
        d2 /= d3;
        double d4 = pSource.f_19853_.f_46441_.m_188500_();
        if (!pSource.f_19853_.f_46443_) {
            ServerLevel serverWorld = (ServerLevel)pSource.f_19853_;
            while (d4 < d3) {
                serverWorld.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.BONE.get()), pSource.m_20185_() + d0 * (d4 += 1.0), pSource.m_20186_() + d1 * d4, pSource.m_20189_() + d2 * d4, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public void spawnMobs() {
        int spawnRange = 2;
        boolean random = this.f_19853_.f_46441_.m_188499_();
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            double d0 = (double)this.m_20183_().m_123341_() + this.f_19853_.f_46441_.m_188500_();
            double d1 = (double)this.m_20183_().m_123342_() + this.f_19853_.f_46441_.m_188500_();
            double d2 = (double)this.m_20183_().m_123343_() + this.f_19853_.f_46441_.m_188500_();
            for (int p = 0; p < 4; ++p) {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123745_, d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, 1, 0.0, 5.0E-4, 0.0, 5.0E-4);
            }
            SoundUtil.playNecromancerSummon((Entity)this);
            for (int i = 0; i < 2 + serverLevel.f_46441_.m_188503_(2) * serverLevel.f_46441_.m_188503_(1); ++i) {
                Summoned summoned;
                double d3 = (double)this.m_20183_().m_123341_() + (serverLevel.f_46441_.m_188500_() - serverLevel.f_46441_.m_188500_()) * (double)spawnRange + 0.5;
                double d4 = this.m_20183_().m_123342_() + serverLevel.f_46441_.m_188503_(3);
                double d5 = (double)this.m_20183_().m_123343_() + (serverLevel.f_46441_.m_188500_() - serverLevel.f_46441_.m_188500_()) * (double)spawnRange + 0.5;
                if (this.m_5842_()) {
                    summoned = random ? (Summoned)((EntityType)ModEntityType.DROWNED_SERVANT.get()).m_20615_((Level)serverLevel) : (Summoned)((EntityType)ModEntityType.SUNKEN_SKELETON_SERVANT.get()).m_20615_((Level)serverLevel);
                } else {
                    summoned = random ? (serverLevel.f_46441_.m_188501_() <= 0.8f ? (Summoned)((EntityType)ModEntityType.FROZEN_ZOMBIE_SERVANT.get()).m_20615_((Level)serverLevel) : (Summoned)((EntityType)ModEntityType.ZOMBIE_SERVANT.get()).m_20615_((Level)serverLevel)) : (serverLevel.f_46441_.m_188501_() <= 0.8f ? (Summoned)((EntityType)ModEntityType.STRAY_SERVANT.get()).m_20615_((Level)serverLevel) : (Summoned)((EntityType)ModEntityType.SKELETON_SERVANT.get()).m_20615_((Level)serverLevel));
                    if (serverLevel.f_46441_.m_188501_() <= 0.15f) {
                        summoned = (Summoned)((EntityType)ModEntityType.BORDER_WRAITH_SERVANT.get()).m_20615_((Level)serverLevel);
                    }
                }
                if (summoned == null) continue;
                BlockPos blockPos = BlockPos.m_274561_((double)d3, (double)d4, (double)d5);
                summoned.setTrueOwner((LivingEntity)this);
                summoned.setUpgraded(true);
                summoned.m_20035_(BlockFinder.SummonPosition((Entity)summoned, blockPos), this.m_146908_(), this.m_146909_());
                summoned.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(summoned.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                serverLevel.m_47205_((Entity)summoned);
            }
        }
    }

    public void m_6667_(DamageSource cause) {
        BlockEntity blockEntity;
        super.m_6667_(cause);
        for (int i = 0; i < this.f_19853_.f_46441_.m_188503_(35) + 10; ++i) {
            float f11 = this.f_19796_.m_188501_() - 0.5f;
            float f13 = this.f_19796_.m_188501_() - 0.5f;
            float f14 = this.f_19796_.m_188501_() - 0.5f;
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_() + (double)f11, this.m_20186_() + 2.0 + (double)f13, this.m_20189_() + (double)f14, 0.0, 0.0, 0.0);
        }
        if (this.getBoneLord() != null) {
            this.getBoneLord().m_6667_(cause);
        }
        if (this.getPithos() != null && (blockEntity = this.getPithos()) instanceof PithosBlockEntity) {
            PithosBlockEntity pithosTile = (PithosBlockEntity)blockEntity;
            pithosTile.unlock();
        }
    }

    public void onRemovedFromWorld() {
        BlockEntity blockEntity;
        super.onRemovedFromWorld();
        if (this.getBoneLord() != null) {
            this.getBoneLord().m_146870_();
        }
        if (!this.isDespawn() && this.getPithos() != null && (blockEntity = this.getPithos()) instanceof PithosBlockEntity) {
            PithosBlockEntity pithosTile = (PithosBlockEntity)blockEntity;
            pithosTile.unlock();
        }
    }

    public void m_7601_(BlockState pState, Vec3 pMotionMultiplier) {
        if (!pState.m_60713_(Blocks.f_50033_)) {
            super.m_7601_(pState, pMotionMultiplier);
        }
    }

    public boolean m_142535_(float p_146828_, float p_146829_, DamageSource p_146830_) {
        return false;
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return false;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.SKULL_LORD_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.SKULL_LORD_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.SKULL_LORD_DEATH.get();
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public boolean m_7307_(Entity entityIn) {
        Monster monster;
        if (super.m_7307_(entityIn)) {
            return true;
        }
        if (entityIn instanceof Monster && (monster = (Monster)entityIn).m_6336_() == MobType.f_21641_) {
            return this.m_5647_() == null && entityIn.m_5647_() == null;
        }
        return false;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FLAGS, (Object)0);
        this.f_19804_.m_135372_(BONE_LORD, Optional.empty());
        this.f_19804_.m_135372_(BONE_LORD_CLIENT_ID, (Object)-1);
    }

    private boolean geFlags(int mask) {
        byte i = (Byte)this.f_19804_.m_135370_(FLAGS);
        return (i & mask) != 0;
    }

    private void setFlags(int mask, boolean value) {
        int i = ((Byte)this.f_19804_.m_135370_(FLAGS)).byteValue();
        i = value ? (i |= mask) : (i &= ~mask);
        this.f_19804_.m_135381_(FLAGS, (Object)((byte)(i & 0xFF)));
    }

    @Nullable
    public BlockPos getBoundOrigin() {
        return this.boundOrigin;
    }

    public void setBoundOrigin(@Nullable BlockPos pBoundOrigin) {
        this.boundOrigin = pBoundOrigin;
    }

    @Nullable
    public BoneLord getBoneLord() {
        BoneLord boneLord;
        Entity entity;
        if (!this.f_19853_.f_46443_) {
            BoneLord boneLord2;
            UUID uuid = this.getBoneLordUUID();
            LivingEntity livingEntity = EntityFinder.getLivingEntityByUuiD(uuid);
            return livingEntity instanceof BoneLord ? (boneLord2 = (BoneLord)livingEntity) : null;
        }
        int id = this.getBoneLordClientId();
        return id <= -1 ? null : ((entity = this.f_19853_.m_6815_(id)) instanceof BoneLord ? (boneLord = (BoneLord)entity) : null);
    }

    @Nullable
    public UUID getBoneLordUUID() {
        return ((Optional)this.f_19804_.m_135370_(BONE_LORD)).orElse(null);
    }

    public void setBoneLordUUID(UUID uuid) {
        this.f_19804_.m_135381_(BONE_LORD, Optional.ofNullable(uuid));
    }

    public int getBoneLordClientId() {
        return (Integer)this.f_19804_.m_135370_(BONE_LORD_CLIENT_ID);
    }

    public void setBoneLordClientId(int id) {
        this.f_19804_.m_135381_(BONE_LORD_CLIENT_ID, (Object)id);
    }

    public void setBoneLord(BoneLord boneLord) {
        this.setBoneLordUUID(boneLord.m_20148_());
        this.setBoneLordClientId(boneLord.m_19879_());
    }

    public boolean isCharging() {
        return this.geFlags(1);
    }

    public void setIsCharging(boolean charging) {
        this.setFlags(1, charging);
    }

    public boolean m_20147_() {
        return this.geFlags(2);
    }

    public void setIsInvulnerable(boolean invulnerable) {
        this.setFlags(2, invulnerable);
    }

    public boolean isDespawn() {
        return this.geFlags(4);
    }

    public void setIsDespawn(boolean despawn) {
        this.setFlags(4, despawn);
    }

    public boolean isElectroOrb() {
        return this.geFlags(8);
    }

    public void setElectroOrb(boolean electroOrb) {
        this.setFlags(8, electroOrb);
    }

    public boolean isSpawning() {
        return this.geFlags(16);
    }

    public void setSpawning(boolean spawning) {
        this.setFlags(16, spawning);
    }

    public boolean isShockWave() {
        return this.geFlags(32);
    }

    public void setShockWave(boolean shockWave) {
        this.setFlags(32, shockWave);
    }

    public boolean isNotAbility() {
        return !this.isCharging() && !this.isElectroOrb() && !this.isSpawning() && !this.isShockWave();
    }

    public void m_7378_(CompoundTag pCompound) {
        UUID uuid;
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("BoundX")) {
            this.boundOrigin = new BlockPos(pCompound.m_128451_("BoundX"), pCompound.m_128451_("BoundY"), pCompound.m_128451_("BoundZ"));
        }
        if (pCompound.m_128403_("boneLord")) {
            uuid = pCompound.m_128342_("boneLord");
        } else {
            String s = pCompound.m_128461_("boneLord");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
        }
        if (uuid != null) {
            try {
                this.setBoneLordUUID(uuid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (pCompound.m_128441_("BoneLordClient")) {
            this.setBoneLordClientId(pCompound.m_128451_("BoneLordClient"));
        }
        this.hitTimes = pCompound.m_128451_("hitTimes");
        this.boneLordRegen = pCompound.m_128451_("boneLordRegen");
        this.spawnDelay = pCompound.m_128451_("spawnDelay");
        this.spawnNumber = pCompound.m_128451_("spawnNumber");
        this.shockWaveCool = pCompound.m_128451_("shockWaveCool");
        this.stuckTime = pCompound.m_128451_("stuckTime");
        if (this.m_8077_()) {
            this.bossInfo.m_6456_(this.m_5446_());
        }
        this.setConfigurableAttributes();
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        if (this.boundOrigin != null) {
            pCompound.m_128405_("BoundX", this.boundOrigin.m_123341_());
            pCompound.m_128405_("BoundY", this.boundOrigin.m_123342_());
            pCompound.m_128405_("BoundZ", this.boundOrigin.m_123343_());
        }
        if (this.getBoneLordUUID() != null) {
            pCompound.m_128362_("boneLord", this.getBoneLordUUID());
        }
        if (this.getBoneLordClientId() > -1) {
            pCompound.m_128405_("BoneLordClient", this.getBoneLordClientId());
        }
        pCompound.m_128405_("hitTimes", this.hitTimes);
        pCompound.m_128405_("boneLordRegen", this.boneLordRegen);
        pCompound.m_128405_("spawnDelay", this.spawnDelay);
        pCompound.m_128405_("spawnNumber", this.spawnNumber);
        pCompound.m_128405_("shockWaveCool", this.shockWaveCool);
        pCompound.m_128405_("stuckTime", this.stuckTime);
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossInfo.m_6456_(this.m_5446_());
    }

    protected void m_8024_() {
        super.m_8024_();
        this.bossInfo.m_8321_((Boolean)MainConfig.SpecialBossBar.get());
    }

    public void m_6457_(ServerPlayer pPlayer) {
        super.m_6457_(pPlayer);
        this.bossInfo.m_6543_(pPlayer);
    }

    public void m_6452_(ServerPlayer pPlayer) {
        super.m_6452_(pPlayer);
        this.bossInfo.m_6539_(pPlayer);
    }

    public float m_213856_() {
        return 1.0f;
    }

    public boolean isHalfHealth() {
        return this.m_21223_() <= this.m_21233_() / 2.0f;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.m_213945_(pLevel.m_213780_(), pDifficulty);
        this.m_213946_(pLevel.m_213780_(), pDifficulty);
        BoneLord boneLord = (BoneLord)((EntityType)ModEntityType.BONE_LORD.get()).m_20615_((Level)pLevel);
        if (boneLord != null) {
            boneLord.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
            boneLord.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            boneLord.setSkullLord(this);
            this.setBoneLord(boneLord);
            pLevel.m_7967_((Entity)boneLord);
        }
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public void m_7822_(byte p_21375_) {
        if (p_21375_ == 4) {
            this.setIsInvulnerable(true);
        } else if (p_21375_ == 5) {
            this.setIsInvulnerable(false);
        } else if (p_21375_ == 6) {
            this.setShockWave(true);
        } else if (p_21375_ == 7) {
            this.setShockWave(false);
        } else {
            super.m_7822_(p_21375_);
        }
    }

    static class MoveHelperController
    extends MoveControl {
        private final SkullLord skullLord;
        private int floatDuration;

        public MoveHelperController(SkullLord p_i45838_1_) {
            super((Mob)p_i45838_1_);
            this.skullLord = p_i45838_1_;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && this.floatDuration-- <= 0) {
                this.floatDuration += this.skullLord.m_217043_().m_188503_(5) + 2;
                Vec3 vector3d = new Vec3(this.f_24975_ - this.skullLord.m_20185_(), this.f_24976_ - this.skullLord.m_20186_(), this.f_24977_ - this.skullLord.m_20189_());
                double d0 = vector3d.m_82553_();
                if (this.canReach(vector3d = vector3d.m_82541_(), Mth.m_14165_((double)d0))) {
                    this.skullLord.m_20256_(this.skullLord.m_20184_().m_82549_(vector3d.m_82490_(0.1)));
                } else {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                }
            }
        }

        private boolean canReach(Vec3 p_220673_1_, int p_220673_2_) {
            AABB axisalignedbb = this.skullLord.m_20191_();
            for (int i = 1; i < p_220673_2_; ++i) {
                if (this.skullLord.f_19853_.m_45756_((Entity)this.skullLord, axisalignedbb = axisalignedbb.m_82383_(p_220673_1_))) continue;
                return false;
            }
            return true;
        }
    }

    class SoulSkullGoal
    extends Goal {
        public int shootTime;

        SoulSkullGoal() {
        }

        public boolean m_8036_() {
            if (SkullLord.this.m_5448_() != null && SkullLord.this.isNotAbility() && SkullLord.this.m_142582_((Entity)SkullLord.this.m_5448_()) && SkullLord.this.m_20147_()) {
                return !MobUtil.areAllies((Entity)SkullLord.this.m_5448_(), (Entity)SkullLord.this);
            }
            return false;
        }

        public boolean m_8045_() {
            return SkullLord.this.m_5448_() != null && SkullLord.this.isNotAbility() && SkullLord.this.m_142582_((Entity)SkullLord.this.m_5448_()) && SkullLord.this.m_5448_().m_6084_() && SkullLord.this.getBoneLord() != null;
        }

        public void m_8037_() {
            LivingEntity livingentity = SkullLord.this.m_5448_();
            if (livingentity != null) {
                int shoot = 45;
                if (SkullLord.this.isHalfHealth()) {
                    shoot = 30;
                }
                if (--this.shootTime <= 0) {
                    double d1 = livingentity.m_20185_() - SkullLord.this.m_20185_();
                    double d2 = livingentity.m_20227_(0.5) - SkullLord.this.m_20227_(0.5);
                    double d3 = livingentity.m_20189_() - SkullLord.this.m_20189_();
                    HauntedSkullProjectile soulSkull = new HauntedSkullProjectile((LivingEntity)SkullLord.this, d1, d2, d3, SkullLord.this.f_19853_);
                    soulSkull.m_6034_(soulSkull.m_20185_(), SkullLord.this.m_20227_(0.75), soulSkull.m_20189_());
                    soulSkull.m_146922_(SkullLord.this.m_146908_());
                    soulSkull.m_146926_(SkullLord.this.m_146909_());
                    this.shootTime = shoot;
                    SkullLord.this.f_19853_.m_7967_((Entity)soulSkull);
                    SkullLord.this.m_5496_((SoundEvent)ModSounds.SKULL_LORD_SHOOT.get(), 1.0f, 1.0f);
                }
            }
        }

        public boolean m_183429_() {
            return true;
        }
    }

    class ChargeAttackGoal
    extends Goal {
        private Vec3 chargePos;

        public ChargeAttackGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (SkullLord.this.m_5448_() != null && SkullLord.this.isNotAbility() && SkullLord.this.m_142582_((Entity)SkullLord.this.m_5448_()) && SkullLord.this.getBoneLord() == null && SkullLord.this.m_20270_((Entity)SkullLord.this.m_5448_()) <= 8.0f) {
                if (!SkullLord.this.isHalfHealth()) {
                    return SkullLord.this.f_19796_.m_188503_(60) == 0;
                }
                return SkullLord.this.f_19796_.m_188503_(30) == 0;
            }
            return false;
        }

        public boolean m_8045_() {
            return SkullLord.this.isCharging() && SkullLord.this.m_5448_() != null && SkullLord.this.getBoneLord() == null && SkullLord.this.m_20270_((Entity)SkullLord.this.m_5448_()) <= 8.0f && SkullLord.this.m_5448_().m_6084_();
        }

        public void m_8056_() {
            LivingEntity livingentity = SkullLord.this.m_5448_();
            if (livingentity != null) {
                Vec3 vector3d = livingentity.m_20299_(1.0f);
                double dx = SkullLord.this.m_20185_() - vector3d.m_7096_();
                double dy = SkullLord.this.m_20186_() - vector3d.m_7098_();
                double dz = SkullLord.this.m_20189_() - vector3d.m_7094_();
                double d0 = Math.sqrt(dx * dx + dy * dy + dz * dz);
                double velocity = 2.0;
                if (SkullLord.this.isHalfHealth()) {
                    velocity = 2.5;
                }
                double xPower = -(dx / d0 * velocity * 0.2);
                double yPower = -(dy / d0 * velocity * 0.2);
                double zPower = -(dz / d0 * velocity * 0.2);
                this.chargePos = new Vec3(xPower, yPower, zPower);
                SkullLord.this.setIsCharging(true);
                SkullLord.this.m_5496_((SoundEvent)ModSounds.SKULL_LORD_CHARGE.get(), 1.0f, 1.0f);
            }
        }

        public void m_8041_() {
            SkullLord.this.setIsCharging(false);
            SkullLord.this.m_20256_(Vec3.f_82478_);
        }

        public void m_8037_() {
            SkullLord skullLord = SkullLord.this;
            LivingEntity livingentity = SkullLord.this.m_5448_();
            if (this.chargePos != null) {
                SkullLord.this.m_20256_(this.chargePos);
            }
            if (livingentity != null && skullLord.m_20191_().m_82381_(livingentity.m_20191_()) && livingentity.m_6469_(skullLord.m_269291_().m_269104_((Entity)skullLord, (Entity)skullLord), (float)skullLord.m_21133_(Attributes.f_22281_))) {
                if (skullLord.m_6060_()) {
                    livingentity.m_20254_(5);
                }
                if (skullLord.isHalfHealth()) {
                    livingentity.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.SAPPED.get(), 100));
                }
                skullLord.f_19853_.m_254849_((Entity)skullLord, skullLord.m_20185_(), skullLord.m_20186_(), skullLord.m_20189_(), skullLord.explosionRadius, Level.ExplosionInteraction.NONE);
                skullLord.setIsCharging(false);
            }
        }
    }

    class ElectroOrbAttackGoal
    extends Goal {
        private int electroTime;

        public ElectroOrbAttackGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (SkullLord.this.m_5448_() != null && SkullLord.this.isNotAbility() && SkullLord.this.getBoneLord() == null && SkullLord.this.m_142582_((Entity)SkullLord.this.m_5448_())) {
                if (!SkullLord.this.isHalfHealth()) {
                    return SkullLord.this.f_19796_.m_188503_(400) == 0;
                }
                return SkullLord.this.f_19796_.m_188503_(200) == 0;
            }
            return false;
        }

        public boolean m_8045_() {
            return SkullLord.this.isElectroOrb() && SkullLord.this.m_5448_() != null && SkullLord.this.getBoneLord() == null && this.electroTime > 0 && SkullLord.this.m_5448_().m_6084_();
        }

        public void m_8056_() {
            LivingEntity livingentity = SkullLord.this.m_5448_();
            if (livingentity != null) {
                int time = 100;
                if (SkullLord.this.isHalfHealth()) {
                    time = 80;
                }
                this.electroTime = time;
                SkullLord.this.setElectroOrb(true);
                SkullLord.this.m_5496_((SoundEvent)ModSounds.ZAP.get(), 1.0f, 1.0f);
            }
        }

        public void m_8041_() {
            this.electroTime = 0;
            SkullLord.this.setElectroOrb(false);
            SkullLord.this.m_20256_(Vec3.f_82478_);
        }

        public void m_8037_() {
            Level level;
            SkullLord skullLord = SkullLord.this;
            LivingEntity livingentity = SkullLord.this.m_5448_();
            if (livingentity != null && (level = skullLord.f_19853_) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (this.electroTime > 0) {
                    --this.electroTime;
                    if (!skullLord.m_142582_((Entity)livingentity)) {
                        skullLord.m_20334_(0.0, 0.08, 0.0);
                    } else {
                        skullLord.m_20256_(Vec3.f_82478_);
                    }
                    double d1 = livingentity.m_20185_() - skullLord.m_20185_();
                    double d2 = livingentity.m_20189_() - skullLord.m_20189_();
                    skullLord.m_21563_().m_24960_((Entity)livingentity, 10.0f, (float)skullLord.m_8132_());
                    skullLord.m_146922_(-((float)Mth.m_14136_((double)d1, (double)d2)) * 57.295776f);
                    skullLord.f_20883_ = skullLord.m_146908_();
                    if (this.electroTime > 60) {
                        ServerParticleUtil.addParticlesAroundMiddleSelf(serverLevel, (ParticleOptions)ModParticleTypes.BIG_ELECTRIC.get(), (Entity)skullLord);
                    }
                    if (this.electroTime <= 60 && this.electroTime % 10 == 0) {
                        new ElectroOrbSpell().mobSpellResult((LivingEntity)skullLord, ItemStack.f_41583_);
                    }
                }
            }
        }

        public boolean m_183429_() {
            return true;
        }
    }

    class ShockwaveAttackGoal
    extends Goal {
        private int shockWave;

        public ShockwaveAttackGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (SkullLord.this.m_5448_() != null && SkullLord.this.isNotAbility() && SkullLord.this.getBoneLord() == null && (double)SkullLord.this.m_5448_().m_20270_((Entity)SkullLord.this) <= 4.0 && SkullLord.this.m_142582_((Entity)SkullLord.this.m_5448_())) {
                return SkullLord.this.shockWaveCool <= 0;
            }
            return false;
        }

        public boolean m_8045_() {
            return SkullLord.this.isShockWave() && SkullLord.this.m_5448_() != null && SkullLord.this.getBoneLord() == null && this.shockWave > 0 && SkullLord.this.m_5448_().m_6084_();
        }

        public void m_8056_() {
            LivingEntity livingentity = SkullLord.this.m_5448_();
            if (livingentity != null) {
                int time = 60;
                if (SkullLord.this.isHalfHealth()) {
                    time = 50;
                }
                this.shockWave = time;
                SkullLord.this.setShockWave(true);
                SkullLord.this.f_19853_.m_7605_((Entity)SkullLord.this, (byte)6);
                SkullLord.this.m_5496_((SoundEvent)ModSounds.BOMB_FUSE.get(), 3.0f, 1.0f);
                SkullLord.this.m_5496_((SoundEvent)ModSounds.SKULL_LORD_CHARGE.get(), 3.0f, 0.25f);
            }
        }

        public void m_8041_() {
            this.shockWave = 0;
            SkullLord.this.shockWaveCool = SkullLord.this.isHalfHealth() ? 100 : 200;
            SkullLord.this.setShockWave(false);
            SkullLord.this.f_19853_.m_7605_((Entity)SkullLord.this, (byte)7);
            SkullLord.this.m_20256_(Vec3.f_82478_);
        }

        public void m_8037_() {
            Level level;
            SkullLord skullLord = SkullLord.this;
            LivingEntity livingentity = SkullLord.this.m_5448_();
            if (livingentity != null && (level = skullLord.f_19853_) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (this.shockWave > 0) {
                    --this.shockWave;
                    skullLord.m_20256_(Vec3.f_82478_);
                    double d1 = livingentity.m_20185_() - skullLord.m_20185_();
                    double d2 = livingentity.m_20189_() - skullLord.m_20189_();
                    skullLord.m_21563_().m_24960_((Entity)livingentity, 10.0f, (float)skullLord.m_8132_());
                    skullLord.m_146922_(-((float)Mth.m_14136_((double)d1, (double)d2)) * 57.295776f);
                    skullLord.f_20883_ = skullLord.m_146908_();
                    ServerParticleUtil.gatheringParticles((ParticleOptions)ModParticleTypes.LASER_GATHER.get(), (Entity)skullLord, serverLevel);
                    if (this.shockWave == 10) {
                        new ShockwaveSpell().mobSpellResult((LivingEntity)skullLord, ItemStack.f_41583_);
                    }
                }
            }
        }

        public boolean m_183429_() {
            return true;
        }
    }

    class MoveRandomGoal
    extends Goal {
        public MoveRandomGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return SkullLord.this.isNotAbility();
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8037_() {
            int distance = 8;
            BlockPos blockPos = null;
            if (SkullLord.this.getBoneLord() != null) {
                blockPos = SkullLord.this.getBoneLord().m_20183_().m_6630_(2);
            } else if (SkullLord.this.m_5448_() != null) {
                blockPos = SkullLord.this.m_5448_().m_20183_().m_6630_(2);
            } else if (SkullLord.this.getBoundOrigin() != null) {
                blockPos = SkullLord.this.getBoundOrigin();
            }
            for (int i = 0; i < 64; ++i) {
                double d2;
                double d1;
                if (blockPos != null) {
                    double Z;
                    double Y;
                    Vec3 vector3d = Vec3.m_82512_((Vec3i)blockPos);
                    double X = vector3d.f_82479_ + (double)SkullLord.this.f_19796_.m_216332_(-distance, distance);
                    BlockPos blockPos1 = BlockPos.m_274561_((double)X, (double)(Y = vector3d.f_82480_ + (double)SkullLord.this.f_19796_.m_216332_(-distance, distance)), (double)(Z = vector3d.f_82481_ + (double)SkullLord.this.f_19796_.m_216332_(-distance, distance)));
                    if (!SkullLord.this.f_19853_.m_46859_(blockPos1)) continue;
                    SkullLord.this.m_21566_().m_6849_(X, Y, Z, 0.05);
                    break;
                }
                double d0 = SkullLord.this.m_20185_() + (double)SkullLord.this.f_19796_.m_216332_(-(distance /= 2), distance);
                BlockPos blockPos1 = BlockPos.m_274561_((double)d0, (double)(d1 = SkullLord.this.m_20186_() + (double)SkullLord.this.f_19796_.m_216332_(-distance, distance)), (double)(d2 = SkullLord.this.m_20189_() + (double)SkullLord.this.f_19796_.m_216332_(-distance, distance)));
                if (!SkullLord.this.f_19853_.m_46859_(blockPos1)) continue;
                SkullLord.this.m_21566_().m_6849_(d0, d1, d2, 0.05);
                break;
            }
        }
    }

    static class LookAroundGoal
    extends Goal {
        private final SkullLord skullLord;

        public LookAroundGoal(SkullLord p_i45839_1_) {
            this.skullLord = p_i45839_1_;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return true;
        }

        public void m_8037_() {
            if (this.skullLord.m_5448_() == null) {
                Vec3 vector3d = this.skullLord.m_20184_();
                this.skullLord.m_146922_(-((float)Mth.m_14136_((double)vector3d.f_82479_, (double)vector3d.f_82481_)) * 57.295776f);
            } else {
                LivingEntity livingentity = this.skullLord.m_5448_();
                double d1 = livingentity.m_20185_() - this.skullLord.m_20185_();
                double d2 = livingentity.m_20189_() - this.skullLord.m_20189_();
                this.skullLord.m_21563_().m_24960_((Entity)livingentity, 10.0f, (float)this.skullLord.m_8132_());
                this.skullLord.m_146922_(-((float)Mth.m_14136_((double)d1, (double)d2)) * 57.295776f);
            }
            this.skullLord.f_20883_ = this.skullLord.m_146908_();
        }
    }
}

