/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.hostile;

import com.Polarice3.Goety.common.entities.neutral.IRavager;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.items.RavagerArmorItem;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class ArmoredRavager
extends Ravager
implements IRavager {
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("d404309f-25d3-4837-8828-e2b7b0ea79fd");

    public ArmoredRavager(EntityType<? extends Ravager> p_33325_, Level p_33326_) {
        super(p_33325_, p_33326_);
        this.f_21364_ = 40;
    }

    public void m_7380_(CompoundTag p_33353_) {
        super.m_7380_(p_33353_);
        ItemStack itemStack = this.m_6844_(EquipmentSlot.CHEST);
        if (!itemStack.m_41619_()) {
            CompoundTag compoundTag = new CompoundTag();
            itemStack.m_41739_(compoundTag);
            p_33353_.m_128365_("ArmorItem", (Tag)compoundTag);
        }
    }

    public void m_7378_(CompoundTag p_33344_) {
        super.m_7378_(p_33344_);
        CompoundTag armorItem = p_33344_.m_128469_("ArmorItem");
        if (!armorItem.m_128456_()) {
            this.setArmorEquipment(ItemStack.m_41712_((CompoundTag)armorItem));
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.getArmor().m_41619_()) {
            this.m_21406_(EntityType.f_20518_, false);
        }
    }

    @Override
    public ItemStack getArmor() {
        return this.m_6844_(EquipmentSlot.CHEST);
    }

    public void setArmor(ItemStack p_30733_) {
        this.m_8061_(EquipmentSlot.CHEST, p_30733_);
        this.m_21409_(EquipmentSlot.CHEST, 0.0f);
    }

    public void setArmorEquipment(ItemStack armor) {
        if (!this.f_19853_.f_46443_) {
            this.m_8061_(EquipmentSlot.CHEST, armor);
            this.m_21409_(EquipmentSlot.CHEST, 0.0f);
            this.updateArmor();
        }
    }

    public void updateArmor() {
        AttributeInstance attribute = this.m_21051_(Attributes.f_22284_);
        if (attribute != null) {
            int i;
            attribute.m_22120_(ARMOR_MODIFIER_UUID);
            if (this.isArmor(this.getArmor()) && (i = ((RavagerArmorItem)this.getArmor().m_41720_()).getProtection()) != 0) {
                attribute.m_22118_(new AttributeModifier(ARMOR_MODIFIER_UUID, "Ravager armor bonus", (double)i, AttributeModifier.Operation.ADDITION));
            }
        }
    }

    public boolean isArmor(ItemStack p_30731_) {
        return p_30731_.m_41720_() instanceof RavagerArmorItem;
    }

    public int m_33362_() {
        return super.m_33362_();
    }

    public int m_33364_() {
        return super.m_33364_();
    }

    public int m_33366_() {
        return super.m_33366_();
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        Item item;
        float f;
        pSpawnData = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        int i = pLevel.m_6018_().f_46441_.m_188503_(2);
        float f2 = f = pLevel.m_6018_().m_46791_() == Difficulty.HARD ? 0.75f : 0.45f;
        if (pLevel.m_6018_().f_46441_.m_188501_() < f) {
            ++i;
        }
        if (pLevel.m_6018_().f_46441_.m_188501_() < f) {
            ++i;
        }
        if (pLevel.m_6018_().f_46441_.m_188501_() < f) {
            ++i;
        }
        if ((item = ArmoredRavager.getEquipmentForSlot(i)) != null) {
            this.setArmorEquipment(new ItemStack((ItemLike)item));
        }
        return pSpawnData;
    }

    protected ResourceLocation m_7582_() {
        return EntityType.f_20518_.m_20677_();
    }

    @Nullable
    public static Item getEquipmentForSlot(int p_21414_) {
        if (p_21414_ < 3) {
            return (Item)ModItems.IRON_RAVAGER_ARMOR.get();
        }
        if (p_21414_ == 3) {
            return (Item)ModItems.GOLD_RAVAGER_ARMOR.get();
        }
        if (p_21414_ == 4) {
            return (Item)ModItems.DIAMOND_RAVAGER_ARMOR.get();
        }
        return null;
    }
}

