/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally.undead.bound;

import com.Polarice3.Goety.common.entities.ai.AvoidTargetGoal;
import com.Polarice3.Goety.common.entities.ally.illager.RaiderServant;
import com.Polarice3.Goety.common.entities.ally.undead.bound.AbstractBoundIllager;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.magic.spells.frost.IceChunkSpell;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class BoundIceologer
extends AbstractBoundIllager {
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(BoundIceologer.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int spellCool;
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState walkAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();

    public BoundIceologer(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, new AvoidTargetGoal<LivingEntity>(this, LivingEntity.class, 6.0f, 1.0, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new ChunkSpellGoal(this));
        this.f_21345_.m_25352_(8, new RaiderServant.RaiderWanderGoal<BoundIceologer>(this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22280_, 0.15).m_22268_(Attributes.f_22277_, ((Double)AttributesConfig.BoundIceologerFollowRange.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.BoundIceologerArmor.get()).doubleValue()).m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.BoundIceologerHealth.get()).doubleValue());
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.BoundIceologerHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.BoundIceologerArmor.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22277_), (Double)AttributesConfig.BoundIceologerFollowRange.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIM_STATE, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("SpellCool", this.spellCool);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("SpellCool")) {
            this.spellCool = compound.m_128451_("SpellCool");
        }
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "idle")) {
            return 1;
        }
        if (Objects.equals(animation, "attack")) {
            return 2;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.idleAnimationState);
        list.add(this.attackAnimationState);
        return list;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public int getCurrentAnimation() {
        return (Integer)this.f_19804_.m_135370_(ANIM_STATE);
    }

    public void m_7350_(EntityDataAccessor<?> accessor) {
        if (ANIM_STATE.equals(accessor) && this.f_19853_.f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    break;
                }
                case 1: {
                    this.idleAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.idleAnimationState);
                    break;
                }
                case 2: {
                    this.attackAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.attackAnimationState);
                }
            }
        }
    }

    @Override
    public SoundEvent getCelebrateSound() {
        return (SoundEvent)ModSounds.ICEOLOGER_AMBIENT.get();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.ICEOLOGER_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.ICEOLOGER_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource p_32654_) {
        return (SoundEvent)ModSounds.ICEOLOGER_HURT.get();
    }

    public float m_6100_() {
        return 0.45f;
    }

    @Override
    protected SoundEvent getCastingSoundEvent() {
        return null;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            this.idleAnimationState.m_246184_(this.getCurrentAnimation() != this.getAnimationState("attack") && !this.f_267362_.m_267780_(), this.f_19797_);
            for (int i = 0; i < 2; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123796_, this.m_20208_(0.5), this.m_20186_() + 0.5, this.m_20262_(0.5), (0.5 - this.f_19796_.m_188500_()) * 0.15, (double)0.01f, (0.5 - this.f_19796_.m_188500_()) * 0.15);
            }
        }
        if (!this.f_19853_.f_46443_ && this.spellCool > 0) {
            --this.spellCool;
        }
    }

    @Override
    public void tryKill(Player player) {
        if (this.killChance <= 0) {
            this.warnKill(player);
        } else {
            super.tryKill(player);
        }
    }

    public static class ChunkSpellGoal
    extends Goal {
        public BoundIceologer iceologer;
        public boolean attack = false;
        public int spellTick;

        public ChunkSpellGoal(BoundIceologer iceologer) {
            this.iceologer = iceologer;
            this.m_7021_(EnumSet.of(Goal.Flag.TARGET, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (this.iceologer.m_5448_() != null && (double)this.iceologer.m_20270_((Entity)this.iceologer.m_5448_()) <= this.iceologer.m_21133_(Attributes.f_22277_)) {
                return this.iceologer.spellCool <= 0;
            }
            return false;
        }

        public boolean m_8045_() {
            return this.iceologer.m_5448_() != null && this.spellTick < 66;
        }

        public void m_8056_() {
            super.m_8056_();
            this.attack = false;
            this.spellTick = 0;
        }

        public void m_8041_() {
            super.m_8041_();
            this.attack = false;
            this.spellTick = 0;
            this.iceologer.spellCool = MathHelper.secondsToTicks(6);
            this.iceologer.setAnimationState("idle");
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            if (this.iceologer.m_5448_() == null) {
                this.m_8041_();
                return;
            }
            if ((double)this.iceologer.m_20270_((Entity)this.iceologer.m_5448_()) <= 7.0 || this.attack) {
                if (!this.attack) {
                    this.iceologer.m_5496_((SoundEvent)ModSounds.ICEOLOGER_ATTACK.get(), 1.0f, this.iceologer.m_6100_());
                    if (this.iceologer.m_5448_() != null) {
                        MobUtil.instaLook((Mob)this.iceologer, (Entity)this.iceologer.m_5448_());
                        new IceChunkSpell().mobSpellResult((LivingEntity)this.iceologer, new ItemStack((ItemLike)ModItems.FROST_STAFF.get()));
                    }
                    this.iceologer.setAnimationState("attack");
                    this.attack = true;
                }
                MobUtil.instaLook((Mob)this.iceologer, (Entity)this.iceologer.m_5448_());
                this.iceologer.m_21573_().m_26573_();
                ++this.spellTick;
            } else {
                this.iceologer.m_21573_().m_5624_((Entity)this.iceologer.m_5448_(), 0.8);
            }
        }
    }
}

