/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally.illager;

import com.Polarice3.Goety.common.entities.ai.ModRangedAttackGoal;
import com.Polarice3.Goety.common.entities.ai.SummonTargetGoal;
import com.Polarice3.Goety.common.entities.ally.illager.RaiderServant;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;

public class WitchServant
extends RaiderServant
implements RangedAttackMob {
    private static final UUID SPEED_MODIFIER_DRINKING_UUID = UUID.fromString("5CD17E52-A79A-43D3-A529-90FDE04B181E");
    private static final AttributeModifier SPEED_MODIFIER_DRINKING = new AttributeModifier(SPEED_MODIFIER_DRINKING_UUID, "Drinking speed penalty", -0.25, AttributeModifier.Operation.ADDITION);
    private static final EntityDataAccessor<Boolean> DATA_USING_ITEM = SynchedEntityData.m_135353_(WitchServant.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private LivingEntity shootTarget;
    private int cooldown = 0;
    private int usingTime;

    public WitchServant(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new ModRangedAttackGoal<WitchServant>(this, 1.0, 60, 10.0f){

            @Override
            public boolean m_8036_() {
                LivingEntity livingentity = WitchServant.this.getShootTarget();
                if (livingentity != null && livingentity.m_6084_()) {
                    this.target = livingentity;
                    return true;
                }
                return false;
            }
        });
        this.f_21345_.m_25352_(2, new RaiderServant.RaiderWanderGoal<WitchServant>(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Override
    public void targetSelectGoal() {
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{RaiderServant.class}));
        this.f_21346_.m_25352_(1, (Goal)new SummonTargetGoal((Mob)this));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_USING_ITEM, (Object)false);
    }

    public LivingEntity getShootTarget() {
        return this.shootTarget;
    }

    public void setShootTarget(@Nullable LivingEntity target) {
        this.shootTarget = target;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12548_;
    }

    protected SoundEvent m_7975_(DamageSource p_34154_) {
        return SoundEvents.f_12552_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12550_;
    }

    public void setUsingItem(boolean p_34164_) {
        this.m_20088_().m_135381_(DATA_USING_ITEM, (Object)p_34164_);
    }

    public boolean isDrinkingPotion() {
        return (Boolean)this.m_20088_().m_135370_(DATA_USING_ITEM);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 26.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    @Override
    public void m_8107_() {
        AttributeInstance attributeinstance = this.m_21051_(Attributes.f_22279_);
        if (!this.f_19853_.f_46443_ && this.m_6084_()) {
            --this.cooldown;
            if (this.cooldown <= 0 && this.m_217043_().m_188499_()) {
                this.findTarget();
                this.cooldown = 200;
            }
            if (this.getShootTarget() == null && this.m_5448_() != null && this.m_5448_().m_6084_()) {
                this.setShootTarget(this.m_5448_());
            }
            if (this.isDrinkingPotion()) {
                if (this.usingTime-- <= 0) {
                    List list;
                    this.setUsingItem(false);
                    ItemStack itemstack = this.m_21205_();
                    this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                    if (itemstack.m_150930_(Items.f_42589_) && (list = PotionUtils.m_43547_((ItemStack)itemstack)) != null) {
                        for (MobEffectInstance mobeffectinstance : list) {
                            this.m_7292_(new MobEffectInstance(mobeffectinstance));
                        }
                    }
                    if (attributeinstance != null) {
                        attributeinstance.m_22130_(SPEED_MODIFIER_DRINKING);
                    }
                }
            } else {
                Potion potion = null;
                if (this.f_19796_.m_188501_() < 0.15f && this.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get()) && !this.m_21023_(MobEffects.f_19608_)) {
                    potion = Potions.f_43621_;
                } else if (this.f_19796_.m_188501_() < 0.15f && (this.m_6060_() || this.m_21225_() != null && this.m_21225_().m_269533_(DamageTypeTags.f_268745_)) && !this.m_21023_(MobEffects.f_19607_)) {
                    potion = Potions.f_43610_;
                } else if (this.f_19796_.m_188501_() < 0.05f && this.m_21223_() < this.m_21233_()) {
                    potion = Potions.f_43623_;
                } else if (this.f_19796_.m_188501_() < 0.5f && this.m_5448_() != null && !this.m_21023_(MobEffects.f_19596_) && this.m_5448_().m_20280_((Entity)this) > 121.0) {
                    potion = Potions.f_43612_;
                }
                if (potion != null) {
                    this.m_8061_(EquipmentSlot.MAINHAND, PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)potion));
                    this.usingTime = this.m_21205_().m_41779_();
                    this.setUsingItem(true);
                    if (!this.m_20067_()) {
                        this.m_9236_().m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12551_, this.m_5720_(), 1.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
                    }
                    if (attributeinstance != null) {
                        attributeinstance.m_22130_(SPEED_MODIFIER_DRINKING);
                        attributeinstance.m_22118_(SPEED_MODIFIER_DRINKING);
                    }
                }
            }
            if (this.f_19796_.m_188501_() < 7.5E-4f) {
                this.m_9236_().m_7605_((Entity)this, (byte)15);
            }
        }
        super.m_8107_();
    }

    protected AABB getTargetSearchArea(double p_26069_) {
        return this.m_20191_().m_82377_(p_26069_, 4.0, p_26069_);
    }

    public boolean isAlliedTarget(Entity target) {
        if (this.getTrueOwner() != null) {
            return target == this.getTrueOwner() || MobUtil.getOwner(target) == this.getTrueOwner();
        }
        return MobUtil.areAllies((Entity)this, target);
    }

    protected void findTarget() {
        this.shootTarget = this.f_19853_.m_45982_(this.f_19853_.m_6443_(LivingEntity.class, this.getTargetSearchArea(this.m_21133_(Attributes.f_22277_)), p_148152_ -> true), TargetingConditions.m_148353_().m_26883_(this.m_21133_(Attributes.f_22277_)).m_26888_(livingEntity -> this.isAlliedTarget((Entity)livingEntity) && livingEntity.m_21223_() < livingEntity.m_21233_()), (LivingEntity)this, this.m_20185_(), this.m_20188_(), this.m_20189_());
    }

    @Override
    public SoundEvent getCelebrateSound() {
        return SoundEvents.f_12549_;
    }

    public void m_7822_(byte p_34138_) {
        if (p_34138_ == 15) {
            for (int i = 0; i < this.f_19796_.m_188503_(35) + 10; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123771_, this.m_20185_() + this.f_19796_.m_188583_() * (double)0.13f, this.m_20191_().f_82292_ + 0.5 + this.f_19796_.m_188583_() * (double)0.13f, this.m_20189_() + this.f_19796_.m_188583_() * (double)0.13f, 0.0, 0.0, 0.0);
            }
        } else {
            super.m_7822_(p_34138_);
        }
    }

    protected float m_6515_(DamageSource p_34149_, float p_34150_) {
        p_34150_ = super.m_6515_(p_34149_, p_34150_);
        if (p_34149_.m_7639_() == this) {
            p_34150_ = 0.0f;
        }
        if (p_34149_.m_269533_(DamageTypeTags.f_268731_)) {
            p_34150_ *= 0.15f;
        }
        return p_34150_;
    }

    public void m_6504_(LivingEntity target, float velocity) {
        if (!this.isDrinkingPotion()) {
            Vec3 vec3 = target.m_20184_();
            double d0 = target.m_20185_() + vec3.f_82479_ - this.m_20185_();
            double d1 = target.m_20188_() - (double)1.1f - this.m_20186_();
            double d2 = target.m_20189_() + vec3.f_82481_ - this.m_20189_();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            Potion potion = Potions.f_43582_;
            if (this.isAlliedTarget((Entity)target) && this.m_5448_() != target) {
                potion = target.m_21223_() <= 4.0f ? Potions.f_43623_ : Potions.f_43587_;
                this.setShootTarget(null);
            } else if (d3 >= 8.0 && !target.m_21023_(MobEffects.f_19597_)) {
                potion = Potions.f_43615_;
            } else if (target.m_21223_() >= 8.0f && !target.m_21023_(MobEffects.f_19614_)) {
                potion = Potions.f_43584_;
            } else if (d3 <= 3.0 && !target.m_21023_(MobEffects.f_19613_) && this.f_19796_.m_188501_() < 0.25f) {
                potion = Potions.f_43593_;
            }
            ThrownPotion thrownpotion = new ThrownPotion(this.f_19853_, (LivingEntity)this);
            thrownpotion.m_37446_(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)potion));
            thrownpotion.m_146926_(thrownpotion.m_146909_() - -20.0f);
            thrownpotion.m_6686_(d0, d1 + d3 * 0.2, d2, 0.75f, 8.0f);
            if (!this.m_20067_()) {
                this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12553_, this.m_5720_(), 1.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
            }
            this.f_19853_.m_7967_((Entity)thrownpotion);
        }
    }

    protected float m_6431_(Pose p_34146_, EntityDimensions p_34147_) {
        return 1.62f;
    }

    @Override
    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        Item item = itemstack.m_41720_();
        if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner() && item instanceof ArmorItem) {
            ArmorItem armor = (ArmorItem)item;
            ItemStack helmet = this.m_6844_(EquipmentSlot.HEAD);
            ItemStack chestplate = this.m_6844_(EquipmentSlot.CHEST);
            ItemStack legging = this.m_6844_(EquipmentSlot.LEGS);
            ItemStack boots = this.m_6844_(EquipmentSlot.FEET);
            this.m_5496_(SoundEvents.f_11675_, 1.0f, 1.0f);
            if (armor.m_266204_() == ArmorItem.Type.HELMET) {
                this.m_8061_(EquipmentSlot.HEAD, itemstack.m_255036_(1));
                this.dropEquipment(EquipmentSlot.HEAD, helmet);
                this.m_21508_(EquipmentSlot.HEAD);
            }
            if (armor.m_266204_() == ArmorItem.Type.CHESTPLATE) {
                this.m_8061_(EquipmentSlot.CHEST, itemstack.m_255036_(1));
                this.dropEquipment(EquipmentSlot.CHEST, chestplate);
                this.m_21508_(EquipmentSlot.CHEST);
            }
            if (armor.m_266204_() == ArmorItem.Type.LEGGINGS) {
                this.m_8061_(EquipmentSlot.LEGS, itemstack.m_255036_(1));
                this.dropEquipment(EquipmentSlot.LEGS, legging);
                this.m_21508_(EquipmentSlot.LEGS);
            }
            if (armor.m_266204_() == ArmorItem.Type.BOOTS) {
                this.m_8061_(EquipmentSlot.FEET, itemstack.m_255036_(1));
                this.dropEquipment(EquipmentSlot.FEET, boots);
                this.m_21508_(EquipmentSlot.FEET);
            }
            for (int i = 0; i < 7; ++i) {
                double d0 = this.f_19796_.m_188583_() * 0.02;
                double d1 = this.f_19796_.m_188583_() * 0.02;
                double d2 = this.f_19796_.m_188583_() * 0.02;
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
            }
            if (!pPlayer.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(pPlayer, pHand);
    }
}

