/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally;

import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ai.ModMeleeAttackGoal;
import com.Polarice3.Goety.common.entities.ai.SummonTargetGoal;
import com.Polarice3.Goety.common.entities.ally.BlackWolf;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.neutral.BeastHead;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.entities.projectiles.FlyingItem;
import com.Polarice3.Goety.common.entities.projectiles.SpellEntity;
import com.Polarice3.Goety.common.entities.util.CameraShake;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.items.magic.TaglockKit;
import com.Polarice3.Goety.common.items.revive.HowlingSoul;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.server.SPlayPlayerSoundPacket;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.config.MobsConfig;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModMobType;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.EntityFinder;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreakDoorGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlackBeast
extends Summoned {
    private static final EntityDataAccessor<Boolean> DATA_INTERESTED_ID = SynchedEntityData.m_135353_(BlackBeast.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(BlackBeast.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Optional<UUID>> PREY_ID = SynchedEntityData.m_135353_(BlackBeast.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    public static String IDLE = "idle";
    public static String ATTACK = "attack";
    public static String WALK = "walk";
    public static String ROAR = "roar";
    public static String TO_SIT = "to_sit";
    public static String TO_STAND = "to_stand";
    public static String SIT = "sit";
    public static String DEATH = "death";
    public boolean leftSwiped = true;
    private float interestedAngle;
    private float interestedAngleO;
    private int invisibleCool;
    public int attackTick;
    public int summonTick;
    private int summonCool;
    private int happyCool;
    private int headTick;
    private int pathFindTick;
    public int isSittingDown;
    public int isStandingUp;
    public int deathTime = 0;
    public float deathRotation = 0.0f;
    @Nullable
    public Path path;
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState walkAnimationState = new AnimationState();
    public AnimationState roarAnimationState = new AnimationState();
    public AnimationState toSitAnimationState = new AnimationState();
    public AnimationState toStandAnimationState = new AnimationState();
    public AnimationState sitAnimationState = new AnimationState();
    public AnimationState deathAnimationState = new AnimationState();

    public BlackBeast(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_POWDER_SNOW, -1.0f);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SummonGoal());
        this.f_21345_.m_25352_(1, (Goal)new HuntBreakDoorGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new ModMeleeAttackGoal(this, 1.2, false));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 140.0f));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 140.0f));
        this.f_21345_.m_25352_(5, new Summoned.WanderGoal<BlackBeast>(this, 0.8));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new BegGoal(this, 8.0f));
    }

    @Override
    public void targetSelectGoal() {
        this.f_21346_.m_25352_(1, (Goal)new SummonTargetGoal((Mob)this, false, true));
        this.f_21346_.m_25352_(5, new Summoned.NaturalAttackGoal<Animal>(this, Animal.class, false, BlackWolf.PREY_SELECTOR));
        this.f_21346_.m_25352_(6, new Summoned.NaturalAttackGoal<Turtle>(this, Turtle.class, false, Turtle.f_30122_));
        this.f_21346_.m_25352_(7, new Summoned.NaturalAttackGoal<AbstractSkeleton>(this, AbstractSkeleton.class, false));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.28).m_22268_(Attributes.f_22277_, 64.0).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 2.0).m_22268_(Attributes.f_22278_, 0.75).m_22268_(Attributes.f_22282_, 1.5).m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.BlackBeastHealth.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.BlackBeastArmor.get()).doubleValue()).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.BlackBeastDamage.get()).doubleValue());
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.BlackBeastHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.BlackBeastArmor.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.BlackBeastDamage.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_INTERESTED_ID, (Object)false);
        this.f_19804_.m_135372_(ANIM_STATE, (Object)0);
        this.f_19804_.m_135372_(PREY_ID, Optional.empty());
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        if (this.getPreyId() != null) {
            pCompound.m_128362_("Prey", this.getPreyId());
        }
        pCompound.m_128405_("InvisibleCool", this.invisibleCool);
        pCompound.m_128405_("SummonTick", this.summonTick);
        pCompound.m_128405_("SummonCool", this.summonCool);
        pCompound.m_128405_("HeadTick", this.headTick);
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("Prey")) {
            this.setPreyId(pCompound.m_128342_("Prey"));
        }
        if (pCompound.m_128441_("InvisibleCool")) {
            this.invisibleCool = pCompound.m_128451_("InvisibleCool");
        }
        if (pCompound.m_128441_("SummonTick")) {
            this.summonTick = pCompound.m_128451_("SummonTick");
        }
        if (pCompound.m_128441_("SummonCool")) {
            this.summonCool = pCompound.m_128451_("SummonCool");
        }
        if (pCompound.m_128441_("HeadTick")) {
            this.headTick = pCompound.m_128451_("HeadTick");
        }
    }

    @Override
    public Predicate<Entity> summonPredicate() {
        return entity -> entity instanceof BlackBeast;
    }

    @Override
    public int getSummonLimit(LivingEntity owner) {
        return (Integer)SpellConfig.BlackBeastLimit.get();
    }

    public boolean isPretty() {
        return this.m_7770_() != null && (this.m_7770_().getString().contains("Princess") || this.m_7770_().getString().contains("Cupcake"));
    }

    protected PathNavigation m_6037_(Level level) {
        return new BlackBeastNavigation((Mob)this, level);
    }

    @Nullable
    public LivingEntity getPrey() {
        UUID uuid = this.getPreyId();
        return uuid == null ? null : EntityFinder.getLivingEntityByUuiD(uuid);
    }

    @Nullable
    public UUID getPreyId() {
        return ((Optional)this.f_19804_.m_135370_(PREY_ID)).orElse(null);
    }

    public void setPreyId(@Nullable UUID p_184754_1_) {
        this.f_19804_.m_135381_(PREY_ID, Optional.ofNullable(p_184754_1_));
    }

    public void setPrey(@Nullable LivingEntity livingEntity) {
        if (livingEntity != null) {
            this.setPreyId(livingEntity.m_20148_());
        } else {
            this.setPreyId(null);
        }
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "idle")) {
            return 1;
        }
        if (Objects.equals(animation, "attack")) {
            return 2;
        }
        if (Objects.equals(animation, "walk")) {
            return 3;
        }
        if (Objects.equals(animation, "roar")) {
            return 4;
        }
        if (Objects.equals(animation, "to_sit")) {
            return 5;
        }
        if (Objects.equals(animation, "to_stand")) {
            return 6;
        }
        if (Objects.equals(animation, "sit")) {
            return 7;
        }
        if (Objects.equals(animation, "death")) {
            return 8;
        }
        return 0;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public void stopAllAnimation() {
        for (AnimationState state : this.getAnimations()) {
            state.m_216973_();
        }
    }

    public int getCurrentAnimation() {
        return (Integer)this.f_19804_.m_135370_(ANIM_STATE);
    }

    public void m_7350_(EntityDataAccessor<?> p_219422_) {
        if (ANIM_STATE.equals(p_219422_) && this.f_19853_.f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    break;
                }
                case 1: {
                    this.idleAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.idleAnimationState);
                    break;
                }
                case 2: {
                    this.stopAllAnimation();
                    this.attackAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 3: {
                    this.walkAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 4: {
                    this.roarAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.roarAnimationState);
                    break;
                }
                case 5: {
                    this.stopMostAnimation(this.toSitAnimationState);
                    this.toSitAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 6: {
                    this.stopMostAnimation(this.toStandAnimationState);
                    this.toStandAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 7: {
                    this.sitAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.sitAnimationState);
                    break;
                }
                case 8: {
                    this.deathAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.deathAnimationState);
                }
            }
        }
        super.m_7350_(p_219422_);
    }

    public List<AnimationState> getAnimations() {
        ArrayList<AnimationState> animationStates = new ArrayList<AnimationState>();
        animationStates.add(this.idleAnimationState);
        animationStates.add(this.attackAnimationState);
        animationStates.add(this.roarAnimationState);
        animationStates.add(this.toSitAnimationState);
        animationStates.add(this.toStandAnimationState);
        animationStates.add(this.sitAnimationState);
        animationStates.add(this.walkAnimationState);
        animationStates.add(this.deathAnimationState);
        return animationStates;
    }

    public MobType m_6336_() {
        return ModMobType.NATURAL;
    }

    protected float m_6108_() {
        return 0.98f;
    }

    public boolean isPushedByFluid(FluidType type) {
        return !this.m_6069_();
    }

    @Override
    public boolean canUpdateMove() {
        return true;
    }

    protected boolean m_6107_() {
        return super.m_6107_() || this.isSummoning();
    }

    public int m_8100_() {
        return 240;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.BLACK_BEAST_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource p_21239_) {
        return (SoundEvent)ModSounds.BLACK_BEAST_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.BLACK_BEAST_DEATH.get();
    }

    protected void m_7355_(BlockPos p_20135_, BlockState p_20136_) {
        this.m_5496_((SoundEvent)ModSounds.BLACK_BEAST_STEP.get(), 0.15f, 1.0f);
    }

    public boolean isSummoning() {
        return this.summonTick > 0;
    }

    public boolean isMeleeAttacking() {
        return this.attackTick > 0;
    }

    public void setIsInterested(boolean p_30445_) {
        this.f_19804_.m_135381_(DATA_INTERESTED_ID, (Object)p_30445_);
    }

    public boolean isInterested() {
        return (Boolean)this.f_19804_.m_135370_(DATA_INTERESTED_ID);
    }

    protected void m_6153_() {
        Object flyingItem;
        ++this.deathTime;
        if (this.deathTime == 40) {
            if (this.getTrueOwner() != null && ((Boolean)MobsConfig.BlackBeastHowlingSoul.get()).booleanValue()) {
                ItemStack itemStack = new ItemStack((ItemLike)ModItems.HOWLING_SOUL.get());
                HowlingSoul.setOwnerName(this.getTrueOwner(), itemStack);
                HowlingSoul.setSummon((Entity)this, itemStack);
                flyingItem = new FlyingItem((EntityType<? extends FlyingItem>)((EntityType)ModEntityType.FLYING_ITEM.get()), this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_());
                ((SpellEntity)((Object)flyingItem)).setOwner(this.getTrueOwner());
                ((FlyingItem)((Object)flyingItem)).setItem(itemStack);
                ((FlyingItem)((Object)flyingItem)).setParticle((ParticleOptions)ModParticleTypes.TOTEM_EFFECT.get());
                ((FlyingItem)((Object)flyingItem)).setSecondsCool(30);
                this.f_19853_.m_7967_((Entity)flyingItem);
            }
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
        if ((flyingItem = this.f_19853_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)flyingItem;
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.WRAITH.get()), this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.WRAITH_BURST.get()), this.m_20208_(1.0), this.m_20186_(), this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
        }
        this.m_146922_(this.deathRotation);
        this.m_5618_(this.deathRotation);
    }

    @Override
    public void m_6667_(DamageSource p_21014_) {
        this.setAnimationState(DEATH);
        this.deathRotation = this.m_146908_();
        if (this.getPrey() != null) {
            this.setPrey(null);
        }
        super.m_6667_(p_21014_);
    }

    public EntityDimensions m_6972_(Pose p_21047_) {
        if (p_21047_ == Pose.CROUCHING) {
            return super.m_6972_(p_21047_).m_20390_(1.0f, 0.5f);
        }
        return super.m_6972_(p_21047_);
    }

    public boolean m_142535_(float p_148711_, float p_148712_, DamageSource p_148713_) {
        return false;
    }

    public boolean canAnimateMove() {
        return !this.m_6107_();
    }

    @Override
    public boolean m_7301_(MobEffectInstance pPotioneffect) {
        return super.m_7301_(pPotioneffect) && pPotioneffect.m_19544_() != MobEffects.f_19615_;
    }

    @Nullable
    public Path findPath(double x, double y, double z) {
        return this.m_21573_().m_26524_(x, y, z, 0);
    }

    @Nullable
    public Path findPath(Vec3 position) {
        return this.findPath(position.m_7096_(), position.m_7098_(), position.m_7094_());
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_269533_(DamageTypeTags.f_268549_) || source.m_269533_(DamageTypeTags.f_268581_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268493_) || source.m_276093_(DamageTypes.f_268641_)) {
            return false;
        }
        if (source.m_7639_() instanceof Mob || source.m_7640_() instanceof AbstractArrow) {
            amount = (amount + 1.0f) / 2.0f;
        }
        if (this.m_21023_(MobEffects.f_19609_) && amount >= 1.0f) {
            this.m_21195_(MobEffects.f_19609_);
            Level level = this.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < 8; ++i) {
                    ColorUtil colorUtil = new ColorUtil(4073788);
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.BIG_CULT_SPELL.get()), this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 0, (double)colorUtil.red, (double)colorUtil.green, (double)colorUtil.blue, 0.5);
                }
            }
        }
        return super.m_6469_(source, amount);
    }

    @Override
    public boolean m_7327_(Entity entityIn) {
        boolean flag = super.m_7327_(entityIn);
        if (!this.f_19853_.f_46443_ && flag) {
            LivingEntity target;
            this.attackTick = 10;
            this.setAnimationState(ATTACK);
            this.f_19853_.m_7605_((Entity)this, (byte)101);
            this.m_5496_((SoundEvent)ModSounds.BLACK_BEAST_CLAW.get(), this.m_6121_(), this.m_6100_());
            if (entityIn instanceof LivingEntity && !(target = (LivingEntity)entityIn).m_21023_((MobEffect)GoetyEffects.DOOM.get()) && !MobUtil.isInSunlightNoRain((LivingEntity)this)) {
                int debuffDuration = MathHelper.secondsToTicks(15);
                int regenAmp = 2;
                if (((Boolean)MobsConfig.BlackBeastDayStrength.get()).booleanValue()) {
                    if (this.f_19853_.m_8044_() >= (long)MathHelper.minecraftDayToTicks(50)) {
                        ++regenAmp;
                    }
                    if (this.f_19853_.m_8044_() >= (long)MathHelper.minecraftDayToTicks(100)) {
                        ++regenAmp;
                    }
                }
                this.m_5496_((SoundEvent)ModSounds.BLACK_BEAST_ROAR.get(), this.m_6121_(), 0.25f);
                target.m_147207_(new MobEffectInstance((MobEffect)GoetyEffects.DOOM.get(), debuffDuration, 0, false, false), (Entity)this);
                target.m_147207_(new MobEffectInstance(MobEffects.f_19615_, debuffDuration, 1, false, false), (Entity)this);
                target.m_147207_(new MobEffectInstance((MobEffect)GoetyEffects.CURSED.get(), debuffDuration, 0, false, false), (Entity)this);
                this.m_147207_(new MobEffectInstance(MobEffects.f_19605_, MathHelper.secondsToTicks(5), regenAmp, false, false), (Entity)this);
            }
        }
        return flag;
    }

    @Override
    public void m_8119_() {
        boolean shouldCrouch;
        super.m_8119_();
        if (this.m_21224_()) {
            this.m_146922_(this.deathRotation);
            this.m_5618_(this.deathRotation);
        } else {
            this.interestedAngleO = this.interestedAngle;
            this.interestedAngle = this.isInterested() ? (this.interestedAngle += (1.0f - this.interestedAngle) * 0.4f) : (this.interestedAngle += (0.0f - this.interestedAngle) * 0.4f);
            if (this.happyCool > 0) {
                --this.happyCool;
            }
        }
        if (!this.f_19853_.m_5776_() && !this.m_21224_()) {
            Level resistAmp2;
            if (!this.isMeleeAttacking() && !this.isSummoning()) {
                if (this.isStaying()) {
                    this.isStandingUp = MathHelper.secondsToTicks(1);
                    if (this.isSittingDown > 0 && this.getCurrentAnimation() != this.getAnimationState(SIT)) {
                        --this.isSittingDown;
                        this.m_21573_().m_26573_();
                        this.setAnimationState(TO_SIT);
                    } else {
                        if (this.isSittingDown > 0) {
                            this.isSittingDown = 0;
                        }
                        this.setAnimationState(SIT);
                    }
                } else {
                    this.isSittingDown = MathHelper.secondsToTicks(1);
                    if (this.isStandingUp > 0 && this.f_19853_.m_8055_(this.m_20183_().m_7494_()).m_60795_()) {
                        --this.isStandingUp;
                        this.m_21573_().m_26573_();
                        this.setAnimationState(TO_STAND);
                    } else {
                        if (this.isStandingUp > 0) {
                            this.isStandingUp = 0;
                        }
                        if (!this.f_19853_.m_8055_(this.m_20183_().m_7494_()).m_60795_() && this.m_6047_() && !this.isMoving()) {
                            this.setAnimationState(SIT);
                        } else {
                            this.setAnimationState(IDLE);
                        }
                    }
                }
            }
            if (((Boolean)MobsConfig.BlackBeastDayStrength.get()).booleanValue()) {
                int boostAmp = 1;
                int resistAmp2 = 0;
                if (this.f_19853_.m_8044_() >= (long)MathHelper.minecraftDayToTicks(100)) {
                    boostAmp = 2;
                    resistAmp2 = 2;
                }
                if (this.f_19853_.m_8044_() >= (long)MathHelper.minecraftDayToTicks(50) && !MobUtil.isInSunlightNoRain((LivingEntity)this)) {
                    this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 20, boostAmp, false, false));
                    this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 20, resistAmp2, false, false));
                }
            }
            if (this.attackTick > 0) {
                --this.attackTick;
            }
            if (this.summonCool > 0) {
                --this.summonCool;
            }
            if (this.pathFindTick > 0) {
                --this.pathFindTick;
            }
            if (this.m_5448_() != null) {
                if (this.pathFindTick <= 0) {
                    this.path = this.findPath(this.m_5448_().m_20182_());
                    this.pathFindTick = 10;
                }
                if (!(!(this.m_5448_().m_20186_() > this.m_20186_()) || this.m_217066_(this.m_5448_()) || this.path != null && this.path.m_77403_())) {
                    this.beastHeadTick();
                }
            }
            if (this.summonTick > 0) {
                this.m_21573_().m_26573_();
                --this.summonTick;
            }
            if (this.summonTick == MathHelper.secondsToTicks(1.17f)) {
                CameraShake.cameraShake(this.f_19853_, this.m_20182_(), 10.0f, 0.1f, 0, 20);
                this.roar();
            }
            if (this.summonTick == MathHelper.secondsToTicks(1) && (resistAmp2 = this.f_19853_) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)resistAmp2;
                for (int i1 = 0; i1 < 3; ++i1) {
                    BlackWolf summonedentity = new BlackWolf((EntityType<? extends Owned>)((EntityType)ModEntityType.BLACK_WOLF.get()), (Level)serverLevel);
                    BlockPos blockPos = BlockFinder.SummonRadius(this.m_20183_(), (Entity)summonedentity, (Level)serverLevel);
                    summonedentity.setTrueOwner((LivingEntity)this);
                    summonedentity.m_20035_(blockPos, this.m_146908_(), this.m_146909_());
                    MobUtil.moveDownToGround((Entity)summonedentity);
                    summonedentity.m_21530_();
                    ((Summoned)summonedentity).m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(this.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                    if (this.getTrueOwner() != null) {
                        ((Summoned)summonedentity).setUpgraded(CuriosFinder.hasWildRobe(this.getTrueOwner()));
                    }
                    summonedentity.setLimitedLife(MobUtil.getSummonLifespan((Level)serverLevel));
                    summonedentity.m_21153_(summonedentity.m_21233_());
                    this.m_6710_(this.m_5448_());
                    serverLevel.m_7967_((Entity)summonedentity);
                }
            }
            if (this.getPrey() != null) {
                if (this.m_5448_() == null) {
                    if (EntitySelector.f_20406_.test(this.getPrey()) && MobUtil.sameDimension((Entity)this, (Entity)this.getPrey()) && this.f_19853_.m_46749_(this.getPrey().m_20183_())) {
                        this.m_6710_(this.getPrey());
                    }
                } else if (this.m_5448_() == this.getPrey() && (double)this.m_5448_().m_20270_((Entity)this) > 64.0 && MobUtil.sameDimension((Entity)this, (Entity)this.getPrey())) {
                    this.teleportTowards((Entity)this.getPrey());
                }
                if (this.getTrueOwner() != null && (MobUtil.areAllies((Entity)this.getPrey(), (Entity)this.getTrueOwner()) || this.getPrey().m_21224_())) {
                    if ((double)this.getTrueOwner().m_20270_((Entity)this) > 32.0 && MobUtil.sameDimension((Entity)this, (Entity)this.getTrueOwner())) {
                        this.teleportTowards((Entity)this.getTrueOwner());
                    }
                    if (this.getPrey() != null) {
                        this.setPrey(null);
                    }
                }
            }
        }
        boolean bl = shouldCrouch = !this.f_19853_.m_8055_(this.m_20183_().m_7494_().m_121945_(this.m_6350_())).m_60795_() && this.f_19853_.m_8055_(this.m_20183_().m_121945_(this.m_6350_())).m_60795_();
        if (!shouldCrouch && !this.m_5830_()) {
            this.m_20124_(Pose.STANDING);
        } else {
            this.m_20124_(Pose.CROUCHING);
        }
    }

    public void beastHeadTick() {
        ++this.headTick;
        float lifePercent = this.m_21223_() / this.m_21233_();
        int i0 = (int)Mth.m_14179_((float)lifePercent, (float)40.0f, (float)80.0f);
        int i1 = this.headTick / i0;
        if (i1 >= 1) {
            this.headTick = 0;
            this.spawnBeastHead();
        }
    }

    public void spawnBeastHead() {
        if (this.m_5448_() == null) {
            return;
        }
        BeastHead beastHead = new BeastHead((EntityType<? extends Owned>)((EntityType)ModEntityType.BEAST_HEAD.get()), this.f_19853_, this.m_5448_());
        beastHead.setTrueOwner((LivingEntity)this);
        beastHead.m_6710_(this.m_5448_());
        Vec3 vec3 = this.m_5448_().m_20182_().m_272010_(this.f_19796_, 8.0f);
        for (int i = 0; i < 16 && (this.m_5448_().m_20238_(vec3) <= (double)Mth.m_14207_((float)3.0f) || !MobUtil.canPositionBeSeen(this.f_19853_, this.m_5448_(), vec3)); ++i) {
            vec3 = this.m_5448_().m_20182_().m_272010_(this.f_19796_, 8.0f);
        }
        beastHead.m_20219_(vec3);
        MobUtil.instaLook((Mob)beastHead, (Entity)this.m_5448_());
        this.f_19853_.m_7967_((Entity)beastHead);
    }

    @Override
    public void teleportHits() {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int i = 8;
            for (int j = 0; j < i; ++j) {
                double d0 = (double)j / 7.0;
                ColorUtil colorUtil = new ColorUtil(4073788);
                double d1 = Mth.m_14139_((double)d0, (double)this.f_19854_, (double)this.m_20185_()) + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_() * 2.0;
                double d2 = Mth.m_14139_((double)d0, (double)this.f_19855_, (double)this.m_20186_()) + this.f_19796_.m_188500_() * (double)this.m_20206_();
                double d3 = Mth.m_14139_((double)d0, (double)this.f_19856_, (double)this.m_20189_()) + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_() * 2.0;
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.BIG_CULT_SPELL.get()), d1, d2, d3, 0, (double)colorUtil.red(), (double)colorUtil.green(), (double)colorUtil.blue(), 0.5);
            }
        }
    }

    @Override
    public void mobSense() {
        block3: {
            LivingEntity livingEntity;
            Mob mob;
            block4: {
                block5: {
                    block6: {
                        if (!((Boolean)MobsConfig.MobSense.get()).booleanValue() || !this.m_6084_() || this.m_5448_() == null) break block3;
                        if (this.m_20145_()) break block4;
                        if (this.invisibleCool <= 0) break block5;
                        LivingEntity livingEntity2 = this.m_5448_();
                        if (!(livingEntity2 instanceof Mob)) break block4;
                        mob = (Mob)livingEntity2;
                        LivingEntity livingEntity3 = this.m_5448_();
                        if (!(livingEntity3 instanceof Animal)) break block6;
                        Animal animal = (Animal)livingEntity3;
                        animal.m_6703_((LivingEntity)this);
                        break block4;
                    }
                    if (mob.m_5448_() != null && !mob.m_5448_().m_21224_()) break block4;
                    mob.m_6710_((LivingEntity)this);
                    break block4;
                }
                this.m_7292_(new MobEffectInstance(MobEffects.f_19609_, MathHelper.secondsToTicks(30), 0, false, false));
                this.invisibleCool = MathHelper.secondsToTicks(30);
                Level animal = this.f_19853_;
                if (animal instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)animal;
                    for (int i = 0; i < 8; ++i) {
                        ColorUtil colorUtil = new ColorUtil(4073788);
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.BIG_CULT_SPELL.get()), this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 0, (double)colorUtil.red, (double)colorUtil.green, (double)colorUtil.blue, 0.5);
                    }
                }
            }
            if ((livingEntity = this.m_5448_()) instanceof Mob && (mob = (Mob)livingEntity).m_6095_().m_20675_().contains("nightmare_stalker")) {
                mob.m_6710_((LivingEntity)this);
            }
        }
    }

    private void roar() {
        if (this.m_6084_()) {
            for (LivingEntity livingentity : this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_().m_82400_(4.0), target -> target.m_6084_() && target instanceof BlackBeast)) {
                if (MobUtil.areAllies((Entity)this, (Entity)livingentity)) continue;
                this.strongKnockback((Entity)livingentity);
            }
            Vec3 vec3 = this.m_20191_().m_82399_();
            for (int i = 0; i < 40; ++i) {
                double d0 = this.f_19796_.m_188583_() * 0.2;
                double d1 = this.f_19796_.m_188583_() * 0.2;
                double d2 = this.f_19796_.m_188583_() * 0.2;
                Level level = this.f_19853_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123759_, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0, d0, d1, d2, 0.5);
                    continue;
                }
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123759_, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, d0, d1, d2);
            }
            this.m_146850_(GameEvent.f_223709_);
        }
    }

    private void strongKnockback(Entity p_33340_) {
        double d0 = p_33340_.m_20185_() - this.m_20185_();
        double d1 = p_33340_.m_20189_() - this.m_20189_();
        double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
        MobUtil.push(p_33340_, d0 / d2 * 6.0, 0.4, d1 / d2 * 6.0);
    }

    public float getHeadRollAngle(float p_30449_) {
        return Mth.m_14179_((float)p_30449_, (float)this.interestedAngleO, (float)this.interestedAngle) * 0.15f * (float)Math.PI;
    }

    public boolean isFood(ItemStack p_30440_) {
        Item item = p_30440_.m_41720_();
        return item.m_41472_() && p_30440_.getFoodProperties((LivingEntity)this).m_38746_();
    }

    @Override
    public void tryKill(Player player) {
        if (this.killChance <= 0) {
            this.warnKill(player);
        } else {
            super.tryKill(player);
        }
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner()) {
            if (this.isFood(itemstack) && this.m_21223_() < this.m_21233_()) {
                FoodProperties foodProperties = itemstack.getFoodProperties((LivingEntity)this);
                if (foodProperties != null) {
                    this.m_5634_(foodProperties.m_38744_());
                    if (!pPlayer.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    this.m_146852_(GameEvent.f_157806_, (Entity)this);
                    this.m_5584_(this.f_19853_, itemstack);
                    Level level = this.f_19853_;
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        for (int i = 0; i < 7; ++i) {
                            double d0 = this.f_19796_.m_188583_() * 0.02;
                            double d1 = this.f_19796_.m_188583_() * 0.02;
                            double d2 = this.f_19796_.m_188583_() * 0.02;
                            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.HEAL_EFFECT.get()), this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                        }
                    }
                    pPlayer.m_6674_(pHand);
                    return InteractionResult.SUCCESS;
                }
            } else {
                if (pPlayer.m_21205_().m_41720_() instanceof TaglockKit && TaglockKit.hasEntity(pPlayer.m_21205_()) && !MobUtil.areAllies((Entity)pPlayer, (Entity)TaglockKit.getEntity(pPlayer.m_21205_()))) {
                    ServerPlayer player;
                    LivingEntity livingEntity;
                    this.setPrey(TaglockKit.getEntity(pPlayer.m_21205_()));
                    this.m_6710_(this.getPrey());
                    if (!pPlayer.m_150110_().f_35937_) {
                        TaglockKit.removeEntity(pPlayer.m_21205_());
                    }
                    if (!this.f_19853_.f_46443_ && (livingEntity = this.getPrey()) instanceof ServerPlayer && CuriosFinder.hasCurio((LivingEntity)(player = (ServerPlayer)livingEntity), (Item)ModItems.ALARMING_CHARM.get())) {
                        player.m_5661_((Component)Component.m_237115_((String)"info.goety.summon.hunt").m_130940_(ChatFormatting.RED), true);
                        ModNetwork.sendToClient(player, new SPlayPlayerSoundPacket(SoundEvents.f_12620_, 3.0f, 0.5f));
                    }
                    if (MobUtil.sameDimension((Entity)this, (Entity)this.getPrey())) {
                        this.teleportTowards((Entity)this.getPrey());
                    }
                    if (this.isStaying()) {
                        this.setStaying(false);
                    }
                    if (this.isGuardingArea()) {
                        this.setBoundPos(null);
                    }
                    return InteractionResult.SUCCESS;
                }
                if (pPlayer.m_21205_().m_41619_() && this.happyCool <= 0) {
                    this.happyCool = 40;
                    this.f_19853_.m_7605_((Entity)this, (byte)102);
                    this.m_5496_(SoundEvents.f_12617_, 1.0f, 0.5f);
                    this.m_5634_(1.0f);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public void m_7822_(byte pId) {
        if (pId == 101) {
            this.leftSwiped = !this.leftSwiped;
        } else if (pId == 102) {
            this.happyCool = 40;
            this.m_5496_(SoundEvents.f_12617_, 1.0f, 0.5f);
            this.addParticlesAroundSelf((ParticleOptions)ParticleTypes.f_123750_);
        } else {
            super.m_7822_(pId);
        }
    }

    protected void addParticlesAroundSelf(ParticleOptions pParticleData) {
        for (int i = 0; i < 5; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.f_19853_.m_7106_(pParticleData, this.m_20208_(1.0), this.m_20187_() + 1.0, this.m_20262_(1.0), d0, d1, d2);
        }
    }

    class SummonGoal
    extends Goal {
        public SummonGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            List list = BlackBeast.this.f_19853_.m_6443_(BlackWolf.class, BlackBeast.this.m_20191_().m_82400_(32.0), blackWolf -> blackWolf.getTrueOwner() == BlackBeast.this);
            if (BlackBeast.this.m_5448_() != null && BlackBeast.this.m_142582_((Entity)BlackBeast.this.m_5448_()) && BlackBeast.this.summonCool <= 0 && !BlackBeast.this.m_20145_() && !BlackBeast.this.m_6047_() && list.size() < 3) {
                return BlackBeast.this.f_19796_.m_188503_(100) == 0;
            }
            return false;
        }

        public void m_8056_() {
            super.m_8056_();
            BlackBeast.this.summonTick = MathHelper.secondsToTicks(1.5f);
            BlackBeast.this.summonCool = MathHelper.secondsToTicks(10);
            BlackBeast.this.setAnimationState(ROAR);
            BlackBeast.this.m_5496_((SoundEvent)ModSounds.BLACK_BEAST_ROAR.get(), BlackBeast.this.m_6121_() + 2.0f, BlackBeast.this.m_6100_());
        }
    }

    static class HuntBreakDoorGoal
    extends BreakDoorGoal {
        public HuntBreakDoorGoal(Mob p_34112_) {
            super(p_34112_, 6, difficulty -> difficulty != Difficulty.PEACEFUL);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            BlackBeast blackBeast = (BlackBeast)this.f_25189_;
            return blackBeast.getPrey() != null && blackBeast.m_5448_() == blackBeast.getPrey() && blackBeast.f_19796_.m_188503_(HuntBreakDoorGoal.m_186073_((int)10)) == 0 && super.m_8036_();
        }

        public boolean m_8045_() {
            BlackBeast blackBeast = (BlackBeast)this.f_25189_;
            return blackBeast.getPrey() != null && blackBeast.m_5448_() == blackBeast.getPrey() && super.m_8045_();
        }

        public void m_8056_() {
            super.m_8056_();
            this.f_25189_.m_21310_(0);
        }
    }

    public static class BegGoal
    extends Goal {
        private final BlackBeast wolf;
        private final float lookDistance;
        private int lookTime;

        public BegGoal(BlackBeast p_25063_, float p_25064_) {
            this.wolf = p_25063_;
            this.lookDistance = p_25064_;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.wolf.m_5448_() == null && !this.wolf.isMeleeAttacking() && !this.wolf.isSummoning() && this.wolf.getTrueOwner() != null && this.playerHoldingInteresting(this.wolf.getTrueOwner());
        }

        public boolean m_8045_() {
            if (this.wolf.m_5448_() != null || this.wolf.isMeleeAttacking() || this.wolf.isSummoning()) {
                return false;
            }
            if (this.wolf.getTrueOwner() == null || !this.wolf.getTrueOwner().m_6084_()) {
                return false;
            }
            if (this.wolf.m_20280_((Entity)this.wolf.getTrueOwner()) > (double)(this.lookDistance * this.lookDistance)) {
                return false;
            }
            return this.lookTime > 0 && this.playerHoldingInteresting(this.wolf.getTrueOwner());
        }

        public void m_8056_() {
            this.wolf.setIsInterested(true);
            this.lookTime = this.m_183277_(40 + this.wolf.m_217043_().m_188503_(40));
        }

        public void m_8041_() {
            this.wolf.setIsInterested(false);
        }

        public void m_8037_() {
            this.wolf.m_21563_().m_24950_(this.wolf.getTrueOwner().m_20185_(), this.wolf.getTrueOwner().m_20188_(), this.wolf.getTrueOwner().m_20189_(), 10.0f, (float)this.wolf.m_8132_());
            --this.lookTime;
        }

        private boolean playerHoldingInteresting(LivingEntity p_25067_) {
            for (InteractionHand interactionhand : InteractionHand.values()) {
                ItemStack itemstack = p_25067_.m_21120_(interactionhand);
                if (!this.wolf.isFood(itemstack)) continue;
                return true;
            }
            return false;
        }
    }

    static class BlackBeastNavigation
    extends GroundPathNavigation {
        public BlackBeastNavigation(Mob p_33379_, Level p_33380_) {
            super(p_33379_, p_33380_);
        }

        @NotNull
        protected PathFinder m_5532_(int p_33382_) {
            this.f_26508_ = new BlackBeastNodeEvaluator();
            this.f_26508_.m_77351_(true);
            return new PathFinder(this.f_26508_, p_33382_);
        }
    }

    static class BlackBeastNodeEvaluator
    extends WalkNodeEvaluator {
        BlackBeastNodeEvaluator() {
        }

        public void m_6028_(PathNavigationRegion region, Mob mob) {
            super.m_6028_(region, mob);
            this.f_77315_ = Mth.m_14143_((float)(mob.m_20205_() + 1.0f));
            this.f_77316_ = Mth.m_14143_((float)1.0f);
            this.f_77317_ = Mth.m_14143_((float)(mob.m_20205_() + 1.0f));
        }
    }
}

