/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally;

import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.BlockPathTypes;

public abstract class AnimalSummon
extends Summoned {
    private static final EntityDataAccessor<Boolean> DATA_BABY_ID = SynchedEntityData.m_135353_(AnimalSummon.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected int age;
    protected int forcedAge;
    protected int forcedAgeTimer;
    private int inLove;
    @Nullable
    private UUID loveCause;

    public AnimalSummon(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 16.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_BABY_ID, (Object)false);
    }

    public boolean canBreed() {
        return false;
    }

    public int getAge() {
        if (this.m_9236_().f_46443_) {
            return (Boolean)this.f_19804_.m_135370_(DATA_BABY_ID) != false ? -1 : 1;
        }
        return this.age;
    }

    public void ageUp(int p_146741_, boolean p_146742_) {
        int i = this.getAge();
        if ((i += p_146741_ * 20) > 0) {
            i = 0;
        }
        int j = i - i;
        this.setAge(i);
        if (p_146742_) {
            this.forcedAge += j;
            if (this.forcedAgeTimer == 0) {
                this.forcedAgeTimer = 40;
            }
        }
        if (this.getAge() == 0) {
            this.setAge(this.forcedAge);
        }
    }

    public void ageUp(int p_146759_) {
        this.ageUp(p_146759_, false);
    }

    public void setAge(int p_146763_) {
        int i = this.getAge();
        this.age = p_146763_;
        if (i < 0 && p_146763_ >= 0 || i >= 0 && p_146763_ < 0) {
            this.f_19804_.m_135381_(DATA_BABY_ID, (Object)(p_146763_ < 0 ? 1 : 0));
            this.ageBoundaryReached();
        }
    }

    @Nullable
    public AnimalSummon getBreedOffspring(ServerLevel p_146743_, AnimalSummon p_146744_) {
        Entity entity = this.m_6095_().m_20615_((Level)p_146743_);
        if (entity instanceof AnimalSummon) {
            AnimalSummon animalSummon = (AnimalSummon)entity;
            if (this.isUpgraded() || p_146744_.isUpgraded()) {
                animalSummon.setUpgraded(true);
            }
            return animalSummon;
        }
        return null;
    }

    protected void m_8024_() {
        if (this.getAge() != 0) {
            this.inLove = 0;
        }
        super.m_8024_();
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.m_9236_().f_46443_) {
            if (this.forcedAgeTimer > 0) {
                if (this.forcedAgeTimer % 4 == 0) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0.0, 0.0, 0.0);
                }
                --this.forcedAgeTimer;
            }
        } else if (this.m_6084_()) {
            int i = this.getAge();
            if (i < 0) {
                this.setAge(++i);
            } else if (i > 0) {
                this.setAge(--i);
            }
        }
        if (this.getAge() != 0) {
            this.inLove = 0;
        }
        if (this.inLove > 0) {
            --this.inLove;
            if (this.inLove % 10 == 0) {
                double d0 = this.f_19796_.m_188583_() * 0.02;
                double d1 = this.f_19796_.m_188583_() * 0.02;
                double d2 = this.f_19796_.m_188583_() * 0.02;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
            }
        }
    }

    protected void ageBoundaryReached() {
        Boat boat;
        Entity entity;
        if (!this.m_6162_() && this.m_20159_() && (entity = this.m_20202_()) instanceof Boat && !(boat = (Boat)entity).m_271938_((Entity)this)) {
            this.m_8127_();
        }
    }

    public boolean m_6162_() {
        return this.getAge() < 0;
    }

    public void m_6863_(boolean p_146756_) {
        this.setAge(p_146756_ ? -24000 : 0);
    }

    public static int getSpeedUpSecondsWhenFeeding(int p_216968_) {
        return (int)((float)(p_216968_ / 20) * 0.1f);
    }

    @Override
    public boolean m_6469_(DamageSource p_27567_, float p_27568_) {
        if (this.m_6673_(p_27567_)) {
            return false;
        }
        this.inLove = 0;
        return super.m_6469_(p_27567_, p_27568_);
    }

    public float m_5610_(BlockPos p_27573_, LevelReader p_27574_) {
        return p_27574_.m_8055_(p_27573_.m_7495_()).m_60713_(Blocks.f_50440_) ? 10.0f : p_27574_.m_220419_(p_27573_);
    }

    @Override
    public void m_7380_(CompoundTag p_27587_) {
        super.m_7380_(p_27587_);
        p_27587_.m_128405_("Age", this.getAge());
        p_27587_.m_128405_("ForcedAge", this.forcedAge);
        p_27587_.m_128405_("InLove", this.inLove);
        if (this.loveCause != null) {
            p_27587_.m_128362_("LoveCause", this.loveCause);
        }
    }

    public double m_6049_() {
        return 0.14;
    }

    @Override
    public void m_7378_(CompoundTag p_27576_) {
        super.m_7378_(p_27576_);
        this.setAge(p_27576_.m_128451_("Age"));
        this.forcedAge = p_27576_.m_128451_("ForcedAge");
        this.inLove = p_27576_.m_128451_("InLove");
        this.loveCause = p_27576_.m_128403_("LoveCause") ? p_27576_.m_128342_("LoveCause") : null;
    }

    public void m_7350_(EntityDataAccessor<?> p_146754_) {
        if (DATA_BABY_ID.equals(p_146754_)) {
            this.m_6210_();
        }
        super.m_7350_(p_146754_);
    }

    public int m_8100_() {
        return 120;
    }

    @Override
    public boolean m_6785_(double p_27598_) {
        return false;
    }

    @Override
    public int m_213860_() {
        return 1 + this.m_9236_().f_46441_.m_188503_(3);
    }

    public boolean isFood(ItemStack p_27600_) {
        return p_27600_.m_150930_(Items.f_42405_);
    }

    public InteractionResult m_6071_(Player p_27584_, InteractionHand p_27585_) {
        ItemStack itemstack = p_27584_.m_21120_(p_27585_);
        if (this.getTrueOwner() != null && p_27584_ == this.getTrueOwner() && this.isFood(itemstack)) {
            int i = this.getAge();
            if (!this.f_19853_.f_46443_ && i == 0 && this.canFallInLove()) {
                this.usePlayerItem(p_27584_, p_27585_, itemstack);
                this.setInLove(p_27584_);
                return InteractionResult.SUCCESS;
            }
            if (this.m_6162_()) {
                this.usePlayerItem(p_27584_, p_27585_, itemstack);
                this.ageUp(AnimalSummon.getSpeedUpSecondsWhenFeeding(-i), true);
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
            if (this.f_19853_.f_46443_) {
                return InteractionResult.CONSUME;
            }
        }
        return super.m_6071_(p_27584_, p_27585_);
    }

    protected void usePlayerItem(Player p_148715_, InteractionHand p_148716_, ItemStack p_148717_) {
        if (!p_148715_.m_150110_().f_35937_) {
            p_148717_.m_41774_(1);
        }
    }

    public boolean canFallInLove() {
        return this.inLove <= 0 && !this.limitedLifespan && this.limitedLifeTicks <= 0;
    }

    public void setInLove(@Nullable Player p_27596_) {
        if (!this.limitedLifespan && this.limitedLifeTicks <= 0) {
            this.inLove = 600;
            if (p_27596_ != null) {
                this.loveCause = p_27596_.m_20148_();
            }
            this.m_9236_().m_7605_((Entity)this, (byte)18);
        }
    }

    public void setInLoveTime(int p_27602_) {
        this.inLove = p_27602_;
    }

    public int getInLoveTime() {
        return this.inLove;
    }

    @Nullable
    public ServerPlayer getLoveCause() {
        if (this.loveCause == null) {
            return null;
        }
        Player player = this.m_9236_().m_46003_(this.loveCause);
        return player instanceof ServerPlayer ? (ServerPlayer)player : null;
    }

    public boolean isInLove() {
        return this.inLove > 0;
    }

    public void resetLove() {
        this.inLove = 0;
    }

    public boolean canMate(AnimalSummon p_27569_) {
        if (p_27569_ == this) {
            return false;
        }
        if (p_27569_.getClass() != this.getClass()) {
            return false;
        }
        return this.isInLove() && p_27569_.isInLove();
    }

    public void spawnChildFromBreeding(ServerLevel p_27564_, AnimalSummon p_27565_) {
        AnimalSummon ageablemob = this.getBreedOffspring(p_27564_, p_27565_);
        if (ageablemob != null) {
            ageablemob.m_6863_(true);
            ageablemob.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
            if (this.getTrueOwner() != null) {
                ageablemob.setTrueOwner(this.getTrueOwner());
            }
            this.finalizeSpawnChildFromBreeding(p_27564_, p_27565_, ageablemob);
            p_27564_.m_47205_((Entity)ageablemob);
        }
    }

    public void finalizeSpawnChildFromBreeding(ServerLevel p_277963_, AnimalSummon p_277357_, @Nullable AnimalSummon p_277516_) {
        Optional.ofNullable(this.getLoveCause()).or(() -> Optional.ofNullable(p_277357_.getLoveCause())).ifPresent(p_277486_ -> p_277486_.m_36220_(Stats.f_12937_));
        this.setAge(6000);
        p_277357_.setAge(6000);
        this.resetLove();
        p_277357_.resetLove();
        p_277963_.m_7605_((Entity)this, (byte)18);
        if (p_277963_.m_46469_().m_46207_(GameRules.f_46135_)) {
            p_277963_.m_7967_((Entity)new ExperienceOrb((Level)p_277963_, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_217043_().m_188503_(7) + 1));
        }
    }

    public void m_7822_(byte p_27562_) {
        if (p_27562_ == 18) {
            for (int i = 0; i < 7; ++i) {
                double d0 = this.f_19796_.m_188583_() * 0.02;
                double d1 = this.f_19796_.m_188583_() * 0.02;
                double d2 = this.f_19796_.m_188583_() * 0.02;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
            }
        } else {
            super.m_7822_(p_27562_);
        }
    }

    public static class BreedGoal
    extends Goal {
        private static final TargetingConditions PARTNER_TARGETING = TargetingConditions.m_148353_().m_26883_(8.0).m_148355_();
        protected final AnimalSummon animal;
        private final Class<? extends AnimalSummon> partnerClass;
        protected final Level level;
        @Nullable
        protected AnimalSummon partner;
        private int loveTime;
        private final double speedModifier;

        public BreedGoal(AnimalSummon p_25122_, double p_25123_) {
            this(p_25122_, p_25123_, p_25122_.getClass());
        }

        public BreedGoal(AnimalSummon p_25125_, double p_25126_, Class<? extends AnimalSummon> p_25127_) {
            this.animal = p_25125_;
            this.level = p_25125_.m_9236_();
            this.partnerClass = p_25127_;
            this.speedModifier = p_25126_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (!this.animal.isInLove()) {
                return false;
            }
            this.partner = this.getFreePartner();
            return this.partner != null;
        }

        public boolean m_8045_() {
            return this.partner != null && this.partner.m_6084_() && this.partner.isInLove() && this.loveTime < 60;
        }

        public void m_8041_() {
            this.partner = null;
            this.loveTime = 0;
        }

        public void m_8037_() {
            this.animal.m_21563_().m_24960_((Entity)this.partner, 10.0f, (float)this.animal.m_8132_());
            this.animal.m_21573_().m_5624_((Entity)this.partner, this.speedModifier);
            ++this.loveTime;
            if (this.loveTime >= this.m_183277_(60) && this.animal.m_20280_((Entity)this.partner) < 9.0) {
                this.breed();
            }
        }

        @Nullable
        private AnimalSummon getFreePartner() {
            List list = this.level.m_45971_(this.partnerClass, PARTNER_TARGETING, (LivingEntity)this.animal, this.animal.m_20191_().m_82400_(8.0));
            double d0 = Double.MAX_VALUE;
            AnimalSummon animal = null;
            for (AnimalSummon animal1 : list) {
                if (!this.animal.canMate(animal1) || !(this.animal.m_20280_((Entity)animal1) < d0)) continue;
                animal = animal1;
                d0 = this.animal.m_20280_((Entity)animal1);
            }
            return animal;
        }

        protected void breed() {
            this.animal.spawnChildFromBreeding((ServerLevel)this.level, this.partner);
        }
    }
}

