/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ai;

import com.Polarice3.Goety.utils.CrossbowHelper;
import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.NodeEvaluator;

public class BackawayCrossbowGoal<T extends PathfinderMob & CrossbowAttackMob>
extends Goal {
    private final T mob;
    private CrossbowState crossbowState = CrossbowState.UNCHARGED;
    private final double speedModifier;
    private final float attackRadiusSqr;
    private int seeTime;
    private int attackDelay;

    public BackawayCrossbowGoal(T p_i50322_1_, double p_i50322_2_, float p_i50322_4_) {
        this.mob = p_i50322_1_;
        this.speedModifier = p_i50322_2_;
        this.attackRadiusSqr = p_i50322_4_ * p_i50322_4_;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.isValidTarget() && this.isHoldingCrossbow();
    }

    private boolean isHoldingCrossbow() {
        return this.mob.m_21093_(is -> is.m_41720_() instanceof CrossbowItem);
    }

    public boolean m_8045_() {
        return this.isValidTarget() && (this.m_8036_() || !this.mob.m_21573_().m_26571_()) && this.isHoldingCrossbow();
    }

    private boolean isValidTarget() {
        return this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_();
    }

    public void m_8056_() {
        super.m_8056_();
        this.mob.m_21561_(true);
    }

    public void m_8041_() {
        super.m_8041_();
        this.mob.m_21561_(false);
        this.mob.m_6710_((LivingEntity)null);
        this.seeTime = 0;
        if (this.mob.m_6117_()) {
            this.mob.m_5810_();
            ((CrossbowAttackMob)this.mob).m_6136_(false);
            CrossbowItem.m_40884_((ItemStack)this.mob.m_21211_(), (boolean)false);
        }
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        LivingEntity livingentity = this.mob.m_5448_();
        if (livingentity != null) {
            boolean shouldMoveTowardsEnemy;
            boolean canSeeEnemy = this.mob.m_21574_().m_148306_((Entity)livingentity);
            this.seeTime = canSeeEnemy ? ++this.seeTime : 0;
            double distanceSq = this.mob.m_20280_((Entity)livingentity);
            double distance = Mth.m_14116_((float)((float)distanceSq));
            if ((distance <= 5.0 || this.hasFirework()) && this.isWalkable()) {
                this.mob.m_21566_().m_24988_(this.mob.m_6117_() ? -0.5f : -3.0f, 0.0f);
            }
            ItemStack activeStack = this.mob.m_21211_();
            boolean isCloseToAttack = distanceSq <= (double)this.attackRadiusSqr;
            boolean bl = shouldMoveTowardsEnemy = !isCloseToAttack || this.seeTime < 5;
            if (shouldMoveTowardsEnemy) {
                double speedChange = this.isCrossbowUncharged() ? this.speedModifier : this.speedModifier * 0.5;
                this.mob.m_21573_().m_5624_((Entity)livingentity, speedChange);
            } else {
                this.mob.m_21573_().m_26573_();
            }
            this.mob.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
            if (this.crossbowState == CrossbowState.UNCHARGED && !CrossbowItem.m_40932_((ItemStack)activeStack)) {
                if (canSeeEnemy) {
                    this.mob.m_6672_(ProjectileUtil.getWeaponHoldingHand(this.mob, item -> item instanceof CrossbowItem));
                    this.crossbowState = CrossbowState.CHARGING;
                    ((CrossbowAttackMob)this.mob).m_6136_(true);
                }
            } else if (this.crossbowState == CrossbowState.CHARGING) {
                int i;
                if (!this.mob.m_6117_()) {
                    this.crossbowState = CrossbowState.UNCHARGED;
                }
                if ((i = this.mob.m_21252_()) >= CrossbowItem.m_40939_((ItemStack)activeStack) || CrossbowItem.m_40932_((ItemStack)activeStack)) {
                    this.mob.m_21253_();
                    this.crossbowState = CrossbowState.CHARGED;
                    this.attackDelay = 20 + this.mob.m_217043_().m_188503_(20);
                    if (this.mob.m_21206_().m_41720_() instanceof FireworkRocketItem) {
                        this.mob.m_6672_(InteractionHand.OFF_HAND);
                    }
                    ((CrossbowAttackMob)this.mob).m_6136_(false);
                }
            } else if (this.crossbowState == CrossbowState.CHARGED) {
                --this.attackDelay;
                if (this.attackDelay == 0) {
                    this.crossbowState = CrossbowState.READY_TO_ATTACK;
                }
            } else if (this.crossbowState == CrossbowState.READY_TO_ATTACK && canSeeEnemy) {
                ((RangedAttackMob)this.mob).m_6504_(livingentity, 1.0f);
                CrossbowItem.m_40884_((ItemStack)this.mob.m_21120_(ProjectileUtil.getWeaponHoldingHand(this.mob, item -> item instanceof CrossbowItem)), (boolean)false);
                this.crossbowState = CrossbowState.UNCHARGED;
            }
        }
    }

    private boolean isWalkable() {
        PathNavigation pathnavigator = this.mob.m_21573_();
        NodeEvaluator nodeprocessor = pathnavigator.m_26575_();
        return nodeprocessor.m_8086_((BlockGetter)this.mob.m_9236_(), Mth.m_14107_((double)(this.mob.m_20185_() + 1.0)), Mth.m_14107_((double)this.mob.m_20186_()), Mth.m_14107_((double)(this.mob.m_20189_() + 1.0))) == BlockPathTypes.WALKABLE;
    }

    private boolean isCrossbowUncharged() {
        return this.crossbowState == CrossbowState.UNCHARGED;
    }

    private boolean hasFirework() {
        if (this.mob.m_6298_(this.mob.m_21211_()).m_41720_() == Items.f_42688_) {
            return true;
        }
        if (this.mob.m_21206_().m_41720_() == Items.f_42688_) {
            return true;
        }
        for (ItemStack projectileStack : CrossbowHelper.getChargedProjectiles(this.mob.m_21120_(ProjectileUtil.getWeaponHoldingHand(this.mob, item -> item instanceof CrossbowItem)))) {
            if (projectileStack.m_41720_() != Items.f_42688_) continue;
            return true;
        }
        return false;
    }

    static enum CrossbowState {
        UNCHARGED,
        CHARGING,
        CHARGED,
        READY_TO_ATTACK;

    }
}

