/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.effects.brew.block;

import com.Polarice3.Goety.common.effects.brew.BrewEffect;
import com.Polarice3.Goety.common.events.TimedEvents;
import com.Polarice3.Goety.utils.BlockFinder;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class ChopTreeBlockEffect
extends BrewEffect {
    public ChopTreeBlockEffect() {
        super("chop_tree", MobEffectCategory.NEUTRAL, 6967847);
    }

    @Override
    public void applyBlockEffect(Level pLevel, BlockPos pPos, LivingEntity pSource, int pAmplifier, int pAreaOfEffect) {
        Item axeItem = Items.f_42428_;
        if (pAmplifier == 1) {
            axeItem = Items.f_42386_;
        } else if (pAmplifier == 2) {
            axeItem = Items.f_42391_;
        } else if (pAmplifier > 3) {
            axeItem = Items.f_42396_;
        }
        ItemStack axe = new ItemStack((ItemLike)axeItem);
        if (pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            if (pSource instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)pSource;
                for (BlockPos blockPos : this.getSquarePos(pPos, pAreaOfEffect + 3)) {
                    BlockState blockState = serverLevel.m_8055_(blockPos.m_7494_());
                    if (!this.isTree((Level)serverLevel, blockPos.m_7494_(), blockState)) continue;
                    TimedEvents.submitTask("goety:brew_chop_tree", new BlockFinder.ChopTreeTask(serverPlayer.m_20148_(), axe, serverLevel, blockPos));
                }
            }
        }
    }

    private boolean isTree(Level level, BlockPos pos, BlockState state) {
        if (!state.m_204336_(BlockTags.f_13106_)) {
            return false;
        }
        while (state.m_204336_(BlockTags.f_13106_)) {
            pos = pos.m_7494_();
            state = level.m_8055_(pos);
        }
        for (BlockPos blockPos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-2, -2, -2), (BlockPos)pos.m_7918_(2, 2, 2))) {
            if (!level.m_8055_(blockPos).m_204336_(BlockTags.f_13035_) && !level.m_8055_(blockPos).m_204336_(BlockTags.f_13106_)) continue;
            return true;
        }
        return false;
    }
}

