/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.crafting;

import com.Polarice3.Goety.common.crafting.ModRecipeSerializer;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;

public class BrazierRecipe
implements Recipe<Container> {
    public static Serializer SERIALIZER = new Serializer();
    private final ResourceLocation id;
    private final ItemStack result;
    private final NonNullList<Ingredient> ingredients;
    private final int soulCost;

    public BrazierRecipe(ResourceLocation p_44246_, ItemStack p_44248_, NonNullList<Ingredient> p_44249_, int soulCost) {
        this.id = p_44246_;
        this.result = p_44248_;
        this.ingredients = p_44249_;
        this.soulCost = soulCost;
    }

    public boolean m_5818_(Container container, Level p_44003_) {
        ItemStack itemStack;
        ArrayList missingIngredients = Lists.newArrayList(this.ingredients);
        for (int i = 0; i < container.m_6643_() && !(itemStack = container.m_8020_(i)).m_41619_(); ++i) {
            int index = -1;
            for (int j = 0; j < missingIngredients.size(); ++j) {
                Ingredient ingredient = (Ingredient)missingIngredients.get(j);
                if (!ingredient.test(itemStack)) continue;
                index = j;
                break;
            }
            if (index == -1) {
                return false;
            }
            missingIngredients.remove(index);
        }
        return missingIngredients.isEmpty();
    }

    public ItemStack m_5874_(Container p_44001_, RegistryAccess pAccess) {
        return this.result.m_41777_();
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    public boolean m_8004_(int p_43999_, int p_44000_) {
        return false;
    }

    public ItemStack m_8043_(RegistryAccess pAccess) {
        return this.result;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeSerializer.BRAZIER_TYPE.get();
    }

    public int getSoulCost() {
        return this.soulCost;
    }

    public static class Serializer
    implements RecipeSerializer<BrazierRecipe> {
        public BrazierRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            NonNullList<Ingredient> ingredients = Serializer.itemsFromJson(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for Brazier recipe");
            }
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            int soulCost = GsonHelper.m_13824_((JsonObject)json, (String)"soulCost", (int)0);
            return new BrazierRecipe(recipeId, result, ingredients, soulCost);
        }

        private static NonNullList<Ingredient> itemsFromJson(JsonArray pIngredientArray) {
            NonNullList nonnulllist = NonNullList.m_122779_();
            for (int i = 0; i < pIngredientArray.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)pIngredientArray.get(i));
                if (ingredient.m_43947_()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        public BrazierRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int i = buffer.m_130242_();
            NonNullList ingredients1 = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            for (int j = 0; j < ingredients1.size(); ++j) {
                ingredients1.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack result = buffer.m_130267_();
            int soulCost = buffer.m_130242_();
            return new BrazierRecipe(recipeId, result, (NonNullList<Ingredient>)ingredients1, soulCost);
        }

        public void toNetwork(FriendlyByteBuf buffer, BrazierRecipe recipe) {
            buffer.m_130130_(recipe.ingredients.size());
            for (Ingredient ingredient : recipe.ingredients) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.result);
            buffer.m_130130_(recipe.soulCost);
        }
    }
}

