/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.commands;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.common.events.IllagerSpawner;
import com.Polarice3.Goety.common.events.WightSpawner;
import com.Polarice3.Goety.common.research.Research;
import com.Polarice3.Goety.common.research.ResearchList;
import com.Polarice3.Goety.config.MobsConfig;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.SEHelper;
import com.Polarice3.Goety.utils.WandUtil;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringUtil;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class GoetyCommand {
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.summon.failed"));
    private static final SimpleCommandExceptionType ERROR_DUPLICATE_UUID = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.summon.failed.uuid"));
    private static final SimpleCommandExceptionType INVALID_POSITION = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.summon.invalidPosition"));
    private static final SimpleCommandExceptionType ERROR_SET_POINTS_INVALID = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.goety.soul.set.points.invalid"));
    private static final SimpleCommandExceptionType ERROR_SET_POINTS_INVALID2 = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.goety.illager.rest.set.points.invalid"));
    private static final SimpleCommandExceptionType ERROR_SET_POINTS_INVALID3 = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.goety.brew.level.set.failure"));
    private static final SimpleCommandExceptionType ERROR_SET_POINTS_INVALID4 = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.goety.brew.xp.set.failure"));
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_RESEARCHES = (p_136344_, p_136345_) -> {
        Collection<Research> collection = ResearchList.getResearchIdList().values();
        return SharedSuggestionProvider.m_82957_(collection.stream().map(Research::getLocation), (SuggestionsBuilder)p_136345_);
    };

    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher, CommandBuildContext p_250122_) {
        pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"goety").requires(p_198442_0_ -> p_198442_0_.m_6761_(2))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"soul").then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(p_198445_0_ -> GoetyCommand.addSoulEnergy((CommandSourceStack)p_198445_0_.getSource(), EntityArgument.m_91477_((CommandContext)p_198445_0_, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)p_198445_0_, (String)"amount"))))))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(p_198439_0_ -> GoetyCommand.setSoulEnergy((CommandSourceStack)p_198439_0_.getSource(), EntityArgument.m_91477_((CommandContext)p_198439_0_, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)p_198439_0_, (String)"amount")))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"illager").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"spawn").executes(p_198352_0_ -> GoetyCommand.spawnIllagers((CommandSourceStack)p_198352_0_.getSource(), ((CommandSourceStack)p_198352_0_.getSource()).m_81375_()))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91466_()).executes(p_198435_0_ -> GoetyCommand.spawnIllagers((CommandSourceStack)p_198435_0_.getSource(), EntityArgument.m_91474_((CommandContext)p_198435_0_, (String)"targets")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"rest").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"get").executes(p_198352_0_ -> GoetyCommand.getRestPeriod((CommandSourceStack)p_198352_0_.getSource(), ((CommandSourceStack)p_198352_0_.getSource()).m_81375_()))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91466_()).executes(p_198435_0_ -> GoetyCommand.getRestPeriod((CommandSourceStack)p_198435_0_.getSource(), EntityArgument.m_91474_((CommandContext)p_198435_0_, (String)"targets")))))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"ticks", (ArgumentType)IntegerArgumentType.integer()).executes(p_198445_0_ -> GoetyCommand.addRestPeriod((CommandSourceStack)p_198445_0_.getSource(), EntityArgument.m_91477_((CommandContext)p_198445_0_, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)p_198445_0_, (String)"ticks"))))))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(p_198439_0_ -> GoetyCommand.setRestPeriod((CommandSourceStack)p_198439_0_.getSource(), EntityArgument.m_91477_((CommandContext)p_198439_0_, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)p_198439_0_, (String)"ticks"))))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"summons").then(Commands.m_82127_((String)"summon_noai").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"entity", (ArgumentType)ResourceArgument.m_247102_((CommandBuildContext)p_250122_, (ResourceKey)Registries.f_256939_)).suggests(SuggestionProviders.f_121645_).executes(p_198738_0_ -> GoetyCommand.spawnNoAIEntity((CommandSourceStack)p_198738_0_.getSource(), ResourceArgument.m_247713_((CommandContext)p_198738_0_, (String)"entity"), ((CommandSourceStack)p_198738_0_.getSource()).m_81371_(), new CompoundTag(), true))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"pos", (ArgumentType)Vec3Argument.m_120841_()).executes(p_198735_0_ -> GoetyCommand.spawnNoAIEntity((CommandSourceStack)p_198735_0_.getSource(), ResourceArgument.m_247713_((CommandContext)p_198735_0_, (String)"entity"), Vec3Argument.m_120844_((CommandContext)p_198735_0_, (String)"pos"), new CompoundTag(), true))).then(Commands.m_82129_((String)"nbt", (ArgumentType)CompoundTagArgument.m_87657_()).executes(p_198739_0_ -> GoetyCommand.spawnNoAIEntity((CommandSourceStack)p_198739_0_.getSource(), ResourceArgument.m_247713_((CommandContext)p_198739_0_, (String)"entity"), Vec3Argument.m_120844_((CommandContext)p_198739_0_, (String)"pos"), CompoundTagArgument.m_87660_((CommandContext)p_198739_0_, (String)"nbt"), false))))))).then(Commands.m_82127_((String)"summon_persist").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"entity", (ArgumentType)ResourceArgument.m_247102_((CommandBuildContext)p_250122_, (ResourceKey)Registries.f_256939_)).suggests(SuggestionProviders.f_121645_).executes(p_198738_0_ -> GoetyCommand.spawnPersistEntity((CommandSourceStack)p_198738_0_.getSource(), ResourceArgument.m_247713_((CommandContext)p_198738_0_, (String)"entity"), ((CommandSourceStack)p_198738_0_.getSource()).m_81371_(), new CompoundTag(), true))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"pos", (ArgumentType)Vec3Argument.m_120841_()).executes(p_198735_0_ -> GoetyCommand.spawnPersistEntity((CommandSourceStack)p_198735_0_.getSource(), ResourceArgument.m_247713_((CommandContext)p_198735_0_, (String)"entity"), Vec3Argument.m_120844_((CommandContext)p_198735_0_, (String)"pos"), new CompoundTag(), true))).then(Commands.m_82129_((String)"nbt", (ArgumentType)CompoundTagArgument.m_87657_()).executes(p_198739_0_ -> GoetyCommand.spawnPersistEntity((CommandSourceStack)p_198739_0_.getSource(), ResourceArgument.m_247713_((CommandContext)p_198739_0_, (String)"entity"), Vec3Argument.m_120844_((CommandContext)p_198739_0_, (String)"pos"), CompoundTagArgument.m_87660_((CommandContext)p_198739_0_, (String)"nbt"), false))))))).then(Commands.m_82127_((String)"summon_tamed").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"entity", (ArgumentType)ResourceArgument.m_247102_((CommandBuildContext)p_250122_, (ResourceKey)Registries.f_256939_)).suggests(SuggestionProviders.f_121645_).executes(p_198738_0_ -> GoetyCommand.spawnTamedEntity((CommandSourceStack)p_198738_0_.getSource(), ResourceArgument.m_247713_((CommandContext)p_198738_0_, (String)"entity"), ((CommandSourceStack)p_198738_0_.getSource()).m_81371_(), new CompoundTag(), true))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"pos", (ArgumentType)Vec3Argument.m_120841_()).executes(p_198735_0_ -> GoetyCommand.spawnTamedEntity((CommandSourceStack)p_198735_0_.getSource(), ResourceArgument.m_247713_((CommandContext)p_198735_0_, (String)"entity"), Vec3Argument.m_120844_((CommandContext)p_198735_0_, (String)"pos"), new CompoundTag(), true))).then(Commands.m_82129_((String)"nbt", (ArgumentType)CompoundTagArgument.m_87657_()).executes(p_198739_0_ -> GoetyCommand.spawnTamedEntity((CommandSourceStack)p_198739_0_.getSource(), ResourceArgument.m_247713_((CommandContext)p_198739_0_, (String)"entity"), Vec3Argument.m_120844_((CommandContext)p_198739_0_, (String)"pos"), CompoundTagArgument.m_87660_((CommandContext)p_198739_0_, (String)"nbt"), false))))))).then(Commands.m_82127_((String)"summon_hostile").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"entity", (ArgumentType)ResourceArgument.m_247102_((CommandBuildContext)p_250122_, (ResourceKey)Registries.f_256939_)).suggests(SuggestionProviders.f_121645_).executes(p_198738_0_ -> GoetyCommand.spawnHostileEntity((CommandSourceStack)p_198738_0_.getSource(), ResourceArgument.m_247713_((CommandContext)p_198738_0_, (String)"entity"), ((CommandSourceStack)p_198738_0_.getSource()).m_81371_(), new CompoundTag(), true))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"pos", (ArgumentType)Vec3Argument.m_120841_()).executes(p_198735_0_ -> GoetyCommand.spawnHostileEntity((CommandSourceStack)p_198735_0_.getSource(), ResourceArgument.m_247713_((CommandContext)p_198735_0_, (String)"entity"), Vec3Argument.m_120844_((CommandContext)p_198735_0_, (String)"pos"), new CompoundTag(), true))).then(Commands.m_82129_((String)"nbt", (ArgumentType)CompoundTagArgument.m_87657_()).executes(p_198739_0_ -> GoetyCommand.spawnHostileEntity((CommandSourceStack)p_198739_0_.getSource(), ResourceArgument.m_247713_((CommandContext)p_198739_0_, (String)"entity"), Vec3Argument.m_120844_((CommandContext)p_198739_0_, (String)"pos"), CompoundTagArgument.m_87660_((CommandContext)p_198739_0_, (String)"nbt"), false)))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"research").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"get").executes(p_198352_0_ -> GoetyCommand.getResearches((CommandSourceStack)p_198352_0_.getSource(), ((CommandSourceStack)p_198352_0_.getSource()).m_81375_()))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91466_()).executes(p_198435_0_ -> GoetyCommand.getResearches((CommandSourceStack)p_198435_0_.getSource(), EntityArgument.m_91474_((CommandContext)p_198435_0_, (String)"targets")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"add").executes(p_198352_0_ -> GoetyCommand.getResearches((CommandSourceStack)p_198352_0_.getSource(), ((CommandSourceStack)p_198352_0_.getSource()).m_81375_()))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82127_((String)"only").then(Commands.m_82129_((String)"research", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_RESEARCHES).executes(p_136363_ -> GoetyCommand.addResearch((CommandSourceStack)p_136363_.getSource(), EntityArgument.m_91477_((CommandContext)p_136363_, (String)"targets"), ResourceLocationArgument.m_107011_((CommandContext)p_136363_, (String)"research")))))).then(Commands.m_82127_((String)"all").executes(context -> GoetyCommand.addAllResearch((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"remove").executes(p_198352_0_ -> GoetyCommand.getResearches((CommandSourceStack)p_198352_0_.getSource(), ((CommandSourceStack)p_198352_0_.getSource()).m_81375_()))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82127_((String)"only").then(Commands.m_82129_((String)"research", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_RESEARCHES).executes(p_136363_ -> GoetyCommand.removeResearch((CommandSourceStack)p_136363_.getSource(), EntityArgument.m_91477_((CommandContext)p_136363_, (String)"targets"), ResourceLocationArgument.m_107011_((CommandContext)p_136363_, (String)"research")))))).then(Commands.m_82127_((String)"all").executes(context -> GoetyCommand.removeAllResearch((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets")))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"brew").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"level").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"get").executes(p_198352_0_ -> GoetyCommand.getBrewLevel((CommandSourceStack)p_198352_0_.getSource(), ((CommandSourceStack)p_198352_0_.getSource()).m_81375_()))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91466_()).executes(p_198435_0_ -> GoetyCommand.getBrewLevel((CommandSourceStack)p_198435_0_.getSource(), EntityArgument.m_91474_((CommandContext)p_198435_0_, (String)"targets")))))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(p_198445_0_ -> GoetyCommand.addBrewLevel((CommandSourceStack)p_198445_0_.getSource(), EntityArgument.m_91477_((CommandContext)p_198445_0_, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)p_198445_0_, (String)"amount"))))))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(p_198439_0_ -> GoetyCommand.setBrewLevel((CommandSourceStack)p_198439_0_.getSource(), EntityArgument.m_91477_((CommandContext)p_198439_0_, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)p_198439_0_, (String)"amount")))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"xp").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"get").executes(p_198352_0_ -> GoetyCommand.getBrewBottling((CommandSourceStack)p_198352_0_.getSource(), ((CommandSourceStack)p_198352_0_.getSource()).m_81375_()))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91466_()).executes(p_198435_0_ -> GoetyCommand.getBrewBottling((CommandSourceStack)p_198435_0_.getSource(), EntityArgument.m_91474_((CommandContext)p_198435_0_, (String)"targets")))))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(p_198445_0_ -> GoetyCommand.addBrewBottling((CommandSourceStack)p_198445_0_.getSource(), EntityArgument.m_91477_((CommandContext)p_198445_0_, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)p_198445_0_, (String)"amount"))))))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(p_198439_0_ -> GoetyCommand.setBrewBottling((CommandSourceStack)p_198439_0_.getSource(), EntityArgument.m_91477_((CommandContext)p_198439_0_, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)p_198439_0_, (String)"amount"))))))))).then(Commands.m_82127_((String)"spell").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"cooldown").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"held").executes(p_198352_0_ -> {
            if (((CommandSourceStack)p_198352_0_.getSource()).m_230897_()) {
                ArrayList<ServerPlayer> list = new ArrayList<ServerPlayer>();
                list.add(((CommandSourceStack)p_198352_0_.getSource()).m_81375_());
                return GoetyCommand.resetFocusCooldown((CommandSourceStack)p_198352_0_.getSource(), list);
            }
            return 0;
        })).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(p_198435_0_ -> GoetyCommand.resetFocusCooldown((CommandSourceStack)p_198435_0_.getSource(), EntityArgument.m_91477_((CommandContext)p_198435_0_, (String)"targets")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"all").executes(p_198352_0_ -> {
            if (((CommandSourceStack)p_198352_0_.getSource()).m_230897_()) {
                ArrayList<ServerPlayer> list = new ArrayList<ServerPlayer>();
                list.add(((CommandSourceStack)p_198352_0_.getSource()).m_81375_());
                return GoetyCommand.resetAllFocusCooldowns((CommandSourceStack)p_198352_0_.getSource(), list);
            }
            return 0;
        })).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(p_198435_0_ -> GoetyCommand.resetAllFocusCooldowns((CommandSourceStack)p_198435_0_.getSource(), EntityArgument.m_91477_((CommandContext)p_198435_0_, (String)"targets")))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"misc").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"wight").executes(p_198352_0_ -> GoetyCommand.spawnWight((CommandSourceStack)p_198352_0_.getSource(), ((CommandSourceStack)p_198352_0_.getSource()).m_81375_()))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91466_()).executes(p_198435_0_ -> GoetyCommand.spawnWight((CommandSourceStack)p_198435_0_.getSource(), EntityArgument.m_91474_((CommandContext)p_198435_0_, (String)"targets")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"repair").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"held").executes(p_198352_0_ -> {
            if (((CommandSourceStack)p_198352_0_.getSource()).m_230897_()) {
                ArrayList<ServerPlayer> list = new ArrayList<ServerPlayer>();
                list.add(((CommandSourceStack)p_198352_0_.getSource()).m_81375_());
                return GoetyCommand.repairItem((CommandSourceStack)p_198352_0_.getSource(), list);
            }
            return 0;
        })).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(p_198435_0_ -> GoetyCommand.repairItem((CommandSourceStack)p_198435_0_.getSource(), EntityArgument.m_91477_((CommandContext)p_198435_0_, (String)"targets")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"inventory").executes(p_198352_0_ -> {
            if (((CommandSourceStack)p_198352_0_.getSource()).m_230897_()) {
                ArrayList<ServerPlayer> list = new ArrayList<ServerPlayer>();
                list.add(((CommandSourceStack)p_198352_0_.getSource()).m_81375_());
                return GoetyCommand.repairAllItems((CommandSourceStack)p_198352_0_.getSource(), list);
            }
            return 0;
        })).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(p_198435_0_ -> GoetyCommand.repairAllItems((CommandSourceStack)p_198435_0_.getSource(), EntityArgument.m_91477_((CommandContext)p_198435_0_, (String)"targets"))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"heal").executes(p_198352_0_ -> {
            if (((CommandSourceStack)p_198352_0_.getSource()).m_230897_()) {
                ArrayList<ServerPlayer> list = new ArrayList<ServerPlayer>();
                list.add(((CommandSourceStack)p_198352_0_.getSource()).m_81375_());
                return GoetyCommand.heal((CommandSourceStack)p_198352_0_.getSource(), list);
            }
            return 0;
        })).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(p_198435_0_ -> GoetyCommand.heal((CommandSourceStack)p_198435_0_.getSource(), EntityArgument.m_91477_((CommandContext)p_198435_0_, (String)"targets")))))));
    }

    private static int addSoulEnergy(CommandSourceStack pSource, Collection<? extends ServerPlayer> pTargets, int pAmount) {
        for (ServerPlayer serverPlayer : pTargets) {
            if (SEHelper.getSoulsContainer((Player)serverPlayer)) {
                SEHelper.increaseSouls((Player)serverPlayer, pAmount);
                continue;
            }
            pSource.m_81352_((Component)Component.m_237110_((String)"commands.goety.soul.failed", (Object[])new Object[]{pTargets.iterator().next().m_5446_()}));
        }
        if (pTargets.size() == 1) {
            pSource.m_288197_(() -> Component.m_237110_((String)"commands.goety.soul.add.success.single", (Object[])new Object[]{pAmount, ((ServerPlayer)pTargets.iterator().next()).m_5446_()}), true);
        } else {
            pSource.m_288197_(() -> Component.m_237110_((String)"commands.goety.soul.add.success.multiple", (Object[])new Object[]{pAmount, pTargets.size()}), true);
        }
        return pTargets.size();
    }

    private static int setSoulEnergy(CommandSourceStack pSource, Collection<? extends ServerPlayer> pTargets, int pAmount) throws CommandSyntaxException {
        int i = 0;
        for (ServerPlayer serverPlayer : pTargets) {
            if (SEHelper.getSoulsContainer((Player)serverPlayer)) {
                SEHelper.setSoulsAmount((Player)serverPlayer, pAmount);
                ++i;
                continue;
            }
            pSource.m_81352_((Component)Component.m_237110_((String)"commands.goety.soul.failed", (Object[])new Object[]{pTargets.iterator().next().m_5446_()}));
        }
        if (i == 0) {
            throw ERROR_SET_POINTS_INVALID.create();
        }
        if (pTargets.size() == 1) {
            pSource.m_288197_(() -> Component.m_237110_((String)"commands.goety.soul.set.success.single", (Object[])new Object[]{pAmount, ((ServerPlayer)pTargets.iterator().next()).m_5446_()}), true);
        } else {
            pSource.m_288197_(() -> Component.m_237110_((String)"commands.goety.soul.set.success.multiple", (Object[])new Object[]{pAmount, pTargets.size()}), true);
        }
        return pTargets.size();
    }

    private static int spawnIllagers(CommandSourceStack pSource, ServerPlayer pPlayer) {
        int i = SEHelper.getSoulAmountInt((Player)pPlayer);
        if (i > (Integer)MobsConfig.IllagerAssaultSEThreshold.get()) {
            IllagerSpawner illagerSpawner = new IllagerSpawner();
            illagerSpawner.forceSpawn(pPlayer.m_284548_(), pPlayer, pSource);
            return 1;
        }
        pSource.m_81352_((Component)Component.m_237110_((String)"commands.goety.illager.spawn.failure", (Object[])new Object[]{pPlayer.m_5446_()}));
        return i;
    }

    private static int getRestPeriod(CommandSourceStack pSource, ServerPlayer pPlayer) {
        int i = SEHelper.getRestPeriod((Player)pPlayer);
        pSource.m_288197_(() -> Component.m_237110_((String)"commands.goety.illager.rest.get.success", (Object[])new Object[]{pPlayer.m_5446_(), StringUtil.m_14404_((int)i)}), false);
        return 1;
    }

    private static int addRestPeriod(CommandSourceStack pSource, Collection<? extends ServerPlayer> pTargets, int tick) {
        for (ServerPlayer serverPlayer : pTargets) {
            SEHelper.increaseRestPeriod((Player)serverPlayer, tick);
        }
        if (pTargets.size() == 1) {
            pSource.m_288197_(() -> Component.m_237110_((String)"commands.goety.illager.rest.add.success.single", (Object[])new Object[]{tick, ((ServerPlayer)pTargets.iterator().next()).m_5446_()}), true);
        } else {
            pSource.m_288197_(() -> Component.m_237110_((String)"commands.goety.illager.rest.add.success.multiple", (Object[])new Object[]{tick, pTargets.size()}), true);
        }
        return pTargets.size();
    }

    private static int setRestPeriod(CommandSourceStack pSource, Collection<? extends ServerPlayer> pTargets, int tick) throws CommandSyntaxException {
        int i = 0;
        for (ServerPlayer serverPlayer : pTargets) {
            SEHelper.setRestPeriod((Player)serverPlayer, tick);
            ++i;
        }
        if (i == 0) {
            throw ERROR_SET_POINTS_INVALID2.create();
        }
        if (pTargets.size() == 1) {
            pSource.m_288197_(() -> Component.m_237110_((String)"commands.goety.illager.rest.set.success.single", (Object[])new Object[]{tick, ((ServerPlayer)pTargets.iterator().next()).m_5446_()}), true);
        } else {
            pSource.m_288197_(() -> Component.m_237110_((String)"commands.goety.illager.rest.set.success.multiple", (Object[])new Object[]{tick, pTargets.size()}), true);
        }
        return pTargets.size();
    }

    private static int spawnNoAIEntity(CommandSourceStack pSource, Holder.Reference<EntityType<?>> pType, Vec3 pPos, CompoundTag pNbt, boolean pRandomizeProperties) throws CommandSyntaxException {
        BlockPos blockpos = BlockPos.m_274446_((Position)pPos);
        if (!Level.m_46741_((BlockPos)blockpos)) {
            throw INVALID_POSITION.create();
        }
        CompoundTag compoundnbt = pNbt.m_6426_();
        compoundnbt.m_128359_("id", pType.m_205785_().m_135782_().toString());
        ServerLevel serverworld = pSource.m_81372_();
        Entity entity = EntityType.m_20645_((CompoundTag)compoundnbt, (Level)serverworld, p_218914_1_ -> {
            p_218914_1_.m_7678_(pPos.f_82479_, pPos.f_82480_, pPos.f_82481_, p_218914_1_.m_146908_(), p_218914_1_.m_146909_());
            return p_218914_1_;
        });
        if (entity == null) {
            throw ERROR_FAILED.create();
        }
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.m_21557_(true);
            mob.m_21530_();
            if (pRandomizeProperties) {
                ForgeEventFactory.onFinalizeSpawn((Mob)mob, (ServerLevelAccessor)pSource.m_81372_(), (DifficultyInstance)pSource.m_81372_().m_6436_(entity.m_20183_()), (MobSpawnType)MobSpawnType.COMMAND, null, null);
            }
        }
        if (!serverworld.m_8860_(entity)) {
            throw ERROR_DUPLICATE_UUID.create();
        }
        pSource.m_288197_(() -> Component.m_237110_((String)"commands.summon_noai.success", (Object[])new Object[]{entity.m_5446_()}), true);
        return 1;
    }

    private static int spawnPersistEntity(CommandSourceStack pSource, Holder.Reference<EntityType<?>> pType, Vec3 pPos, CompoundTag pNbt, boolean pRandomizeProperties) throws CommandSyntaxException {
        BlockPos blockpos = BlockPos.m_274446_((Position)pPos);
        if (!Level.m_46741_((BlockPos)blockpos)) {
            throw INVALID_POSITION.create();
        }
        CompoundTag compoundnbt = pNbt.m_6426_();
        compoundnbt.m_128359_("id", pType.m_205785_().m_135782_().toString());
        ServerLevel serverworld = pSource.m_81372_();
        Entity entity = EntityType.m_20645_((CompoundTag)compoundnbt, (Level)serverworld, p_218914_1_ -> {
            p_218914_1_.m_7678_(pPos.f_82479_, pPos.f_82480_, pPos.f_82481_, p_218914_1_.m_146908_(), p_218914_1_.m_146909_());
            return p_218914_1_;
        });
        if (entity == null) {
            throw ERROR_FAILED.create();
        }
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.m_21530_();
            if (pRandomizeProperties) {
                ForgeEventFactory.onFinalizeSpawn((Mob)mob, (ServerLevelAccessor)pSource.m_81372_(), (DifficultyInstance)pSource.m_81372_().m_6436_(entity.m_20183_()), (MobSpawnType)MobSpawnType.COMMAND, null, null);
            }
        }
        if (!serverworld.m_8860_(entity)) {
            throw ERROR_DUPLICATE_UUID.create();
        }
        pSource.m_288197_(() -> Component.m_237110_((String)"commands.summon_persist.success", (Object[])new Object[]{entity.m_5446_()}), true);
        return 1;
    }

    private static int spawnTamedEntity(CommandSourceStack pSource, Holder.Reference<EntityType<?>> pType, Vec3 pPos, CompoundTag pNbt, boolean pRandomizeProperties) throws CommandSyntaxException {
        BlockPos blockpos = BlockPos.m_274446_((Position)pPos);
        if (!Level.m_46741_((BlockPos)blockpos)) {
            throw INVALID_POSITION.create();
        }
        CompoundTag compoundnbt = pNbt.m_6426_();
        compoundnbt.m_128359_("id", pType.m_205785_().m_135782_().toString());
        ServerLevel serverworld = pSource.m_81372_();
        Entity entity = EntityType.m_20645_((CompoundTag)compoundnbt, (Level)serverworld, p_218914_1_ -> {
            p_218914_1_.m_7678_(pPos.f_82479_, pPos.f_82480_, pPos.f_82481_, p_218914_1_.m_146908_(), p_218914_1_.m_146909_());
            return p_218914_1_;
        });
        if (entity == null) {
            throw ERROR_FAILED.create();
        }
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            MobUtil.summonTame((Entity)mob, (Player)pSource.m_81375_());
            if (pRandomizeProperties) {
                ForgeEventFactory.onFinalizeSpawn((Mob)mob, (ServerLevelAccessor)pSource.m_81372_(), (DifficultyInstance)pSource.m_81372_().m_6436_(entity.m_20183_()), (MobSpawnType)MobSpawnType.COMMAND, null, null);
            }
        }
        if (!serverworld.m_8860_(entity)) {
            throw ERROR_DUPLICATE_UUID.create();
        }
        pSource.m_288197_(() -> Component.m_237110_((String)"commands.summon_tame.success", (Object[])new Object[]{entity.m_5446_()}), true);
        return 1;
    }

    private static int spawnHostileEntity(CommandSourceStack pSource, Holder.Reference<EntityType<?>> pType, Vec3 pPos, CompoundTag pNbt, boolean pRandomizeProperties) throws CommandSyntaxException {
        BlockPos blockpos = BlockPos.m_274446_((Position)pPos);
        if (!Level.m_46741_((BlockPos)blockpos)) {
            throw INVALID_POSITION.create();
        }
        CompoundTag compoundnbt = pNbt.m_6426_();
        compoundnbt.m_128359_("id", pType.m_205785_().m_135782_().toString());
        ServerLevel serverworld = pSource.m_81372_();
        Entity entity = EntityType.m_20645_((CompoundTag)compoundnbt, (Level)serverworld, p_218914_1_ -> {
            p_218914_1_.m_7678_(pPos.f_82479_, pPos.f_82480_, pPos.f_82481_, p_218914_1_.m_146908_(), p_218914_1_.m_146909_());
            return p_218914_1_;
        });
        if (entity == null) {
            throw ERROR_FAILED.create();
        }
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.m_21530_();
            if (mob.m_21051_(Attributes.f_22281_) != null) {
                if (mob instanceof IOwned) {
                    IOwned owned = (IOwned)mob;
                    owned.setHostile(true);
                } else {
                    mob.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal(mob, Player.class, true));
                }
            }
            if (pRandomizeProperties) {
                ForgeEventFactory.onFinalizeSpawn((Mob)mob, (ServerLevelAccessor)pSource.m_81372_(), (DifficultyInstance)pSource.m_81372_().m_6436_(entity.m_20183_()), (MobSpawnType)MobSpawnType.COMMAND, null, null);
            }
        }
        if (!serverworld.m_8860_(entity)) {
            throw ERROR_DUPLICATE_UUID.create();
        }
        pSource.m_288197_(() -> Component.m_237110_((String)"commands.summon_hostile.success", (Object[])new Object[]{entity.m_5446_()}), true);
        return 1;
    }

    private static int getResearches(CommandSourceStack pSource, ServerPlayer pPlayer) {
        if (SEHelper.getResearch((Player)pPlayer).isEmpty()) {
            pSource.m_81352_((Component)Component.m_237110_((String)"commands.goety.research.get.empty", (Object[])new Object[]{pPlayer.m_5446_()}));
        } else {
            pSource.m_288197_(() -> Component.m_237110_((String)"commands.goety.research.get", (Object[])new Object[]{pPlayer.m_5446_()}), true);
        }
        for (Research research : SEHelper.getResearch((Player)pPlayer)) {
            pSource.m_288197_(() -> Component.m_237113_((String)research.getId()), true);
        }
        return 1;
    }

    private static int addResearch(CommandSourceStack pSource, Collection<? extends ServerPlayer> pTargets, ResourceLocation string) {
        for (ServerPlayer serverPlayer : pTargets) {
            if (ResearchList.getResearch(string) == null) continue;
            Research research = ResearchList.getResearch(string);
            if (SEHelper.hasResearch((Player)serverPlayer, research)) {
                pSource.m_81352_((Component)Component.m_237110_((String)"commands.goety.research.add.failure", (Object[])new Object[]{serverPlayer.m_5446_()}));
                continue;
            }
            SEHelper.addResearch((Player)serverPlayer, research);
            pSource.m_288197_(() -> Component.m_237110_((String)"commands.goety.research.add.success", (Object[])new Object[]{serverPlayer.m_5446_()}), true);
        }
        return 1;
    }

    private static int removeResearch(CommandSourceStack pSource, Collection<? extends ServerPlayer> pTargets, ResourceLocation string) {
        for (ServerPlayer serverPlayer : pTargets) {
            if (ResearchList.getResearch(string) == null) continue;
            Research research = ResearchList.getResearch(string);
            if (!SEHelper.hasResearch((Player)serverPlayer, research)) {
                pSource.m_81352_((Component)Component.m_237110_((String)"commands.goety.research.remove.failure", (Object[])new Object[]{serverPlayer.m_5446_()}));
                continue;
            }
            SEHelper.removeResearch((Player)serverPlayer, research);
            pSource.m_288197_(() -> Component.m_237110_((String)"commands.goety.research.remove.success", (Object[])new Object[]{serverPlayer.m_5446_()}), true);
        }
        return 1;
    }

    private static int addAllResearch(CommandSourceStack pSource, Collection<? extends ServerPlayer> pTargets) {
        for (ServerPlayer serverPlayer : pTargets) {
            for (Research research : ResearchList.getResearchList().values()) {
                if (SEHelper.hasResearch((Player)serverPlayer, research)) continue;
                SEHelper.addResearch((Player)serverPlayer, research);
            }
            pSource.m_288197_(() -> Component.m_237110_((String)"commands.goety.research.addAll", (Object[])new Object[]{serverPlayer.m_5446_()}), true);
        }
        return 1;
    }

    private static int removeAllResearch(CommandSourceStack pSource, Collection<? extends ServerPlayer> pTargets) {
        for (ServerPlayer serverPlayer : pTargets) {
            for (Research research : ResearchList.getResearchList().values()) {
                if (!SEHelper.hasResearch((Player)serverPlayer, research)) continue;
                SEHelper.removeResearch((Player)serverPlayer, research);
            }
            pSource.m_288197_(() -> Component.m_237110_((String)"commands.goety.research.removeAll", (Object[])new Object[]{serverPlayer.m_5446_()}), true);
        }
        return 1;
    }

    private static int getBrewLevel(CommandSourceStack pSource, ServerPlayer pPlayer) {
        int i = SEHelper.getBottleLevel((Player)pPlayer);
        pSource.m_288197_(() -> Component.m_237110_((String)"commands.goety.brew.level.get.success", (Object[])new Object[]{pPlayer.m_5446_(), i}), false);
        return 1;
    }

    private static int addBrewLevel(CommandSourceStack pSource, Collection<? extends ServerPlayer> pTargets, int level) {
        for (ServerPlayer serverPlayer : pTargets) {
            SEHelper.setBottleLevel((Player)serverPlayer, SEHelper.getBottleLevel((Player)serverPlayer) + level);
        }
        if (pTargets.size() == 1) {
            pSource.m_288197_(() -> Component.m_237110_((String)"commands.goety.brew.level.add.success.single", (Object[])new Object[]{level, ((ServerPlayer)pTargets.iterator().next()).m_5446_()}), true);
        } else {
            pSource.m_288197_(() -> Component.m_237110_((String)"commands.goety.brew.level.add.success.multiple", (Object[])new Object[]{level, pTargets.size()}), true);
        }
        return pTargets.size();
    }

    private static int setBrewLevel(CommandSourceStack pSource, Collection<? extends ServerPlayer> pTargets, int level) throws CommandSyntaxException {
        int i = 0;
        for (ServerPlayer serverPlayer : pTargets) {
            SEHelper.setBottleLevel((Player)serverPlayer, level);
            ++i;
        }
        if (i == 0) {
            throw ERROR_SET_POINTS_INVALID3.create();
        }
        if (pTargets.size() == 1) {
            pSource.m_288197_(() -> Component.m_237110_((String)"commands.goety.brew.level.set.success.single", (Object[])new Object[]{level, ((ServerPlayer)pTargets.iterator().next()).m_5446_()}), true);
        } else {
            pSource.m_288197_(() -> Component.m_237110_((String)"commands.goety.brew.level.set.success.multiple", (Object[])new Object[]{level, pTargets.size()}), true);
        }
        return pTargets.size();
    }

    private static int getBrewBottling(CommandSourceStack pSource, ServerPlayer pPlayer) {
        int i = SEHelper.getBottling((Player)pPlayer);
        pSource.m_288197_(() -> Component.m_237110_((String)"commands.goety.brew.xp.get.success", (Object[])new Object[]{pPlayer.m_5446_(), i}), false);
        return 1;
    }

    private static int addBrewBottling(CommandSourceStack pSource, Collection<? extends ServerPlayer> pTargets, int level) {
        for (ServerPlayer serverPlayer : pTargets) {
            SEHelper.increaseBottling((Player)serverPlayer, level);
        }
        if (pTargets.size() == 1) {
            pSource.m_288197_(() -> Component.m_237110_((String)"commands.goety.brew.xp.add.success.single", (Object[])new Object[]{level, ((ServerPlayer)pTargets.iterator().next()).m_5446_()}), true);
        } else {
            pSource.m_288197_(() -> Component.m_237110_((String)"commands.goety.brew.xp.add.success.multiple", (Object[])new Object[]{level, pTargets.size()}), true);
        }
        return pTargets.size();
    }

    private static int setBrewBottling(CommandSourceStack pSource, Collection<? extends ServerPlayer> pTargets, int level) throws CommandSyntaxException {
        int i = 0;
        for (ServerPlayer serverPlayer : pTargets) {
            SEHelper.setBottling((Player)serverPlayer, level);
            ++i;
        }
        if (i == 0) {
            throw ERROR_SET_POINTS_INVALID4.create();
        }
        if (pTargets.size() == 1) {
            pSource.m_288197_(() -> Component.m_237110_((String)"commands.goety.brew.xp.set.success.single", (Object[])new Object[]{level, ((ServerPlayer)pTargets.iterator().next()).m_5446_()}), true);
        } else {
            pSource.m_288197_(() -> Component.m_237110_((String)"commands.goety.brew.xp.set.success.multiple", (Object[])new Object[]{level, pTargets.size()}), true);
        }
        return pTargets.size();
    }

    private static int resetFocusCooldown(CommandSourceStack pSource, Collection<? extends ServerPlayer> pTargets) {
        int i = 0;
        for (ServerPlayer serverPlayer : pTargets) {
            if (WandUtil.findFocus((LivingEntity)serverPlayer).m_41619_()) continue;
            Item item = WandUtil.findFocus((LivingEntity)serverPlayer).m_41720_();
            if (!SEHelper.getCooldowns((Player)serverPlayer).containsKey(item)) continue;
            SEHelper.getFocusCoolDown((Player)serverPlayer).removeCooldown((Player)serverPlayer, (Level)pSource.m_81372_(), item);
            ++i;
        }
        if (i == 0) {
            pSource.m_81352_((Component)Component.m_237115_((String)"commands.goety.spell.cooldown.held.failure"));
        } else if (pTargets.size() == 1) {
            pSource.m_288197_(() -> Component.m_237110_((String)"commands.goety.spell.cooldown.held.success.single", (Object[])new Object[]{WandUtil.findFocus((LivingEntity)pTargets.iterator().next()).m_41611_()}), true);
        } else {
            pSource.m_288197_(() -> Component.m_237110_((String)"commands.goety.spell.cooldown.held.success.multiple", (Object[])new Object[]{pTargets.size()}), true);
        }
        return i;
    }

    private static int resetAllFocusCooldowns(CommandSourceStack pSource, Collection<? extends ServerPlayer> pTargets) {
        int i = 0;
        for (ServerPlayer serverPlayer : pTargets) {
            for (Item item : SEHelper.getCooldowns((Player)serverPlayer).keySet()) {
                SEHelper.getFocusCoolDown((Player)serverPlayer).removeCooldown((Player)serverPlayer, (Level)pSource.m_81372_(), item);
            }
        }
        if (pTargets.size() == 1) {
            pSource.m_288197_(() -> Component.m_237110_((String)"commands.goety.spell.cooldown.inventory.success.single", (Object[])new Object[]{((ServerPlayer)pTargets.iterator().next()).m_5446_()}), true);
        } else {
            pSource.m_288197_(() -> Component.m_237110_((String)"commands.goety.spell.cooldown.inventory.success.multiple", (Object[])new Object[]{pTargets.size()}), true);
        }
        return i;
    }

    private static int spawnWight(CommandSourceStack pSource, ServerPlayer pPlayer) {
        WightSpawner spawner = new WightSpawner();
        spawner.forceSpawn(pPlayer.m_284548_(), pPlayer, pSource);
        return 1;
    }

    private static int repairItem(CommandSourceStack pSource, Collection<? extends ServerPlayer> pTargets) {
        int i = 0;
        for (ServerPlayer serverPlayer : pTargets) {
            if (serverPlayer.m_21205_().m_41619_() || !serverPlayer.m_21205_().m_41768_()) continue;
            serverPlayer.m_21205_().m_41721_(0);
            ++i;
        }
        if (i == 0) {
            pSource.m_81352_((Component)Component.m_237115_((String)"commands.goety.misc.repair.held.failure"));
        } else if (pTargets.size() == 1) {
            pSource.m_288197_(() -> Component.m_237110_((String)"commands.goety.misc.repair.held.success.single", (Object[])new Object[]{((ServerPlayer)pTargets.iterator().next()).m_5446_(), ((ServerPlayer)pTargets.iterator().next()).m_21205_().m_41611_()}), true);
        } else {
            pSource.m_288197_(() -> Component.m_237110_((String)"commands.goety.misc.repair.held.success.multiple", (Object[])new Object[]{pTargets.size()}), true);
        }
        return i;
    }

    private static int repairAllItems(CommandSourceStack pSource, Collection<? extends ServerPlayer> pTargets) {
        int i0 = 0;
        for (ServerPlayer serverPlayer : pTargets) {
            for (int i = 0; i < serverPlayer.m_150109_().m_6643_(); ++i) {
                ItemStack itemStack = serverPlayer.m_150109_().m_8020_(i);
                if (!itemStack.m_41768_()) continue;
                itemStack.m_41721_(0);
                ++i0;
            }
        }
        if (i0 == 0) {
            pSource.m_81352_((Component)Component.m_237115_((String)"commands.goety.misc.repair.inventory.failure"));
        } else if (pTargets.size() == 1) {
            pSource.m_288197_(() -> Component.m_237110_((String)"commands.goety.misc.repair.inventory.success.single", (Object[])new Object[]{((ServerPlayer)pTargets.iterator().next()).m_5446_()}), true);
        } else {
            pSource.m_288197_(() -> Component.m_237110_((String)"commands.goety.misc.repair.inventory.success.multiple", (Object[])new Object[]{pTargets.size()}), true);
        }
        return i0;
    }

    private static int heal(CommandSourceStack pSource, Collection<? extends ServerPlayer> pTargets) {
        for (ServerPlayer serverPlayer : pTargets) {
            serverPlayer.m_21219_();
            serverPlayer.m_5634_(serverPlayer.m_21233_());
            serverPlayer.m_36324_().m_38705_(20);
            serverPlayer.m_36324_().m_38717_(20.0f);
            serverPlayer.m_36324_().m_150378_(0.0f);
        }
        if (pTargets.size() == 1) {
            pSource.m_288197_(() -> Component.m_237110_((String)"commands.goety.misc.heal.success.single", (Object[])new Object[]{((ServerPlayer)pTargets.iterator().next()).m_5446_()}), true);
        } else {
            pSource.m_288197_(() -> Component.m_237110_((String)"commands.goety.misc.heal.success.multiple", (Object[])new Object[]{pTargets.size()}), true);
        }
        return 1;
    }
}

