/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.blocks.entities;

import com.Polarice3.Goety.common.blocks.ModBlocks;
import com.Polarice3.Goety.common.blocks.ShriekObeliskBlock;
import com.Polarice3.Goety.common.blocks.entities.CursedCageBlockEntity;
import com.Polarice3.Goety.common.blocks.entities.ModBlockEntities;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.server.SPlayWorldSoundPacket;
import com.Polarice3.Goety.config.MainConfig;
import com.Polarice3.Goety.config.MobsConfig;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ShriekParticleOption;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class ShriekObeliskBlockEntity
extends BlockEntity {
    public int power;
    private CursedCageBlockEntity cursedCageTile;

    public ShriekObeliskBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)ModBlockEntities.SHRIEKING_OBELISK.get(), p_155229_, p_155230_);
    }

    public void tick() {
        if (this.f_58857_ != null) {
            this.power = ShriekObeliskBlockEntity.updateBase(this.f_58857_, this.m_58899_());
            if (!this.f_58857_.f_46443_) {
                this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)ShriekObeliskBlock.POWERED, (Comparable)Boolean.valueOf(this.checkCage())), 3);
            }
        }
    }

    private static int updateBase(Level pLevel, BlockPos blockPos) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        for (int levels = 1; levels <= 4; ++levels) {
            BlockPos blockPos1;
            int newZ;
            int newX;
            int lowerLevel = levels - 1;
            int newY = blockPos.m_123342_() - levels;
            if (newY < pLevel.m_141937_()) break;
            for (newX = blockPos.m_123341_() - levels; newX <= blockPos.m_123341_() + levels; ++newX) {
                for (newZ = blockPos.m_123343_() - levels; newZ <= blockPos.m_123343_() + levels; ++newZ) {
                    blockPos1 = new BlockPos(newX, newY, newZ);
                    if (!pLevel.m_8055_(blockPos1).m_60713_((Block)ModBlocks.TALL_SKULL_BLOCK.get()) && !pLevel.m_8055_(blockPos1).m_60713_((Block)ModBlocks.WALL_TALL_SKULL_BLOCK.get())) continue;
                    result.add(blockPos1);
                }
            }
            for (newX = blockPos.m_123341_() - lowerLevel; newX <= blockPos.m_123341_() + lowerLevel; ++newX) {
                for (newZ = blockPos.m_123343_() - lowerLevel; newZ <= blockPos.m_123343_() + lowerLevel; ++newZ) {
                    blockPos1 = new BlockPos(newX, newY, newZ);
                    if (!pLevel.m_8055_(blockPos1).m_60713_((Block)ModBlocks.TALL_SKULL_BLOCK.get()) && !pLevel.m_8055_(blockPos1).m_60713_((Block)ModBlocks.WALL_TALL_SKULL_BLOCK.get())) continue;
                    result.remove(blockPos1);
                }
            }
        }
        return result.isEmpty() ? 8 : Mth.m_14143_((float)((float)result.size() * 1.5f)) + 8;
    }

    public boolean shriek(ServerLevel serverLevel, @Nullable Player player, int soulEnergy) {
        BlockPos blockpos = this.m_58899_();
        BlockState blockstate = this.m_58900_();
        int cost = soulEnergy / (Integer)MobsConfig.IllagerAssaultSEThreshold.get() * (Integer)MainConfig.ShriekObeliskCost.get();
        if (((Boolean)blockstate.m_61143_((Property)ShriekObeliskBlock.POWERED)).booleanValue() && this.cursedCageTile != null && this.cursedCageTile.getSouls() >= cost && !((Boolean)blockstate.m_61143_((Property)ShriekObeliskBlock.SHRIEKING)).booleanValue()) {
            this.cursedCageTile.decreaseSouls(cost);
            serverLevel.m_7731_(blockpos, (BlockState)blockstate.m_61124_((Property)ShriekObeliskBlock.SHRIEKING, (Comparable)Boolean.TRUE), 2);
            serverLevel.m_186460_(blockpos, blockstate.m_60734_(), 90);
            for (int j = 0; j < 10; ++j) {
                serverLevel.m_8767_((ParticleOptions)new ShriekParticleOption(j * 5), (double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() + 1.0, (double)blockpos.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.5);
            }
            ModNetwork.sendToALL(new SPlayWorldSoundPacket(blockpos.m_7494_(), SoundEvents.f_215750_, 2.0f, 0.25f));
            serverLevel.m_220407_(GameEvent.f_223701_, blockpos, GameEvent.Context.m_223717_((Entity)player));
            return true;
        }
        return false;
    }

    public int getPower() {
        return this.power;
    }

    private boolean checkCage() {
        BlockEntity tileentity;
        BlockPos pos;
        BlockState blockState;
        if (this.f_58857_ != null && (blockState = this.f_58857_.m_8055_(pos = this.m_58899_().m_7495_())).m_60713_((Block)ModBlocks.CURSED_CAGE_BLOCK.get()) && (tileentity = this.f_58857_.m_7702_(pos)) instanceof CursedCageBlockEntity) {
            this.cursedCageTile = (CursedCageBlockEntity)tileentity;
            return !this.cursedCageTile.getItem().m_41619_();
        }
        return false;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

