/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.blocks.entities;

import com.Polarice3.Goety.api.blocks.entities.IWaystoneBlock;
import com.Polarice3.Goety.api.magic.GolemType;
import com.Polarice3.Goety.common.blocks.AnimatorBlock;
import com.Polarice3.Goety.common.blocks.ModBlocks;
import com.Polarice3.Goety.common.blocks.entities.CursedCageBlockEntity;
import com.Polarice3.Goety.common.blocks.entities.ModBlockEntities;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.undead.HauntedArmorServant;
import com.Polarice3.Goety.common.entities.deco.HauntedArmorStand;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.items.WaystoneItem;
import com.Polarice3.Goety.common.magic.construct.SpawnFromBlock;
import com.Polarice3.Goety.common.research.ResearchList;
import com.Polarice3.Goety.config.MainConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.ItemHelper;
import com.Polarice3.Goety.utils.SEHelper;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class AnimatorBlockEntity
extends BlockEntity
implements IWaystoneBlock,
Clearable {
    private ItemStack item = ItemStack.f_41583_;
    private CursedCageBlockEntity cursedCageTile;
    private int spinning;
    public boolean showBlock;

    public AnimatorBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.ANIMATOR.get(), blockPos, blockState);
    }

    @Override
    public int getSoulCost() {
        if (this.getPosition() != null) {
            double distance = this.m_58899_().m_203193_((Position)this.getPosition().m_122646_().m_252807_());
            return (int)((double)((Integer)MainConfig.AnimatorCost.get()).intValue() * distance);
        }
        return 0;
    }

    public AABB getRenderBoundingBox() {
        return BlockEntity.INFINITE_EXTENT_AABB;
    }

    public void summonGolem() {
        if (this.f_58857_ != null && this.getPosition() != null && this.f_58857_.m_46472_() == this.getPosition().m_122640_() && this.f_58857_.m_46749_(this.getPosition().m_122646_()) && this.checkCage() && this.cursedCageTile.getSouls() >= this.getSoulCost()) {
            Optional optional;
            ItemStack itemStack = ((Item)ModItems.ANIMATION_CORE.get()).m_7968_();
            BlockState blockState = this.f_58857_.m_8055_(this.getPosition().m_122646_());
            AABB aabb = new AABB(this.getPosition().m_122646_());
            List list = this.f_58857_.m_6443_(HauntedArmorStand.class, aabb, ItemHelper::isFullEquipped);
            Optional<Object> optional2 = optional = !list.isEmpty() ? list.stream().findFirst() : Optional.empty();
            if (optional.isPresent() && SEHelper.hasResearch(this.getOwner(), ResearchList.HAUNTING)) {
                HauntedArmorStand hauntedArmorStand = (HauntedArmorStand)((Object)optional.get());
                HauntedArmorServant hauntedArmorServant = new HauntedArmorServant((EntityType<? extends Owned>)((EntityType)ModEntityType.HAUNTED_ARMOR_SERVANT.get()), this.f_58857_);
                for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                    hauntedArmorServant.m_8061_(equipmentSlot, hauntedArmorStand.m_6844_(equipmentSlot));
                    hauntedArmorServant.m_21508_(equipmentSlot);
                }
                hauntedArmorServant.m_21530_();
                hauntedArmorServant.setTrueOwner((LivingEntity)this.getOwner());
                hauntedArmorServant.m_20035_(hauntedArmorStand.m_20183_(), hauntedArmorStand.m_146908_(), hauntedArmorStand.m_146909_());
                hauntedArmorServant.m_21559_(this.getOwner().m_5737_() == HumanoidArm.LEFT);
                if (this.f_58857_.m_7967_((Entity)hauntedArmorServant)) {
                    hauntedArmorStand.m_216990_((SoundEvent)ModSounds.SUMMON_SPELL.get());
                    hauntedArmorStand.m_31565_();
                    hauntedArmorStand.m_146870_();
                }
            } else if (GolemType.getGolemList().containsKey(blockState)) {
                if (GolemType.getGolemList().get(blockState).spawnServant(this.getOwner(), itemStack, this.f_58857_, this.getPosition().m_122646_())) {
                    this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)ModSounds.SUMMON_SPELL.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    this.f_58857_.m_5594_(null, this.getPosition().m_122646_(), (SoundEvent)ModSounds.SUMMON_SPELL.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    this.cursedCageTile.decreaseSouls(this.getSoulCost());
                    this.generateManyParticles();
                }
            } else if (SpawnFromBlock.spawnServant(this.getOwner(), itemStack, this.f_58857_, this.getPosition().m_122646_())) {
                this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)ModSounds.SUMMON_SPELL.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                this.f_58857_.m_5594_(null, this.getPosition().m_122646_(), (SoundEvent)ModSounds.SUMMON_SPELL.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                this.cursedCageTile.decreaseSouls(this.getSoulCost());
                this.generateManyParticles();
            }
        }
    }

    public ItemStack getItem() {
        return this.item;
    }

    public void setItem(ItemStack stack) {
        this.item = stack;
        this.markUpdated();
    }

    public Player getOwner() {
        if (this.f_58857_ != null && !this.getItem().m_41619_() && this.getItem().m_41720_() instanceof WaystoneItem && this.getItem().m_41783_() != null && this.getItem().m_41783_().m_128441_("Owner")) {
            UUID owner = this.getItem().m_41783_().m_128342_("Owner");
            return this.f_58857_.m_46003_(owner);
        }
        return null;
    }

    @Override
    @Nullable
    public GlobalPos getPosition() {
        if (!this.getItem().m_41619_() && this.getItem().m_41783_() != null) {
            return WaystoneItem.getPosition(this.getItem().m_41783_());
        }
        return null;
    }

    public int getSpinning() {
        return this.spinning;
    }

    public void tick() {
        if (this.spinning > 0) {
            --this.spinning;
        }
        if (this.f_58857_ != null) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)AnimatorBlock.POWERED, (Comparable)Boolean.valueOf(this.checkCage() && this.getPosition() != null)), 3);
        }
    }

    public void generateManyParticles() {
        BlockPos blockpos = this.m_58899_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            ServerLevel serverWorld = (ServerLevel)this.f_58857_;
            for (int k = 0; k < 20; ++k) {
                double d9 = (double)blockpos.m_123341_() + 0.5 + (this.f_58857_.f_46441_.m_188500_() - 0.5) * 2.0;
                double d13 = (double)blockpos.m_123342_() + 0.5 + (this.f_58857_.f_46441_.m_188500_() - 0.5) * 2.0;
                double d19 = (double)blockpos.m_123343_() + 0.5 + (this.f_58857_.f_46441_.m_188500_() - 0.5) * 2.0;
                serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123762_, d9, d13, d19, 1, 0.0, 0.0, 0.0, 0.0);
                serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123744_, d9, d13, d19, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    private boolean checkCage() {
        BlockEntity tileentity;
        BlockPos pos;
        BlockState blockState;
        if (this.f_58857_ != null && (blockState = this.f_58857_.m_8055_(pos = new BlockPos(this.m_58899_().m_123341_(), this.m_58899_().m_123342_() - 1, this.m_58899_().m_123343_()))).m_60713_((Block)ModBlocks.CURSED_CAGE_BLOCK.get()) && (tileentity = this.f_58857_.m_7702_(pos)) instanceof CursedCageBlockEntity) {
            CursedCageBlockEntity cageBlock;
            this.cursedCageTile = cageBlock = (CursedCageBlockEntity)tileentity;
            return !this.cursedCageTile.getItem().m_41619_();
        }
        return false;
    }

    @Override
    public boolean isShowBlock() {
        return this.showBlock;
    }

    @Override
    public void setShowBlock(boolean showBlock) {
        this.showBlock = showBlock;
        this.markUpdated();
    }

    public void markNetworkDirty() {
    }

    public CompoundTag m_5995_() {
        return this.writeNetwork(super.m_5995_());
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.readNetwork(pkt.m_131708_());
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.m_142466_(tag);
        this.readNetwork(tag);
    }

    public void readNetwork(CompoundTag tag) {
        this.item = ItemStack.m_41712_((CompoundTag)tag.m_128469_("item"));
        if (tag.m_128441_("showBlock")) {
            this.showBlock = tag.m_128471_("showBlock");
        }
    }

    public CompoundTag writeNetwork(CompoundTag tag) {
        tag.m_128365_("item", (Tag)this.item.m_41739_(new CompoundTag()));
        tag.m_128379_("showBlock", this.showBlock);
        return tag;
    }

    public void m_6211_() {
        this.setItem(ItemStack.f_41583_);
    }

    public void markUpdated() {
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void m_142466_(CompoundTag compound) {
        this.readNetwork(compound);
        super.m_142466_(compound);
    }

    public void m_183515_(CompoundTag compound) {
        this.writeNetwork(compound);
        super.m_183515_(compound);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

