/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render.model;

import com.Polarice3.Goety.client.render.animation.WildfireAnimations;
import com.Polarice3.Goety.common.entities.neutral.Wildfire;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class WildfireModel<T extends Wildfire>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart wildfire;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart shields;
    private final ModelPart[] shieldParts = new ModelPart[4];

    public WildfireModel(ModelPart root) {
        this.root = root;
        this.wildfire = root.m_171324_("wildfire");
        this.body = this.wildfire.m_171324_("body");
        this.head = this.body.m_171324_("head");
        this.shields = this.wildfire.m_171324_("shields");
        for (int i = 0; i < this.shieldParts.length; ++i) {
            this.shieldParts[i] = this.shields.m_171324_(WildfireModel.createShieldName(i));
        }
    }

    private static String createShieldName(int p_170573_) {
        return "shield" + p_170573_;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition wildfire = partdefinition.m_171599_("wildfire", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = wildfire.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-2.0f, -21.0f, -2.0f, 4.0f, 21.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(32, 47).m_171488_(-4.0f, -8.95f, -4.0f, 8.0f, 9.0f, 8.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)0.0f, (float)-21.0f, (float)0.1f));
        PartDefinition shields = wildfire.m_171599_("shields", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition shield0 = shields.m_171599_("shield0", CubeListBuilder.m_171558_().m_171514_(16, 18).m_171488_(-5.0f, 0.0f, -1.0f, 10.0f, 17.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-22.0f, (float)-9.0f));
        PartDefinition shield1 = shields.m_171599_("shield1", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)9.0f, (float)-22.0f, (float)0.0f));
        PartDefinition shield1_r1 = shield1.m_171599_("shield1_r1", CubeListBuilder.m_171558_().m_171514_(16, 18).m_171488_(-5.0f, -22.0f, 8.0f, 10.0f, 17.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-9.0f, (float)22.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition shield2 = shields.m_171599_("shield2", CubeListBuilder.m_171558_().m_171514_(16, 18).m_171488_(-5.0f, 0.0f, -1.0f, 10.0f, 17.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-22.0f, (float)9.0f));
        PartDefinition shield3 = shields.m_171599_("shield3", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-9.0f, (float)-22.0f, (float)0.0f));
        PartDefinition shield3_r1 = shield3.m_171599_("shield3_r1", CubeListBuilder.m_171558_().m_171514_(16, 18).m_171488_(-5.0f, -22.0f, -10.0f, 10.0f, 17.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)9.0f, (float)22.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        if (!entity.m_21224_()) {
            this.animateHeadLookTarget(netHeadYaw, headPitch);
        }
        this.m_233381_(((Wildfire)entity).spinAnimationState, WildfireAnimations.SPIN, ageInTicks);
        this.m_233381_(((Wildfire)entity).idleAnimationState, WildfireAnimations.IDLE, ageInTicks);
        this.m_233381_(((Wildfire)entity).shockwaveAnimationState, WildfireAnimations.SHOCKWAVE, ageInTicks);
        this.m_233381_(((Wildfire)entity).shootAnimationState, WildfireAnimations.SHOOT, ageInTicks);
        if (((Wildfire)entity).canAnimateMove()) {
            this.m_267799_(WildfireAnimations.WALK, limbSwing, limbSwingAmount, 1.0f, 2.5f);
        }
        for (int i = 0; i < 4; ++i) {
            this.shieldParts[i].f_104207_ = i < ((Wildfire)entity).getShields();
        }
    }

    private void animateHeadLookTarget(float netHeadYaw, float headPitch) {
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

