/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render.model;

import com.Polarice3.Goety.client.render.animation.BlastlingAnimations;
import com.Polarice3.Goety.common.entities.neutral.ender.AbstractBlastling;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.AnimationState;

public class BlastlingModel<T extends AbstractBlastling>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart watchling;
    private final ModelPart body;
    private final ModelPart head;

    public BlastlingModel(ModelPart root) {
        this.root = root;
        this.watchling = root.m_171324_("watchling");
        this.body = this.watchling.m_171324_("body");
        this.head = this.body.m_171324_("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition watchling = partdefinition.m_171599_("watchling", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = watchling.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 15).m_171488_(-6.0f, -11.5f, -3.0f, 12.0f, 14.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-25.5f, (float)-2.0f, (float)0.3054f, (float)-0.0436f, (float)0.0175f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -6.0f, 8.0f, 8.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-7.5f, (float)0.0f, (float)-0.2269f, (float)0.0f, (float)0.0f));
        PartDefinition flames = head.m_171599_("flames", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition front = flames.m_171599_("front", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)-6.0f));
        PartDefinition cube_r1 = front.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(96, 0).m_171488_(-12.0f, -9.0f, 0.0f, 16.0f, 16.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)-5.0f, (float)3.0f, (float)-0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition back = flames.m_171599_("back", CubeListBuilder.m_171558_().m_171514_(96, 0).m_171488_(-8.0f, -16.0f, 0.0f, 16.0f, 16.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)0.5f));
        PartDefinition left = flames.m_171599_("left", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)4.5872f, (float)0.0038f, (float)1.0f));
        PartDefinition cube_r2 = left.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(96, -16).m_171488_(-0.6972f, -15.9696f, -8.0f, 0.0f, 16.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0873f));
        PartDefinition right = flames.m_171599_("right", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-4.5872f, (float)0.0038f, (float)1.0f));
        PartDefinition cube_r3 = right.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(96, -16).m_171488_(0.6972f, -15.9696f, -8.0f, 0.0f, 16.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0873f));
        PartDefinition top = flames.m_171599_("top", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-8.5f, (float)-1.0f));
        PartDefinition cube_r4 = top.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(80, 0).m_171488_(-8.0f, 0.0f, 0.0f, 16.0f, 0.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition eyes = head.m_171599_("eyes", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_eye = eyes.m_171599_("right_eye", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.0f, -4.0f, -6.05f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_eye = eyes.m_171599_("left_eye", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.0f, -4.0f, -6.05f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_arm = body.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(42, 22).m_171488_(-6.0f, -3.0f, -4.0f, 6.0f, 35.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-6.0f, (float)-8.5f, (float)2.0f, (float)-0.3491f, (float)0.0436f, (float)-0.0262f));
        PartDefinition left_arm = body.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(68, 22).m_171488_(0.0f, -3.0f, -4.0f, 6.0f, 35.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)6.0f, (float)-8.5f, (float)2.0f, (float)-0.3927f, (float)0.0524f, (float)-0.0087f));
        PartDefinition right_leg = watchling.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 38).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 24.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.0f, (float)-24.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0262f));
        PartDefinition left_leg = watchling.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(8, 38).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 24.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)-24.0f, (float)0.0f, (float)-0.0436f, (float)0.0f, (float)-0.0436f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        if (!entity.m_21224_()) {
            this.animateHeadLookTarget(netHeadYaw, headPitch);
        }
        AnimationState animationState = new AnimationState();
        animationState.m_216977_(((AbstractBlastling)entity).f_19797_);
        this.m_233381_(animationState, BlastlingAnimations.SCALE, ageInTicks);
        this.m_233381_(((AbstractBlastling)entity).idleAnimationState, BlastlingAnimations.CUSTOM_IDLE, ageInTicks);
        this.m_267799_(BlastlingAnimations.WALK, limbSwing, limbSwingAmount, 2.5f, 20.0f);
        this.m_233381_(((AbstractBlastling)entity).preAttackAnimationState, BlastlingAnimations.PRE_ATTACK, ageInTicks);
        this.m_233381_(((AbstractBlastling)entity).attackAnimationState, BlastlingAnimations.SHOT, ageInTicks);
        this.m_233381_(((AbstractBlastling)entity).postAttackAnimationState, BlastlingAnimations.POST_ATTACK, ageInTicks);
    }

    private void animateHeadLookTarget(float netHeadYaw, float headPitch) {
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

