/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render.model;

import com.Polarice3.Goety.common.entities.ally.BlackWolf;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class BlackWolfModel<T extends BlackWolf>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart hound;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart upperBody;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart tail;
    private float r = 1.0f;
    private float g = 1.0f;
    private float b = 1.0f;

    public BlackWolfModel(ModelPart root) {
        this.root = root;
        this.hound = root.m_171324_("hound");
        this.head = this.hound.m_171324_("head");
        this.body = this.hound.m_171324_("body");
        this.upperBody = this.hound.m_171324_("upperBody");
        this.rightHindLeg = this.hound.m_171324_("right_hind_leg");
        this.leftHindLeg = this.hound.m_171324_("left_hind_leg");
        this.rightFrontLeg = this.hound.m_171324_("right_front_leg");
        this.leftFrontLeg = this.hound.m_171324_("left_front_leg");
        this.tail = this.hound.m_171324_("tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition hound = partdefinition.m_171599_("hound", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition head = hound.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.5f, -3.0f, -2.0f, 7.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(58, 7).m_171488_(-1.5f, 3.0f, 1.0f, 3.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(56, 1).m_171488_(0.0f, -5.0f, -2.0f, 0.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 10).m_171488_(-2.0f, -0.0156f, -5.0f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 27).m_171488_(-2.0f, 2.9844f, -5.0f, 4.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-8.0f, (float)-8.0f));
        PartDefinition head_r1 = head.m_171599_("head_r1", CubeListBuilder.m_171558_().m_171514_(18, 0).m_171480_().m_171488_(-1.0f, -2.0f, -0.5f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)2.5f, (float)-3.5f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.4363f));
        PartDefinition head_r2 = head.m_171599_("head_r2", CubeListBuilder.m_171558_().m_171514_(18, 0).m_171488_(-1.0f, -2.0f, -0.5f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.5f, (float)-3.5f, (float)0.5f, (float)0.0f, (float)0.0f, (float)-0.4363f));
        PartDefinition body = hound.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171488_(-4.0f, 0.0f, -4.0f, 6.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.0f, (float)-9.0f, (float)2.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition upperBody = hound.m_171599_("upperBody", CubeListBuilder.m_171558_().m_171514_(22, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-9.0f, (float)2.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition upperBody_r1 = upperBody.m_171599_("upperBody_r1", CubeListBuilder.m_171558_().m_171514_(46, 0).m_171488_(-4.0f, 0.0f, -0.5f, 8.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-2.75f, (float)3.55f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition upperBody_r2 = upperBody.m_171599_("upperBody_r2", CubeListBuilder.m_171558_().m_171514_(46, 0).m_171488_(-4.0f, 0.0f, -0.5f, 8.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-7.75f, (float)3.55f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition right_hind_leg = hound.m_171599_("right_hind_leg", CubeListBuilder.m_171558_().m_171514_(0, 17).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.5f, (float)-8.0f, (float)7.0f));
        PartDefinition left_hind_leg = hound.m_171599_("left_hind_leg", CubeListBuilder.m_171558_().m_171514_(0, 17).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.5f, (float)-8.0f, (float)7.0f));
        PartDefinition right_front_leg = hound.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171514_(0, 17).m_171488_(-2.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.5f, (float)-8.0f, (float)-4.0f));
        PartDefinition left_front_leg = hound.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171514_(0, 17).m_171488_(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.5f, (float)-8.0f, (float)-4.0f));
        PartDefinition tail = hound.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(8, 17).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-10.0f, (float)8.0f, (float)0.9599f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void prepareMobModel(T p_104132_, float p_104133_, float p_104134_, float p_104135_) {
        this.tail.f_104204_ = 0.0f;
        if (((BlackWolf)p_104132_).isSitting()) {
            this.head.m_104227_(0.0f, -12.0f, -5.0f);
            this.upperBody.m_104227_(0.0f, -6.0f, 2.0f);
            this.upperBody.f_104203_ = 0.8727f;
            this.body.m_104227_(1.0f, -8.0f, 1.0f);
            this.body.f_104203_ = 0.4363f;
            this.tail.m_104227_(0.0f, -2.0f, 4.0f);
            this.rightHindLeg.m_104227_(-1.5f, -1.0f, 3.0f);
            this.rightHindLeg.f_104203_ = -1.5708f;
            this.leftHindLeg.m_104227_(1.5f, -1.0f, 3.0f);
            this.leftHindLeg.f_104203_ = -1.5708f;
            this.rightFrontLeg.f_104203_ = -0.4363f;
            this.rightFrontLeg.m_104227_(-1.5f, -7.0f, -4.0f);
            this.leftFrontLeg.f_104203_ = -0.4363f;
            this.leftFrontLeg.m_104227_(1.5f, -7.0f, -4.0f);
        } else {
            this.head.m_104227_(0.0f, -8.0f, -8.0f);
            this.body.m_104227_(1.0f, -9.0f, 2.0f);
            this.body.f_104203_ = 1.5707964f;
            this.upperBody.m_104227_(0.0f, -9.0f, 2.0f);
            this.upperBody.f_104203_ = this.body.f_104203_;
            this.tail.m_104227_(0.0f, -10.0f, 8.0f);
            this.rightHindLeg.m_104227_(-1.5f, -8.0f, 7.0f);
            this.leftHindLeg.m_104227_(1.5f, -8.0f, 7.0f);
            this.rightFrontLeg.m_104227_(-1.5f, -8.0f, -4.0f);
            this.leftFrontLeg.m_104227_(1.5f, -8.0f, -4.0f);
            this.rightHindLeg.f_104203_ = Mth.m_14089_((float)(p_104133_ * 0.6662f)) * 1.4f * p_104134_ * 0.5f;
            this.leftHindLeg.f_104203_ = Mth.m_14089_((float)(p_104133_ * 0.6662f + (float)Math.PI)) * 1.4f * p_104134_ * 0.5f;
            this.rightFrontLeg.f_104203_ = Mth.m_14089_((float)(p_104133_ * 0.6662f + (float)Math.PI)) * 1.4f * p_104134_ * 0.5f;
            this.leftFrontLeg.f_104203_ = Mth.m_14089_((float)(p_104133_ * 0.6662f)) * 1.4f * p_104134_ * 0.5f;
        }
        this.head.f_104205_ = ((BlackWolf)p_104132_).getHeadRollAngle(p_104135_) + ((BlackWolf)p_104132_).getBodyRollAngle(p_104135_, 0.0f);
        this.upperBody.f_104205_ = ((BlackWolf)p_104132_).getBodyRollAngle(p_104135_, -0.08f);
        this.body.f_104205_ = ((BlackWolf)p_104132_).getBodyRollAngle(p_104135_, -0.16f);
        this.tail.f_104205_ = ((BlackWolf)p_104132_).getBodyRollAngle(p_104135_, -0.2f);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.rightHindLeg, (Object)this.leftHindLeg, (Object)this.rightFrontLeg, (Object)this.leftFrontLeg, (Object)this.tail, (Object)this.upperBody);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void setColor(float p_102420_, float p_102421_, float p_102422_) {
        this.r = p_102420_;
        this.g = p_102421_;
        this.b = p_102422_;
    }

    public void m_7695_(PoseStack p_102424_, VertexConsumer p_102425_, int p_102426_, int p_102427_, float p_102428_, float p_102429_, float p_102430_, float p_102431_) {
        if (this.f_102610_) {
            p_102424_.m_85836_();
            p_102424_.m_252880_(0.0f, 1.75f, 0.25f);
            this.headParts().forEach(p_102081_ -> p_102081_.m_104306_(p_102424_, p_102425_, p_102426_, p_102427_, this.r * p_102428_, this.g * p_102429_, this.b * p_102430_, p_102431_));
            p_102424_.m_85849_();
            p_102424_.m_85836_();
            float f1 = 0.5f;
            p_102424_.m_85841_(f1, f1, f1);
            p_102424_.m_252880_(0.0f, 3.0f, 0.0f);
            this.bodyParts().forEach(p_102071_ -> p_102071_.m_104306_(p_102424_, p_102425_, p_102426_, p_102427_, this.r * p_102428_, this.g * p_102429_, this.b * p_102430_, p_102431_));
            p_102424_.m_85849_();
        } else {
            super.m_7695_(p_102424_, p_102425_, p_102426_, p_102427_, this.r * p_102428_, this.g * p_102429_, this.b * p_102430_, p_102431_);
        }
    }
}

