/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render;

import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.client.render.ModModelLayer;
import com.Polarice3.Goety.client.render.model.TidalSurgeModel;
import com.Polarice3.Goety.common.entities.projectiles.AbstractWave;
import com.Polarice3.Goety.utils.MathHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;

public class TidalSurgeRenderer<T extends AbstractWave>
extends EntityRenderer<T> {
    private static final ResourceLocation TEXTURE_0 = Goety.location("textures/entity/projectiles/tidal_surge/surge_0.png");
    private static final ResourceLocation TEXTURE_1 = Goety.location("textures/entity/projectiles/tidal_surge/surge_1.png");
    private static final ResourceLocation TEXTURE_2 = Goety.location("textures/entity/projectiles/tidal_surge/surge_2.png");
    private static final ResourceLocation TEXTURE_3 = Goety.location("textures/entity/projectiles/tidal_surge/surge_3.png");
    private static final ResourceLocation OVERLAY_TEXTURE_0 = Goety.location("textures/entity/projectiles/tidal_surge/overlay_0.png");
    private static final ResourceLocation OVERLAY_TEXTURE_1 = Goety.location("textures/entity/projectiles/tidal_surge/overlay_1.png");
    private static final ResourceLocation OVERLAY_TEXTURE_2 = Goety.location("textures/entity/projectiles/tidal_surge/overlay_2.png");
    private static final ResourceLocation OVERLAY_TEXTURE_3 = Goety.location("textures/entity/projectiles/tidal_surge/overlay_3.png");
    private final TidalSurgeModel<T> model;

    public TidalSurgeRenderer(EntityRendererProvider.Context p_174008_) {
        super(p_174008_);
        this.model = new TidalSurgeModel(p_174008_.m_174023_(ModModelLayer.TIDAL_SURGE));
    }

    public void render(T entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        if (entityIn.m_20145_()) {
            return;
        }
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(0.0, 1.5, 0.0);
        matrixStackIn.m_252781_(Axis.f_252392_.m_252977_(Mth.m_14179_((float)partialTicks, (float)((AbstractWave)((Object)entityIn)).f_19859_, (float)((AbstractWave)((Object)entityIn)).m_146908_()) + 180.0f));
        float ageInTicks = (float)((AbstractWave)((Object)entityIn)).activeWaveTicks + partialTicks;
        float f = ageInTicks / 10.0f;
        matrixStackIn.m_85837_(0.0, -0.1 + (1.0 - (double)(f * 0.5f)) * -1.0, -0.5);
        matrixStackIn.m_85841_((0.2f + f) * 0.9f, -1.0f, 1.0f);
        this.model.setupAnim(entityIn, 0.0f, 0.0f, ageInTicks, 0.0f, 0.0f);
        VertexConsumer waveConsumer = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)this.getWaveTexture(((AbstractWave)((Object)entityIn)).activeWaveTicks)));
        int waterColorAt = ((Biome)((AbstractWave)((Object)entityIn)).f_19853_.m_204166_(entityIn.m_20183_()).get()).m_47560_();
        float[] color = MathHelper.rgbFloat(waterColorAt);
        this.model.m_7695_(matrixStackIn, waveConsumer, packedLightIn, OverlayTexture.f_118083_, color[0], color[1], color[2], 1.0f);
        VertexConsumer overlayConsumer = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)this.getOverlayTexture(((AbstractWave)((Object)entityIn)).activeWaveTicks)));
        float[] overlayColor = new float[]{Math.min(1.0f, color[0] + 0.5f), Math.min(1.0f, color[1] + 0.5f), Math.min(1.0f, color[2] + 0.5f)};
        this.model.m_7695_(matrixStackIn, overlayConsumer, packedLightIn, OverlayTexture.f_118083_, overlayColor[0], overlayColor[1], overlayColor[2], 1.0f);
        matrixStackIn.m_85849_();
        super.m_7392_(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    public ResourceLocation getTextureLocation(T entity) {
        return this.getWaveTexture(((AbstractWave)((Object)entity)).activeWaveTicks);
    }

    private ResourceLocation getWaveTexture(int tickCount) {
        int j = tickCount % 12 / 3;
        return switch (j) {
            case 0 -> TEXTURE_0;
            case 1 -> TEXTURE_1;
            case 2 -> TEXTURE_2;
            default -> TEXTURE_3;
        };
    }

    private ResourceLocation getOverlayTexture(int tickCount) {
        int j = tickCount % 12 / 3;
        return switch (j) {
            case 0 -> OVERLAY_TEXTURE_0;
            case 1 -> OVERLAY_TEXTURE_1;
            case 2 -> OVERLAY_TEXTURE_2;
            default -> OVERLAY_TEXTURE_3;
        };
    }
}

