/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render;

import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.client.render.ModModelLayer;
import com.Polarice3.Goety.client.render.model.HauntedPaintingModel;
import com.Polarice3.Goety.common.entities.deco.HauntedPainting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.decoration.PaintingVariant;
import org.joml.Quaternionf;

public class HauntedPaintingRenderer
extends EntityRenderer<HauntedPainting> {
    public static final ResourceLocation SMALL_FRAME_TEXTURE = Goety.location("textures/painting/frame/small.png");
    public static final ResourceLocation MEDIUM_FRAME_TEXTURE = Goety.location("textures/painting/frame/medium.png");
    public static final ResourceLocation LARGE_FRAME_TEXTURE = Goety.location("textures/painting/frame/large.png");
    public static final ResourceLocation WIDE_FRAME_TEXTURE = Goety.location("textures/painting/frame/wide.png");
    public static final ResourceLocation TALL_FRAME_TEXTURE = Goety.location("textures/painting/frame/tall.png");

    public HauntedPaintingRenderer(EntityRendererProvider.Context p_174332_) {
        super(p_174332_);
    }

    public void render(HauntedPainting entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        ResourceLocation frameTexture;
        HauntedPaintingModel model;
        EntityModelSet modelSet = Minecraft.m_91087_().m_167973_();
        PaintingVariant variant = (PaintingVariant)entity.m_28554_().m_203334_();
        Direction direction = entity.m_6350_();
        int width = variant.m_218908_();
        int height = variant.m_218909_();
        if (width == 32 && height == 32) {
            model = new HauntedPaintingModel(modelSet.m_171103_(ModModelLayer.MEDIUM_PAINTING));
            frameTexture = MEDIUM_FRAME_TEXTURE;
            poseStack.m_252880_(0.0f, -0.4f, 0.0f);
            if (direction == Direction.NORTH) {
                poseStack.m_252880_(-0.4f, 0.0f, 0.0f);
            }
            if (direction == Direction.SOUTH) {
                poseStack.m_252880_(0.4f, 0.0f, 0.0f);
            }
        } else if (width == 48 && height == 32) {
            model = new HauntedPaintingModel(modelSet.m_171103_(ModModelLayer.LARGE_PAINTING));
            frameTexture = LARGE_FRAME_TEXTURE;
            poseStack.m_252880_(0.0f, -0.4f, 0.0f);
            if (direction == Direction.EAST) {
                poseStack.m_252880_(0.0f, 0.0f, 0.4f);
            }
            if (direction == Direction.WEST) {
                poseStack.m_252880_(0.0f, 0.0f, -0.4f);
            }
        } else if (width == 16 && height == 32) {
            model = new HauntedPaintingModel(modelSet.m_171103_(ModModelLayer.TALL_PAINTING));
            frameTexture = TALL_FRAME_TEXTURE;
            poseStack.m_252880_(0.0f, -0.4f, 0.0f);
            if (direction == Direction.EAST) {
                poseStack.m_252880_(0.0f, 0.0f, 0.4f);
            }
            if (direction == Direction.WEST) {
                poseStack.m_252880_(0.0f, 0.0f, -0.4f);
            }
        } else if (width == 32 && height == 16) {
            model = new HauntedPaintingModel(modelSet.m_171103_(ModModelLayer.WIDE_PAINTING));
            frameTexture = WIDE_FRAME_TEXTURE;
            if (direction == Direction.NORTH) {
                poseStack.m_252880_(-0.4f, 0.0f, 0.0f);
            }
            if (direction == Direction.SOUTH) {
                poseStack.m_252880_(0.4f, 0.0f, 0.0f);
            }
        } else {
            model = new HauntedPaintingModel(modelSet.m_171103_(ModModelLayer.SMALL_PAINTING));
            frameTexture = SMALL_FRAME_TEXTURE;
            if (direction == Direction.EAST) {
                poseStack.m_252880_(0.0f, 0.0f, 0.4f);
            }
            if (direction == Direction.WEST) {
                poseStack.m_252880_(0.0f, 0.0f, -0.4f);
            }
        }
        poseStack.m_85841_(0.8f, 0.8f, 0.8f);
        switch (direction) {
            case NORTH: {
                poseStack.m_252880_(0.0f, 0.0f, -0.023f);
                break;
            }
            case EAST: {
                poseStack.m_252880_(0.023f, 0.0f, -0.5f);
                break;
            }
            case SOUTH: {
                poseStack.m_252880_(0.0f, 0.0f, 0.023f);
                break;
            }
            case WEST: {
                poseStack.m_252880_(-0.023f, 0.0f, 0.5f);
            }
        }
        try (CloseablePoseStack ignored = new CloseablePoseStack(poseStack);){
            poseStack.m_252880_(0.0f, 0.875f, 0.0f);
            poseStack.m_252781_(Axis.f_252392_.m_252977_(direction.m_122424_().m_122435_()));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
            model.m_7695_(poseStack, buffer.m_6299_(RenderType.m_110446_((ResourceLocation)frameTexture)), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.m_252880_(0.0f, 0.0f, 0.01f);
            poseStack.m_85841_((float)width / 16.0f, (float)height / 16.0f, 1.0f);
            if (width == 32 && height == 32) {
                poseStack.m_252880_(0.75f, -0.3125f, 0.0f);
            } else if (width == 48 && height == 32) {
                poseStack.m_252880_(0.5f, -0.3125f, 0.0f);
            } else if (width == 16 && height == 32) {
                poseStack.m_252880_(0.5f, -0.3125f, 0.0f);
            } else if (width == 32 && height == 16) {
                poseStack.m_252880_(0.75f, 0.375f, 0.0f);
            } else {
                poseStack.m_252880_(0.5f, 0.375f, 0.0f);
            }
            VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)this.getTextureLocation(entity)));
            HauntedPaintingRenderer.renderPainting(poseStack, vertexConsumer, direction, packedLight, OverlayTexture.f_118083_);
        }
    }

    private static void renderPainting(PoseStack poseStack, VertexConsumer consumer, Direction dir, int light, int overlay) {
        Vec3i normal = dir.m_122436_();
        consumer.m_252986_(poseStack.m_85850_().m_252922_(), 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_86008_(overlay).m_85969_(light).m_252939_(poseStack.m_85850_().m_252943_(), (float)normal.m_123341_(), (float)normal.m_123342_(), (float)normal.m_123343_()).m_5752_();
        consumer.m_252986_(poseStack.m_85850_().m_252922_(), 0.0f, 1.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_86008_(overlay).m_85969_(light).m_252939_(poseStack.m_85850_().m_252943_(), (float)normal.m_123341_(), (float)normal.m_123342_(), (float)normal.m_123343_()).m_5752_();
        consumer.m_252986_(poseStack.m_85850_().m_252922_(), -1.0f, 1.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_86008_(overlay).m_85969_(light).m_252939_(poseStack.m_85850_().m_252943_(), (float)normal.m_123341_(), (float)normal.m_123342_(), (float)normal.m_123343_()).m_5752_();
        consumer.m_252986_(poseStack.m_85850_().m_252922_(), -1.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_86008_(overlay).m_85969_(light).m_252939_(poseStack.m_85850_().m_252943_(), (float)normal.m_123341_(), (float)normal.m_123342_(), (float)normal.m_123343_()).m_5752_();
    }

    public ResourceLocation getTextureLocation(HauntedPainting entity) {
        return Goety.location("textures/painting/" + BuiltInRegistries.f_257051_.m_7981_((Object)((PaintingVariant)entity.m_28554_().m_203334_())).m_135815_() + ".png");
    }

    public class CloseablePoseStack
    implements AutoCloseable {
        private final PoseStack stack;

        public CloseablePoseStack(PoseStack stack) {
            this.stack = stack;
            this.stack.m_85836_();
        }

        public void translate(double d, double e, double f) {
            this.stack.m_85837_(d, e, f);
        }

        public void scale(float f, float g, float h) {
            this.stack.m_85841_(f, g, h);
        }

        public void mulPose(Quaternionf quaternion) {
            this.stack.m_252781_(quaternion);
        }

        public PoseStack.Pose last() {
            return this.stack.m_85850_();
        }

        public boolean clear() {
            return this.stack.m_85851_();
        }

        @Override
        public void close() {
            this.stack.m_85849_();
        }
    }
}

