/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render;

import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.client.render.ModModelLayer;
import com.Polarice3.Goety.client.render.model.BlackBeastModel;
import com.Polarice3.Goety.common.entities.ally.BlackBeast;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.EyesLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class BlackBeastRenderer<T extends BlackBeast>
extends MobRenderer<T, BlackBeastModel<T>> {
    private static final ResourceLocation TEXTURES = Goety.location("textures/entity/servants/black_wolf/black_beast.png");
    private static final ResourceLocation PRINCESS = Goety.location("textures/entity/servants/black_wolf/black_beast_princess.png");
    protected static final ResourceLocation DEATH = Goety.location("textures/entity/servants/black_wolf/black_beast_death.png");

    public BlackBeastRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, new BlackBeastModel(renderManagerIn.m_174023_(ModModelLayer.BLACK_BEAST)), 0.0f);
        this.m_115326_((RenderLayer)new BlackBeastEyesLayer(this));
    }

    public void render(T pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        super.m_7392_(pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
        if (((BlackBeast)pEntity).deathTime > 0) {
            pMatrixStack.m_85836_();
            boolean flag = ((BlackBeast)pEntity).f_20916_ > 0;
            float f = Mth.m_14189_((float)pPartialTicks, (float)((BlackBeast)pEntity).f_20884_, (float)((BlackBeast)pEntity).f_20883_);
            float f1 = Mth.m_14189_((float)pPartialTicks, (float)((BlackBeast)pEntity).f_20886_, (float)((BlackBeast)pEntity).f_20885_);
            float f2 = f1 - f;
            float f6 = Mth.m_14179_((float)pPartialTicks, (float)((BlackBeast)pEntity).f_19860_, (float)pEntity.m_146909_());
            float f71 = this.m_6930_((LivingEntity)pEntity, pPartialTicks);
            this.m_7523_((LivingEntity)pEntity, pMatrixStack, f71, f, pPartialTicks);
            pMatrixStack.m_85841_(-1.0f, -1.0f, 1.0f);
            this.m_7546_((LivingEntity)pEntity, pMatrixStack, pPartialTicks);
            pMatrixStack.m_85837_(0.0, (double)-1.501f, 0.0);
            ((BlackBeastModel)this.f_115290_).m_6839_((Entity)pEntity, 0.0f, 0.0f, pPartialTicks);
            ((BlackBeastModel)this.f_115290_).setupAnim(pEntity, 0.0f, 0.0f, f71, f2, f6);
            float f8 = 40.0f;
            float f9 = (float)((BlackBeast)pEntity).deathTime / f8;
            float f10 = 1.0f - (float)((BlackBeast)pEntity).deathTime / 40.0f;
            VertexConsumer vertexconsumer = pBuffer.m_6299_(RenderType.m_173235_((ResourceLocation)DEATH));
            ((BlackBeastModel)this.f_115290_).m_7695_(pMatrixStack, vertexconsumer, pPackedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, f9);
            VertexConsumer ivertexbuilder1 = pBuffer.m_6299_(RenderType.m_110479_((ResourceLocation)this.getTextureLocation(pEntity)));
            ((BlackBeastModel)this.f_115290_).m_7695_(pMatrixStack, ivertexbuilder1, pPackedLight, OverlayTexture.m_118090_((float)0.0f, (boolean)flag), f10, f10, f10, 1.0f);
            pMatrixStack.m_85849_();
        }
    }

    @Nullable
    protected RenderType getRenderType(T p_230496_1_, boolean p_230496_2_, boolean p_230496_3_, boolean p_230496_4_) {
        if (((BlackBeast)p_230496_1_).deathTime > 0) {
            return RenderType.m_173235_((ResourceLocation)DEATH);
        }
        return super.m_7225_(p_230496_1_, p_230496_2_, p_230496_3_, p_230496_4_);
    }

    public ResourceLocation getTextureLocation(T entity) {
        if (((BlackBeast)entity).isPretty()) {
            return PRINCESS;
        }
        return TEXTURES;
    }

    public static class BlackBeastEyesLayer<T extends BlackBeast, M extends BlackBeastModel<T>>
    extends EyesLayer<T, M> {
        private static final ResourceLocation EYES = Goety.location("textures/entity/servants/black_wolf/black_beast_eyes.png");

        public BlackBeastEyesLayer(RenderLayerParent<T, M> p_116981_) {
            super(p_116981_);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, T blackHound, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (!blackHound.m_21224_()) {
                super.m_6494_(matrixStackIn, bufferIn, packedLightIn, blackHound, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
            }
        }

        public RenderType m_5708_() {
            return RenderType.m_110488_((ResourceLocation)EYES);
        }
    }
}

