/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.gui.screen.inventory;

import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.api.items.magic.IFocus;
import com.Polarice3.Goety.client.events.ClientEvents;
import com.Polarice3.Goety.client.gui.radial.GenericRadialMenu;
import com.Polarice3.Goety.client.gui.radial.IRadialMenuHost;
import com.Polarice3.Goety.client.gui.radial.ItemStackRadialMenuItem;
import com.Polarice3.Goety.client.gui.radial.RadialMenuItem;
import com.Polarice3.Goety.client.gui.radial.TextRadialMenuItem;
import com.Polarice3.Goety.common.items.handler.FocusBagItemHandler;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.client.focus.CAddFocusToBagPacket;
import com.Polarice3.Goety.common.network.client.focus.CAddFocusToInventoryPacket;
import com.Polarice3.Goety.common.network.client.focus.CSwapFocusPacket;
import com.Polarice3.Goety.common.network.client.focus.CSwapFocusTwoPacket;
import com.Polarice3.Goety.init.ModKeybindings;
import com.Polarice3.Goety.utils.TotemFinder;
import com.Polarice3.Goety.utils.WandUtil;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandler;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class FocusRadialMenuScreen
extends Screen {
    private ItemStack stackEquipped;
    private IItemHandler focusBagHandler;
    private boolean needsRecheckStacks = true;
    private final List<ItemStackRadialMenuItem> cachedMenuItems = Lists.newArrayList();
    private final TextRadialMenuItem insertMenuItem;
    private final TextRadialMenuItem extractMenuItem;
    private final GenericRadialMenu menu;

    public FocusRadialMenuScreen() {
        super((Component)Component.m_237113_((String)"FOCUS RADIAL MENU"));
        this.stackEquipped = TotemFinder.findBag((Player)Minecraft.m_91087_().f_91074_);
        this.focusBagHandler = this.stackEquipped.m_41613_() > 0 ? FocusBagItemHandler.get(this.stackEquipped) : null;
        this.menu = new GenericRadialMenu(Minecraft.m_91087_(), Goety.location("textures/gui/focus_wheel.png"), new IRadialMenuHost(){

            @Override
            public void renderTooltip(GuiGraphics matrixStack, ItemStack stack, int mouseX, int mouseY) {
                matrixStack.m_280153_(FocusRadialMenuScreen.this.f_96547_, stack, mouseX, mouseY);
            }

            @Override
            public Screen getScreen() {
                return FocusRadialMenuScreen.this;
            }

            @Override
            public Font getFontRenderer() {
                return FocusRadialMenuScreen.this.f_96547_;
            }
        }){

            @Override
            public void onClickOutside() {
                this.close();
            }
        };
        this.insertMenuItem = new TextRadialMenuItem(this.menu, (Component)Component.m_237115_((String)"tooltip.goety.focusBag.bag")){

            @Override
            public boolean onClick() {
                return FocusRadialMenuScreen.this.tryAddFocus();
            }
        };
        this.extractMenuItem = new TextRadialMenuItem(this.menu, (Component)Component.m_237115_((String)"tooltip.goety.focusBag.extract")){

            @Override
            public boolean onClick() {
                return FocusRadialMenuScreen.this.tryExtractFocus();
            }
        };
    }

    @SubscribeEvent
    public static void overlayEvent(RenderGuiOverlayEvent.Pre event) {
        if (event.getOverlay() != VanillaGuiOverlay.CROSSHAIR.type()) {
            return;
        }
        if (Minecraft.m_91087_().f_91080_ instanceof FocusRadialMenuScreen) {
            event.setCanceled(true);
        }
    }

    public void m_7861_() {
        super.m_7861_();
        ClientEvents.wipeOpen();
    }

    public void m_86600_() {
        super.m_86600_();
        this.menu.tick();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && player.m_6084_()) {
            boolean noFocusInBag;
            boolean hasFocusInInv = WandUtil.hasFocusInInv((Player)player);
            boolean hasFocusInBag = this.focusBagHandler != null && TotemFinder.hasFocusInBag((Player)player);
            boolean bl = noFocusInBag = this.focusBagHandler == null || !hasFocusInBag;
            if (this.menu.isClosed() || noFocusInBag && !hasFocusInInv && WandUtil.findFocus((LivingEntity)player).m_41619_()) {
                Minecraft.m_91087_().m_91152_(null);
                ClientEvents.wipeOpen();
            }
            if (!this.menu.isReady() || noFocusInBag && !hasFocusInInv && WandUtil.findFocus((LivingEntity)player).m_41619_()) {
                return;
            }
            ItemStack stack = TotemFinder.findBag((Player)player);
            if (stack.m_41613_() <= 0) {
                this.focusBagHandler = null;
                this.stackEquipped = hasFocusInInv ? WandUtil.findFocusInInv((Player)player) : null;
            } else if (this.stackEquipped != stack) {
                this.stackEquipped = stack;
                this.focusBagHandler = FocusBagItemHandler.get(stack);
                this.needsRecheckStacks = true;
            }
            if (ModKeybindings.wandCircle() != null && !ClientEvents.isKeyDown(ModKeybindings.wandCircle())) {
                this.processClick();
            }
        } else {
            Minecraft.m_91087_().m_91152_(null);
            ClientEvents.wipeOpen();
        }
    }

    public boolean m_6348_(double p_94722_, double p_94723_, int p_94724_) {
        this.processClick();
        return super.m_6348_(p_94722_, p_94723_, p_94724_);
    }

    protected void processClick() {
        this.menu.clickItem();
    }

    public void m_88315_(GuiGraphics matrixStack, int mouseX, int mouseY, float partialTicks) {
        matrixStack.m_280168_().m_85836_();
        super.m_88315_(matrixStack, mouseX, mouseY, partialTicks);
        matrixStack.m_280168_().m_85849_();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && player.m_6084_()) {
            boolean hasFocusInBag;
            boolean hasFocusInInv = WandUtil.hasFocusInInv((Player)player);
            boolean bl = hasFocusInBag = this.focusBagHandler != null && TotemFinder.hasFocusInBag((Player)player);
            if (!(this.focusBagHandler != null && hasFocusInBag || hasFocusInInv || !WandUtil.findFocus((LivingEntity)player).m_41619_())) {
                return;
            }
            ItemStack inHand = WandUtil.findWand((LivingEntity)player);
            if (this.needsRecheckStacks) {
                ItemStackRadialMenuItem item;
                ItemStack inSlot;
                int i;
                this.cachedMenuItems.clear();
                if (this.focusBagHandler != null) {
                    for (i = 1; i < this.focusBagHandler.getSlots(); ++i) {
                        inSlot = this.focusBagHandler.getStackInSlot(i);
                        item = new ItemStackRadialMenuItem(this.menu, i, inSlot, (Component)Component.m_237115_((String)"tooltip.goety.focusBag.empty")){

                            @Override
                            public boolean onClick() {
                                return FocusRadialMenuScreen.this.trySwap(this.getSlot(), this.getStack());
                            }
                        };
                        item.setVisible(inSlot.m_41613_() > 0);
                        this.cachedMenuItems.add(item);
                    }
                }
                for (i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
                    inSlot = player.m_150109_().m_8020_(i);
                    if (!(inSlot.m_41720_() instanceof IFocus)) continue;
                    item = new ItemStackRadialMenuItem(this.menu, i, inSlot, (Component)Component.m_237115_((String)"tooltip.goety.focusBag.empty")){

                        @Override
                        public boolean onClick() {
                            return FocusRadialMenuScreen.this.trySwapInv(this.getSlot(), this.getStack());
                        }
                    };
                    item.setVisible(inSlot.m_41613_() > 0);
                    this.cachedMenuItems.add(item);
                }
                this.menu.clear();
                this.menu.addAll(this.cachedMenuItems);
                this.menu.add(this.insertMenuItem);
                this.menu.add(this.extractMenuItem);
                this.needsRecheckStacks = false;
            }
            boolean hasAddButton = !this.cachedMenuItems.stream().allMatch(RadialMenuItem::isVisible) && inHand.m_41613_() > 0;
            this.insertMenuItem.setVisible(hasAddButton && this.focusBagHandler != null && TotemFinder.hasEmptyBagSpace((Player)player) && !WandUtil.findFocus((LivingEntity)player).m_41619_());
            this.extractMenuItem.setVisible(!WandUtil.findFocus((LivingEntity)player).m_41619_() && player.m_150109_().m_36062_() != -1);
            if (!WandUtil.findFocus((LivingEntity)player).m_41619_()) {
                this.menu.setCentralItem(WandUtil.findFocus((LivingEntity)player));
            } else {
                this.menu.setCentralItem(ItemStack.f_41583_);
            }
            this.menu.draw(matrixStack, partialTicks, mouseX, mouseY);
        } else {
            this.menu.close();
        }
    }

    private boolean trySwap(int slotNumber, ItemStack itemMouseOver) {
        ItemStack inHand = WandUtil.findWand((LivingEntity)Minecraft.m_91087_().f_91074_);
        if (inHand.m_41613_() > 0 || itemMouseOver.m_41613_() > 0) {
            ModNetwork.sendToServer(new CSwapFocusPacket(slotNumber));
        }
        this.menu.close();
        return true;
    }

    private boolean trySwapInv(int slotNumber, ItemStack itemMouseOver) {
        ItemStack inHand = WandUtil.findWand((LivingEntity)Minecraft.m_91087_().f_91074_);
        if (inHand.m_41613_() > 0 || itemMouseOver.m_41613_() > 0) {
            ModNetwork.sendToServer(new CSwapFocusTwoPacket(slotNumber));
        }
        this.menu.close();
        return true;
    }

    private boolean tryAddFocus() {
        ItemStack inHand = WandUtil.findWand((LivingEntity)Minecraft.m_91087_().f_91074_);
        if (inHand.m_41613_() > 0) {
            ModNetwork.sendToServer(new CAddFocusToBagPacket());
        }
        this.menu.close();
        return true;
    }

    private boolean tryExtractFocus() {
        ItemStack inHand = WandUtil.findFocus((LivingEntity)Minecraft.m_91087_().f_91074_);
        if (inHand.m_41613_() > 0) {
            ModNetwork.sendToServer(new CAddFocusToInventoryPacket());
        }
        this.menu.close();
        return true;
    }

    public boolean m_7043_() {
        return false;
    }
}

