/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;

public class SandCastleManager {
    private static final Map<Long, Set<BlockPos>> sandCastleChunks = new HashMap<Long, Set<BlockPos>>();

    private static long getChunkKey(BlockPos pos) {
        int chunkX = pos.m_123341_() >> 4;
        int chunkZ = pos.m_123343_() >> 4;
        return (long)chunkX & 0xFFFFFFFFL | ((long)chunkZ & 0xFFFFFFFFL) << 32;
    }

    public static void registerSandCastle(BlockPos pos) {
        long chunkKey = SandCastleManager.getChunkKey(pos);
        sandCastleChunks.computeIfAbsent(chunkKey, k -> new HashSet()).add(pos);
    }

    public static void unregisterSandCastle(BlockPos pos) {
        long chunkKey = SandCastleManager.getChunkKey(pos);
        Set<BlockPos> positions = sandCastleChunks.get(chunkKey);
        if (positions != null) {
            positions.remove(pos);
            if (positions.isEmpty()) {
                sandCastleChunks.remove(chunkKey);
            }
        }
    }

    public static BlockPos getNearestSandCastle(BlockPos mobPos) {
        int chunkX = mobPos.m_123341_() >> 4;
        int chunkZ = mobPos.m_123343_() >> 4;
        BlockPos nearestPos = null;
        double nearestDistance = Double.MAX_VALUE;
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                long chunkKey = (long)(chunkX + dx) & 0xFFFFFFFFL | ((long)(chunkZ + dz) & 0xFFFFFFFFL) << 32;
                Set<BlockPos> positions = sandCastleChunks.get(chunkKey);
                if (positions == null) continue;
                for (BlockPos pos : positions) {
                    double distance = pos.m_123331_((Vec3i)mobPos);
                    if (!(distance < nearestDistance)) continue;
                    nearestDistance = distance;
                    nearestPos = pos;
                }
            }
        }
        return nearestPos;
    }
}

