/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.beachparty.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class HangingCoconutBlock
extends FallingBlock
implements BonemealableBlock {
    public static final IntegerProperty AGE = BlockStateProperties.f_61406_;
    protected static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.m_49796_((double)4.0, (double)7.0, (double)4.0, (double)12.0, (double)15.0, (double)12.0), Block.m_49796_((double)3.0, (double)5.0, (double)3.0, (double)13.0, (double)15.0, (double)13.0), Block.m_49796_((double)2.0, (double)3.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0)};
    private static final float FALL_DAMAGE = 2.0f;
    private static final int FALL_DAMAGE_THRESHOLD = 40;
    private static final float COCONUT_SMASH_VOLUME = 0.7f;
    private static final float COCONUT_SMASH_PITCH_BASE = 0.9f;

    public HangingCoconutBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return level.m_8055_(pos.m_7494_()).m_60713_((Block)ObjectRegistry.PALM_LEAVES.get());
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.UP && !this.m_7898_(state, (LevelReader)level, currentPos)) {
            if (!level.m_5776_()) {
                level.m_186460_(currentPos, (Block)this, 1);
            }
            return state;
        }
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    public boolean m_6724_(BlockState state) {
        return true;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int age = (Integer)state.m_61143_((Property)AGE);
        if (random.m_188503_(3) == 0) {
            if (age < 2) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age + 1)), 2);
            } else if (pos.m_123342_() >= level.m_141937_() && HangingCoconutBlock.m_53241_((BlockState)level.m_8055_(pos.m_7495_()))) {
                FallingBlockEntity fallingEntity = FallingBlockEntity.m_201971_((Level)level, (BlockPos)pos, (BlockState)level.m_8055_(pos));
                this.m_6788_(fallingEntity);
                level.m_7471_(pos, false);
            }
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (level.m_46859_(pos.m_7494_()) && pos.m_123342_() >= level.m_141937_() && HangingCoconutBlock.m_53241_((BlockState)level.m_8055_(pos.m_7495_()))) {
            FallingBlockEntity fallingEntity = FallingBlockEntity.m_201971_((Level)level, (BlockPos)pos, (BlockState)level.m_8055_(pos));
            this.m_6788_(fallingEntity);
            level.m_7471_(pos, false);
        }
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_AGE[(Integer)state.m_61143_((Property)AGE)];
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        return (Integer)state.m_61143_((Property)AGE) < 2;
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)AGE) + 1)), 2);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE});
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    protected void m_6788_(FallingBlockEntity entity) {
        entity.m_149656_(2.0f, 40);
    }

    @NotNull
    public DamageSource m_252932_(Entity entity) {
        return entity.m_269291_().m_269564_(entity);
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (random.m_188503_(16) == 0 && (Integer)state.m_61143_((Property)AGE) == 2) {
            double x = (double)pos.m_123341_() + random.m_188500_();
            double y = (double)pos.m_123342_() - 0.05;
            double z = (double)pos.m_123343_() + random.m_188500_();
            level.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(0.545f, 0.345f, 0.169f), 1.0f), x, y, z, 0.0, -0.2, 0.0);
        }
    }

    public void m_142525_(Level level, BlockPos pos, FallingBlockEntity fallingEntity) {
        level.m_5594_(null, pos, SoundEvents.f_11716_, SoundSource.BLOCKS, 0.7f, 0.9f + level.m_213780_().m_188501_() * 0.2f);
        if (level instanceof ServerLevel) {
            RandomSource random = level.m_213780_();
            int chance = random.m_188503_(100);
            if (chance < 5) {
                HangingCoconutBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ObjectRegistry.PALM_SPROUT.get().m_5456_()));
            } else if (chance < 25) {
                HangingCoconutBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)((Item)ObjectRegistry.COCONUT_OPEN.get()).m_5456_()));
            } else if (chance < 100) {
                HangingCoconutBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)((Item)ObjectRegistry.COCONUT.get()).m_5456_()));
            }
        }
    }
}

