/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class EMTUtils {
    public static boolean SHOW_ITEM_CD;
    public static final String TIP_SUFFIX = ".tip";
    public static final String CONFIG_SUFFIX = ".config";
    public static final String OTHER_PREFIX = "other.";
    public static final String MOD_ID = "eeeabsmobs.";
    public static final String ITEM_PREFIX = "item.";
    public static final String ITEM_ARMOR_PREFIX = "item.armor.";
    public static final String ITEM_OTHER_PREFIX = "item.other.";
    public static final String ITEM_STRUCTURE_PREFIX = "item.structure.";
    public static final String KEY_PREFIX = "hotkeys.";
    public static final Component UNABLE_BREAKS;
    public static final Component HOLD_SHIFT_KEY;

    private EMTUtils() {
    }

    public static Component simpleText(String prefix, String key, ChatFormatting format, Object ... args) {
        return EMTUtils.simpleText(prefix, key, format, TIP_SUFFIX, args);
    }

    public static Component simpleText(String prefix, String key, ChatFormatting format, String suffix, Object ... args) {
        MutableComponent component;
        String finalPrefix = prefix + MOD_ID;
        if (args == null) {
            args = new Object[]{};
        }
        if (key == null) {
            component = Component.m_237110_((String)(finalPrefix + suffix.substring(1)), (Object[])args);
        } else {
            key = EMTUtils.subDescriptionId(key);
            component = Component.m_237110_((String)(finalPrefix + key + suffix), (Object[])args);
        }
        if (format != null) {
            component.m_130940_(format);
        }
        return component;
    }

    public static Component itemCoolTime(double args) {
        return EMTUtils.simpleText(ITEM_OTHER_PREFIX, args == 0.0 ? "no_cd" : "cd", ChatFormatting.GREEN, args);
    }

    public static Component simpleItemText(String key, Object ... args) {
        return EMTUtils.simpleText(ITEM_PREFIX, key, ChatFormatting.GRAY, args);
    }

    public static Component simpleArmorText(String key, ChatFormatting format, Object ... args) {
        return EMTUtils.simpleText(ITEM_ARMOR_PREFIX, key, format, args);
    }

    public static Component simpleOtherText(String key, ChatFormatting format, Object ... args) {
        return EMTUtils.simpleText(ITEM_OTHER_PREFIX, key, format, args);
    }

    public static Component simpleConfigText(String key, ChatFormatting format, Object ... args) {
        return EMTUtils.simpleText(OTHER_PREFIX, key, format, CONFIG_SUFFIX, args);
    }

    public static List<Component> complexText(String prefix, int count, ChatFormatting format, String key, Object ... args) {
        ArrayList<Component> components = new ArrayList<Component>();
        if (args == null) {
            args = new Object[]{};
        }
        for (int i = 1; i <= count; ++i) {
            StringBuilder sb = new StringBuilder();
            MutableComponent component = Component.m_237110_((String)sb.append(prefix).append(MOD_ID).append(EMTUtils.subDescriptionId(key)).append(TIP_SUFFIX).append("_").append(i).toString(), (Object[])args);
            if (format != null) {
                component.m_130940_(format);
            }
            components.add((Component)component);
        }
        return components;
    }

    public static List<Component> complexText(String prefix, boolean hasIndex, ChatFormatting format, String ... keys) {
        ArrayList<Component> components = new ArrayList<Component>();
        for (int i = 0; i < keys.length; ++i) {
            StringBuilder sb = new StringBuilder();
            sb.append(prefix).append(MOD_ID).append(EMTUtils.subDescriptionId(keys[i])).append(TIP_SUFFIX);
            if (hasIndex) {
                sb.append("_").append(i + 1);
            }
            MutableComponent component = Component.m_237115_((String)sb.toString());
            if (format != null) {
                component.m_130940_(format);
            }
            components.add((Component)component);
        }
        return components;
    }

    public static String subDescriptionId(String descriptionId) {
        int i = descriptionId.lastIndexOf(".");
        if (i == -1) {
            return descriptionId;
        }
        return descriptionId.substring(i + 1);
    }

    static {
        UNABLE_BREAKS = Component.m_237115_((String)"item.unbreakable").m_130940_(ChatFormatting.BLUE);
        HOLD_SHIFT_KEY = EMTUtils.simpleText("item.hotkeys.", "shift_down", ChatFormatting.GREEN, new Object[0]);
    }
}

