/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.capability;

import com.eeeab.eeeabsmobs.sever.ability.Ability;
import com.eeeab.eeeabsmobs.sever.ability.AbilityHandler;
import com.eeeab.eeeabsmobs.sever.ability.AbilityType;
import com.eeeab.eeeabsmobs.sever.handler.HandlerCapability;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbilityCapability {
    public static ResourceLocation ID = new ResourceLocation("eeeabsmobs", "ability_processor_cap");

    public static class AbilityCapabilityProvider
    implements ICapabilityProvider,
    ICapabilitySerializable<CompoundTag> {
        private final LazyOptional<AbilityCapabilityImp> instance = LazyOptional.of(AbilityCapabilityImp::new);

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            return HandlerCapability.CUSTOM_ABILITY_CAPABILITY.orEmpty(cap, this.instance.cast());
        }

        public CompoundTag serializeNBT() {
            return ((AbilityCapabilityImp)this.instance.orElseThrow(NullPointerException::new)).serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            ((AbilityCapabilityImp)this.instance.orElseThrow(NullPointerException::new)).deserializeNBT(nbt);
        }
    }

    public static class AbilityCapabilityImp
    implements IAbilityCapability {
        TreeMap<AbilityType<?, ?>, Ability<?>> abilitiesInstances = new TreeMap();
        Ability<?> ability = null;
        Map<String, Tag> nbtMap = new HashMap<String, Tag>();

        @Override
        public void onInit(LivingEntity entity) {
            for (AbilityType<?, ?> abilityType : this.getAbilityTypeByEntity(entity)) {
                Object instance = abilityType.getInstance(entity);
                this.abilitiesInstances.put(abilityType, (Ability<?>)instance);
                if (!this.nbtMap.containsKey(abilityType.getName())) continue;
                ((Ability)instance).readNBT(this.nbtMap.get(abilityType.getName()));
            }
        }

        @Override
        public void onActive(LivingEntity entity, AbilityType<?, ?> type) {
            Ability<?> ability = this.abilitiesInstances.get(type);
            if (ability != null) {
                ability.start();
            }
        }

        @Override
        public void tick(LivingEntity entity) {
            for (Ability<?> ability : this.abilitiesInstances.values()) {
                ability.tick();
            }
        }

        @Override
        public AbilityType<?, ?>[] getAbilityTypeByEntity(LivingEntity entity) {
            if (entity instanceof Player) {
                return AbilityHandler.PLAYER_ABILITY_TYPES;
            }
            return new AbilityType[0];
        }

        @Override
        public Map<AbilityType<?, ?>, Ability<?>> getAbilitiesMap() {
            return this.abilitiesInstances;
        }

        @Override
        public Collection<Ability<?>> getAbilities() {
            return this.abilitiesInstances.values();
        }

        @Override
        public Ability<?> getAbility() {
            return this.ability;
        }

        @Override
        public void setAbility(Ability<?> ability) {
            this.ability = ability;
        }

        @Override
        public boolean checkConflicting() {
            return this.getAbility() != null;
        }

        public CompoundTag serializeNBT() {
            CompoundTag compound = new CompoundTag();
            for (Map.Entry<AbilityType<?, ?>, Ability<?>> abilityNbt : this.getAbilitiesMap().entrySet()) {
                CompoundTag writeNbt = abilityNbt.getValue().writeNBT();
                if (writeNbt.m_128456_()) continue;
                compound.m_128365_(abilityNbt.getKey().getName(), (Tag)writeNbt);
            }
            return compound;
        }

        public void deserializeNBT(CompoundTag nbt) {
            Set nbtSet = nbt.m_128431_();
            for (String key : nbtSet) {
                this.nbtMap.put(key, nbt.m_128423_(key));
            }
        }
    }

    public static interface IAbilityCapability
    extends INBTSerializable<CompoundTag> {
        public void onActive(LivingEntity var1, AbilityType<?, ?> var2);

        public void onInit(LivingEntity var1);

        public void tick(LivingEntity var1);

        public AbilityType<?, ?>[] getAbilityTypeByEntity(LivingEntity var1);

        public Map<AbilityType<?, ?>, Ability<?>> getAbilitiesMap();

        public Collection<Ability<?>> getAbilities();

        public Ability<?> getAbility();

        public void setAbility(Ability<?> var1);

        public boolean checkConflicting();
    }
}

