/*
 * Decompiled with CFR 0.152.
 */
package net.rosemarythyme.simplymore.registry;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.HexFormat;
import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.rosemarythyme.simplymore.SimplyMore;
import net.rosemarythyme.simplymore.config.UniqueEffectConfig;
import net.rosemarythyme.simplymore.config.WeaponAttributesConfig;
import net.rosemarythyme.simplymore.config.WrapperConfig;
import net.rosemarythyme.simplymore.effect.BleedPoisonEffect;
import net.rosemarythyme.simplymore.effect.BloomEffect;
import net.rosemarythyme.simplymore.effect.ChillEffect;
import net.rosemarythyme.simplymore.effect.FallDamageImmunityEffect;
import net.rosemarythyme.simplymore.effect.HarvestEffect;
import net.rosemarythyme.simplymore.effect.HexEffect;
import net.rosemarythyme.simplymore.effect.InsanityEffect;
import net.rosemarythyme.simplymore.effect.LanceEffect;
import net.rosemarythyme.simplymore.effect.MimicryEffect;
import net.rosemarythyme.simplymore.effect.MistyEffect;
import net.rosemarythyme.simplymore.effect.ModStatusEffect;
import net.rosemarythyme.simplymore.effect.MoltenFlareEffect;
import net.rosemarythyme.simplymore.effect.MyrmedgeEffect;
import net.rosemarythyme.simplymore.effect.RadiantEffect;
import net.rosemarythyme.simplymore.effect.RageEffect;
import net.rosemarythyme.simplymore.effect.RemovedEffect;
import net.rosemarythyme.simplymore.effect.RevvengineRushEffect;
import net.rosemarythyme.simplymore.effect.SolidifyEffect;
import net.rosemarythyme.simplymore.effect.SoulForesightEffect;
import net.rosemarythyme.simplymore.effect.StarlightEffect;
import net.rosemarythyme.simplymore.effect.SuffocatingEffect;
import net.rosemarythyme.simplymore.effect.TidebreakerEffect;
import net.rosemarythyme.simplymore.effect.VenomPoisonEffect;

public class ModEffectsRegistry {
    static WrapperConfig config = (WrapperConfig)AutoConfig.getConfigHolder(WrapperConfig.class).getConfig();
    static WeaponAttributesConfig attributes = ModEffectsRegistry.config.weaponAttributes;
    static UniqueEffectConfig effects = ModEffectsRegistry.config.uniqueEffects;
    public static final DeferredRegister<MobEffect> EFFECTS = DeferredRegister.create((String)"simplymore", (ResourceKey)Registries.f_256929_);
    public static final RegistrySupplier<MobEffect> BLEED = ModEffectsRegistry.registerEffect("bleed", new BleedPoisonEffect(MobEffectCategory.HARMFUL, 7865862));
    public static final RegistrySupplier<MobEffect> MIMICRY_HAPPENING = ModEffectsRegistry.registerEffect("mimicry_happening", new MimicryEffect(MobEffectCategory.NEUTRAL, 0));
    public static final RegistrySupplier<MobEffect> HEX = ModEffectsRegistry.registerEffect("hex", new HexEffect(MobEffectCategory.HARMFUL, 10494192));
    public static final RegistrySupplier<MobEffect> STARLIGHT = ModEffectsRegistry.registerEffect("starlight", new StarlightEffect(MobEffectCategory.BENEFICIAL, 11393254));
    public static final RegistrySupplier<MobEffect> GRASPING = ModEffectsRegistry.registerEffect("grasping", new MyrmedgeEffect(MobEffectCategory.NEUTRAL, 7865862).m_19472_(Attributes.f_22283_, "7d90bac9-a45b-4355-ad10-e354bdcf2fcf", -99.0, AttributeModifier.Operation.ADDITION).m_19472_(Attributes.f_22281_, "58d2352a-7caa-4025-9add-333f96effda0", -9999.0, AttributeModifier.Operation.ADDITION));
    public static final RegistrySupplier<MobEffect> SOUL_HEALTH = ModEffectsRegistry.registerEffect("soul_health", new ModStatusEffect(MobEffectCategory.BENEFICIAL, 7865862).m_19472_(Attributes.f_22276_, "81c601bf-416a-48bc-889d-018ded246002", 2.0, AttributeModifier.Operation.ADDITION));
    public static final RegistrySupplier<MobEffect> BLOOM = ModEffectsRegistry.registerEffect("bloom", new BloomEffect(MobEffectCategory.BENEFICIAL, 7865862));
    public static final RegistrySupplier<MobEffect> RAVENOUS = ModEffectsRegistry.registerEffect("ravenous", new RevvengineRushEffect(MobEffectCategory.BENEFICIAL, 0x8B0000));
    public static final RegistrySupplier<MobEffect> LIGHTWEIGHT = ModEffectsRegistry.registerEffect("lightweight", new FallDamageImmunityEffect(MobEffectCategory.BENEFICIAL, (int)HexFormat.fromHexDigitsToLong("BFBFBF")));
    public static final RegistrySupplier<MobEffect> VENOM = ModEffectsRegistry.registerEffect("venom", new VenomPoisonEffect(MobEffectCategory.HARMFUL, 7350627));
    public static final RegistrySupplier<MobEffect> MOLTEN_FLARE = ModEffectsRegistry.registerEffect("molten_flare", new MoltenFlareEffect(MobEffectCategory.NEUTRAL, 13570080).m_19472_(Attributes.f_22283_, "f53f18d4-ac4d-4010-aa0a-7d2d25050c66", effects.getMoltenFlareExecutingSliceSwingSpeedBonus(), AttributeModifier.Operation.ADDITION));
    public static final RegistrySupplier<MobEffect> CHILL = ModEffectsRegistry.registerEffect("chill", new ChillEffect(MobEffectCategory.HARMFUL, 10875635));
    public static final RegistrySupplier<MobEffect> MIMICRY = ModEffectsRegistry.registerEffect("mimicry", new RemovedEffect(MobEffectCategory.NEUTRAL, 0));
    public static final RegistrySupplier<MobEffect> LANCE = ModEffectsRegistry.registerEffect("lance_mounted", new LanceEffect(MobEffectCategory.NEUTRAL, 0).m_19472_(Attributes.f_22281_, "82a0acc0-2b8f-4ecb-89e6-8d9ae55c5777", attributes.getLanceFriendshipDamageModifier(), AttributeModifier.Operation.ADDITION));
    public static final RegistrySupplier<MobEffect> HARVEST = ModEffectsRegistry.registerEffect("harvest", new HarvestEffect(MobEffectCategory.BENEFICIAL, 7865862).m_19472_(Attributes.f_22283_, "c05d986c-5c04-434d-b5b0-72fc4b4151ab", 0.8, AttributeModifier.Operation.ADDITION).m_19472_(Attributes.f_22279_, "443724ff-b478-4f43-bcea-ea4037d87d0c", 0.04, AttributeModifier.Operation.ADDITION));
    public static final RegistrySupplier<MobEffect> RAGE = ModEffectsRegistry.registerEffect("rage", new RageEffect(MobEffectCategory.NEUTRAL, 7865862).m_19472_(Attributes.f_22281_, "3e0c2338-1d22-4375-a70d-856dc5d2a0a6", 1.5, AttributeModifier.Operation.ADDITION).m_19472_(Attributes.f_22279_, "b33f3caf-876d-4809-a55e-5647809cad16", 0.04, AttributeModifier.Operation.ADDITION));
    public static final RegistrySupplier<MobEffect> GROTESQUE = ModEffectsRegistry.registerEffect("grotesque", new RemovedEffect(MobEffectCategory.NEUTRAL, 0));
    public static final RegistrySupplier<MobEffect> GROTESQUE_WARD = ModEffectsRegistry.registerEffect("grotesque_ward", new ModStatusEffect(MobEffectCategory.HARMFUL, 1023141).m_19472_(Attributes.f_22281_, "9e3ef8b8-1e2c-43f6-876f-da4808fdbbb8", -1.0, AttributeModifier.Operation.ADDITION).m_19472_(Attributes.f_22279_, "1fffd775-87fc-4ddb-9a61-3ccb63a1a221", -0.01, AttributeModifier.Operation.ADDITION));
    public static final RegistrySupplier<MobEffect> SOLIDIFIED = ModEffectsRegistry.registerEffect("solidified", new SolidifyEffect(MobEffectCategory.NEUTRAL, 0x888C8D).m_19472_(Attributes.f_22284_, "695fbd36-b9e1-452d-8f41-2f850a4ccf6a", effects.getGrotesqueSolidifyAttackerStunnedArmorBuff(), AttributeModifier.Operation.ADDITION).m_19472_(Attributes.f_22283_, "8976a053-b499-4fba-9dcb-432c4694fbbb", -99.0, AttributeModifier.Operation.ADDITION).m_19472_(Attributes.f_22281_, "1f3ea85b-ab38-435f-858a-b508aefdeefe", -9999.0, AttributeModifier.Operation.ADDITION));
    public static final RegistrySupplier<MobEffect> STUNNED = ModEffectsRegistry.registerEffect("stunned", new SolidifyEffect(MobEffectCategory.HARMFUL, 0x888C8D).m_19472_(Attributes.f_22284_, "f00fd930-1cd9-4524-a375-0d50225d323f", effects.getGrotesqueSolidifySelfStunnedArmorBuff(), AttributeModifier.Operation.ADDITION).m_19472_(Attributes.f_22283_, "25b787e4-eb31-4257-95b2-e3962ccc1ea7", -99.0, AttributeModifier.Operation.ADDITION).m_19472_(Attributes.f_22281_, "3a55dc27-08d0-4575-a6fc-b896f2c347b2", -9999.0, AttributeModifier.Operation.ADDITION));
    public static final RegistrySupplier<MobEffect> STUNNED_MOXIE = ModEffectsRegistry.registerEffect("stunned_moxie", new SolidifyEffect(MobEffectCategory.HARMFUL, 0x888C8D).m_19472_(Attributes.f_22283_, "61b06328-fb0c-4d7c-ba2f-cdb8b370224c", -99.0, AttributeModifier.Operation.ADDITION).m_19472_(Attributes.f_22281_, "e8940579-765e-4458-928d-e430e50713c1", -9999.0, AttributeModifier.Operation.ADDITION));
    public static final RegistrySupplier<MobEffect> WITHERING_FATE = ModEffectsRegistry.registerEffect("withering_fate", new ModStatusEffect(MobEffectCategory.HARMFUL, 2818819).m_19472_(Attributes.f_22276_, "ebed9986-78c5-4c08-9f2f-05e929ee5fa7", -1.0, AttributeModifier.Operation.ADDITION));
    public static final RegistrySupplier<MobEffect> MISTIFIED = ModEffectsRegistry.registerEffect("mistified", new MistyEffect(MobEffectCategory.BENEFICIAL, 0));
    public static final RegistrySupplier<MobEffect> INSANITY = ModEffectsRegistry.registerEffect("insanity", new InsanityEffect(MobEffectCategory.HARMFUL, 700).m_19472_(Attributes.f_22281_, "1ce784a4-a543-4436-a0fe-376bea83d30e", -3.0, AttributeModifier.Operation.ADDITION).m_19472_(Attributes.f_22279_, "42d45eb0-2230-48b0-9288-a3be65e15cf1", -0.03, AttributeModifier.Operation.ADDITION));
    public static final RegistrySupplier<MobEffect> TIDEBREAKER = ModEffectsRegistry.registerEffect("tidebreaker_rain", new TidebreakerEffect(MobEffectCategory.BENEFICIAL, 700));
    public static final RegistrySupplier<MobEffect> BLESSING = ModEffectsRegistry.registerEffect("blessing", new ModStatusEffect(MobEffectCategory.BENEFICIAL, 16709211));
    public static final RegistrySupplier<MobEffect> CURSE = ModEffectsRegistry.registerEffect("curse", new ModStatusEffect(MobEffectCategory.HARMFUL, 3152180));
    public static final RegistrySupplier<MobEffect> SUFFOCATION = ModEffectsRegistry.registerEffect("constricted", new SuffocatingEffect(MobEffectCategory.HARMFUL, 0).m_19472_(Attributes.f_22279_, "a6f03a84-1731-4558-9bf5-265f0d1dd84c", -0.03, AttributeModifier.Operation.ADDITION));
    public static final RegistrySupplier<MobEffect> RADIANT_MARK = ModEffectsRegistry.registerEffect("radiant_mark", new RadiantEffect(MobEffectCategory.HARMFUL, 0));
    public static final RegistrySupplier<MobEffect> FORESEEN = ModEffectsRegistry.registerEffect("soul_lock", new SoulForesightEffect(MobEffectCategory.HARMFUL, 0));
    public static final RegistrySupplier<MobEffect> ARMOUR_CRUNCH = ModEffectsRegistry.registerEffect("armor_crunch", new ModStatusEffect(MobEffectCategory.HARMFUL, 9849600).m_19472_(Attributes.f_22284_, "ec7aa674-2cba-464e-973b-2a26e7ff5c4a", -2.0, AttributeModifier.Operation.ADDITION));

    public static void registerModEffects() {
        SimplyMore.LOGGER.info("Registering Status Effects for simplymore");
        EFFECTS.register();
    }

    public static RegistrySupplier<MobEffect> registerEffect(String name, MobEffect effect) {
        return EFFECTS.register(new ResourceLocation("simplymore", name), () -> effect);
    }
}

