/*
 * Decompiled with CFR 0.152.
 */
package net.rosemarythyme.simplymore.recipes;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Tuple;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;

public class UpgradeUniqueRecipe
extends ShapedRecipe {
    private final int upgradableItemSlot;
    private final ItemStack output;

    public UpgradeUniqueRecipe(ResourceLocation id, String group, CraftingBookCategory category, int width, int height, NonNullList<Ingredient> input, ItemStack output, int upgradableItemSlot) {
        super(id, group, category, width, height, input, output);
        this.upgradableItemSlot = upgradableItemSlot;
        this.output = output;
    }

    public ItemStack m_5874_(CraftingContainer inventory, RegistryAccess registryManager) {
        ItemStack output = this.output.m_41777_();
        output.m_41751_(inventory.m_8020_(this.upgradableItemSlot).m_41784_().m_6426_());
        return output;
    }

    static Tuple<NonNullList<Ingredient>, Integer> createPatternMatrix(String[] pattern, Map<String, Tuple<Ingredient, Boolean>> symbols, int width, int height) {
        NonNullList defaultedList = NonNullList.m_122780_((int)(width * height), (Object)Ingredient.f_43901_);
        HashSet set = Sets.newHashSet(symbols.keySet());
        set.remove(" ");
        int slot = -1;
        for (int i = 0; i < pattern.length; ++i) {
            for (int j = 0; j < pattern[i].length(); ++j) {
                String string = pattern[i].substring(j, j + 1);
                Ingredient ingredient = (Ingredient)symbols.get(string).m_14418_();
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + string + "' but it's not defined in the key");
                }
                if (((Boolean)symbols.get(string).m_14419_()).booleanValue()) {
                    if (slot < 0) {
                        slot = j + i * pattern[i].length();
                    } else {
                        throw new JsonSyntaxException("Pattern attempted to define slot #" + j + " as upgradable, but slot #" + slot + " is already upgradable");
                    }
                }
                set.remove(string);
                defaultedList.set(j + width * i, (Object)ingredient);
            }
        }
        if (slot < 0) {
            throw new JsonSyntaxException("Pattern does not define a slot as upgradable");
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + String.valueOf(set));
        }
        return new Tuple((Object)defaultedList, (Object)slot);
    }

    static Map<String, Tuple<Ingredient, Boolean>> readSymbols(JsonObject json) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : json.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            boolean isSlot = GsonHelper.m_13855_((JsonObject)((JsonElement)entry.getValue()).getAsJsonObject(), (String)"upgradable", (boolean)false);
            map.put((String)entry.getKey(), new Tuple((Object)Ingredient.m_43917_((JsonElement)((JsonElement)entry.getValue())), (Object)isSlot));
        }
        map.put(" ", new Tuple((Object)Ingredient.f_43901_, (Object)false));
        return map;
    }

    static String[] getPattern(JsonArray json) {
        String[] strings = new String[json.size()];
        if (strings.length > 3) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, 3 is maximum");
        }
        if (strings.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < strings.length; ++i) {
            String string = GsonHelper.m_13805_((JsonElement)json.get(i), (String)("pattern[" + i + "]"));
            if (string.length() > 3) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, 3 is maximum");
            }
            if (i > 0 && strings[0].length() != string.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            strings[i] = string;
        }
        int a = strings[0].length();
        int b = strings.length;
        int c = 0;
        int d = 0;
        for (int y = 0; y < strings.length; ++y) {
            for (int x = 0; x < strings[0].length(); ++x) {
                if (strings[y].charAt(x) == ' ') continue;
                if (x < a) {
                    a = x;
                }
                if (x > c) {
                    c = x;
                }
                if (y < b) {
                    b = y;
                }
                if (y <= d) continue;
                d = y;
            }
        }
        ArrayList<String> strippedStrings = new ArrayList<String>();
        for (int y = 0; y < strings.length; ++y) {
            if (y < b || y > d) continue;
            strippedStrings.add(strings[y].substring(a, c + 1));
        }
        return strippedStrings.toArray(new String[0]);
    }

    public RecipeSerializer<?> m_7707_() {
        return RecipeSerializer.f_44078_;
    }

    public static class Serializer
    implements RecipeSerializer<UpgradeUniqueRecipe> {
        public UpgradeUniqueRecipe read(ResourceLocation identifier, JsonObject jsonObject) {
            String string = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"group", (String)"");
            CraftingBookCategory craftingRecipeCategory = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_((JsonObject)jsonObject, (String)"category", null), (Enum)CraftingBookCategory.MISC);
            Map<String, Tuple<Ingredient, Boolean>> map = UpgradeUniqueRecipe.readSymbols(GsonHelper.m_13930_((JsonObject)jsonObject, (String)"key"));
            String[] strings = UpgradeUniqueRecipe.getPattern(GsonHelper.m_13933_((JsonObject)jsonObject, (String)"pattern"));
            int i = strings[0].length();
            int j = strings.length;
            Tuple<NonNullList<Ingredient>, Integer> patternMatrix = UpgradeUniqueRecipe.createPatternMatrix(strings, map, i, j);
            NonNullList defaultedList = (NonNullList)patternMatrix.m_14418_();
            ItemStack itemStack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"result"));
            return new UpgradeUniqueRecipe(identifier, string, craftingRecipeCategory, i, j, (NonNullList<Ingredient>)defaultedList, itemStack, (Integer)patternMatrix.m_14419_());
        }

        public UpgradeUniqueRecipe read(ResourceLocation identifier, FriendlyByteBuf packetByteBuf) {
            int i = packetByteBuf.m_130242_();
            int j = packetByteBuf.m_130242_();
            String string = packetByteBuf.m_130277_();
            CraftingBookCategory craftingRecipeCategory = (CraftingBookCategory)packetByteBuf.m_130066_(CraftingBookCategory.class);
            NonNullList defaultedList = NonNullList.m_122780_((int)(i * j), (Object)Ingredient.f_43901_);
            defaultedList.replaceAll(ing -> Ingredient.m_43940_((FriendlyByteBuf)packetByteBuf));
            ItemStack itemStack = packetByteBuf.m_130267_();
            int slot = packetByteBuf.m_130242_();
            return new UpgradeUniqueRecipe(identifier, string, craftingRecipeCategory, i, j, (NonNullList<Ingredient>)defaultedList, itemStack, slot);
        }

        public void write(FriendlyByteBuf packetByteBuf, UpgradeUniqueRecipe shapedRecipe) {
            packetByteBuf.m_130130_(shapedRecipe.m_44221_());
            packetByteBuf.m_130130_(shapedRecipe.m_44220_());
            packetByteBuf.m_130070_(shapedRecipe.m_6076_());
            packetByteBuf.m_130068_((Enum)shapedRecipe.m_245232_());
            for (Ingredient ingredient : shapedRecipe.m_7527_()) {
                ingredient.m_43923_(packetByteBuf);
            }
            packetByteBuf.m_130055_(shapedRecipe.output);
            packetByteBuf.m_130130_(shapedRecipe.upgradableItemSlot);
        }
    }
}

