/*
 * Decompiled with CFR 0.152.
 */
package net.rosemarythyme.simplymore.mixin;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.rosemarythyme.simplymore.config.ModConfigs;
import net.rosemarythyme.simplymore.config.UniqueEffectConfig;
import net.rosemarythyme.simplymore.config.WrapperConfig;
import net.rosemarythyme.simplymore.item.uniques.CindergorgeItem;
import net.rosemarythyme.simplymore.util.SimplyMoreHelperMethods;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerEntityMixin {
    private static final WrapperConfig config = ModConfigs.safeGetConfig();
    private static final UniqueEffectConfig effect = PlayerEntityMixin.config.uniqueEffects;
    private final int stunTime = effect.getGrotesqueSolidifyAuraStunTime();

    @Inject(at={@At(value="HEAD")}, method={"applyDamage"}, cancellable=true)
    private void simplyMore$applyDamage(DamageSource source, float amount, CallbackInfo info) {
        Entity attacker;
        Player player = (Player)this;
        SimplyMoreHelperMethods.simplyMore$onDamageEffects(amount, source, info, (LivingEntity)player);
        if ((player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof CindergorgeItem || player.m_21120_(InteractionHand.OFF_HAND).m_41720_() instanceof CindergorgeItem) && (attacker = source.m_7639_()) != null && player.m_217043_().m_216332_(1, 100) <= effect.getCindergorgeThornsChance()) {
            if (attacker.m_6060_()) {
                attacker.m_6469_(player.m_269291_().m_269549_(), effect.getCindergorgeThornsFireDamage());
            } else {
                attacker.m_6469_(player.m_269291_().m_269374_(attacker), effect.getCindergorgeThornsDamage());
            }
        }
    }
}

