/*
 * Decompiled with CFR 0.152.
 */
package net.rosemarythyme.simplymore.item.uniques.mimicry;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.rosemarythyme.simplymore.item.uniques.MimicryItem;
import net.rosemarythyme.simplymore.registry.ModEffectsRegistry;

public class SpearItem
extends MimicryItem {
    public SpearItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    @Override
    public boolean isFormDisabledInConfig() {
        return mimicryAttributes.isDisableSpearVariant();
    }

    @Override
    public Component getMimicryFormName() {
        return Component.m_237115_((String)"item.simplymore.mimicry.spear");
    }

    @Override
    public void appendSpecificTooltip(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.mimicry.spear.tooltip1").m_6270_(this.textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.mimicry.spear.tooltip2").m_6270_(this.textStyle));
    }

    @Override
    public void usageTimeline(Player player, int ticksUsed) {
        float damage;
        List<LivingEntity> enemies;
        if (ticksUsed == 6 || ticksUsed == 10) {
            enemies = this.stabAttack(player, 5, 0.4f);
            damage = mimicryAttributes.getSpearDamage();
            enemies.forEach(target -> {
                if (target.m_21254_()) {
                    return;
                }
                target.f_19802_ = 0;
                target.m_6469_(player.m_269291_().m_269075_(player), damage);
                target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, mimicryAttributes.getSpearEffectTime(), 0));
            });
        }
        if (ticksUsed == 20) {
            enemies = this.stabAttack(player, 5, 0.4f);
            damage = mimicryAttributes.getSpearFinalStabDamage();
            enemies.forEach(target -> {
                SpearItem.breakShield(target);
                target.f_19802_ = 0;
                target.m_6469_(player.m_269291_().m_269075_(player), damage);
                target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, mimicryAttributes.getSpearEffectTime(), 0));
            });
        }
        if (ticksUsed >= 28) {
            player.m_21195_((MobEffect)ModEffectsRegistry.MIMICRY_HAPPENING.get());
        }
    }
}

