/*
 * Decompiled with CFR 0.152.
 */
package net.rosemarythyme.simplymore.item.uniques.mimicry;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.rosemarythyme.simplymore.item.uniques.MimicryItem;
import net.rosemarythyme.simplymore.registry.ModEffectsRegistry;

public class RapierItem
extends MimicryItem {
    public RapierItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    @Override
    public boolean isFormDisabledInConfig() {
        return mimicryAttributes.isDisableRapierVariant();
    }

    @Override
    public Component getMimicryFormName() {
        return Component.m_237115_((String)"item.simplymore.mimicry.rapier");
    }

    @Override
    public void appendSpecificTooltip(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.mimicry.rapier.tooltip1").m_6270_(this.textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.mimicry.rapier.tooltip2").m_6270_(this.textStyle));
    }

    @Override
    public void usageTimeline(Player player, int ticksUsed) {
        List<LivingEntity> enemies;
        float damage = mimicryAttributes.getRapierDamage();
        if (ticksUsed == 4 || ticksUsed == 16) {
            enemies = this.stabAttack(player, 3, 0.25f);
            enemies.forEach(target -> {
                if (target.m_21254_()) {
                    return;
                }
                target.f_19802_ = 0;
                target.m_6469_(player.m_269291_().m_269075_(player), damage);
                target.m_7292_(new MobEffectInstance((MobEffect)ModEffectsRegistry.BLEED.get(), mimicryAttributes.getRapierEffectTime(), 0));
            });
        }
        if (ticksUsed == 7 || ticksUsed == 10 || ticksUsed == 13) {
            enemies = this.stabAttack(player, 3, 0.25f);
            enemies.forEach(target -> {
                if (target.m_21254_()) {
                    return;
                }
                target.f_19802_ = 0;
                target.m_6469_(player.m_269291_().m_269075_(player), damage);
            });
        }
        if (ticksUsed >= 22) {
            player.m_21195_((MobEffect)ModEffectsRegistry.MIMICRY_HAPPENING.get());
        }
    }
}

