/*
 * Decompiled with CFR 0.152.
 */
package net.rosemarythyme.simplymore.item.uniques.mimicry;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.rosemarythyme.simplymore.item.uniques.MimicryItem;
import net.rosemarythyme.simplymore.registry.ModEffectsRegistry;

public class LongswordItem
extends MimicryItem {
    public LongswordItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    @Override
    public void usageTimeline(Player player, int ticksUsed) {
        if (ticksUsed == 3) {
            List<LivingEntity> enemies = this.sweepAttack(player, 1.6f);
            float damage = mimicryAttributes.getLongswordBaseDamage() + (float)enemies.size() * mimicryAttributes.getLongswordExtraDamagePerTarget();
            enemies.forEach(target -> {
                if (target.m_21254_()) {
                    return;
                }
                target.m_6469_(player.m_269291_().m_269075_(player), damage);
                this.knockback(player, (LivingEntity)target, mimicryAttributes.getLongswordKnockback());
            });
        }
        if (ticksUsed >= 13) {
            player.m_21195_((MobEffect)ModEffectsRegistry.MIMICRY_HAPPENING.get());
        }
    }

    @Override
    public boolean isFormDisabledInConfig() {
        return mimicryAttributes.isDisableLongswordVariant();
    }

    @Override
    public Component getMimicryFormName() {
        return Component.m_237115_((String)"item.simplymore.mimicry.longsword");
    }

    @Override
    public void appendSpecificTooltip(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.mimicry.longsword.tooltip1").m_6270_(this.textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.mimicry.longsword.tooltip2").m_6270_(this.textStyle));
    }
}

