/*
 * Decompiled with CFR 0.152.
 */
package net.rosemarythyme.simplymore.item.uniques.mimicry;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.rosemarythyme.simplymore.item.uniques.MimicryItem;
import net.rosemarythyme.simplymore.registry.ModEffectsRegistry;
import net.rosemarythyme.simplymore.util.SimplyMoreHelperMethods;
import org.joml.Vector3d;

public class KatanaItem
extends MimicryItem {
    public KatanaItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    @Override
    public void usageTimeline(Player player, int ticksUsed) {
        player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 10, 4));
        if (ticksUsed == 30) {
            Vec3 currentPos = player.m_20182_();
            float damage = mimicryAttributes.getKatanaDamage();
            Vec3 targetPos = player.m_19907_(15.0, 1.0f, false).m_82450_();
            player.m_20324_(targetPos.m_7096_(), targetPos.m_7098_(), targetPos.m_7094_());
            double distance = Vector3d.distance((double)currentPos.m_7096_(), (double)currentPos.m_7098_(), (double)currentPos.m_7094_(), (double)targetPos.m_7096_(), (double)targetPos.m_7098_(), (double)targetPos.m_7094_());
            Vector3d normalisedVector = SimplyMoreHelperMethods.getNormalised3dVector((Entity)player);
            for (int i = 0; i < 15; ++i) {
                double distanceInterval = distance / (15.0 / (double)(i + 1));
                Vec3 slashPos = new Vec3(currentPos.m_7096_() + normalisedVector.x() * distanceInterval, currentPos.m_7098_() + normalisedVector.y() * distanceInterval, currentPos.m_7094_() + normalisedVector.z() * distanceInterval);
                List<LivingEntity> livingEntities = this.katanaAttack(player, slashPos.m_7096_(), slashPos.m_7098_(), slashPos.m_7094_(), 0.8f);
                livingEntities.forEach(target -> target.m_6469_(player.m_269291_().m_269075_(player), damage));
            }
        }
        if (ticksUsed >= 40) {
            player.m_21195_((MobEffect)ModEffectsRegistry.MIMICRY_HAPPENING.get());
        }
    }

    @Override
    public boolean isFormDisabledInConfig() {
        return mimicryAttributes.isDisableKatanaVariant();
    }

    @Override
    public Component getMimicryFormName() {
        return Component.m_237115_((String)"item.simplymore.mimicry.katana");
    }

    @Override
    public void appendSpecificTooltip(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.mimicry.katana.tooltip1").m_6270_(this.textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.mimicry.katana.tooltip2").m_6270_(this.textStyle));
    }
}

