/*
 * Decompiled with CFR 0.152.
 */
package net.rosemarythyme.simplymore.item.uniques.mimicry;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.rosemarythyme.simplymore.item.uniques.MimicryItem;
import net.rosemarythyme.simplymore.registry.ModEffectsRegistry;

public class HalberdItem
extends MimicryItem {
    public HalberdItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    @Override
    public void usageTimeline(Player player, int ticksUsed) {
        float damage;
        List<LivingEntity> enemies;
        if (ticksUsed == 8) {
            enemies = this.spinAttack(player, 5.5f);
            damage = mimicryAttributes.getHalberdDamage();
            enemies.forEach(target -> {
                if (target.m_21254_()) {
                    return;
                }
                target.m_6469_(player.m_269291_().m_269075_(player), damage);
                target.m_7292_(new MobEffectInstance((MobEffect)ModEffectsRegistry.BLEED.get(), mimicryAttributes.getHalberdEffectTime(), 1));
            });
        }
        if (ticksUsed >= 14 && 28 >= ticksUsed) {
            this.jump((LivingEntity)player, 1.0f, 0.0f);
            if (ticksUsed % 7 != 0) {
                return;
            }
            enemies = this.sweepAttack(player, 3.2f);
            damage = mimicryAttributes.getHalberdDamage();
            enemies.forEach(target -> {
                if (target.m_21254_()) {
                    return;
                }
                target.m_6469_(player.m_269291_().m_269075_(player), damage);
                target.m_7292_(new MobEffectInstance((MobEffect)ModEffectsRegistry.BLEED.get(), mimicryAttributes.getHalberdEffectTime(), 1));
            });
        }
        if (ticksUsed >= 30) {
            player.m_21195_((MobEffect)ModEffectsRegistry.MIMICRY_HAPPENING.get());
        }
    }

    @Override
    public boolean isFormDisabledInConfig() {
        return mimicryAttributes.isDisableHalberdVariant();
    }

    @Override
    public Component getMimicryFormName() {
        return Component.m_237115_((String)"item.simplymore.mimicry.halberd");
    }

    @Override
    public void appendSpecificTooltip(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.mimicry.halberd.tooltip1").m_6270_(this.textStyle));
        tooltip.add((Component)Component.m_237115_((String)"item.simplymore.mimicry.halberd.tooltip2").m_6270_(this.textStyle));
    }
}

